/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.os.Build;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.constraint.R;
import android.support.constraint.motion.Debug;
import android.support.constraint.motion.DesignTool;
import android.support.constraint.motion.MotionController;
import android.support.constraint.motion.MotionHelper;
import android.support.constraint.motion.MotionPaths;
import android.support.constraint.motion.MotionScene;
import android.support.constraint.motion.utils.StopLogic;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.v4.view.NestedScrollingParent2;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.HashMap;

public class MotionLayout
extends ConstraintLayout
implements NestedScrollingParent2 {
    static final String TAG = "MotionLayout";
    private static final boolean DEBUG = false;
    MotionScene mScene;
    Interpolator mInterpolator;
    private int mBeginState = -1;
    int mCurrentState = -1;
    private int mEndState = -1;
    private int mLastWidthMeasureSpec = 0;
    private int mLastHeightMeasureSpec = 0;
    private int mLastWidthMeasureSpecOnLayout = 0;
    private int mLastHeightMeasureSpecOnLayout = 0;
    HashMap<View, MotionController> mFrameArrayList = new HashMap();
    private long mAnimationStartTime = 0L;
    private float mTransitionDuration = 1.0f;
    float mTransitionPosition = 0.0f;
    float mTransitionLastPosition = 0.0f;
    private long mTransitionLastTime;
    float mTransitionGoalPosition = 0.0f;
    private boolean mTransitionInstantly;
    boolean mInTransition = false;
    boolean mIndirectTransition = false;
    private TransitionListener mListener;
    private float lastPos;
    private float lastY;
    boolean mSetup = false;
    public static final int DEBUG_SHOW_NONE = 0;
    public static final int DEBUG_SHOW_PROGRESS = 1;
    public static final int DEBUG_SHOW_PATH = 2;
    private int mDebugPath = 0;
    static final int MAX_KEY_FRAMES = 50;
    DevModeDraw mDevModeDraw;
    private boolean mTemporalInterpolator = false;
    StopLogic mStopLogic = new StopLogic();
    boolean mStartConstraintSetComputed = false;
    boolean mEndConstraintSetComputed = false;
    private DesignTool mDesignTool;
    boolean firstDown = true;
    int mOldWidth;
    int mOldHeight;
    int mLastLayoutWidth;
    int mLastLayoutHeight;
    View mScrollTarget;
    float mScrollTargetDX;
    float mScrollTargetDY;
    long mScrollTargetTime;
    float mScrollTargetDT;
    private boolean mKeepAnimating = false;
    private ArrayList<MotionHelper> mOnShowHelpers = null;
    private ArrayList<MotionHelper> mOnHideHelpers = null;
    private int mFrames = 0;
    private long mLastDrawTime = -1L;
    private float mLastFps = 0.0f;

    public MotionLayout(Context context) {
        super(context);
        this.init(null);
    }

    public MotionLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MotionLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public void setTransition(int beginId, int endId) {
        if (this.mScene != null) {
            this.mBeginState = beginId;
            this.mEndState = endId;
            this.mScene.setTransition(beginId, endId);
            this.mSetup = false;
            this.mTransitionLastPosition = 0.0f;
            this.transitionToStart();
        }
    }

    protected void setTransition(MotionScene.Transition transition) {
        this.mScene.setTransition(transition);
        this.mSetup = false;
        if (this.mCurrentState == this.mScene.getEndId()) {
            this.mTransitionLastPosition = 1.0f;
            this.mTransitionPosition = 1.0f;
        } else {
            this.mTransitionLastPosition = 0.0f;
            this.mTransitionPosition = 0.0f;
        }
        this.mBeginState = this.mScene.getStartId();
        this.mEndState = this.mScene.getEndId();
        if (this.mListener != null) {
            this.mListener.onTransitionStarted(this, this.mBeginState, this.mEndState);
        }
    }

    @Override
    public void loadLayoutDescription(int motionScene) {
        if (motionScene != 0) {
            try {
                this.mScene = new MotionScene(this.getContext(), this, motionScene);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("unable to parse MotionScene file", ex);
            }
        } else {
            this.mScene = null;
        }
    }

    @Override
    public void setState(int id2, int screenWidth, int screenHeight) {
        this.mCurrentState = id2;
        this.mBeginState = -1;
        this.mEndState = -1;
        if (this.mConstraintLayoutSpec != null) {
            this.mConstraintLayoutSpec.updateConstraints(id2, screenWidth, screenHeight);
        } else if (this.mScene != null) {
            this.mScene.getConstraintSet(id2).applyTo(this);
        }
    }

    public void setInterpolatedProgress(float pos) {
        this.mCurrentState = pos <= 0.0f ? this.mBeginState : (pos >= 1.0f ? this.mEndState : -1);
        if (this.mScene == null) {
            return;
        }
        int startId = this.mScene.getStartId();
        int endId = this.mScene.getEndId();
        Interpolator interpolator = this.mScene.getInterpolator();
        this.mTransitionPosition = this.mTransitionGoalPosition = interpolator.getInterpolation(pos);
        this.mAnimationStartTime = -1L;
        this.mInterpolator = null;
        this.mTransitionInstantly = true;
        this.mTransitionLastTime = System.nanoTime();
        this.setupMotionViews();
        this.mInTransition = true;
        this.invalidate();
    }

    public void setProgress(float pos) {
        this.mCurrentState = pos <= 0.0f ? this.mBeginState : (pos >= 1.0f ? this.mEndState : -1);
        if (this.mScene == null) {
            return;
        }
        int startId = this.mScene.getStartId();
        int endId = this.mScene.getEndId();
        this.mTransitionGoalPosition = pos;
        this.mTransitionPosition = pos;
        this.mAnimationStartTime = -1L;
        this.mInterpolator = null;
        this.mTransitionInstantly = true;
        this.mTransitionLastTime = System.nanoTime();
        this.setupMotionViews();
        this.mInTransition = true;
        this.invalidate();
    }

    private void setupMotionViews() {
        ConstraintSet endSet;
        ConstraintSet startSet;
        if (this.mSetup) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 18 && this.isInLayout()) {
            return;
        }
        int startId = this.mScene.getStartId();
        int endId = this.mScene.getEndId();
        int n = this.getChildCount();
        this.mFrameArrayList.clear();
        for (int i = 0; i < n; ++i) {
            View v = this.getChildAt(i);
            MotionController f = new MotionController(v);
            this.mFrameArrayList.put(v, f);
        }
        this.mInTransition = true;
        if (!this.mStartConstraintSetComputed && (startSet = this.mScene.getConstraintSet(startId)) != null) {
            startSet.applyToWithoutCustom(this);
            this.computeStartPositions(startSet);
            this.requestLayout();
            this.mTransitionPosition = 0.0f;
            this.mTransitionLastPosition = 0.0f;
        }
        if (!this.mEndConstraintSetComputed && (endSet = this.mScene.getConstraintSet(endId)) != null) {
            endSet.applyToWithoutCustom(this);
            this.computeEndPositions(endSet);
        }
        int layoutWidth = this.getWidth();
        int layoutHeight = this.getHeight();
        for (int i = 0; i < n; ++i) {
            MotionController motionController = this.mFrameArrayList.get(this.getChildAt(i));
            if (motionController == null) continue;
            this.mScene.getKeyFrames(motionController);
            motionController.setup(layoutWidth, layoutHeight, this.mTransitionDuration);
        }
        float stagger = this.mScene.getStaggered();
        if (stagger != 0.0f) {
            float y;
            float x;
            MotionController f;
            int i;
            float min = Float.MAX_VALUE;
            float max = -3.4028235E38f;
            for (i = 0; i < n; ++i) {
                f = this.mFrameArrayList.get(this.getChildAt(i));
                x = f.getFinalX();
                y = f.getFinalY();
                min = Math.min(min, y + x);
                max = Math.max(max, y + x);
            }
            for (i = 0; i < n; ++i) {
                f = this.mFrameArrayList.get(this.getChildAt(i));
                x = f.getFinalX();
                y = f.getFinalY();
                f.stagger_scale = 1.0f / (1.0f - stagger);
                f.stagger_offset = stagger - stagger * (x + y - min) / (max - min);
            }
        }
        this.requestLayout();
        this.mSetup = true;
    }

    void touchAnimateTo(float position, float currentVelocity) {
        if (this.mScene == null) {
            return;
        }
        if (this.mTransitionLastPosition == position) {
            return;
        }
        this.mTemporalInterpolator = true;
        this.mAnimationStartTime = System.nanoTime();
        this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        this.mStopLogic.config(this.mTransitionLastPosition, position, currentVelocity, this.mTransitionDuration, this.mScene.getMaxAcceleration(), this.mScene.getMaxVelocity());
        this.mTransitionGoalPosition = position;
        this.setProgress(0.0f);
        this.mInterpolator = this.mStopLogic;
        this.mTransitionInstantly = false;
        this.mAnimationStartTime = System.nanoTime();
        this.requestLayout();
        this.invalidate();
    }

    void animateTo(float position) {
        if (this.mScene == null) {
            return;
        }
        if (this.mTransitionLastPosition == position) {
            return;
        }
        this.mTemporalInterpolator = false;
        float currentPosition = this.mTransitionLastPosition;
        this.mTransitionGoalPosition = position;
        this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        this.setProgress(this.mTransitionGoalPosition);
        this.mInterpolator = this.mScene.getInterpolator();
        this.mTransitionInstantly = false;
        this.mAnimationStartTime = System.nanoTime();
        this.mInTransition = true;
        this.mTransitionPosition = currentPosition;
        this.mTransitionLastPosition = currentPosition;
        this.requestLayout();
        this.invalidate();
    }

    private void computeCurrentPositions() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getChildAt(i);
            MotionController frame = this.mFrameArrayList.get(v);
            if (frame == null) continue;
            frame.setStartCurrentState(v);
        }
    }

    public void transitionToStart() {
        this.animateTo(0.0f);
    }

    public void transitionToEnd() {
        this.animateTo(1.0f);
    }

    private void computeEndPositions(ConstraintSet constraintSet) {
        try {
            super.onMeasure(this.mLastWidthMeasureSpecOnLayout, this.mLastHeightMeasureSpecOnLayout);
            this.mInTransition = true;
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getChildAt(i);
                MotionController frame = this.mFrameArrayList.get(v);
                if (frame == null) continue;
                ConstraintWidget w = this.getViewWidget(v);
                frame.setEndState(w, constraintSet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void computeStartPositions(ConstraintSet constraintSet) {
        try {
            super.onMeasure(this.mLastWidthMeasureSpecOnLayout, this.mLastHeightMeasureSpecOnLayout);
            this.mInTransition = true;
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getChildAt(i);
                MotionController frame = this.mFrameArrayList.get(v);
                if (frame == null) continue;
                ConstraintWidget w = this.getViewWidget(v);
                frame.setStartState(w, constraintSet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void transitionToState(int id2) {
        if (id2 == this.mBeginState) {
            this.transitionToStart();
        } else if (id2 == this.mEndState) {
            this.transitionToEnd();
        } else {
            this.transitionToState(id2, -1, -1);
        }
    }

    public void transitionToState(int id2, int screenWidth, int screenHeight) {
        this.mEndState = id2;
        if (this.mCurrentState != -1) {
            this.setTransition(this.mCurrentState, id2);
            this.animateTo(1.0f);
            this.mSetup = false;
            this.mTransitionLastPosition = 0.0f;
            this.transitionToEnd();
            return;
        }
        this.mTemporalInterpolator = false;
        this.mTransitionGoalPosition = 1.0f;
        this.mTransitionPosition = 0.0f;
        this.mTransitionLastPosition = 0.0f;
        this.mTransitionLastTime = System.nanoTime();
        this.mAnimationStartTime = System.nanoTime();
        this.mTransitionInstantly = false;
        this.mInterpolator = null;
        this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        int startId = this.mScene.getStartId();
        int targetID = id2;
        int n = this.getChildCount();
        this.mFrameArrayList.clear();
        for (int i = 0; i < n; ++i) {
            View v = this.getChildAt(i);
            MotionController f = new MotionController(v);
            this.mFrameArrayList.put(v, f);
        }
        this.mInTransition = true;
        this.computeCurrentPositions();
        if (!this.mEndConstraintSetComputed) {
            ConstraintSet endSet = this.mScene.getConstraintSet(targetID);
            endSet.applyToWithoutCustom(this);
            this.computeEndPositions(endSet);
        }
        int layoutWidth = this.getWidth();
        int layoutHeight = this.getHeight();
        for (int i = 0; i < n; ++i) {
            MotionController motionController = this.mFrameArrayList.get(this.getChildAt(i));
            this.mScene.getKeyFrames(motionController);
            motionController.setup(layoutWidth, layoutHeight, this.mTransitionDuration);
        }
        float stagger = this.mScene.getStaggered();
        if (stagger != 0.0f) {
            float y;
            float x;
            MotionController f;
            int i;
            float min = Float.MAX_VALUE;
            float max = -3.4028235E38f;
            for (i = 0; i < n; ++i) {
                f = this.mFrameArrayList.get(this.getChildAt(i));
                x = f.getFinalX();
                y = f.getFinalY();
                min = Math.min(min, y + x);
                max = Math.max(max, y + x);
            }
            for (i = 0; i < n; ++i) {
                f = this.mFrameArrayList.get(this.getChildAt(i));
                x = f.getFinalX();
                y = f.getFinalY();
                f.stagger_scale = 1.0f / (1.0f - stagger);
                f.stagger_offset = stagger - stagger * (x + y - min) / (max - min);
            }
        }
        this.requestLayout();
        this.mSetup = true;
        this.mTransitionPosition = 0.0f;
        this.mTransitionLastPosition = 0.0f;
        this.mInTransition = true;
        this.invalidate();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mLastWidthMeasureSpec = widthMeasureSpec;
        this.mLastHeightMeasureSpec = heightMeasureSpec;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onStartNestedScroll(View child, View target, int axes, int type) {
        this.mScrollTarget = target;
        return true;
    }

    public void onNestedScrollAccepted(View child, View target, int axes, int type) {
    }

    public void onStopNestedScroll(View target, int type) {
        this.mScene.processScrollUp(this.mScrollTargetDX / this.mScrollTargetDT, this.mScrollTargetDY / this.mScrollTargetDT);
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed, int type) {
        if (this.mScene != null && this.mScene.getMoveWhenScrollAtTop() && this.mTransitionPosition == 1.0f && target.canScrollVertically(-1)) {
            return;
        }
        boolean accepted = false;
        float progress = this.mTransitionPosition;
        long time = System.nanoTime();
        this.mScrollTargetDX = dx;
        this.mScrollTargetDY = dy;
        this.mScrollTargetDT = (float)((double)(time - this.mScrollTargetTime) * 1.0E-9);
        this.mScrollTargetTime = time;
        this.mScene.processScrollMove(dx, dy);
        if (progress != this.mTransitionPosition) {
            consumed[0] = dx;
            consumed[1] = dy;
        }
        this.evaluate(false);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    @Override
    public void dispatchDraw(Canvas canvas) {
        this.evaluate(false);
        super.dispatchDraw(canvas);
        if ((this.mDebugPath & 1) == 1 && !this.isInEditMode()) {
            ++this.mFrames;
            long currentDrawTime = System.nanoTime();
            if (this.mLastDrawTime != -1L) {
                long delay = currentDrawTime - this.mLastDrawTime;
                if (delay > 200000000L) {
                    float fps = (float)this.mFrames / ((float)delay * 1.0E-9f);
                    this.mLastFps = (float)((int)(fps * 100.0f)) / 100.0f;
                    this.mFrames = 0;
                    this.mLastDrawTime = currentDrawTime;
                }
            } else {
                this.mLastDrawTime = currentDrawTime;
            }
            Paint paint = new Paint();
            paint.setTextSize(42.0f);
            float p = (float)((int)(this.getProgress() * 1000.0f)) / 10.0f;
            String str = this.mLastFps + " fps " + Debug.getState(this, this.mBeginState) + " -> ";
            str = str + Debug.getState(this, this.mEndState) + " (progress: " + p + " ) state=" + (this.mCurrentState == -1 ? "undefined" : Debug.getState(this, this.mCurrentState));
            paint.setColor(-16777216);
            canvas.drawText(str, 11.0f, (float)(this.getHeight() - 29), paint);
            paint.setColor(-7864184);
            canvas.drawText(str, 10.0f, (float)(this.getHeight() - 30), paint);
        }
        if (this.mDebugPath > 1 || this.mScene == null) {
            if (this.mDevModeDraw == null) {
                this.mDevModeDraw = new DevModeDraw();
            }
            this.mDevModeDraw.draw(canvas, this.mFrameArrayList, this.mScene.getDuration(), this.mDebugPath);
        }
    }

    void evaluate(boolean force) {
        if (this.mTransitionLastPosition > 0.0f && this.mTransitionLastPosition < 1.0f) {
            this.mCurrentState = -1;
        }
        if (!this.mSetup) {
            force = true;
        }
        boolean newState = false;
        if (this.mKeepAnimating || this.mInTransition && (force || this.mTransitionGoalPosition != this.mTransitionLastPosition)) {
            if (!this.mSetup) {
                this.setupMotionViews();
            }
            float dir = Math.signum(this.mTransitionGoalPosition - this.mTransitionLastPosition);
            long currentTime = System.nanoTime();
            float deltaPos = 0.0f;
            if (!(this.mInterpolator instanceof StopLogic)) {
                deltaPos = dir * (float)(currentTime - this.mTransitionLastTime) * 1.0E-9f / this.mTransitionDuration;
            }
            float position = this.mTransitionLastPosition + deltaPos;
            boolean done = false;
            if (this.mTransitionInstantly) {
                position = this.mTransitionGoalPosition;
            }
            if (dir > 0.0f && position >= this.mTransitionGoalPosition || dir <= 0.0f && position <= this.mTransitionGoalPosition) {
                position = this.mTransitionGoalPosition;
                this.mInTransition = false;
                done = true;
            }
            this.mTransitionLastPosition = position;
            this.mTransitionLastTime = currentTime;
            if (this.mListener != null) {
                this.mListener.onTransitionChange(this, this.mScene.getStartId(), this.mScene.getEndId(), position);
            }
            if (this.mInterpolator != null && !done) {
                if (this.mTemporalInterpolator) {
                    float time = (float)(currentTime - this.mAnimationStartTime) * 1.0E-9f;
                    this.mTransitionLastPosition = position = this.mInterpolator.getInterpolation(time);
                    this.mTransitionLastTime = currentTime;
                } else {
                    position = this.mInterpolator.getInterpolation(position);
                }
            }
            if (dir > 0.0f && position >= this.mTransitionGoalPosition || dir <= 0.0f && position <= this.mTransitionGoalPosition) {
                position = this.mTransitionGoalPosition;
                this.mInTransition = false;
            }
            if (position >= 1.0f || position <= 0.0f) {
                this.mInTransition = false;
            }
            int n = this.getChildCount();
            this.mKeepAnimating = false;
            long time = System.nanoTime();
            for (int i = 0; i < n; ++i) {
                View child = this.getChildAt(i);
                MotionController frame = this.mFrameArrayList.get(child);
                if (frame == null) continue;
                this.mKeepAnimating |= frame.interpolate(child, position, time);
            }
            if (this.mKeepAnimating) {
                this.invalidate();
            }
            if (this.mInTransition) {
                this.invalidate();
            }
            if (position <= 0.0f && this.mBeginState != -1) {
                ConstraintSet set = this.mScene.getConstraintSet(this.mBeginState);
                if (set != null) {
                    set.applyTo(this);
                }
                if (!(this.mListener == null || this.mInTransition || this.mTransitionLastPosition > 0.0f && this.mTransitionLastPosition < 1.0f)) {
                    this.mListener.onTransitionCompleted(this, this.mBeginState);
                }
            }
            if ((double)position >= 1.0) {
                this.mCurrentState = this.mEndState;
                newState = true;
                ConstraintSet endSet = this.mScene.getConstraintSet(this.mCurrentState);
                endSet.applyTo(this);
                if (!(this.mListener == null || this.mInTransition || this.mTransitionLastPosition > 0.0f && this.mTransitionLastPosition < 1.0f)) {
                    this.mListener.onTransitionCompleted(this, this.mEndState);
                }
            }
        }
        if (this.mTransitionLastPosition >= 1.0f) {
            this.mCurrentState = this.mEndState;
            newState = true;
        } else if (this.mTransitionLastPosition <= 0.0f) {
            this.mCurrentState = this.mBeginState;
            newState = true;
        }
        if (newState) {
            this.onNewStateAttachHandlers();
        }
        this.mTransitionPosition = this.mTransitionLastPosition;
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int w = right - left;
        int h = bottom - top;
        if (this.mLastLayoutWidth != w || this.mLastLayoutHeight != h) {
            this.mStartConstraintSetComputed = false;
            this.mEndConstraintSetComputed = false;
            this.mSetup = false;
        }
        this.mLastLayoutWidth = w;
        this.mLastLayoutHeight = h;
        this.mLastWidthMeasureSpecOnLayout = this.mLastWidthMeasureSpec;
        this.mLastHeightMeasureSpecOnLayout = this.mLastHeightMeasureSpec;
        if (!(this.mIndirectTransition || this.mInTransition || (double)this.mTransitionPosition != 0.0 && (double)this.mTransitionPosition != 1.0)) {
            super.onLayout(changed, left, top, right, bottom);
        }
        this.mOldWidth = w;
        this.mOldHeight = h;
    }

    @Override
    protected void parseLayoutDescription(int id2) {
        this.mConstraintLayoutSpec = null;
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MotionLayout);
            int N = a.getIndexCount();
            boolean apply = true;
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.MotionLayout_layoutDescription) {
                    int n = a.getResourceId(attr, -1);
                    this.mScene = new MotionScene(this.getContext(), this, n);
                    continue;
                }
                if (attr == R.styleable.MotionLayout_currentState) {
                    this.mCurrentState = a.getResourceId(attr, -1);
                    continue;
                }
                if (attr == R.styleable.MotionLayout_progress) {
                    this.mTransitionGoalPosition = a.getFloat(attr, 0.0f);
                    this.mInTransition = true;
                    continue;
                }
                if (attr == R.styleable.MotionLayout_applyMotionScene) {
                    apply = a.getBoolean(attr, apply);
                    continue;
                }
                if (attr == R.styleable.MotionLayout_showPaths) {
                    if (this.mDebugPath != 0) continue;
                    this.mDebugPath = a.getBoolean(attr, false) ? 2 : 0;
                    continue;
                }
                if (attr != R.styleable.MotionLayout_motionDebug) continue;
                this.mDebugPath = a.getInt(attr, 0);
            }
            a.recycle();
            if (this.mScene == null) {
                Log.e((String)TAG, (String)"WARNING NO app:layoutDescription tag");
            }
            if (!apply) {
                this.mScene = null;
            }
        }
        this.mStartConstraintSetComputed = false;
        this.mEndConstraintSetComputed = false;
        if (this.mCurrentState == -1 && this.mScene != null) {
            this.mCurrentState = this.mScene.getStartId();
            this.mBeginState = this.mScene.getStartId();
            this.mEndState = this.mScene.getEndId();
        }
    }

    public void setDebugMode(int debugMode) {
        this.mDebugPath = debugMode;
        this.invalidate();
    }

    public void getDebugMode(boolean showPaths) {
        this.mDebugPath = showPaths ? 2 : 1;
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mScene != null && this.mScene.supportTouch()) {
            this.mScene.processTouchEvent(event, this.getCurrentState(), this);
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mScene != null && this.mCurrentState != -1) {
            ConstraintSet cSet = this.mScene.getConstraintSet(this.mCurrentState);
            this.mScene.readFallback(this);
            if (cSet != null) {
                cSet.applyTo(this);
            }
        }
        this.onNewStateAttachHandlers();
    }

    private void onNewStateAttachHandlers() {
        if (this.mScene == null) {
            return;
        }
        if (this.mCurrentState != -1) {
            this.mScene.addOnClickListeners(this, this.mCurrentState);
        }
        if (this.mScene.supportTouch()) {
            this.mScene.setupTouch();
        }
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public float getProgress() {
        return this.mTransitionLastPosition;
    }

    void getAnchorDpDt(int mTouchAnchorId, float pos, float locationX, float locationY, float[] mAnchorDpDt) {
        View v = this.getViewById(mTouchAnchorId);
        MotionController f = this.mFrameArrayList.get(v);
        if (f != null) {
            f.getDpDt(pos, locationX, locationY, mAnchorDpDt);
            float y = v.getY();
            float deltaPos = pos - this.lastPos;
            float deltaY = y - this.lastY;
            float dydp = deltaPos != 0.0f ? deltaY / deltaPos : Float.NaN;
            this.lastPos = pos;
            this.lastY = y;
        } else {
            String idName = v == null ? "" + mTouchAnchorId : v.getContext().getResources().getResourceName(mTouchAnchorId);
            Log.w((String)TAG, (String)("WARNING could not find view id " + idName));
        }
    }

    public long getTransitionTimeMs() {
        if (this.mScene != null) {
            this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        }
        return (long)this.mTransitionDuration * 1000L;
    }

    public void setTransitionListener(TransitionListener listener) {
        this.mListener = listener;
    }

    public DesignTool getDesignTool() {
        if (this.mDesignTool == null) {
            this.mDesignTool = new DesignTool(this);
        }
        return this.mDesignTool;
    }

    @Override
    public void onViewAdded(View view) {
        super.onViewAdded(view);
        if (view instanceof MotionHelper) {
            MotionHelper helper = (MotionHelper)view;
            if (helper.isUsedOnShow()) {
                if (this.mOnShowHelpers == null) {
                    this.mOnShowHelpers = new ArrayList();
                }
                this.mOnShowHelpers.add(helper);
            }
            if (helper.isUseOnHide()) {
                if (this.mOnHideHelpers == null) {
                    this.mOnHideHelpers = new ArrayList();
                }
                this.mOnHideHelpers.add(helper);
            }
        }
    }

    @Override
    public void onViewRemoved(View view) {
        super.onViewRemoved(view);
        if (this.mOnShowHelpers != null) {
            this.mOnShowHelpers.remove(view);
        }
        if (this.mOnHideHelpers != null) {
            this.mOnHideHelpers.remove(view);
        }
    }

    public void setOnShow(float progress) {
        if (this.mOnShowHelpers != null) {
            int count = this.mOnShowHelpers.size();
            for (int i = 0; i < count; ++i) {
                MotionHelper helper = this.mOnShowHelpers.get(i);
                helper.setProgress(progress);
            }
        }
    }

    public void setOnHide(float progress) {
        if (this.mOnHideHelpers != null) {
            int count = this.mOnHideHelpers.size();
            for (int i = 0; i < count; ++i) {
                MotionHelper helper = this.mOnHideHelpers.get(i);
                helper.setProgress(progress);
            }
        }
    }

    public int[] getConstraintSetIds() {
        if (this.mScene == null) {
            return null;
        }
        return this.mScene.getConstraintSetIds();
    }

    public ConstraintSet getConstraintSet(int id2) {
        if (this.mScene == null) {
            return null;
        }
        return this.mScene.getConstraintSet(id2);
    }

    public void rebuildMotion() {
        this.mSetup = false;
        this.setupMotionViews();
    }

    public ArrayList<MotionScene.Transition> getDefinedTransitions() {
        if (this.mScene == null) {
            return null;
        }
        return this.mScene.getDefinedTransitions();
    }

    public static interface TransitionListener {
        public void onTransitionStarted(MotionLayout var1, int var2, int var3);

        public void onTransitionChange(MotionLayout var1, int var2, int var3, float var4);

        public void onTransitionCompleted(MotionLayout var1, int var2);

        public void onTransitionTrigger(MotionLayout var1, int var2, boolean var3, float var4);
    }

    private class DevModeDraw {
        private static final int DEBUG_PATH_TICKS_PER_MS = 16;
        float[] mPoints;
        int[] mPathMode;
        float[] mKeyFramePoints;
        Path mPath;
        Paint mPaint;
        Paint mPaintKeyframes;
        Paint mPaintGraph;
        Paint mTextPaint;
        Paint mFillPaint;
        private float[] mRectangle;
        final int RED_COLOR = -21965;
        final int KEYFRAME_COLOR = -2067046;
        final int GRAPH_COLOR = -13391360;
        final int SHADOW_COLOR = 0x77000000;
        final int DIAMOND_SIZE = 10;
        DashPathEffect mDashPathEffect;
        int mKeyFrameCount;
        Rect mBounds = new Rect();
        boolean mPresentationMode = false;
        int mShadowTranslate = 1;

        public DevModeDraw() {
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setColor(-21965);
            this.mPaint.setStrokeWidth(2.0f);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaintKeyframes = new Paint();
            this.mPaintKeyframes.setAntiAlias(true);
            this.mPaintKeyframes.setColor(-2067046);
            this.mPaintKeyframes.setStrokeWidth(2.0f);
            this.mPaintKeyframes.setStyle(Paint.Style.STROKE);
            this.mPaintGraph = new Paint();
            this.mPaintGraph.setAntiAlias(true);
            this.mPaintGraph.setColor(-13391360);
            this.mPaintGraph.setStrokeWidth(2.0f);
            this.mPaintGraph.setStyle(Paint.Style.STROKE);
            this.mTextPaint = new Paint();
            this.mTextPaint.setAntiAlias(true);
            this.mTextPaint.setColor(-13391360);
            this.mTextPaint.setTextSize(12.0f * MotionLayout.this.getContext().getResources().getDisplayMetrics().density);
            this.mRectangle = new float[8];
            this.mFillPaint = new Paint();
            this.mFillPaint.setAntiAlias(true);
            this.mDashPathEffect = new DashPathEffect(new float[]{4.0f, 8.0f}, 0.0f);
            this.mPaintGraph.setPathEffect((PathEffect)this.mDashPathEffect);
            this.mKeyFramePoints = new float[100];
            this.mPathMode = new int[50];
            if (this.mPresentationMode) {
                this.mPaint.setStrokeWidth(8.0f);
                this.mFillPaint.setStrokeWidth(8.0f);
                this.mPaintKeyframes.setStrokeWidth(8.0f);
                this.mShadowTranslate = 4;
            }
        }

        public void draw(Canvas canvas, HashMap<View, MotionController> frameArrayList, int duration, int debugPath) {
            if (frameArrayList == null || frameArrayList.size() == 0) {
                return;
            }
            canvas.save();
            if (!MotionLayout.this.isInEditMode() && (1 & debugPath) == 2) {
                String str = MotionLayout.this.getContext().getResources().getResourceName(MotionLayout.this.mEndState) + ":" + MotionLayout.this.getProgress();
                canvas.drawText(str, 10.0f, (float)(MotionLayout.this.getHeight() - 30), this.mTextPaint);
                canvas.drawText(str, 11.0f, (float)(MotionLayout.this.getHeight() - 29), this.mPaint);
            }
            for (MotionController motionController : frameArrayList.values()) {
                int mode = motionController.getDrawPath();
                if (debugPath > 0 && mode == 0) {
                    mode = 1;
                }
                if (mode == 0) continue;
                this.mKeyFrameCount = motionController.buildKeyFrames(this.mKeyFramePoints, this.mPathMode);
                if (mode < 1) continue;
                int frames = duration / 16;
                if (this.mPoints == null || this.mPoints.length != frames * 2) {
                    this.mPoints = new float[frames * 2];
                    this.mPath = new Path();
                }
                canvas.translate((float)this.mShadowTranslate, (float)this.mShadowTranslate);
                this.mPaint.setColor(0x77000000);
                this.mFillPaint.setColor(0x77000000);
                this.mPaintKeyframes.setColor(0x77000000);
                this.mPaintGraph.setColor(0x77000000);
                motionController.buildPath(this.mPoints, frames);
                this.drawAll(canvas, mode, this.mKeyFrameCount, motionController);
                this.mPaint.setColor(-21965);
                this.mPaintKeyframes.setColor(-2067046);
                this.mFillPaint.setColor(-2067046);
                this.mPaintGraph.setColor(-13391360);
                canvas.translate((float)(-this.mShadowTranslate), (float)(-this.mShadowTranslate));
                this.drawAll(canvas, mode, this.mKeyFrameCount, motionController);
                if (mode != 5) continue;
                this.drawRectangle(canvas, motionController);
            }
            canvas.restore();
        }

        public void drawAll(Canvas canvas, int mode, int keyFrames, MotionController motionController) {
            if (mode == 4) {
                this.drawPathAsConfigured(canvas);
            }
            if (mode == 2) {
                this.drawPathRelative(canvas);
            }
            if (mode == 3) {
                this.drawPathCartesian(canvas);
            }
            this.drawBasicPath(canvas);
            this.drawTicks(canvas, mode, keyFrames, motionController);
        }

        private void drawBasicPath(Canvas canvas) {
            canvas.drawLines(this.mPoints, this.mPaint);
        }

        private void drawTicks(Canvas canvas, int mode, int keyFrames, MotionController motionController) {
            int viewWidth = 0;
            int viewHeight = 0;
            if (motionController.mView != null) {
                viewWidth = motionController.mView.getWidth();
                viewHeight = motionController.mView.getHeight();
            }
            for (int i = 1; i < keyFrames - 1; ++i) {
                if (mode == 4 && this.mPathMode[i - 1] == 0) continue;
                float x = this.mKeyFramePoints[i * 2];
                float y = this.mKeyFramePoints[i * 2 + 1];
                this.mPath.reset();
                this.mPath.moveTo(x, y + 10.0f);
                this.mPath.lineTo(x + 10.0f, y);
                this.mPath.lineTo(x, y - 10.0f);
                this.mPath.lineTo(x - 10.0f, y);
                this.mPath.close();
                MotionPaths framePoint = motionController.getKeyFrame(i - 1);
                float dx = 0.0f;
                float dy = 0.0f;
                if (mode == 4) {
                    if (this.mPathMode[i - 1] == 1) {
                        this.drawPathRelativeTicks(canvas, x - dx, y - dy);
                    } else if (this.mPathMode[i - 1] == 2) {
                        this.drawPathCartesianTicks(canvas, x - dx, y - dy);
                    } else if (this.mPathMode[i - 1] == 3) {
                        this.drawPathScreenTicks(canvas, x - dx, y - dy, viewWidth, viewHeight);
                    }
                    canvas.drawPath(this.mPath, this.mFillPaint);
                }
                if (mode == 2) {
                    this.drawPathRelativeTicks(canvas, x - dx, y - dy);
                }
                if (mode == 3) {
                    this.drawPathCartesianTicks(canvas, x - dx, y - dy);
                }
                if (mode == 6) {
                    this.drawPathScreenTicks(canvas, x - dx, y - dy, viewWidth, viewHeight);
                }
                if (dx != 0.0f || dy != 0.0f) {
                    this.drawTranslation(canvas, x - dx, y - dy, x, y);
                    continue;
                }
                canvas.drawPath(this.mPath, this.mFillPaint);
            }
            canvas.drawCircle(this.mPoints[0], this.mPoints[1], 8.0f, this.mPaintKeyframes);
            canvas.drawCircle(this.mPoints[this.mPoints.length - 2], this.mPoints[this.mPoints.length - 1], 8.0f, this.mPaintKeyframes);
        }

        private void drawTranslation(Canvas canvas, float x1, float y1, float x2, float y2) {
            canvas.drawRect(x1, y1, x2, y2, this.mPaintGraph);
            canvas.drawLine(x1, y1, x2, y2, this.mPaintGraph);
        }

        private void drawPathRelative(Canvas canvas) {
            canvas.drawLine(this.mPoints[0], this.mPoints[1], this.mPoints[this.mPoints.length - 2], this.mPoints[this.mPoints.length - 1], this.mPaintGraph);
        }

        private void drawPathAsConfigured(Canvas canvas) {
            boolean path = false;
            boolean cart = false;
            for (int i = 0; i < this.mKeyFrameCount; ++i) {
                if (this.mPathMode[i] == 1) {
                    path = true;
                }
                if (this.mPathMode[i] != 2) continue;
                cart = true;
            }
            if (path) {
                this.drawPathRelative(canvas);
            }
            if (cart) {
                this.drawPathCartesian(canvas);
            }
        }

        private void drawPathRelativeTicks(Canvas canvas, float x, float y) {
            float x1 = this.mPoints[0];
            float y1 = this.mPoints[1];
            float x2 = this.mPoints[this.mPoints.length - 2];
            float y2 = this.mPoints[this.mPoints.length - 1];
            float dist = (float)Math.hypot(x1 - x2, y1 - y2);
            float t = ((x - x1) * (x2 - x1) + (y - y1) * (y2 - y1)) / (dist * dist);
            float xp = x1 + t * (x2 - x1);
            float yp = y1 + t * (y2 - y1);
            Path path = new Path();
            path.moveTo(x, y);
            path.lineTo(xp, yp);
            float len = (float)Math.hypot(xp - x, yp - y);
            String text = "" + (float)((int)(100.0f * len / dist)) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            float off = len / 2.0f - (float)(this.mBounds.width() / 2);
            canvas.drawTextOnPath(text, path, off, -20.0f, this.mTextPaint);
            canvas.drawLine(x, y, xp, yp, this.mPaintGraph);
        }

        void getTextBounds(String text, Paint paint) {
            paint.getTextBounds(text, 0, text.length(), this.mBounds);
        }

        private void drawPathCartesian(Canvas canvas) {
            float x1 = this.mPoints[0];
            float y1 = this.mPoints[1];
            float x2 = this.mPoints[this.mPoints.length - 2];
            float y2 = this.mPoints[this.mPoints.length - 1];
            canvas.drawLine(Math.min(x1, x2), Math.max(y1, y2), Math.max(x1, x2), Math.max(y1, y2), this.mPaintGraph);
            canvas.drawLine(Math.min(x1, x2), Math.min(y1, y2), Math.min(x1, x2), Math.max(y1, y2), this.mPaintGraph);
        }

        private void drawPathCartesianTicks(Canvas canvas, float x, float y) {
            float x1 = this.mPoints[0];
            float y1 = this.mPoints[1];
            float x2 = this.mPoints[this.mPoints.length - 2];
            float y2 = this.mPoints[this.mPoints.length - 1];
            float minx = Math.min(x1, x2);
            float maxy = Math.max(y1, y2);
            float xgap = x - Math.min(x1, x2);
            float ygap = Math.max(y1, y2) - y;
            String text = "" + (float)((int)(0.5 + (double)(100.0f * xgap / Math.abs(x2 - x1)))) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            float off = xgap / 2.0f - (float)(this.mBounds.width() / 2);
            canvas.drawText(text, off + minx, y - 20.0f, this.mTextPaint);
            canvas.drawLine(x, y, Math.min(x1, x2), y, this.mPaintGraph);
            text = "" + (float)((int)(0.5 + (double)(100.0f * ygap / Math.abs(y2 - y1)))) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            off = ygap / 2.0f - (float)(this.mBounds.height() / 2);
            canvas.drawText(text, x + 5.0f, maxy - off, this.mTextPaint);
            canvas.drawLine(x, y, x, Math.max(y1, y2), this.mPaintGraph);
        }

        private void drawPathScreenTicks(Canvas canvas, float x, float y, int viewWidth, int viewHeight) {
            float x1 = 0.0f;
            float y1 = 0.0f;
            float x2 = 1.0f;
            float y2 = 1.0f;
            float minx = 0.0f;
            float maxy = 0.0f;
            float xgap = x;
            float ygap = y;
            String text = "" + (float)((int)(0.5 + (double)(100.0f * (xgap - (float)(viewWidth / 2)) / (float)(MotionLayout.this.getWidth() - viewWidth)))) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            float off = xgap / 2.0f - (float)(this.mBounds.width() / 2);
            canvas.drawText(text, off + minx, y - 20.0f, this.mTextPaint);
            canvas.drawLine(x, y, Math.min(x1, x2), y, this.mPaintGraph);
            text = "" + (float)((int)(0.5 + (double)(100.0f * (ygap - (float)(viewHeight / 2)) / (float)(MotionLayout.this.getHeight() - viewHeight)))) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            off = ygap / 2.0f - (float)(this.mBounds.height() / 2);
            canvas.drawText(text, x + 5.0f, maxy - off, this.mTextPaint);
            canvas.drawLine(x, y, x, Math.max(y1, y2), this.mPaintGraph);
        }

        private void drawRectangle(Canvas canvas, MotionController motionController) {
            this.mPath.reset();
            int rectFrames = 50;
            for (int i = 0; i <= rectFrames; ++i) {
                float p = (float)i / (float)rectFrames;
                motionController.buildRect(p, this.mRectangle, 0);
                this.mPath.moveTo(this.mRectangle[0], this.mRectangle[1]);
                this.mPath.lineTo(this.mRectangle[2], this.mRectangle[3]);
                this.mPath.lineTo(this.mRectangle[4], this.mRectangle[5]);
                this.mPath.lineTo(this.mRectangle[6], this.mRectangle[7]);
                this.mPath.close();
            }
            this.mPaint.setColor(0x44000000);
            canvas.translate(2.0f, 2.0f);
            canvas.drawPath(this.mPath, this.mPaint);
            canvas.translate(-2.0f, -2.0f);
            this.mPaint.setColor(-65536);
            canvas.drawPath(this.mPath, this.mPaint);
        }
    }
}

