/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.support.constraint.ConstraintSet;
import android.support.constraint.R;
import android.support.constraint.StateSet;
import android.support.constraint.motion.Key;
import android.support.constraint.motion.KeyFrames;
import android.support.constraint.motion.MotionController;
import android.support.constraint.motion.MotionLayout;
import android.support.constraint.motion.TouchResponse;
import android.support.constraint.motion.utils.Easing;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.Xml;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MotionScene {
    public static final String TAG = "MotionScene";
    static final int TRANSITION_BACKWARD = 0;
    static final int TRANSITION_FORWARD = 1;
    private static final int SPLINE_STRING = -1;
    private static final int INTERPOLATOR_REFRENCE_ID = -2;
    public static final int UNSET = -1;
    private static final boolean DEBUG = false;
    private final MotionLayout mMotionLayout;
    StateSet mStateSet = null;
    Transition mCurrentTransition = null;
    private ArrayList<Transition> mTransitionList = new ArrayList();
    private SparseArray<ConstraintSet> mConstraintSetMap = new SparseArray();
    private boolean DEBUG_DESKTOP = false;
    private int mDefaultDuration = 100;
    private MotionEvent mLastTouchDonw;
    private VelocityTracker mVelocityTracker;
    float mLastTouchX;
    float mLastTouchY;
    static final int EASE_IN_OUT = 0;
    static final int EASE_IN = 1;
    static final int EASE_OUT = 2;
    static final int LINEAR = 3;
    static final int ANTICIPATE = 4;
    static final int BOUNCE = 5;

    void setTransition(int beginId, int endId) {
        int start = beginId;
        int end = endId;
        if (this.mStateSet != null) {
            int tmp = this.mStateSet.stateGetConstraintID(beginId, -1, -1);
            if (tmp != -1) {
                start = tmp;
            }
            if ((tmp = this.mStateSet.stateGetConstraintID(endId, -1, -1)) != -1) {
                end = tmp;
            }
        }
        for (Transition transition : this.mTransitionList) {
            if ((transition.mConstraintSetEnd != end || transition.mConstraintSetStart != start) && (transition.mConstraintSetEnd != endId || transition.mConstraintSetStart != beginId)) continue;
            this.mCurrentTransition = transition;
            return;
        }
        Transition t = new Transition(this);
        t.mConstraintSetStart = start;
        t.mConstraintSetEnd = end;
        t.mDuration = this.mDefaultDuration;
        this.mTransitionList.add(t);
        this.mCurrentTransition = t;
    }

    public void setTransition(Transition transition) {
        this.mCurrentTransition = transition;
    }

    private int getRealID(int stateid) {
        int tmp;
        if (this.mStateSet != null && (tmp = this.mStateSet.stateGetConstraintID(stateid, -1, -1)) != -1) {
            return tmp;
        }
        return stateid;
    }

    public List<Transition> getTransitionsWithState(int stateid) {
        stateid = this.getRealID(stateid);
        ArrayList<Transition> ret = new ArrayList<Transition>();
        for (Transition transition : this.mTransitionList) {
            if (transition.mConstraintSetStart != stateid && transition.mConstraintSetEnd != stateid) continue;
            ret.add(transition);
        }
        return ret;
    }

    public void addOnClickListeners(MotionLayout motionLayout, int currentState) {
        for (Transition transition : this.mTransitionList) {
            if (transition.mOnClicks.size() <= 0) continue;
            for (Transition.TransitionOnClick onClick : transition.mOnClicks) {
                if (currentState == transition.mConstraintSetStart || currentState == transition.mConstraintSetEnd) {
                    onClick.addOnClickListeners(motionLayout);
                    continue;
                }
                onClick.removeOnClickListeners(motionLayout);
            }
        }
    }

    public Transition bestTransitionFor(int currentState, float dx, float dy) {
        List<Transition> candidates = null;
        if (currentState != -1) {
            candidates = this.getTransitionsWithState(currentState);
            float max = 0.0f;
            Transition best = null;
            for (Transition transition : candidates) {
                if (transition.mTouchResponse == null) continue;
                float val = transition.mTouchResponse.dot(dx, dy);
                if (transition.mConstraintSetEnd == currentState) {
                    val *= -1.0f;
                }
                if (!(val > max)) continue;
                max = val;
                best = transition;
            }
            return best;
        }
        return this.mCurrentTransition;
    }

    public ArrayList<Transition> getDefinedTransitions() {
        return this.mTransitionList;
    }

    public int[] getConstraintSetIds() {
        int[] ids = new int[this.mConstraintSetMap.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.mConstraintSetMap.keyAt(i);
        }
        return ids;
    }

    MotionScene(Context context, MotionLayout layout, int resourceID) {
        this.mMotionLayout = layout;
        this.load(context, resourceID);
    }

    private void load(Context context, int resourceId) {
        Resources res = context.getResources();
        XmlResourceParser parser = res.getXml(resourceId);
        String document = null;
        String tagName = null;
        try {
            Transition transition = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                block1 : switch (eventType) {
                    case 0: {
                        document = parser.getName();
                        break;
                    }
                    case 2: {
                        tagName = parser.getName();
                        if (this.DEBUG_DESKTOP) {
                            System.out.println("parsing = " + tagName);
                        }
                        switch (tagName) {
                            case "MotionScene": {
                                this.parseMotionSceneTags(context, (XmlPullParser)parser);
                                break;
                            }
                            case "Transition": {
                                transition = new Transition(this, context, (XmlPullParser)parser);
                                this.mTransitionList.add(transition);
                                if (this.mCurrentTransition != null) break block1;
                                this.mCurrentTransition = transition;
                                break;
                            }
                            case "OnSwipe": {
                                if (transition == null) {
                                    String name = context.getResources().getResourceEntryName(resourceId);
                                    int line = parser.getLineNumber();
                                    Log.v((String)TAG, (String)(" OnSwipe (" + name + ".xml:" + line + ")"));
                                }
                                transition.mTouchResponse = new TouchResponse(context, this.mMotionLayout, (XmlPullParser)parser);
                                break;
                            }
                            case "OnClick": {
                                transition.addOnClick(context, (XmlPullParser)parser);
                                break;
                            }
                            case "StateSet": {
                                this.mStateSet = new StateSet(context, (XmlPullParser)parser);
                                break;
                            }
                            case "ConstraintSet": {
                                this.parseConstraintSet(context, (XmlPullParser)parser);
                                break;
                            }
                            case "KeyFrameSet": {
                                KeyFrames keyFrames = new KeyFrames(context, (XmlPullParser)parser);
                                transition.mKeyFramesList.add(keyFrames);
                                break;
                            }
                            default: {
                                Log.v((String)TAG, (String)("WARNING UNKNOWN ATTRIBUTE " + tagName));
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        tagName = null;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseMotionSceneTags(Context context, XmlPullParser parser) {
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MotionScene);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr = a.getIndex(i);
            if (attr != R.styleable.MotionScene_duration) continue;
            this.mDefaultDuration = a.getInt(attr, this.mDefaultDuration);
        }
        a.recycle();
    }

    private void parseConstraintSet(Context context, XmlPullParser parser) {
        ConstraintSet set = new ConstraintSet();
        set.setForceId(false);
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!"id".equals(parser.getAttributeName(i))) continue;
            String s = parser.getAttributeValue(i);
            if (this.DEBUG_DESKTOP) {
                System.out.println("id string = " + s);
            }
            int id2 = -1;
            if (s.contains("/")) {
                String tmp = s.substring(s.indexOf(47) + 1);
                id2 = context.getResources().getIdentifier(tmp, "id", context.getPackageName());
                if (this.DEBUG_DESKTOP) {
                    System.out.println("id getMap res = " + id2);
                }
            }
            if (id2 == -1) {
                if (s != null && s.length() > 1) {
                    id2 = Integer.parseInt(s.substring(1));
                } else {
                    Log.e((String)TAG, (String)"error in parsing id");
                }
            }
            set.load(context, parser);
            this.mConstraintSetMap.put(id2, (Object)set);
            break;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    public ConstraintSet getConstraintSet(Context context, String id2) {
        if (this.DEBUG_DESKTOP) {
            System.out.println("id " + id2);
            System.out.println("size " + this.mConstraintSetMap.size());
        }
        for (int i = 0; i < this.mConstraintSetMap.size(); ++i) {
            int key = this.mConstraintSetMap.keyAt(i);
            String IdAsString = context.getResources().getResourceName(key);
            System.out.println("Id for <" + i + "> is <" + IdAsString + "> looking for <" + id2 + ">");
            if (!id2.equals(IdAsString)) continue;
            return (ConstraintSet)this.mConstraintSetMap.get(key);
        }
        return null;
    }

    ConstraintSet getConstraintSet(int id2) {
        return this.getConstraintSet(id2, -1, -1);
    }

    ConstraintSet getConstraintSet(int id2, int width, int height) {
        int cid;
        if (this.DEBUG_DESKTOP) {
            System.out.println("id " + id2);
            System.out.println("size " + this.mConstraintSetMap.size());
        }
        if (this.mStateSet != null && (cid = this.mStateSet.stateGetConstraintID(id2, width, height)) != -1) {
            id2 = cid;
        }
        if (this.mConstraintSetMap.get(id2) == null) {
            return (ConstraintSet)this.mConstraintSetMap.get(this.mConstraintSetMap.keyAt(0));
        }
        return (ConstraintSet)this.mConstraintSetMap.get(id2);
    }

    public void getKeyFrames(MotionController motionController) {
        if (this.mCurrentTransition == null) {
            return;
        }
        for (KeyFrames keyFrames : this.mCurrentTransition.mKeyFramesList) {
            keyFrames.addFrames(motionController);
        }
    }

    Key getKeyFrame(Context context, int type, int target, int position) {
        if (this.mCurrentTransition == null) {
            return null;
        }
        for (KeyFrames keyFrames : this.mCurrentTransition.mKeyFramesList) {
            for (Integer integer : keyFrames.getKeys()) {
                if (target != integer) continue;
                ArrayList<Key> keys = keyFrames.getKeyFramesForView(integer);
                for (Key key : keys) {
                    if (key.mFramePosition != position || key.mType != type) continue;
                    return key;
                }
            }
        }
        return null;
    }

    int getTransitionDirection(int stateId) {
        for (Transition transition : this.mTransitionList) {
            if (transition.mConstraintSetStart != stateId) continue;
            return 0;
        }
        return 1;
    }

    boolean hasKeyFramePosition(View view, int position) {
        if (this.mCurrentTransition == null) {
            return false;
        }
        for (KeyFrames keyFrames : this.mCurrentTransition.mKeyFramesList) {
            ArrayList<Key> framePoints = keyFrames.getKeyFramesForView(view.getId());
            for (Key framePoint : framePoints) {
                if (framePoint.mFramePosition != position) continue;
                return true;
            }
        }
        return false;
    }

    public void setKeyframe(View view, int position, String name, Object value) {
        if (this.mCurrentTransition == null) {
            return;
        }
        for (KeyFrames keyFrames : this.mCurrentTransition.mKeyFramesList) {
            ArrayList<Key> framePoints = keyFrames.getKeyFramesForView(view.getId());
            for (Key framePoint : framePoints) {
                if (framePoint.mFramePosition != position) continue;
                float v = 0.0f;
                if (value != null) {
                    v = ((Float)value).floatValue();
                }
                if (v == 0.0f) {
                    v = 0.01f;
                }
                if (!name.equalsIgnoreCase("app:PerpendicularPath_percent")) continue;
            }
        }
    }

    public float getPathPercent(View view, int position) {
        return 0.0f;
    }

    boolean supportTouch() {
        return this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null;
    }

    void processTouchEvent(MotionEvent event, int currentState, MotionLayout motionLayout) {
        if (this.mCurrentTransition.mTouchResponse == null) {
            return;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        if (currentState != -1) {
            switch (event.getAction()) {
                case 0: {
                    this.mLastTouchX = event.getRawX();
                    this.mLastTouchY = event.getRawY();
                    this.mLastTouchDonw = event;
                    this.mCurrentTransition.mTouchResponse.setDown(this.mLastTouchX, this.mLastTouchY);
                    return;
                }
                case 2: {
                    float dy = event.getRawY() - this.mLastTouchY;
                    float dx = event.getRawX() - this.mLastTouchX;
                    if ((double)dx == 0.0 && (double)dy == 0.0) {
                        return;
                    }
                    Transition transition = this.bestTransitionFor(currentState, dx, dy);
                    if (transition == null) break;
                    motionLayout.setTransition(transition);
                    this.mCurrentTransition.mTouchResponse.setUpTouchEvent(this.mLastTouchX, this.mLastTouchY);
                }
            }
        }
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            this.mCurrentTransition.mTouchResponse.processTouchEvent(event, this.mVelocityTracker, currentState, this);
        }
        this.mLastTouchX = event.getRawX();
        this.mLastTouchY = event.getRawY();
        if (event.getAction() == 1 && this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    void processScrollMove(float dx, float dy) {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            this.mCurrentTransition.mTouchResponse.scrollMove(dx, dy);
        }
    }

    void processScrollUp(float dx, float dy) {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            this.mCurrentTransition.mTouchResponse.scrollUp(dx, dy);
        }
    }

    int getStartId() {
        if (this.mCurrentTransition == null) {
            return -1;
        }
        return this.mCurrentTransition.mConstraintSetStart;
    }

    int getEndId() {
        if (this.mCurrentTransition == null) {
            return -1;
        }
        return this.mCurrentTransition.mConstraintSetEnd;
    }

    public Interpolator getInterpolator() {
        switch (this.mCurrentTransition.mDefaultInterpolator) {
            case -1: {
                final Easing easing = Easing.getInterpolator(this.mCurrentTransition.mDefaultInterpolatorString);
                return new Interpolator(){

                    public float getInterpolation(float v) {
                        return (float)easing.get(v);
                    }
                };
            }
            case -2: {
                return AnimationUtils.loadInterpolator((Context)this.mMotionLayout.getContext(), (int)this.mCurrentTransition.mDefaultInterpolatorID);
            }
            case 0: {
                return new AccelerateDecelerateInterpolator();
            }
            case 1: {
                return new AnticipateInterpolator();
            }
            case 2: {
                return new DecelerateInterpolator();
            }
            case 3: {
                return null;
            }
            case 4: {
                return new AnticipateInterpolator();
            }
            case 5: {
                return new BounceInterpolator();
            }
        }
        return null;
    }

    public int getDuration() {
        if (this.mCurrentTransition != null) {
            return this.mCurrentTransition.mDuration;
        }
        return 300;
    }

    public float getStaggered() {
        if (this.mCurrentTransition != null) {
            return this.mCurrentTransition.mStagger;
        }
        return 0.0f;
    }

    float getMaxAcceleration() {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            return this.mCurrentTransition.mTouchResponse.getMaxAcceleration();
        }
        return 0.0f;
    }

    float getMaxVelocity() {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            return this.mCurrentTransition.mTouchResponse.getMaxVelocity();
        }
        return 0.0f;
    }

    void setupTouch() {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            this.mCurrentTransition.mTouchResponse.setupTouch();
        }
    }

    boolean getMoveWhenScrollAtTop() {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            return this.mCurrentTransition.mTouchResponse.getMoveWhenScrollAtTop();
        }
        return false;
    }

    void readFallback(MotionLayout motionLayout) {
        for (int i = 0; i < this.mConstraintSetMap.size(); ++i) {
            ConstraintSet cs = (ConstraintSet)this.mConstraintSetMap.valueAt(i);
            cs.readFallback(motionLayout);
        }
    }

    static class Transition {
        private int mConstraintSetEnd = 0;
        private int mConstraintSetStart = 0;
        private int mDefaultInterpolator = 0;
        private String mDefaultInterpolatorString = null;
        private int mDefaultInterpolatorID = -1;
        private int mDuration = 400;
        private float mStagger = 0.0f;
        private final MotionScene mMotionScene;
        private ArrayList<KeyFrames> mKeyFramesList = new ArrayList();
        private TouchResponse mTouchResponse = null;
        private ArrayList<TransitionOnClick> mOnClicks = new ArrayList();

        public void addOnClick(Context context, XmlPullParser parser) {
            this.mOnClicks.add(new TransitionOnClick(context, this, parser));
        }

        public int getEndConstraintSetId() {
            return this.mConstraintSetEnd;
        }

        public int getStartConstraintSetId() {
            return this.mConstraintSetStart;
        }

        public void setDuration(int duration) {
            this.mDuration = duration;
        }

        public int getDuration() {
            return this.mDuration;
        }

        public float getStagger() {
            return this.mStagger;
        }

        public List<KeyFrames> getKeyFrameList() {
            return this.mKeyFramesList;
        }

        public List<TransitionOnClick> getOnClickList() {
            return this.mOnClicks;
        }

        public TouchResponse getTouchResponse() {
            return this.mTouchResponse;
        }

        public void setStagger(float stagger) {
            this.mStagger = stagger;
        }

        public String debugString(Context context) {
            String ret = this.mConstraintSetEnd == -1 ? "null" : context.getResources().getResourceEntryName(this.mConstraintSetStart);
            ret = ret + " -> " + context.getResources().getResourceEntryName(this.mConstraintSetEnd);
            return ret;
        }

        Transition(MotionScene motionScene) {
            this.mMotionScene = motionScene;
        }

        Transition(MotionScene motionScene, Context context, XmlPullParser parser) {
            this.mMotionScene = motionScene;
            this.fillFromAttributeList(motionScene, context, Xml.asAttributeSet((XmlPullParser)parser));
        }

        private void fillFromAttributeList(MotionScene motionScene, Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Transition);
            this.fill(motionScene, context, a);
            a.recycle();
        }

        private void fill(MotionScene motionScene, Context context, TypedArray a) {
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                ConstraintSet cSet;
                Object type;
                int attr = a.getIndex(i);
                if (attr == R.styleable.Transition_constraintSetEnd) {
                    this.mConstraintSetEnd = a.getResourceId(attr, this.mConstraintSetEnd);
                    type = context.getResources().getResourceTypeName(this.mConstraintSetEnd);
                    if (!"layout".equals(type)) continue;
                    cSet = new ConstraintSet();
                    cSet.load(context, this.mConstraintSetEnd);
                    motionScene.mConstraintSetMap.append(this.mConstraintSetEnd, (Object)cSet);
                    continue;
                }
                if (attr == R.styleable.Transition_constraintSetStart) {
                    this.mConstraintSetStart = a.getResourceId(attr, this.mConstraintSetStart);
                    type = context.getResources().getResourceTypeName(this.mConstraintSetStart);
                    if (!"layout".equals(type)) continue;
                    cSet = new ConstraintSet();
                    cSet.load(context, this.mConstraintSetStart);
                    motionScene.mConstraintSetMap.append(this.mConstraintSetStart, (Object)cSet);
                    continue;
                }
                if (attr == R.styleable.Transition_interpolator) {
                    type = a.peekValue(attr);
                    if (type.type == 1) {
                        this.mDefaultInterpolatorID = a.getResourceId(attr, -1);
                        if (this.mDefaultInterpolatorID == -1) continue;
                        this.mDefaultInterpolator = -2;
                        continue;
                    }
                    if (type.type == 3) {
                        this.mDefaultInterpolatorString = a.getString(attr);
                        if (this.mDefaultInterpolatorString.indexOf("/") > 0) {
                            this.mDefaultInterpolatorID = a.getResourceId(attr, -1);
                            this.mDefaultInterpolator = -2;
                            continue;
                        }
                        this.mDefaultInterpolator = -1;
                        continue;
                    }
                    this.mDefaultInterpolator = a.getInteger(attr, this.mDefaultInterpolator);
                    continue;
                }
                if (attr == R.styleable.Transition_duration) {
                    this.mDuration = a.getInt(attr, this.mDuration);
                    continue;
                }
                if (attr != R.styleable.Transition_staggered) continue;
                this.mStagger = a.getFloat(attr, this.mStagger);
            }
        }

        static class TransitionOnClick
        implements View.OnClickListener {
            private final Transition mTransition;
            int mTargetId;
            int mode = 1;
            public static final int FORWARD = 0;
            public static final int TOGGLE = 1;
            public static final int BACKWARD = 2;
            public static final int TO_END = 3;
            public static final int TO_START = 4;

            public TransitionOnClick(Context context, Transition transition, XmlPullParser parser) {
                this.mTransition = transition;
                TypedArray a = context.obtainStyledAttributes(Xml.asAttributeSet((XmlPullParser)parser), R.styleable.OnClick);
                int N = a.getIndexCount();
                for (int i = 0; i < N; ++i) {
                    int attr = a.getIndex(i);
                    if (attr == R.styleable.OnClick_target) {
                        this.mTargetId = a.getResourceId(attr, this.mTargetId);
                        continue;
                    }
                    if (attr != R.styleable.OnClick_clickAction) continue;
                    this.mode = a.getInt(attr, this.mode);
                }
                a.recycle();
            }

            public void addOnClickListeners(MotionLayout motionLayout) {
                View v = motionLayout.findViewById(this.mTargetId);
                if (v == null) {
                    Log.e((String)MotionScene.TAG, (String)(" (*)  could not find id " + this.mTargetId));
                    return;
                }
                v.setOnClickListener((View.OnClickListener)this);
            }

            public void removeOnClickListeners(MotionLayout motionLayout) {
                View v = motionLayout.findViewById(this.mTargetId);
                if (v == null) {
                    Log.e((String)MotionScene.TAG, (String)(" (*)  could not find id " + this.mTargetId));
                    return;
                }
                v.setOnClickListener(null);
            }

            boolean isTransitionViable(Transition current, boolean forward, MotionLayout tl) {
                int from;
                if (this.mTransition == current) {
                    return true;
                }
                int dest = forward ? this.mTransition.mConstraintSetEnd : this.mTransition.mConstraintSetStart;
                int n = from = forward ? this.mTransition.mConstraintSetStart : this.mTransition.mConstraintSetEnd;
                if (tl.getProgress() == 0.0f) {
                    return tl.mCurrentState == from;
                }
                if (tl.getProgress() == 1.0f) {
                    return tl.mCurrentState == dest;
                }
                return false;
            }

            public void onClick(View view) {
                MotionLayout tl = this.mTransition.mMotionScene.mMotionLayout;
                Transition current = ((Transition)this.mTransition).mMotionScene.mCurrentTransition;
                switch (this.mode) {
                    case 0: {
                        if (!this.isTransitionViable(current, true, tl)) break;
                        tl.transitionToEnd();
                        break;
                    }
                    case 2: {
                        if (!this.isTransitionViable(current, false, tl)) break;
                        tl.transitionToStart();
                        break;
                    }
                    case 1: {
                        if (((Transition)this.mTransition).mMotionScene.mCurrentTransition != this.mTransition) {
                            tl.setTransition(this.mTransition);
                        }
                        if (tl.getProgress() > 0.5f) {
                            tl.transitionToStart();
                            break;
                        }
                        tl.transitionToEnd();
                        break;
                    }
                    case 3: {
                        tl.setState(this.mTransition.mConstraintSetEnd, -1, -1);
                        break;
                    }
                    case 4: {
                        tl.setState(this.mTransition.mConstraintSetEnd, -1, -1);
                    }
                }
            }
        }
    }
}

