/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion.utils;

import android.view.animation.Interpolator;

public class StopLogic
implements Interpolator {
    private float mStage1Velocity;
    private float mStage2Velocity;
    private float mStage3Velocity;
    private float mStage1Duration;
    private float mStage2Duration;
    private float mStage3Duration;
    private float mStage1EndPosition;
    private float mStage2EndPosition;
    private float mStage3EndPosition;
    private int mNumberOfStages;
    private boolean mBackwards = false;
    private float mStartPosition;

    public float getVelocity(float x) {
        if (x <= this.mStage1Duration) {
            return this.mStage1Velocity + (this.mStage2Velocity - this.mStage1Velocity) * x / this.mStage1Duration;
        }
        if (this.mNumberOfStages == 1) {
            return 0.0f;
        }
        if ((x -= this.mStage1Duration) < this.mStage2Duration) {
            return this.mStage2Velocity + (this.mStage3Velocity - this.mStage2Velocity) * x / this.mStage2Duration;
        }
        if (this.mNumberOfStages == 2) {
            return this.mStage2EndPosition;
        }
        if ((x -= this.mStage2Duration) < this.mStage3Duration) {
            return this.mStage3Velocity - this.mStage3Velocity * x / this.mStage3Duration;
        }
        return this.mStage3EndPosition;
    }

    private float calcY(float time) {
        if (time <= this.mStage1Duration) {
            return this.mStage1Velocity * time + (this.mStage2Velocity - this.mStage1Velocity) * time * time / (2.0f * this.mStage1Duration);
        }
        if (this.mNumberOfStages == 1) {
            return this.mStage1EndPosition;
        }
        if ((time -= this.mStage1Duration) < this.mStage2Duration) {
            return this.mStage1EndPosition + this.mStage2Velocity * time + (this.mStage3Velocity - this.mStage2Velocity) * time * time / (2.0f * this.mStage2Duration);
        }
        if (this.mNumberOfStages == 2) {
            return this.mStage2EndPosition;
        }
        if ((time -= this.mStage2Duration) < this.mStage3Duration) {
            return this.mStage2EndPosition + this.mStage3Velocity * time - this.mStage3Velocity * time * time / (2.0f * this.mStage3Duration);
        }
        return this.mStage3EndPosition;
    }

    public void config(float currentPos, float destination, float currentVelocity, float maxTime, float maxAcceleration, float maxVelocity) {
        this.mStartPosition = currentPos;
        boolean bl = this.mBackwards = currentPos > destination;
        if (this.mBackwards) {
            this.setup(-currentVelocity, currentPos - destination, maxAcceleration, maxVelocity, maxTime);
        } else {
            this.setup(currentVelocity, destination - currentPos, maxAcceleration, maxVelocity, maxTime);
        }
    }

    public float getInterpolation(float v) {
        float y = this.calcY(v);
        return this.mBackwards ? this.mStartPosition - y : this.mStartPosition + y;
    }

    private void setup(float velocity, float distance, float maxAcceleration, float maxVelocity, float maxTime) {
        this.mStage1Velocity = velocity;
        float min_time_to_stop = velocity / maxAcceleration;
        float stopDistance = min_time_to_stop * velocity / 2.0f;
        if (velocity < 0.0f) {
            float timeToZeroVelocity = -velocity / maxAcceleration;
            float reversDistanceTraveled = timeToZeroVelocity * velocity / 2.0f;
            float totalDistance = distance - reversDistanceTraveled;
            float peak_v = (float)Math.sqrt(maxAcceleration * totalDistance);
            if (peak_v < maxVelocity) {
                this.mNumberOfStages = 2;
                this.mStage1Velocity = velocity;
                this.mStage2Velocity = peak_v;
                this.mStage3Velocity = 0.0f;
                this.mStage1Duration = (peak_v - velocity) / maxAcceleration;
                this.mStage2Duration = peak_v / maxAcceleration;
                this.mStage1EndPosition = (velocity + peak_v) * this.mStage1Duration / 2.0f;
                this.mStage2EndPosition = distance;
                this.mStage3EndPosition = distance;
                return;
            }
            this.mNumberOfStages = 3;
            this.mStage1Velocity = velocity;
            this.mStage2Velocity = maxVelocity;
            this.mStage3Velocity = maxVelocity;
            this.mStage1Duration = (maxVelocity - velocity) / maxAcceleration;
            this.mStage3Duration = maxVelocity / maxAcceleration;
            float accDist = (velocity + maxVelocity) * this.mStage1Duration / 2.0f;
            float decDist = maxVelocity * this.mStage3Duration / 2.0f;
            this.mStage2Duration = (distance - accDist - decDist) / maxVelocity;
            this.mStage1EndPosition = accDist;
            this.mStage2EndPosition = distance - decDist;
            this.mStage3EndPosition = distance;
            return;
        }
        if (stopDistance >= distance) {
            float time = 2.0f * distance / velocity;
            this.mNumberOfStages = 1;
            this.mStage1Velocity = velocity;
            this.mStage2Velocity = 0.0f;
            this.mStage1EndPosition = distance;
            this.mStage1Duration = time;
            return;
        }
        float distance_before_break = distance - stopDistance;
        float cruseTime = distance_before_break / velocity;
        if (cruseTime + min_time_to_stop < maxTime) {
            this.mNumberOfStages = 2;
            this.mStage1Velocity = velocity;
            this.mStage2Velocity = velocity;
            this.mStage3Velocity = 0.0f;
            this.mStage1EndPosition = distance_before_break;
            this.mStage2EndPosition = distance;
            this.mStage1Duration = cruseTime;
            this.mStage2Duration = velocity / maxAcceleration;
            return;
        }
        float peak_v = (float)Math.sqrt(maxAcceleration * distance + velocity * velocity / 2.0f);
        this.mStage1Duration = (peak_v - velocity) / maxAcceleration;
        this.mStage2Duration = peak_v / maxAcceleration;
        if (peak_v < maxVelocity) {
            this.mNumberOfStages = 2;
            this.mStage1Velocity = velocity;
            this.mStage2Velocity = peak_v;
            this.mStage3Velocity = 0.0f;
            this.mStage1Duration = (peak_v - velocity) / maxAcceleration;
            this.mStage2Duration = peak_v / maxAcceleration;
            this.mStage1EndPosition = (velocity + peak_v) * this.mStage1Duration / 2.0f;
            this.mStage2EndPosition = distance;
            return;
        }
        this.mNumberOfStages = 3;
        this.mStage1Velocity = velocity;
        this.mStage2Velocity = maxVelocity;
        this.mStage3Velocity = maxVelocity;
        this.mStage1Duration = (maxVelocity - velocity) / maxAcceleration;
        this.mStage3Duration = maxVelocity / maxAcceleration;
        float accDist = (velocity + maxVelocity) * this.mStage1Duration / 2.0f;
        float decDist = maxVelocity * this.mStage3Duration / 2.0f;
        this.mStage2Duration = (distance - accDist - decDist) / maxVelocity;
        this.mStage1EndPosition = accDist;
        this.mStage2EndPosition = distance - decDist;
        this.mStage3EndPosition = distance;
    }
}

