/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.constraint.ConstraintAttribute;
import android.support.constraint.R;
import android.support.constraint.motion.Debug;
import android.support.constraint.motion.Key;
import android.support.constraint.motion.KeyCycleOscillator;
import android.support.constraint.motion.SplineSet;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.TypedValue;
import java.util.HashMap;
import java.util.HashSet;

public class KeyCycle
extends Key {
    private static final String TAG = "KeyCycle";
    static final String NAME = "KeyCycle";
    private String mTransitionEasing = null;
    private int mCurveFit = 0;
    private int mWaveShape = -1;
    private float mWavePeriod = Float.NaN;
    private float mWaveOffset = 0.0f;
    private float mProgress = Float.NaN;
    private int mWaveVariesBy = -1;
    private float mAlpha = Float.NaN;
    private float mElevation = Float.NaN;
    private float mRotation = Float.NaN;
    private float mTransitionPathRotate = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mScaleX = Float.NaN;
    private float mScaleY = Float.NaN;
    private float mTranslationX = Float.NaN;
    private float mTranslationY = Float.NaN;
    private float mTranslationZ = Float.NaN;
    public static final int KEY_TYPE = 4;

    public KeyCycle() {
        this.mType = 4;
        this.mCustomConstraints = new HashMap();
    }

    @Override
    public void load(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyCycle);
        Loader.read(this, a);
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
        if (!Float.isNaN(this.mAlpha)) {
            attributes.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            attributes.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            attributes.add("rotation");
        }
        if (!Float.isNaN(this.mRotationX)) {
            attributes.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            attributes.add("rotationY");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            attributes.add("scaleY");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            attributes.add("transitionPathRotate");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            attributes.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            attributes.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            attributes.add("translationZ");
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String s : this.mCustomConstraints.keySet()) {
                attributes.add("CUSTOM," + s);
            }
        }
    }

    public void addCycleValues(HashMap<String, KeyCycleOscillator> oscSet) {
        for (String key : oscSet.keySet()) {
            float value;
            String ckey;
            ConstraintAttribute cvalue;
            if (key.startsWith("CUSTOM") && (cvalue = (ConstraintAttribute)this.mCustomConstraints.get(ckey = key.substring("CUSTOM".length() + 1))) != null && cvalue.getType() == ConstraintAttribute.AttributeType.FLOAT_TYPE) {
                oscSet.get(key).setPoint(this.mFramePosition, this.mWaveShape, this.mWaveVariesBy, this.mWavePeriod, this.mWaveOffset, cvalue.getValueToInterpolate(), cvalue);
            }
            if (Float.isNaN(value = this.getValue(key))) continue;
            oscSet.get(key).setPoint(this.mFramePosition, this.mWaveShape, this.mWaveVariesBy, this.mWavePeriod, this.mWaveOffset, value);
        }
    }

    public float getValue(String key) {
        switch (key) {
            case "alpha": {
                return this.mAlpha;
            }
            case "elevation": {
                return this.mElevation;
            }
            case "rotation": {
                return this.mRotation;
            }
            case "rotationX": {
                return this.mRotationX;
            }
            case "rotationY": {
                return this.mRotationY;
            }
            case "transitionPathRotate": {
                return this.mTransitionPathRotate;
            }
            case "scaleX": {
                return this.mScaleX;
            }
            case "scaleY": {
                return this.mScaleY;
            }
            case "translationX": {
                return this.mTranslationX;
            }
            case "translationY": {
                return this.mTranslationY;
            }
            case "translationZ": {
                return this.mTranslationZ;
            }
            case "waveOffset": {
                return this.mWaveOffset;
            }
            case "progress": {
                return this.mProgress;
            }
        }
        Log.v((String)"WARNING! KeyCycle", (String)("  UNKNOWN  " + key));
        return Float.NaN;
    }

    @Override
    public void addValues(HashMap<String, SplineSet> splines) {
        Debug.logStack("KeyCycle", "add " + splines.size() + " values", 2);
        block30: for (String s : splines.keySet()) {
            SplineSet splineSet = splines.get(s);
            switch (s) {
                case "alpha": {
                    splineSet.setPoint(this.mFramePosition, this.mAlpha);
                    continue block30;
                }
                case "elevation": {
                    splineSet.setPoint(this.mFramePosition, this.mElevation);
                    continue block30;
                }
                case "rotation": {
                    splineSet.setPoint(this.mFramePosition, this.mRotation);
                    continue block30;
                }
                case "rotationX": {
                    splineSet.setPoint(this.mFramePosition, this.mRotationX);
                    continue block30;
                }
                case "rotationY": {
                    splineSet.setPoint(this.mFramePosition, this.mRotationY);
                    continue block30;
                }
                case "transitionPathRotate": {
                    splineSet.setPoint(this.mFramePosition, this.mTransitionPathRotate);
                    continue block30;
                }
                case "scaleX": {
                    splineSet.setPoint(this.mFramePosition, this.mScaleX);
                    continue block30;
                }
                case "scaleY": {
                    splineSet.setPoint(this.mFramePosition, this.mScaleY);
                    continue block30;
                }
                case "translationX": {
                    splineSet.setPoint(this.mFramePosition, this.mTranslationX);
                    continue block30;
                }
                case "translationY": {
                    splineSet.setPoint(this.mFramePosition, this.mTranslationY);
                    continue block30;
                }
                case "translationZ": {
                    splineSet.setPoint(this.mFramePosition, this.mTranslationZ);
                    continue block30;
                }
                case "waveOffset": {
                    splineSet.setPoint(this.mFramePosition, this.mWaveOffset);
                    continue block30;
                }
                case "progress": {
                    splineSet.setPoint(this.mFramePosition, this.mProgress);
                    continue block30;
                }
            }
            Log.v((String)"WARNING KeyCycle", (String)("  UNKNOWN  " + s));
        }
    }

    @Override
    public void setValue(String tag, Object value) {
        switch (tag) {
            case "alpha": {
                this.mAlpha = this.toFloat(value);
                break;
            }
            case "curveFit": {
                this.mCurveFit = this.toInt(value);
                break;
            }
            case "elevation": {
                this.mElevation = this.toFloat(value);
                break;
            }
            case "progress": {
                this.mProgress = this.toFloat(value);
                break;
            }
            case "rotation": {
                this.mRotation = this.toFloat(value);
                break;
            }
            case "rotationX": {
                this.mRotationX = this.toFloat(value);
                break;
            }
            case "rotationY": {
                this.mRotationY = this.toFloat(value);
                break;
            }
            case "scaleX": {
                this.mScaleX = this.toFloat(value);
                break;
            }
            case "scaleY": {
                this.mScaleY = this.toFloat(value);
                break;
            }
            case "transitionEasing": {
                this.mTransitionEasing = value.toString();
                break;
            }
            case "transitionPathRotate": {
                this.mTransitionPathRotate = this.toFloat(value);
                break;
            }
            case "translationX": {
                this.mTranslationX = this.toFloat(value);
                break;
            }
            case "translationY": {
                this.mTranslationY = this.toFloat(value);
                break;
            }
            case "mTranslationZ": {
                this.mTranslationZ = this.toFloat(value);
                break;
            }
            case "wavePeriod": {
                this.mWavePeriod = this.toFloat(value);
                break;
            }
            case "waveOffset": {
                this.mWaveOffset = this.toFloat(value);
            }
        }
    }

    private static class Loader {
        private static final int TARGET_ID = 1;
        private static final int FRAME_POSITION = 2;
        private static final int TRANSITION_EASING = 3;
        private static final int CURVE_FIT = 4;
        private static final int WAVE_SHAPE = 5;
        private static final int WAVE_PERIOD = 6;
        private static final int WAVE_OFFSET = 7;
        private static final int WAVE_VARIES_BY = 8;
        private static final int ANDROID_ALPHA = 9;
        private static final int ANDROID_ELEVATION = 10;
        private static final int ANDROID_ROTATION = 11;
        private static final int ANDROID_ROTATION_X = 12;
        private static final int ANDROID_ROTATION_Y = 13;
        private static final int TRANSITION_PATH_ROTATE = 14;
        private static final int ANDROID_SCALE_X = 15;
        private static final int ANDROID_SCALE_Y = 16;
        private static final int ANDROID_TRANSLATION_X = 17;
        private static final int ANDROID_TRANSLATION_Y = 18;
        private static final int ANDROID_TRANSLATION_Z = 19;
        private static final int PROGRESS = 20;
        private static SparseIntArray mAttrMap = new SparseIntArray();

        private Loader() {
        }

        private static void read(KeyCycle c, TypedArray a) {
            int N = a.getIndexCount();
            block22: for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                switch (mAttrMap.get(attr)) {
                    case 1: {
                        if (a.peekValue((int)attr).type == 3) {
                            c.mTargetString = a.getString(attr);
                            continue block22;
                        }
                        c.mTargetId = a.getResourceId(attr, c.mTargetId);
                        continue block22;
                    }
                    case 2: {
                        c.mFramePosition = a.getInt(attr, c.mFramePosition);
                        continue block22;
                    }
                    case 3: {
                        c.mTransitionEasing = a.getString(attr);
                        continue block22;
                    }
                    case 4: {
                        c.mCurveFit = a.getInteger(attr, c.mCurveFit);
                        continue block22;
                    }
                    case 5: {
                        c.mWaveShape = a.getInt(attr, c.mWaveShape);
                        continue block22;
                    }
                    case 6: {
                        c.mWavePeriod = a.getFloat(attr, c.mWavePeriod);
                        continue block22;
                    }
                    case 7: {
                        TypedValue type = a.peekValue(attr);
                        if (type.type == 5) {
                            c.mWaveOffset = a.getDimension(attr, c.mWaveOffset);
                            continue block22;
                        }
                        c.mWaveOffset = a.getFloat(attr, c.mWaveOffset);
                        continue block22;
                    }
                    case 8: {
                        c.mWaveVariesBy = a.getInt(attr, c.mWaveVariesBy);
                        continue block22;
                    }
                    case 9: {
                        c.mAlpha = a.getFloat(attr, c.mAlpha);
                        continue block22;
                    }
                    case 10: {
                        c.mElevation = a.getDimension(attr, c.mElevation);
                        continue block22;
                    }
                    case 11: {
                        c.mRotation = a.getFloat(attr, c.mRotation);
                        continue block22;
                    }
                    case 12: {
                        c.mRotationX = a.getFloat(attr, c.mRotationX);
                        continue block22;
                    }
                    case 13: {
                        c.mRotationY = a.getFloat(attr, c.mRotationY);
                        continue block22;
                    }
                    case 14: {
                        c.mTransitionPathRotate = a.getFloat(attr, c.mTransitionPathRotate);
                        continue block22;
                    }
                    case 15: {
                        c.mScaleX = a.getFloat(attr, c.mScaleX);
                        continue block22;
                    }
                    case 16: {
                        c.mScaleY = a.getFloat(attr, c.mScaleY);
                        continue block22;
                    }
                    case 17: {
                        c.mTranslationX = a.getDimension(attr, c.mTranslationX);
                        continue block22;
                    }
                    case 18: {
                        c.mTranslationY = a.getDimension(attr, c.mTranslationY);
                        continue block22;
                    }
                    case 19: {
                        if (Build.VERSION.SDK_INT < 21) continue block22;
                        c.mTranslationZ = a.getDimension(attr, c.mTranslationZ);
                        continue block22;
                    }
                    case 20: {
                        c.mProgress = a.getFloat(attr, c.mProgress);
                        continue block22;
                    }
                    default: {
                        Log.e((String)"KeyCycle", (String)("unused attribute 0x" + Integer.toHexString(attr) + "   " + mAttrMap.get(attr)));
                    }
                }
            }
        }

        static {
            mAttrMap.append(R.styleable.KeyCycle_motionTarget, 1);
            mAttrMap.append(R.styleable.KeyCycle_framePosition, 2);
            mAttrMap.append(R.styleable.KeyCycle_transitionEasing, 3);
            mAttrMap.append(R.styleable.KeyCycle_curveFit, 4);
            mAttrMap.append(R.styleable.KeyCycle_waveShape, 5);
            mAttrMap.append(R.styleable.KeyCycle_wavePeriod, 6);
            mAttrMap.append(R.styleable.KeyCycle_waveOffset, 7);
            mAttrMap.append(R.styleable.KeyCycle_waveVariesBy, 8);
            mAttrMap.append(R.styleable.KeyCycle_android_alpha, 9);
            mAttrMap.append(R.styleable.KeyCycle_android_elevation, 10);
            mAttrMap.append(R.styleable.KeyCycle_android_rotation, 11);
            mAttrMap.append(R.styleable.KeyCycle_android_rotationX, 12);
            mAttrMap.append(R.styleable.KeyCycle_android_rotationY, 13);
            mAttrMap.append(R.styleable.KeyCycle_transitionPathRotate, 14);
            mAttrMap.append(R.styleable.KeyCycle_android_scaleX, 15);
            mAttrMap.append(R.styleable.KeyCycle_android_scaleY, 16);
            mAttrMap.append(R.styleable.KeyCycle_android_translationX, 17);
            mAttrMap.append(R.styleable.KeyCycle_android_translationY, 18);
            mAttrMap.append(R.styleable.KeyCycle_android_translationZ, 19);
            mAttrMap.append(R.styleable.KeyCycle_motionProgress, 20);
        }
    }
}

