/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.constraint.ConstraintAttribute;
import android.support.constraint.motion.MotionLayout;
import android.support.constraint.motion.utils.CurveFit;
import android.support.constraint.motion.utils.Oscillator;
import android.util.Log;
import android.view.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public abstract class KeyCycleOscillator {
    private static final String TAG = "KeyCycleOscillator";
    private CurveFit mCurveFit;
    private CycleOscillator mCycleOscillator;
    protected ConstraintAttribute mCustom;
    private String mType;
    private int mWaveShape = 0;
    public int mVariesBy = 0;
    ArrayList<WavePoint> mWavePoints = new ArrayList();

    public boolean variesByPath() {
        return this.mVariesBy == 1;
    }

    public String toString() {
        String str = this.mType;
        DecimalFormat df = new DecimalFormat("##.##");
        for (WavePoint wp : this.mWavePoints) {
            str = str + "[" + wp.mPosition + " , " + df.format(wp.mValue) + "] ";
        }
        return str;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public abstract void setProperty(View var1, float var2);

    public float get(float t) {
        return (float)this.mCycleOscillator.getValues(t);
    }

    public float getSlope(float position) {
        return (float)this.mCycleOscillator.getSlope(position);
    }

    public CurveFit getCurveFit() {
        return this.mCurveFit;
    }

    static KeyCycleOscillator makeSpline(String str) {
        if (str.startsWith("CUSTOM")) {
            return new CustomSet();
        }
        switch (str) {
            case "alpha": {
                return new AlphaSet();
            }
            case "elevation": {
                return new ElevationSet();
            }
            case "rotation": {
                return new RotationSet();
            }
            case "rotationX": {
                return new RotationXset();
            }
            case "rotationY": {
                return new RotationYset();
            }
            case "transitionPathRotate": {
                return new PathRotateSet();
            }
            case "scaleX": {
                return new ScaleXset();
            }
            case "scaleY": {
                return new ScaleYset();
            }
            case "waveOffset": {
                return new AlphaSet();
            }
            case "waveVariesBy": {
                return new AlphaSet();
            }
            case "translationX": {
                return new TranslationXset();
            }
            case "translationY": {
                return new TranslationYset();
            }
            case "translationZ": {
                return new TranslationZset();
            }
            case "progress": {
                return new ProgressSet();
            }
        }
        return null;
    }

    public void setPoint(int framePosition, int shape, int variesBy, float period, float offset, float value, ConstraintAttribute custom) {
        this.mWavePoints.add(new WavePoint(framePosition, period, offset, value));
        if (variesBy != -1) {
            this.mVariesBy = variesBy;
        }
        this.mWaveShape = shape;
        this.mCustom = custom;
    }

    public void setPoint(int framePosition, int shape, int variesBy, float period, float offset, float value) {
        this.mWavePoints.add(new WavePoint(framePosition, period, offset, value));
        if (variesBy != -1) {
            this.mVariesBy = variesBy;
        }
        this.mWaveShape = shape;
    }

    @TargetApi(value=19)
    public void setup(float pathLength) {
        int count = this.mWavePoints.size();
        if (count == 0) {
            return;
        }
        Collections.sort(this.mWavePoints, new Comparator<WavePoint>(){

            @Override
            public int compare(WavePoint lhs, WavePoint rhs) {
                return Integer.compare(lhs.mPosition, rhs.mPosition);
            }
        });
        double[] time = new double[count];
        double[][] values = new double[count][2];
        this.mCycleOscillator = new CycleOscillator(this.mWaveShape, this.mVariesBy, count);
        int i = 0;
        for (WavePoint wp : this.mWavePoints) {
            time[i] = (double)wp.mPeriod * 0.01;
            values[i][0] = wp.mValue;
            values[i][1] = wp.mOffset;
            this.mCycleOscillator.setPoint(i, wp.mPosition, wp.mPeriod, wp.mOffset, wp.mValue);
            ++i;
        }
        this.mCycleOscillator.setup(pathLength);
        this.mCurveFit = CurveFit.get(0, time, values);
    }

    static class CycleOscillator {
        static final int UNSET = -1;
        private static final String TAG = "CycleOscillator";
        private final int mVariesBy;
        Oscillator mOscillator = new Oscillator();
        float[] mValues;
        double[] mPosition;
        float[] mPeriod;
        float[] mOffset;
        float[] mScale;
        int mWaveShape;
        CurveFit mCurveFit;
        double[] mSplineValueCache;
        double[] mSplineSlopeCache;
        float mPathLength;
        long mStartTimeNano;
        public HashMap<String, ConstraintAttribute> mCustomConstraints = new HashMap();

        CycleOscillator(int waveShape, int variesBy, int steps) {
            this.mWaveShape = waveShape;
            this.mVariesBy = variesBy;
            this.mOscillator.setType(waveShape);
            this.mValues = new float[steps];
            this.mPosition = new double[steps];
            this.mPeriod = new float[steps];
            this.mOffset = new float[steps];
            this.mScale = new float[steps];
        }

        public double getValues(float time) {
            if (this.mCurveFit != null) {
                this.mCurveFit.getPos((double)time, this.mSplineValueCache);
            } else {
                this.mSplineValueCache[0] = this.mOffset[0];
                this.mSplineValueCache[1] = this.mValues[0];
            }
            double offset = this.mSplineValueCache[0];
            double waveValue = this.mOscillator.getValue(time);
            return offset + waveValue * this.mSplineValueCache[1];
        }

        public double getSlope(float time) {
            if (this.mCurveFit != null) {
                this.mCurveFit.getSlope((double)time, this.mSplineSlopeCache);
                this.mCurveFit.getPos((double)time, this.mSplineValueCache);
            } else {
                this.mSplineSlopeCache[0] = 0.0;
                this.mSplineSlopeCache[1] = 0.0;
            }
            double waveValue = this.mOscillator.getValue(time);
            double waveSlope = this.mOscillator.getSlope(time);
            return this.mSplineSlopeCache[0] + waveValue * this.mSplineSlopeCache[1] + waveSlope * this.mSplineValueCache[1];
        }

        private ConstraintAttribute get(String attributeName, ConstraintAttribute.AttributeType attributeType) {
            ConstraintAttribute ret;
            if (this.mCustomConstraints.containsKey(attributeName)) {
                ret = this.mCustomConstraints.get(attributeName);
                if (ret.getType() != attributeType) {
                    throw new IllegalArgumentException("ConstraintAttribute is already a " + ret.getType().name());
                }
            } else {
                ret = new ConstraintAttribute(attributeName, attributeType);
                this.mCustomConstraints.put(attributeName, ret);
            }
            return ret;
        }

        public void setPoint(int index, int framePosition, float wavePeriod, float offset, float values) {
            this.mPosition[index] = (double)framePosition / 100.0;
            this.mPeriod[index] = wavePeriod;
            this.mOffset[index] = offset;
            this.mValues[index] = values;
        }

        public void setup(float pathLength) {
            int last;
            this.mStartTimeNano = System.nanoTime();
            this.mPathLength = pathLength;
            double[][] splineValues = new double[this.mPosition.length][2];
            this.mSplineValueCache = new double[1 + this.mValues.length];
            this.mSplineSlopeCache = new double[1 + this.mValues.length];
            if (this.mPosition[0] > 0.0) {
                this.mOscillator.addPoint(0.0, this.mPeriod[0]);
            }
            if (this.mPosition[last = this.mPosition.length - 1] < 1.0) {
                this.mOscillator.addPoint(1.0, this.mPeriod[last]);
            }
            for (int i = 0; i < splineValues.length; ++i) {
                splineValues[i][0] = this.mOffset[i];
                for (int j = 0; j < this.mValues.length; ++j) {
                    splineValues[j][1] = this.mValues[j];
                }
                this.mOscillator.addPoint(this.mPosition[i], this.mPeriod[i]);
            }
            this.mOscillator.normalize();
            this.mCurveFit = this.mPosition.length > 1 ? CurveFit.get(0, this.mPosition, splineValues) : null;
        }
    }

    private static class IntFloatFloatSort {
        private IntFloatFloatSort() {
        }

        static void sort(int[] key, float[] value1, float[] value2, int low, int hi) {
            int[] stack = new int[key.length + 10];
            int count = 0;
            stack[count++] = hi;
            stack[count++] = low;
            while (count > 0) {
                --count;
                low = stack[count];
                if (low >= (hi = stack[--count])) continue;
                int p = IntFloatFloatSort.partition(key, value1, value2, low, hi);
                stack[count++] = p - 1;
                stack[count++] = low;
                stack[count++] = hi;
                stack[count++] = p + 1;
            }
        }

        private static int partition(int[] array, float[] value1, float[] value2, int low, int hi) {
            int pivot = array[hi];
            int i = low;
            for (int j = low; j < hi; ++j) {
                if (array[j] > pivot) continue;
                IntFloatFloatSort.swap(array, value1, value2, i, j);
                ++i;
            }
            IntFloatFloatSort.swap(array, value1, value2, i, hi);
            return i;
        }

        private static void swap(int[] array, float[] value1, float[] value2, int a, int b) {
            int tmp = array[a];
            array[a] = array[b];
            array[b] = tmp;
            float tmpFloat = value1[a];
            value1[a] = value1[b];
            value1[b] = tmpFloat;
            tmpFloat = value2[a];
            value2[a] = value2[b];
            value2[b] = tmpFloat;
        }
    }

    private static class IntDoubleSort {
        private IntDoubleSort() {
        }

        static void sort(int[] key, float[] value, int low, int hi) {
            int[] stack = new int[key.length + 10];
            int count = 0;
            stack[count++] = hi;
            stack[count++] = low;
            while (count > 0) {
                --count;
                low = stack[count];
                if (low >= (hi = stack[--count])) continue;
                int p = IntDoubleSort.partition(key, value, low, hi);
                stack[count++] = p - 1;
                stack[count++] = low;
                stack[count++] = hi;
                stack[count++] = p + 1;
            }
        }

        private static int partition(int[] array, float[] value, int low, int hi) {
            int pivot = array[hi];
            int i = low;
            for (int j = low; j < hi; ++j) {
                if (array[j] > pivot) continue;
                IntDoubleSort.swap(array, value, i, j);
                ++i;
            }
            IntDoubleSort.swap(array, value, i, hi);
            return i;
        }

        private static void swap(int[] array, float[] value, int a, int b) {
            int tmp = array[a];
            array[a] = array[b];
            array[b] = tmp;
            float tmpv = value[a];
            value[a] = value[b];
            value[b] = tmpv;
        }
    }

    static class ProgressSet
    extends KeyCycleOscillator {
        boolean mNoMethod = false;

        ProgressSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (view instanceof MotionLayout) {
                ((MotionLayout)view).setProgress(this.get(t));
            } else {
                if (this.mNoMethod) {
                    return;
                }
                Method method = null;
                try {
                    method = view.getClass().getMethod("setProgress", Float.TYPE);
                }
                catch (NoSuchMethodException e) {
                    this.mNoMethod = true;
                }
                if (method != null) {
                    try {
                        method.invoke((Object)view, Float.valueOf(this.get(t)));
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)KeyCycleOscillator.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Log.e((String)KeyCycleOscillator.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                }
            }
        }
    }

    static class CustomSet
    extends KeyCycleOscillator {
        float[] value = new float[1];

        CustomSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            this.value[0] = this.get(t);
            this.mCustom.setInterpolatedValue(view, this.value);
        }
    }

    static class TranslationZset
    extends KeyCycleOscillator {
        TranslationZset() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(this.get(t));
            }
        }
    }

    static class TranslationYset
    extends KeyCycleOscillator {
        TranslationYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setTranslationY(this.get(t));
        }
    }

    static class TranslationXset
    extends KeyCycleOscillator {
        TranslationXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setTranslationX(this.get(t));
        }
    }

    static class ScaleYset
    extends KeyCycleOscillator {
        ScaleYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setScaleY(this.get(t));
        }
    }

    static class ScaleXset
    extends KeyCycleOscillator {
        ScaleXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setScaleX(this.get(t));
        }
    }

    static class PathRotateSet
    extends KeyCycleOscillator {
        PathRotateSet() {
        }

        @Override
        public void setProperty(View view, float t) {
        }

        public void setPathRotate(View view, float t, double dx, double dy) {
            view.setRotation(this.get(t) + (float)Math.toDegrees(Math.atan2(dy, dx)));
        }
    }

    static class RotationYset
    extends KeyCycleOscillator {
        RotationYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotationY(this.get(t));
        }
    }

    static class RotationXset
    extends KeyCycleOscillator {
        RotationXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotationX(this.get(t));
        }
    }

    static class RotationSet
    extends KeyCycleOscillator {
        RotationSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotation(this.get(t));
        }
    }

    static class AlphaSet
    extends KeyCycleOscillator {
        AlphaSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setAlpha(this.get(t));
        }
    }

    static class ElevationSet
    extends KeyCycleOscillator {
        ElevationSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(this.get(t));
            }
        }
    }

    static class WavePoint {
        int mPosition;
        float mValue;
        float mOffset;
        float mPeriod;

        public WavePoint(int position, float period, float offset, float value) {
            this.mPosition = position;
            this.mValue = value;
            this.mOffset = offset;
            this.mPeriod = period;
        }
    }
}

