/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.constraint.ConstraintHelper;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.R;
import android.support.constraint.motion.Animatable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class MotionHelper
extends ConstraintHelper
implements Animatable {
    private boolean mUseOnShow = false;
    private boolean mUseOnHide = false;
    private float mProgress;
    protected View[] views;

    public MotionHelper(Context context) {
        super(context);
    }

    public MotionHelper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MotionHelper(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MotionHelper);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.MotionHelper_onShow) {
                    this.mUseOnShow = a.getBoolean(attr, this.mUseOnShow);
                    continue;
                }
                if (attr != R.styleable.MotionHelper_onHide) continue;
                this.mUseOnHide = a.getBoolean(attr, this.mUseOnHide);
            }
        }
    }

    public boolean isUsedOnShow() {
        return this.mUseOnShow;
    }

    public boolean isUseOnHide() {
        return this.mUseOnHide;
    }

    @Override
    public float getProgress() {
        return this.mProgress;
    }

    @Override
    public void setProgress(float progress) {
        this.mProgress = progress;
        if (this.mCount > 0) {
            this.views = this.getViews((ConstraintLayout)this.getParent());
            for (int i = 0; i < this.mCount; ++i) {
                View view = this.views[i];
                this.setProgress(view, progress);
            }
        } else {
            ViewGroup group = (ViewGroup)this.getParent();
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                View view = group.getChildAt(i);
                if (view instanceof MotionHelper) continue;
                this.setProgress(view, progress);
            }
        }
    }

    public void setProgress(View view, float progress) {
    }
}

