/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.RectF;
import android.support.constraint.ConstraintSet;
import android.support.constraint.R;
import android.support.constraint.StateSet;
import android.support.constraint.motion.Key;
import android.support.constraint.motion.KeyFrames;
import android.support.constraint.motion.MotionController;
import android.support.constraint.motion.MotionLayout;
import android.support.constraint.motion.TouchResponse;
import android.support.constraint.motion.utils.Easing;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.Xml;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MotionScene {
    public static final String TAG = "MotionScene";
    private static final boolean DEBUG = false;
    static final int TRANSITION_BACKWARD = 0;
    static final int TRANSITION_FORWARD = 1;
    private static final int SPLINE_STRING = -1;
    private static final int INTERPOLATOR_REFRENCE_ID = -2;
    public static final int UNSET = -1;
    private final MotionLayout mMotionLayout;
    StateSet mStateSet = null;
    Transition mCurrentTransition = null;
    private ArrayList<Transition> mTransitionList = new ArrayList();
    private SparseArray<ConstraintSet> mConstraintSetMap = new SparseArray();
    private SparseIntArray mDeriveMap = new SparseIntArray();
    private boolean DEBUG_DESKTOP = false;
    private int mDefaultDuration = 100;
    private MotionEvent mLastTouchDown;
    private boolean mMotionOutsideRegion = false;
    private VelocityTracker mVelocityTracker;
    float mLastTouchX;
    float mLastTouchY;
    static final int EASE_IN_OUT = 0;
    static final int EASE_IN = 1;
    static final int EASE_OUT = 2;
    static final int LINEAR = 3;
    static final int ANTICIPATE = 4;
    static final int BOUNCE = 5;

    void setTransition(int beginId, int endId) {
        int start = beginId;
        int end = endId;
        if (this.mStateSet != null) {
            int tmp = this.mStateSet.stateGetConstraintID(beginId, -1, -1);
            if (tmp != -1) {
                start = tmp;
            }
            if ((tmp = this.mStateSet.stateGetConstraintID(endId, -1, -1)) != -1) {
                end = tmp;
            }
        }
        for (Transition transition : this.mTransitionList) {
            if ((transition.mConstraintSetEnd != end || transition.mConstraintSetStart != start) && (transition.mConstraintSetEnd != endId || transition.mConstraintSetStart != beginId)) continue;
            this.mCurrentTransition = transition;
            return;
        }
        Transition t = new Transition(this);
        t.mConstraintSetStart = start;
        t.mConstraintSetEnd = end;
        t.mDuration = this.mDefaultDuration;
        this.mTransitionList.add(t);
        this.mCurrentTransition = t;
    }

    public void addTransition(Transition transition) {
        int index = this.getIndex(transition);
        if (index == -1) {
            this.mTransitionList.add(transition);
        } else {
            this.mTransitionList.set(index, transition);
        }
    }

    public void removeTransition(Transition transition) {
        int index = this.getIndex(transition);
        if (index != -1) {
            this.mTransitionList.remove(index);
        }
    }

    private int getIndex(Transition transition) {
        int id2 = transition.mId;
        if (id2 == -1) {
            throw new IllegalArgumentException("The transition must have an id");
        }
        for (int index = 0; index < this.mTransitionList.size(); ++index) {
            if (this.mTransitionList.get(index).mId != id2) continue;
            return index;
        }
        return -1;
    }

    public boolean validateLayout(MotionLayout layout) {
        return layout == this.mMotionLayout && layout.mScene == this;
    }

    public void setTransition(Transition transition) {
        this.mCurrentTransition = transition;
    }

    private int getRealID(int stateid) {
        int tmp;
        if (this.mStateSet != null && (tmp = this.mStateSet.stateGetConstraintID(stateid, -1, -1)) != -1) {
            return tmp;
        }
        return stateid;
    }

    public List<Transition> getTransitionsWithState(int stateid) {
        stateid = this.getRealID(stateid);
        ArrayList<Transition> ret = new ArrayList<Transition>();
        for (Transition transition : this.mTransitionList) {
            if (transition.mConstraintSetStart != stateid && transition.mConstraintSetEnd != stateid) continue;
            ret.add(transition);
        }
        return ret;
    }

    public void addOnClickListeners(MotionLayout motionLayout, int currentState) {
        for (Transition transition : this.mTransitionList) {
            if (transition.mOnClicks.size() <= 0) continue;
            for (Transition.TransitionOnClick onClick : transition.mOnClicks) {
                if (currentState == transition.mConstraintSetStart || currentState == transition.mConstraintSetEnd) {
                    onClick.addOnClickListeners(motionLayout);
                    continue;
                }
                onClick.removeOnClickListeners(motionLayout);
            }
        }
    }

    public Transition bestTransitionFor(int currentState, float dx, float dy, MotionEvent mLastTouchDown) {
        List<Transition> candidates = null;
        if (currentState != -1) {
            candidates = this.getTransitionsWithState(currentState);
            float max = 0.0f;
            Transition best = null;
            RectF cache = new RectF();
            for (Transition transition : candidates) {
                RectF region;
                if (transition.mDisable || transition.mTouchResponse == null || (region = transition.mTouchResponse.getTouchRegion(this.mMotionLayout, cache)) != null && !region.contains(mLastTouchDown.getX(), mLastTouchDown.getY())) continue;
                float val = transition.mTouchResponse.dot(dx, dy);
                if (transition.mConstraintSetEnd == currentState) {
                    val *= -1.0f;
                }
                if (!(val > max)) continue;
                max = val;
                best = transition;
            }
            return best;
        }
        return this.mCurrentTransition;
    }

    public ArrayList<Transition> getDefinedTransitions() {
        return this.mTransitionList;
    }

    public Transition getTransitionById(int id2) {
        for (Transition transition : this.mTransitionList) {
            if (transition.mId != id2) continue;
            return transition;
        }
        return null;
    }

    public int[] getConstraintSetIds() {
        int[] ids = new int[this.mConstraintSetMap.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.mConstraintSetMap.keyAt(i);
        }
        return ids;
    }

    boolean autoTransition(MotionLayout motionLayout, int currentState) {
        if (this.isProcessingTouch()) {
            return false;
        }
        for (Transition transition : this.mTransitionList) {
            if (transition.mConstraintSetStart == 0) continue;
            if (currentState == transition.mConstraintSetStart && (transition.mAutoTransition == 4 || transition.mAutoTransition == 2)) {
                motionLayout.setTransition(transition);
                if (transition.mAutoTransition == 4) {
                    motionLayout.transitionToEnd();
                } else {
                    motionLayout.setProgress(1.0f);
                }
                return true;
            }
            if (currentState != transition.mConstraintSetEnd || transition.mAutoTransition != 3 && transition.mAutoTransition != 1) continue;
            motionLayout.setTransition(transition);
            if (transition.mAutoTransition == 3) {
                motionLayout.transitionToStart();
            } else {
                motionLayout.setProgress(0.0f);
            }
            return true;
        }
        return false;
    }

    private boolean isProcessingTouch() {
        return this.mVelocityTracker != null;
    }

    public MotionScene(MotionLayout layout) {
        this.mMotionLayout = layout;
    }

    MotionScene(Context context, MotionLayout layout, int resourceID) {
        this.mMotionLayout = layout;
        this.load(context, resourceID);
    }

    private void load(Context context, int resourceId) {
        Resources res = context.getResources();
        XmlResourceParser parser = res.getXml(resourceId);
        String document = null;
        String tagName = null;
        try {
            Transition transition = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                block1 : switch (eventType) {
                    case 0: {
                        document = parser.getName();
                        break;
                    }
                    case 2: {
                        tagName = parser.getName();
                        if (this.DEBUG_DESKTOP) {
                            System.out.println("parsing = " + tagName);
                        }
                        switch (tagName) {
                            case "MotionScene": {
                                this.parseMotionSceneTags(context, (XmlPullParser)parser);
                                break;
                            }
                            case "Transition": {
                                transition = new Transition(this, context, (XmlPullParser)parser);
                                this.mTransitionList.add(transition);
                                if (this.mCurrentTransition != null) break block1;
                                this.mCurrentTransition = transition;
                                break;
                            }
                            case "OnSwipe": {
                                if (transition == null) {
                                    String name = context.getResources().getResourceEntryName(resourceId);
                                    int line = parser.getLineNumber();
                                    Log.v((String)TAG, (String)(" OnSwipe (" + name + ".xml:" + line + ")"));
                                }
                                transition.mTouchResponse = new TouchResponse(context, this.mMotionLayout, (XmlPullParser)parser);
                                break;
                            }
                            case "OnClick": {
                                transition.addOnClick(context, (XmlPullParser)parser);
                                break;
                            }
                            case "StateSet": {
                                this.mStateSet = new StateSet(context, (XmlPullParser)parser);
                                break;
                            }
                            case "ConstraintSet": {
                                this.parseConstraintSet(context, (XmlPullParser)parser);
                                break;
                            }
                            case "KeyFrameSet": {
                                KeyFrames keyFrames = new KeyFrames(context, (XmlPullParser)parser);
                                transition.mKeyFramesList.add(keyFrames);
                                break;
                            }
                            default: {
                                Log.v((String)TAG, (String)("WARNING UNKNOWN ATTRIBUTE " + tagName));
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        tagName = null;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseMotionSceneTags(Context context, XmlPullParser parser) {
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MotionScene);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr = a.getIndex(i);
            if (attr != R.styleable.MotionScene_defaultDuration) continue;
            this.mDefaultDuration = a.getInt(attr, this.mDefaultDuration);
        }
        a.recycle();
    }

    private int getId(Context context, String idString) {
        int id2 = -1;
        if (idString.contains("/")) {
            String tmp = idString.substring(idString.indexOf(47) + 1);
            id2 = context.getResources().getIdentifier(tmp, "id", context.getPackageName());
            if (this.DEBUG_DESKTOP) {
                System.out.println("id getMap res = " + id2);
            }
        }
        if (id2 == -1) {
            if (idString != null && idString.length() > 1) {
                id2 = Integer.parseInt(idString.substring(1));
            } else {
                Log.e((String)TAG, (String)"error in parsing id");
            }
        }
        return id2;
    }

    private void parseConstraintSet(Context context, XmlPullParser parser) {
        ConstraintSet set = new ConstraintSet();
        set.setForceId(false);
        int count = parser.getAttributeCount();
        int id2 = -1;
        int derivedId = -1;
        block8: for (int i = 0; i < count; ++i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (this.DEBUG_DESKTOP) {
                System.out.println("id string = " + value);
            }
            switch (name) {
                case "id": {
                    id2 = this.getId(context, value);
                    continue block8;
                }
                case "deriveConstraintsFrom": {
                    derivedId = this.getId(context, value);
                }
            }
        }
        if (id2 != -1) {
            if (this.mMotionLayout.mDebugPath != 0) {
                set.setValidateOnParse(true);
            }
            set.load(context, parser);
            if (derivedId != -1) {
                this.mDeriveMap.put(id2, derivedId);
            }
            this.mConstraintSetMap.put(id2, (Object)set);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    public ConstraintSet getConstraintSet(Context context, String id2) {
        if (this.DEBUG_DESKTOP) {
            System.out.println("id " + id2);
            System.out.println("size " + this.mConstraintSetMap.size());
        }
        for (int i = 0; i < this.mConstraintSetMap.size(); ++i) {
            int key = this.mConstraintSetMap.keyAt(i);
            String IdAsString = context.getResources().getResourceName(key);
            if (this.DEBUG_DESKTOP) {
                System.out.println("Id for <" + i + "> is <" + IdAsString + "> looking for <" + id2 + ">");
            }
            if (!id2.equals(IdAsString)) continue;
            return (ConstraintSet)this.mConstraintSetMap.get(key);
        }
        return null;
    }

    ConstraintSet getConstraintSet(int id2) {
        return this.getConstraintSet(id2, -1, -1);
    }

    ConstraintSet getConstraintSet(int id2, int width, int height) {
        int cid;
        if (this.DEBUG_DESKTOP) {
            System.out.println("id " + id2);
            System.out.println("size " + this.mConstraintSetMap.size());
        }
        if (this.mStateSet != null && (cid = this.mStateSet.stateGetConstraintID(id2, width, height)) != -1) {
            id2 = cid;
        }
        if (this.mConstraintSetMap.get(id2) == null) {
            return (ConstraintSet)this.mConstraintSetMap.get(this.mConstraintSetMap.keyAt(0));
        }
        return (ConstraintSet)this.mConstraintSetMap.get(id2);
    }

    public void setConstraintSet(int id2, ConstraintSet set) {
        this.mConstraintSetMap.put(id2, (Object)set);
    }

    public void getKeyFrames(MotionController motionController) {
        if (this.mCurrentTransition == null) {
            return;
        }
        for (KeyFrames keyFrames : this.mCurrentTransition.mKeyFramesList) {
            keyFrames.addFrames(motionController);
        }
    }

    Key getKeyFrame(Context context, int type, int target, int position) {
        if (this.mCurrentTransition == null) {
            return null;
        }
        for (KeyFrames keyFrames : this.mCurrentTransition.mKeyFramesList) {
            for (Integer integer : keyFrames.getKeys()) {
                if (target != integer) continue;
                ArrayList<Key> keys = keyFrames.getKeyFramesForView(integer);
                for (Key key : keys) {
                    if (key.mFramePosition != position || key.mType != type) continue;
                    return key;
                }
            }
        }
        return null;
    }

    int getTransitionDirection(int stateId) {
        for (Transition transition : this.mTransitionList) {
            if (transition.mConstraintSetStart != stateId) continue;
            return 0;
        }
        return 1;
    }

    boolean hasKeyFramePosition(View view, int position) {
        if (this.mCurrentTransition == null) {
            return false;
        }
        for (KeyFrames keyFrames : this.mCurrentTransition.mKeyFramesList) {
            ArrayList<Key> framePoints = keyFrames.getKeyFramesForView(view.getId());
            for (Key framePoint : framePoints) {
                if (framePoint.mFramePosition != position) continue;
                return true;
            }
        }
        return false;
    }

    public void setKeyframe(View view, int position, String name, Object value) {
        if (this.mCurrentTransition == null) {
            return;
        }
        for (KeyFrames keyFrames : this.mCurrentTransition.mKeyFramesList) {
            ArrayList<Key> framePoints = keyFrames.getKeyFramesForView(view.getId());
            for (Key framePoint : framePoints) {
                if (framePoint.mFramePosition != position) continue;
                float v = 0.0f;
                if (value != null) {
                    v = ((Float)value).floatValue();
                }
                if (v == 0.0f) {
                    v = 0.01f;
                }
                if (!name.equalsIgnoreCase("app:PerpendicularPath_percent")) continue;
            }
        }
    }

    public float getPathPercent(View view, int position) {
        return 0.0f;
    }

    boolean supportTouch() {
        for (Transition transition : this.mTransitionList) {
            if (transition.mTouchResponse == null) continue;
            return true;
        }
        return this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null;
    }

    void processTouchEvent(MotionEvent event, int currentState, MotionLayout motionLayout) {
        RectF cache = new RectF();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        if (currentState != -1) {
            switch (event.getAction()) {
                case 0: {
                    this.mLastTouchX = event.getRawX();
                    this.mLastTouchY = event.getRawY();
                    this.mLastTouchDown = event;
                    if (this.mCurrentTransition.mTouchResponse != null) {
                        RectF region = this.mCurrentTransition.mTouchResponse.getTouchRegion(this.mMotionLayout, cache);
                        this.mMotionOutsideRegion = region != null && !region.contains(this.mLastTouchDown.getX(), this.mLastTouchDown.getY());
                        this.mCurrentTransition.mTouchResponse.setDown(this.mLastTouchX, this.mLastTouchY);
                    }
                    return;
                }
                case 2: {
                    float dy = event.getRawY() - this.mLastTouchY;
                    float dx = event.getRawX() - this.mLastTouchX;
                    if ((double)dx == 0.0 && (double)dy == 0.0) {
                        return;
                    }
                    Transition transition = this.bestTransitionFor(currentState, dx, dy, this.mLastTouchDown);
                    if (transition == null) break;
                    motionLayout.setTransition(transition);
                    RectF region = this.mCurrentTransition.mTouchResponse.getTouchRegion(this.mMotionLayout, cache);
                    this.mMotionOutsideRegion = region != null && !region.contains(this.mLastTouchDown.getX(), this.mLastTouchDown.getY());
                    this.mCurrentTransition.mTouchResponse.setUpTouchEvent(this.mLastTouchX, this.mLastTouchY);
                }
            }
        }
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null && !this.mMotionOutsideRegion) {
            this.mCurrentTransition.mTouchResponse.processTouchEvent(event, this.mVelocityTracker, currentState, this);
        }
        this.mLastTouchX = event.getRawX();
        this.mLastTouchY = event.getRawY();
        if (event.getAction() == 1 && this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
            if (motionLayout.mCurrentState != -1) {
                this.autoTransition(motionLayout, motionLayout.mCurrentState);
            }
        }
    }

    void processScrollMove(float dx, float dy) {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            this.mCurrentTransition.mTouchResponse.scrollMove(dx, dy);
        }
    }

    void processScrollUp(float dx, float dy) {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            this.mCurrentTransition.mTouchResponse.scrollUp(dx, dy);
        }
    }

    float getProgressDirection(float dx, float dy) {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            return this.mCurrentTransition.mTouchResponse.getProgressDirection(dx, dy);
        }
        return 0.0f;
    }

    int getStartId() {
        if (this.mCurrentTransition == null) {
            return -1;
        }
        return this.mCurrentTransition.mConstraintSetStart;
    }

    int getEndId() {
        if (this.mCurrentTransition == null) {
            return -1;
        }
        return this.mCurrentTransition.mConstraintSetEnd;
    }

    public Interpolator getInterpolator() {
        switch (this.mCurrentTransition.mDefaultInterpolator) {
            case -1: {
                final Easing easing = Easing.getInterpolator(this.mCurrentTransition.mDefaultInterpolatorString);
                return new Interpolator(){

                    public float getInterpolation(float v) {
                        return (float)easing.get(v);
                    }
                };
            }
            case -2: {
                return AnimationUtils.loadInterpolator((Context)this.mMotionLayout.getContext(), (int)this.mCurrentTransition.mDefaultInterpolatorID);
            }
            case 0: {
                return new AccelerateDecelerateInterpolator();
            }
            case 1: {
                return new AccelerateInterpolator();
            }
            case 2: {
                return new DecelerateInterpolator();
            }
            case 3: {
                return null;
            }
            case 4: {
                return new AnticipateInterpolator();
            }
            case 5: {
                return new BounceInterpolator();
            }
        }
        return null;
    }

    public int getDuration() {
        if (this.mCurrentTransition != null) {
            return this.mCurrentTransition.mDuration;
        }
        return this.mDefaultDuration;
    }

    public void setDuration(int duration) {
        if (this.mCurrentTransition != null) {
            this.mCurrentTransition.setDuration(duration);
        } else {
            this.mDefaultDuration = duration;
        }
    }

    public float getStaggered() {
        if (this.mCurrentTransition != null) {
            return this.mCurrentTransition.mStagger;
        }
        return 0.0f;
    }

    float getMaxAcceleration() {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            return this.mCurrentTransition.mTouchResponse.getMaxAcceleration();
        }
        return 0.0f;
    }

    float getMaxVelocity() {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            return this.mCurrentTransition.mTouchResponse.getMaxVelocity();
        }
        return 0.0f;
    }

    void setupTouch() {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            this.mCurrentTransition.mTouchResponse.setupTouch();
        }
    }

    boolean getMoveWhenScrollAtTop() {
        if (this.mCurrentTransition != null && this.mCurrentTransition.mTouchResponse != null) {
            return this.mCurrentTransition.mTouchResponse.getMoveWhenScrollAtTop();
        }
        return false;
    }

    void readFallback(MotionLayout motionLayout) {
        int i;
        for (i = 0; i < this.mConstraintSetMap.size(); ++i) {
            this.readConstraintChain(this.mConstraintSetMap.keyAt(i));
        }
        for (i = 0; i < this.mConstraintSetMap.size(); ++i) {
            ConstraintSet cs = (ConstraintSet)this.mConstraintSetMap.valueAt(i);
            cs.readFallback(motionLayout);
        }
    }

    private void readConstraintChain(int key) {
        int derivedFromId = this.mDeriveMap.get(key);
        if (derivedFromId > 0) {
            this.readConstraintChain(this.mDeriveMap.get(key));
            ConstraintSet cs = (ConstraintSet)this.mConstraintSetMap.get(key);
            ConstraintSet derivedFrom = (ConstraintSet)this.mConstraintSetMap.get(derivedFromId);
            cs.readFallback(derivedFrom);
            this.mDeriveMap.put(key, -1);
        }
    }

    public static class Transition {
        private int mId = -1;
        private int mConstraintSetEnd = 0;
        private int mConstraintSetStart = 0;
        private int mDefaultInterpolator = 0;
        private String mDefaultInterpolatorString = null;
        private int mDefaultInterpolatorID = -1;
        private int mDuration = 400;
        private float mStagger = 0.0f;
        private final MotionScene mMotionScene;
        private ArrayList<KeyFrames> mKeyFramesList = new ArrayList();
        private TouchResponse mTouchResponse = null;
        private ArrayList<TransitionOnClick> mOnClicks = new ArrayList();
        private int mAutoTransition = 0;
        public static final int AUTO_NONE = 0;
        public static final int AUTO_JUMP_TO_START = 1;
        public static final int AUTO_JUMP_TO_END = 2;
        public static final int AUTO_ANIMATE_TO_START = 3;
        public static final int AUTO_ANIMATE_TO_END = 4;
        private boolean mDisable = false;

        public void addOnClick(Context context, XmlPullParser parser) {
            this.mOnClicks.add(new TransitionOnClick(context, this, parser));
        }

        public int getEndConstraintSetId() {
            return this.mConstraintSetEnd;
        }

        public int getStartConstraintSetId() {
            return this.mConstraintSetStart;
        }

        public void setDuration(int duration) {
            this.mDuration = duration;
        }

        public int getDuration() {
            return this.mDuration;
        }

        public float getStagger() {
            return this.mStagger;
        }

        public List<KeyFrames> getKeyFrameList() {
            return this.mKeyFramesList;
        }

        public List<TransitionOnClick> getOnClickList() {
            return this.mOnClicks;
        }

        public TouchResponse getTouchResponse() {
            return this.mTouchResponse;
        }

        public void setStagger(float stagger) {
            this.mStagger = stagger;
        }

        public boolean isEnabled() {
            return !this.mDisable;
        }

        public void setEnable(boolean enable) {
            this.mDisable = !enable;
        }

        public String debugString(Context context) {
            String ret = this.mConstraintSetEnd == -1 ? "null" : context.getResources().getResourceEntryName(this.mConstraintSetStart);
            ret = ret + " -> " + context.getResources().getResourceEntryName(this.mConstraintSetEnd);
            return ret;
        }

        Transition(MotionScene motionScene) {
            this.mMotionScene = motionScene;
        }

        public Transition(int id2, MotionScene motionScene, int constraintSetStartId, int constraintSetEndId) {
            this.mId = id2;
            this.mMotionScene = motionScene;
            this.mConstraintSetStart = constraintSetStartId;
            this.mConstraintSetEnd = constraintSetEndId;
        }

        Transition(MotionScene motionScene, Context context, XmlPullParser parser) {
            this.mDuration = motionScene.mDefaultDuration;
            this.mMotionScene = motionScene;
            this.fillFromAttributeList(motionScene, context, Xml.asAttributeSet((XmlPullParser)parser));
        }

        private void fillFromAttributeList(MotionScene motionScene, Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Transition);
            this.fill(motionScene, context, a);
            a.recycle();
        }

        private void fill(MotionScene motionScene, Context context, TypedArray a) {
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                ConstraintSet cSet;
                Object type;
                int attr = a.getIndex(i);
                if (attr == R.styleable.Transition_constraintSetEnd) {
                    this.mConstraintSetEnd = a.getResourceId(attr, this.mConstraintSetEnd);
                    type = context.getResources().getResourceTypeName(this.mConstraintSetEnd);
                    if (!"layout".equals(type)) continue;
                    cSet = new ConstraintSet();
                    cSet.load(context, this.mConstraintSetEnd);
                    motionScene.mConstraintSetMap.append(this.mConstraintSetEnd, (Object)cSet);
                    continue;
                }
                if (attr == R.styleable.Transition_constraintSetStart) {
                    this.mConstraintSetStart = a.getResourceId(attr, this.mConstraintSetStart);
                    type = context.getResources().getResourceTypeName(this.mConstraintSetStart);
                    if (!"layout".equals(type)) continue;
                    cSet = new ConstraintSet();
                    cSet.load(context, this.mConstraintSetStart);
                    motionScene.mConstraintSetMap.append(this.mConstraintSetStart, (Object)cSet);
                    continue;
                }
                if (attr == R.styleable.Transition_motionInterpolator) {
                    type = a.peekValue(attr);
                    if (type.type == 1) {
                        this.mDefaultInterpolatorID = a.getResourceId(attr, -1);
                        if (this.mDefaultInterpolatorID == -1) continue;
                        this.mDefaultInterpolator = -2;
                        continue;
                    }
                    if (type.type == 3) {
                        this.mDefaultInterpolatorString = a.getString(attr);
                        if (this.mDefaultInterpolatorString.indexOf("/") > 0) {
                            this.mDefaultInterpolatorID = a.getResourceId(attr, -1);
                            this.mDefaultInterpolator = -2;
                            continue;
                        }
                        this.mDefaultInterpolator = -1;
                        continue;
                    }
                    this.mDefaultInterpolator = a.getInteger(attr, this.mDefaultInterpolator);
                    continue;
                }
                if (attr == R.styleable.Transition_duration) {
                    this.mDuration = a.getInt(attr, this.mDuration);
                    continue;
                }
                if (attr == R.styleable.Transition_staggered) {
                    this.mStagger = a.getFloat(attr, this.mStagger);
                    continue;
                }
                if (attr == R.styleable.Transition_autoTransition) {
                    this.mAutoTransition = a.getInteger(attr, this.mAutoTransition);
                    continue;
                }
                if (attr == R.styleable.Transition_android_id) {
                    this.mId = a.getResourceId(attr, this.mId);
                    continue;
                }
                if (attr != R.styleable.Transition_transitionDisable) continue;
                this.mDisable = a.getBoolean(attr, this.mDisable);
            }
        }

        static class TransitionOnClick
        implements View.OnClickListener {
            private final Transition mTransition;
            int mTargetId = -1;
            int mMode = 17;
            public static final int ANIM_TO_END = 1;
            public static final int ANIM_TOGGLE = 17;
            public static final int ANIM_TO_START = 16;
            public static final int JUMP_TO_END = 256;
            public static final int JUMP_TO_START = 4096;

            public TransitionOnClick(Context context, Transition transition, XmlPullParser parser) {
                this.mTransition = transition;
                TypedArray a = context.obtainStyledAttributes(Xml.asAttributeSet((XmlPullParser)parser), R.styleable.OnClick);
                int N = a.getIndexCount();
                for (int i = 0; i < N; ++i) {
                    int attr = a.getIndex(i);
                    if (attr == R.styleable.OnClick_targetId) {
                        this.mTargetId = a.getResourceId(attr, this.mTargetId);
                        continue;
                    }
                    if (attr != R.styleable.OnClick_clickAction) continue;
                    this.mMode = a.getInt(attr, this.mMode);
                }
                a.recycle();
            }

            public void addOnClickListeners(MotionLayout motionLayout) {
                MotionLayout v;
                MotionLayout motionLayout2 = v = this.mTargetId == -1 ? motionLayout : motionLayout.findViewById(this.mTargetId);
                if (v == null) {
                    Log.e((String)MotionScene.TAG, (String)(" (*)  could not find id " + this.mTargetId));
                    return;
                }
                v.setOnClickListener(this);
            }

            public void removeOnClickListeners(MotionLayout motionLayout) {
                View v = motionLayout.findViewById(this.mTargetId);
                if (v == null) {
                    Log.e((String)MotionScene.TAG, (String)(" (*)  could not find id " + this.mTargetId));
                    return;
                }
                v.setOnClickListener(null);
            }

            boolean isTransitionViable(Transition current, boolean forward, MotionLayout tl) {
                int from;
                if (this.mTransition == current) {
                    return true;
                }
                int dest = forward ? this.mTransition.mConstraintSetEnd : this.mTransition.mConstraintSetStart;
                int n = from = forward ? this.mTransition.mConstraintSetStart : this.mTransition.mConstraintSetEnd;
                if (tl.getProgress() == 0.0f) {
                    return tl.mCurrentState == from;
                }
                if (tl.getProgress() == 1.0f) {
                    return tl.mCurrentState == dest;
                }
                return false;
            }

            public void onClick(View view) {
                boolean bidirectional;
                MotionLayout tl = this.mTransition.mMotionScene.mMotionLayout;
                Transition current = ((Transition)this.mTransition).mMotionScene.mCurrentTransition;
                boolean forward = (this.mMode & 1) != 0 || (this.mMode & 0x100) != 0;
                boolean backward = (this.mMode & 0x10) != 0 || (this.mMode & 0x1000) != 0;
                boolean bl = bidirectional = forward && backward;
                if (bidirectional) {
                    if (((Transition)this.mTransition).mMotionScene.mCurrentTransition != this.mTransition) {
                        tl.setTransition(this.mTransition);
                    }
                    if (tl.getCurrentState() == tl.getEndState() || tl.getProgress() > 0.5f) {
                        forward = false;
                    } else {
                        backward = false;
                    }
                }
                if (forward) {
                    if (this.isTransitionViable(current, true, tl) && (this.mMode & 1) != 0) {
                        tl.transitionToEnd();
                    } else {
                        tl.setProgress(1.0f);
                    }
                } else if (backward) {
                    if (this.isTransitionViable(current, false, tl) && (this.mMode & 0x10) != 0) {
                        tl.transitionToStart();
                    } else {
                        tl.setProgress(0.0f);
                    }
                }
            }
        }
    }
}

