/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.constraint.ConstraintHelper;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.constraint.R;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.HelperWidget;
import android.util.AttributeSet;
import android.util.SparseArray;

public class Barrier
extends ConstraintHelper {
    public static final int LEFT = 0;
    public static final int TOP = 2;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 3;
    public static final int START = 5;
    public static final int END = 6;
    private int mIndicatedType;
    private int mResolvedType;
    private android.support.constraint.solver.widgets.Barrier mBarrier;

    public Barrier(Context context) {
        super(context);
        super.setVisibility(8);
    }

    public Barrier(Context context, AttributeSet attrs) {
        super(context, attrs);
        super.setVisibility(8);
    }

    public Barrier(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        super.setVisibility(8);
    }

    public int getType() {
        return this.mIndicatedType;
    }

    public void setType(int type) {
        this.mIndicatedType = type;
    }

    private void updateType(ConstraintWidget widget, int type, boolean isRtl) {
        this.mResolvedType = type;
        if (Build.VERSION.SDK_INT < 17) {
            if (this.mIndicatedType == 5) {
                this.mResolvedType = 0;
            } else if (this.mIndicatedType == 6) {
                this.mResolvedType = 1;
            }
        } else if (isRtl) {
            if (this.mIndicatedType == 5) {
                this.mResolvedType = 1;
            } else if (this.mIndicatedType == 6) {
                this.mResolvedType = 0;
            }
        } else if (this.mIndicatedType == 5) {
            this.mResolvedType = 0;
        } else if (this.mIndicatedType == 6) {
            this.mResolvedType = 1;
        }
        if (widget instanceof android.support.constraint.solver.widgets.Barrier) {
            android.support.constraint.solver.widgets.Barrier barrier = (android.support.constraint.solver.widgets.Barrier)widget;
            barrier.setBarrierType(this.mResolvedType);
        }
    }

    @Override
    public void resolveRtl(ConstraintWidget widget, boolean isRtl) {
        this.updateType(widget, this.mIndicatedType, isRtl);
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        this.mBarrier = new android.support.constraint.solver.widgets.Barrier();
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.ConstraintLayout_Layout_barrierDirection) {
                    this.setType(a.getInt(attr, 0));
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_barrierAllowsGoneWidgets) {
                    this.mBarrier.setAllowsGoneWidget(a.getBoolean(attr, true));
                    continue;
                }
                if (attr != R.styleable.ConstraintLayout_Layout_barrierMargin) continue;
                int margin = a.getDimensionPixelSize(attr, 0);
                this.mBarrier.setMargin(margin);
            }
        }
        this.mHelperWidget = this.mBarrier;
        this.validateParams();
    }

    public void setAllowsGoneWidget(boolean supportGone) {
        this.mBarrier.setAllowsGoneWidget(supportGone);
    }

    public boolean allowsGoneWidget() {
        return this.mBarrier.allowsGoneWidget();
    }

    public void setDpMargin(int margin) {
        float density = this.getResources().getDisplayMetrics().density;
        int px = (int)(0.5f + (float)margin * density);
        this.mBarrier.setMargin(px);
    }

    public int getMargin() {
        return this.mBarrier.getMargin();
    }

    public void setMargin(int margin) {
        this.mBarrier.setMargin(margin);
    }

    @Override
    public void loadParameters(ConstraintSet.Constraint constraint, HelperWidget child, ConstraintLayout.LayoutParams layoutParams, SparseArray<ConstraintWidget> mapIdToWidget) {
        super.loadParameters(constraint, child, layoutParams, mapIdToWidget);
        if (child instanceof android.support.constraint.solver.widgets.Barrier) {
            android.support.constraint.solver.widgets.Barrier barrier = (android.support.constraint.solver.widgets.Barrier)child;
            ConstraintWidgetContainer container = (ConstraintWidgetContainer)child.getParent();
            boolean isRtl = container.isRtl();
            this.updateType((ConstraintWidget)barrier, constraint.layout.mBarrierDirection, isRtl);
            barrier.setAllowsGoneWidget(constraint.layout.mBarrierAllowsGoneWidgets);
            barrier.setMargin(constraint.layout.mBarrierMargin);
        }
    }
}

