/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintHelper;
import android.support.constraint.ConstraintLayoutStates;
import android.support.constraint.ConstraintSet;
import android.support.constraint.Constraints;
import android.support.constraint.ConstraintsChangedListener;
import android.support.constraint.Guideline;
import android.support.constraint.Placeholder;
import android.support.constraint.R;
import android.support.constraint.VirtualLayout;
import android.support.constraint.solver.Metrics;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.analyzer.BasicMeasure;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;

public class ConstraintLayout
extends ViewGroup {
    public static final String VERSION = "ConstraintLayout-2.0.1";
    private static final String TAG = "ConstraintLayout";
    private static final boolean USE_CONSTRAINTS_HELPER = true;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_DRAW_CONSTRAINTS = false;
    private static final boolean MEASURE = false;
    SparseArray<View> mChildrenByIds = new SparseArray();
    private ArrayList<ConstraintHelper> mConstraintHelpers = new ArrayList(4);
    protected ConstraintWidgetContainer mLayoutWidget = new ConstraintWidgetContainer();
    private int mMinWidth = 0;
    private int mMinHeight = 0;
    private int mMaxWidth = Integer.MAX_VALUE;
    private int mMaxHeight = Integer.MAX_VALUE;
    protected boolean mDirtyHierarchy = true;
    private int mOptimizationLevel = 263;
    private ConstraintSet mConstraintSet = null;
    protected ConstraintLayoutStates mConstraintLayoutSpec = null;
    private int mConstraintSetId = -1;
    private HashMap<String, Integer> mDesignIds = new HashMap();
    private int mLastMeasureWidth = -1;
    private int mLastMeasureHeight = -1;
    int mLastMeasureWidthSize = -1;
    int mLastMeasureHeightSize = -1;
    int mLastMeasureWidthMode = 0;
    int mLastMeasureHeightMode = 0;
    private SparseArray<ConstraintWidget> mTempMapIdToWidget = new SparseArray();
    public static final int DESIGN_INFO_ID = 0;
    private ConstraintsChangedListener mConstraintsChangedListener;
    private Metrics mMetrics;
    Measurer mMeasurer = new Measurer(this);
    private int mOnMeasureWidthMeasureSpec = 0;
    private int mOnMeasureHeightMeasureSpec = 0;

    public void setDesignInformation(int type, Object value1, Object value2) {
        if (type == 0 && value1 instanceof String && value2 instanceof Integer) {
            String name;
            int index;
            if (this.mDesignIds == null) {
                this.mDesignIds = new HashMap();
            }
            if ((index = (name = (String)value1).indexOf("/")) != -1) {
                name = name.substring(index + 1);
            }
            int id2 = (Integer)value2;
            this.mDesignIds.put(name, id2);
        }
    }

    public Object getDesignInformation(int type, Object value) {
        if (type == 0 && value instanceof String) {
            String name = (String)value;
            if (this.mDesignIds != null && this.mDesignIds.containsKey(name)) {
                return this.mDesignIds.get(name);
            }
        }
        return null;
    }

    public ConstraintLayout(@NonNull Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public ConstraintLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public ConstraintLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public ConstraintLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    public void setId(int id2) {
        this.mChildrenByIds.remove(this.getId());
        super.setId(id2);
        this.mChildrenByIds.put(this.getId(), (Object)this);
    }

    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mLayoutWidget.setCompanionWidget((Object)this);
        this.mLayoutWidget.setMeasurer((BasicMeasure.Measurer)this.mMeasurer);
        this.mChildrenByIds.put(this.getId(), (Object)this);
        this.mConstraintSet = null;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout, defStyleAttr, defStyleRes);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int id2;
                int attr = a.getIndex(i);
                if (attr == R.styleable.ConstraintLayout_Layout_android_minWidth) {
                    this.mMinWidth = a.getDimensionPixelOffset(attr, this.mMinWidth);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_android_minHeight) {
                    this.mMinHeight = a.getDimensionPixelOffset(attr, this.mMinHeight);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_android_maxWidth) {
                    this.mMaxWidth = a.getDimensionPixelOffset(attr, this.mMaxWidth);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_android_maxHeight) {
                    this.mMaxHeight = a.getDimensionPixelOffset(attr, this.mMaxHeight);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_optimizationLevel) {
                    this.mOptimizationLevel = a.getInt(attr, this.mOptimizationLevel);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layoutDescription) {
                    id2 = a.getResourceId(attr, 0);
                    if (id2 == 0) continue;
                    try {
                        this.parseLayoutDescription(id2);
                    }
                    catch (Resources.NotFoundException e) {
                        this.mConstraintLayoutSpec = null;
                    }
                    continue;
                }
                if (attr != R.styleable.ConstraintLayout_Layout_constraintSet) continue;
                id2 = a.getResourceId(attr, 0);
                try {
                    this.mConstraintSet = new ConstraintSet();
                    this.mConstraintSet.load(this.getContext(), id2);
                }
                catch (Resources.NotFoundException e) {
                    this.mConstraintSet = null;
                }
                this.mConstraintSetId = id2;
            }
            a.recycle();
        }
        this.mLayoutWidget.setOptimizationLevel(this.mOptimizationLevel);
    }

    protected void parseLayoutDescription(int id2) {
        this.mConstraintLayoutSpec = new ConstraintLayoutStates(this.getContext(), this, id2);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (Build.VERSION.SDK_INT < 14) {
            this.onViewAdded(child);
        }
    }

    public void removeView(View view) {
        super.removeView(view);
        if (Build.VERSION.SDK_INT < 14) {
            this.onViewRemoved(view);
        }
    }

    public void onViewAdded(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.onViewAdded(view);
        }
        ConstraintWidget widget = this.getViewWidget(view);
        if (view instanceof Guideline && !(widget instanceof android.support.constraint.solver.widgets.Guideline)) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            layoutParams.widget = new android.support.constraint.solver.widgets.Guideline();
            layoutParams.isGuideline = true;
            ((android.support.constraint.solver.widgets.Guideline)layoutParams.widget).setOrientation(layoutParams.orientation);
        }
        if (view instanceof ConstraintHelper) {
            ConstraintHelper helper = (ConstraintHelper)view;
            helper.validateParams();
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            layoutParams.isHelper = true;
            if (!this.mConstraintHelpers.contains((Object)helper)) {
                this.mConstraintHelpers.add(helper);
            }
        }
        this.mChildrenByIds.put(view.getId(), (Object)view);
        this.mDirtyHierarchy = true;
    }

    public void onViewRemoved(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.onViewRemoved(view);
        }
        this.mChildrenByIds.remove(view.getId());
        ConstraintWidget widget = this.getViewWidget(view);
        this.mLayoutWidget.remove(widget);
        this.mConstraintHelpers.remove(view);
        this.mDirtyHierarchy = true;
    }

    public void setMinWidth(int value) {
        if (value == this.mMinWidth) {
            return;
        }
        this.mMinWidth = value;
        this.requestLayout();
    }

    public void setMinHeight(int value) {
        if (value == this.mMinHeight) {
            return;
        }
        this.mMinHeight = value;
        this.requestLayout();
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    public int getMinHeight() {
        return this.mMinHeight;
    }

    public void setMaxWidth(int value) {
        if (value == this.mMaxWidth) {
            return;
        }
        this.mMaxWidth = value;
        this.requestLayout();
    }

    public void setMaxHeight(int value) {
        if (value == this.mMaxHeight) {
            return;
        }
        this.mMaxHeight = value;
        this.requestLayout();
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    private boolean updateHierarchy() {
        int count = this.getChildCount();
        boolean recompute = false;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutRequested()) continue;
            recompute = true;
            break;
        }
        if (recompute) {
            this.setChildrenConstraints();
        }
        return recompute;
    }

    private void setChildrenConstraints() {
        View child;
        int i;
        View child2;
        int i2;
        boolean isInEditMode = this.isInEditMode();
        int count = this.getChildCount();
        for (i2 = 0; i2 < count; ++i2) {
            child2 = this.getChildAt(i2);
            ConstraintWidget widget = this.getViewWidget(child2);
            if (widget == null) continue;
            widget.reset();
        }
        if (isInEditMode) {
            for (i2 = 0; i2 < count; ++i2) {
                View view = this.getChildAt(i2);
                try {
                    String IdAsString = this.getResources().getResourceName(view.getId());
                    this.setDesignInformation(0, IdAsString, view.getId());
                    int slashIndex = IdAsString.indexOf(47);
                    if (slashIndex != -1) {
                        IdAsString = IdAsString.substring(slashIndex + 1);
                    }
                    this.getTargetWidget(view.getId()).setDebugName(IdAsString);
                    continue;
                }
                catch (Resources.NotFoundException IdAsString) {
                    // empty catch block
                }
            }
        }
        if (this.mConstraintSetId != -1) {
            for (i2 = 0; i2 < count; ++i2) {
                child2 = this.getChildAt(i2);
                if (child2.getId() != this.mConstraintSetId || !(child2 instanceof Constraints)) continue;
                this.mConstraintSet = ((Constraints)child2).getConstraintSet();
            }
        }
        if (this.mConstraintSet != null) {
            this.mConstraintSet.applyToInternal(this, true);
        }
        this.mLayoutWidget.removeAllChildren();
        int helperCount = this.mConstraintHelpers.size();
        if (helperCount > 0) {
            for (int i3 = 0; i3 < helperCount; ++i3) {
                ConstraintHelper helper = this.mConstraintHelpers.get(i3);
                helper.updatePreLayout(this);
            }
        }
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (!(child instanceof Placeholder)) continue;
            ((Placeholder)child).updatePreLayout(this);
        }
        this.mTempMapIdToWidget.clear();
        this.mTempMapIdToWidget.put(0, (Object)this.mLayoutWidget);
        this.mTempMapIdToWidget.put(this.getId(), (Object)this.mLayoutWidget);
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            ConstraintWidget widget = this.getViewWidget(child);
            this.mTempMapIdToWidget.put(child.getId(), (Object)widget);
        }
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            ConstraintWidget widget = this.getViewWidget(child);
            if (widget == null) continue;
            LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
            this.mLayoutWidget.add(widget);
            this.applyConstraintsFromLayoutParams(isInEditMode, child, widget, layoutParams, this.mTempMapIdToWidget);
        }
    }

    protected void applyConstraintsFromLayoutParams(boolean isInEditMode, View child, ConstraintWidget widget, LayoutParams layoutParams, SparseArray<ConstraintWidget> idToWidget) {
        layoutParams.validate();
        layoutParams.helped = false;
        widget.setVisibility(child.getVisibility());
        if (layoutParams.isInPlaceholder) {
            widget.setInPlaceholder(true);
            widget.setVisibility(8);
        }
        widget.setCompanionWidget((Object)child);
        if (child instanceof ConstraintHelper) {
            ConstraintHelper helper = (ConstraintHelper)child;
            helper.resolveRtl(widget, this.mLayoutWidget.isRtl());
        }
        if (layoutParams.isGuideline) {
            android.support.constraint.solver.widgets.Guideline guideline = (android.support.constraint.solver.widgets.Guideline)widget;
            int resolvedGuideBegin = layoutParams.resolvedGuideBegin;
            int resolvedGuideEnd = layoutParams.resolvedGuideEnd;
            float resolvedGuidePercent = layoutParams.resolvedGuidePercent;
            if (Build.VERSION.SDK_INT < 17) {
                resolvedGuideBegin = layoutParams.guideBegin;
                resolvedGuideEnd = layoutParams.guideEnd;
                resolvedGuidePercent = layoutParams.guidePercent;
            }
            if (resolvedGuidePercent != -1.0f) {
                guideline.setGuidePercent(resolvedGuidePercent);
            } else if (resolvedGuideBegin != -1) {
                guideline.setGuideBegin(resolvedGuideBegin);
            } else if (resolvedGuideEnd != -1) {
                guideline.setGuideEnd(resolvedGuideEnd);
            }
        } else {
            int resolvedLeftToLeft = layoutParams.resolvedLeftToLeft;
            int resolvedLeftToRight = layoutParams.resolvedLeftToRight;
            int resolvedRightToLeft = layoutParams.resolvedRightToLeft;
            int resolvedRightToRight = layoutParams.resolvedRightToRight;
            int resolveGoneLeftMargin = layoutParams.resolveGoneLeftMargin;
            int resolveGoneRightMargin = layoutParams.resolveGoneRightMargin;
            float resolvedHorizontalBias = layoutParams.resolvedHorizontalBias;
            if (Build.VERSION.SDK_INT < 17) {
                resolvedLeftToLeft = layoutParams.leftToLeft;
                resolvedLeftToRight = layoutParams.leftToRight;
                resolvedRightToLeft = layoutParams.rightToLeft;
                resolvedRightToRight = layoutParams.rightToRight;
                resolveGoneLeftMargin = layoutParams.goneLeftMargin;
                resolveGoneRightMargin = layoutParams.goneRightMargin;
                resolvedHorizontalBias = layoutParams.horizontalBias;
                if (resolvedLeftToLeft == -1 && resolvedLeftToRight == -1) {
                    if (layoutParams.startToStart != -1) {
                        resolvedLeftToLeft = layoutParams.startToStart;
                    } else if (layoutParams.startToEnd != -1) {
                        resolvedLeftToRight = layoutParams.startToEnd;
                    }
                }
                if (resolvedRightToLeft == -1 && resolvedRightToRight == -1) {
                    if (layoutParams.endToStart != -1) {
                        resolvedRightToLeft = layoutParams.endToStart;
                    } else if (layoutParams.endToEnd != -1) {
                        resolvedRightToRight = layoutParams.endToEnd;
                    }
                }
            }
            if (layoutParams.circleConstraint != -1) {
                ConstraintWidget target = (ConstraintWidget)idToWidget.get(layoutParams.circleConstraint);
                if (target != null) {
                    widget.connectCircularConstraint(target, layoutParams.circleAngle, layoutParams.circleRadius);
                }
            } else {
                ConstraintWidget target;
                if (resolvedLeftToLeft != -1) {
                    target = (ConstraintWidget)idToWidget.get(resolvedLeftToLeft);
                    if (target != null) {
                        widget.immediateConnect(ConstraintAnchor.Type.LEFT, target, ConstraintAnchor.Type.LEFT, layoutParams.leftMargin, resolveGoneLeftMargin);
                    }
                } else if (resolvedLeftToRight != -1 && (target = (ConstraintWidget)idToWidget.get(resolvedLeftToRight)) != null) {
                    widget.immediateConnect(ConstraintAnchor.Type.LEFT, target, ConstraintAnchor.Type.RIGHT, layoutParams.leftMargin, resolveGoneLeftMargin);
                }
                if (resolvedRightToLeft != -1) {
                    target = (ConstraintWidget)idToWidget.get(resolvedRightToLeft);
                    if (target != null) {
                        widget.immediateConnect(ConstraintAnchor.Type.RIGHT, target, ConstraintAnchor.Type.LEFT, layoutParams.rightMargin, resolveGoneRightMargin);
                    }
                } else if (resolvedRightToRight != -1 && (target = (ConstraintWidget)idToWidget.get(resolvedRightToRight)) != null) {
                    widget.immediateConnect(ConstraintAnchor.Type.RIGHT, target, ConstraintAnchor.Type.RIGHT, layoutParams.rightMargin, resolveGoneRightMargin);
                }
                if (layoutParams.topToTop != -1) {
                    target = (ConstraintWidget)idToWidget.get(layoutParams.topToTop);
                    if (target != null) {
                        widget.immediateConnect(ConstraintAnchor.Type.TOP, target, ConstraintAnchor.Type.TOP, layoutParams.topMargin, layoutParams.goneTopMargin);
                    }
                } else if (layoutParams.topToBottom != -1 && (target = (ConstraintWidget)idToWidget.get(layoutParams.topToBottom)) != null) {
                    widget.immediateConnect(ConstraintAnchor.Type.TOP, target, ConstraintAnchor.Type.BOTTOM, layoutParams.topMargin, layoutParams.goneTopMargin);
                }
                if (layoutParams.bottomToTop != -1) {
                    target = (ConstraintWidget)idToWidget.get(layoutParams.bottomToTop);
                    if (target != null) {
                        widget.immediateConnect(ConstraintAnchor.Type.BOTTOM, target, ConstraintAnchor.Type.TOP, layoutParams.bottomMargin, layoutParams.goneBottomMargin);
                    }
                } else if (layoutParams.bottomToBottom != -1 && (target = (ConstraintWidget)idToWidget.get(layoutParams.bottomToBottom)) != null) {
                    widget.immediateConnect(ConstraintAnchor.Type.BOTTOM, target, ConstraintAnchor.Type.BOTTOM, layoutParams.bottomMargin, layoutParams.goneBottomMargin);
                }
                if (layoutParams.baselineToBaseline != -1) {
                    View view = (View)this.mChildrenByIds.get(layoutParams.baselineToBaseline);
                    ConstraintWidget target2 = (ConstraintWidget)idToWidget.get(layoutParams.baselineToBaseline);
                    if (target2 != null && view != null && view.getLayoutParams() instanceof LayoutParams) {
                        LayoutParams targetParams = (LayoutParams)view.getLayoutParams();
                        layoutParams.needsBaseline = true;
                        targetParams.needsBaseline = true;
                        ConstraintAnchor baseline = widget.getAnchor(ConstraintAnchor.Type.BASELINE);
                        ConstraintAnchor targetBaseline = target2.getAnchor(ConstraintAnchor.Type.BASELINE);
                        baseline.connect(targetBaseline, 0, -1, true);
                        widget.setHasBaseline(true);
                        targetParams.widget.setHasBaseline(true);
                        widget.getAnchor(ConstraintAnchor.Type.TOP).reset();
                        widget.getAnchor(ConstraintAnchor.Type.BOTTOM).reset();
                    }
                }
                if (resolvedHorizontalBias >= 0.0f) {
                    widget.setHorizontalBiasPercent(resolvedHorizontalBias);
                }
                if (layoutParams.verticalBias >= 0.0f) {
                    widget.setVerticalBiasPercent(layoutParams.verticalBias);
                }
            }
            if (isInEditMode && (layoutParams.editorAbsoluteX != -1 || layoutParams.editorAbsoluteY != -1)) {
                widget.setOrigin(layoutParams.editorAbsoluteX, layoutParams.editorAbsoluteY);
            }
            if (!layoutParams.horizontalDimensionFixed) {
                if (layoutParams.width == -1) {
                    if (layoutParams.constrainedWidth) {
                        widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    } else {
                        widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
                    }
                    widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.LEFT).mMargin = layoutParams.leftMargin;
                    widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.RIGHT).mMargin = layoutParams.rightMargin;
                } else {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    widget.setWidth(0);
                }
            } else {
                widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                widget.setWidth(layoutParams.width);
                if (layoutParams.width == -2) {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
            if (!layoutParams.verticalDimensionFixed) {
                if (layoutParams.height == -1) {
                    if (layoutParams.constrainedHeight) {
                        widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    } else {
                        widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
                    }
                    widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.TOP).mMargin = layoutParams.topMargin;
                    widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.BOTTOM).mMargin = layoutParams.bottomMargin;
                } else {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    widget.setHeight(0);
                }
            } else {
                widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                widget.setHeight(layoutParams.height);
                if (layoutParams.height == -2) {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
            widget.setDimensionRatio(layoutParams.dimensionRatio);
            widget.setHorizontalWeight(layoutParams.horizontalWeight);
            widget.setVerticalWeight(layoutParams.verticalWeight);
            widget.setHorizontalChainStyle(layoutParams.horizontalChainStyle);
            widget.setVerticalChainStyle(layoutParams.verticalChainStyle);
            widget.setHorizontalMatchStyle(layoutParams.matchConstraintDefaultWidth, layoutParams.matchConstraintMinWidth, layoutParams.matchConstraintMaxWidth, layoutParams.matchConstraintPercentWidth);
            widget.setVerticalMatchStyle(layoutParams.matchConstraintDefaultHeight, layoutParams.matchConstraintMinHeight, layoutParams.matchConstraintMaxHeight, layoutParams.matchConstraintPercentHeight);
        }
    }

    private final ConstraintWidget getTargetWidget(int id2) {
        if (id2 == 0) {
            return this.mLayoutWidget;
        }
        View view = (View)this.mChildrenByIds.get(id2);
        if (view == null && (view = this.findViewById(id2)) != null && view != this && view.getParent() == this) {
            this.onViewAdded(view);
        }
        if (view == this) {
            return this.mLayoutWidget;
        }
        return view == null ? null : ((LayoutParams)view.getLayoutParams()).widget;
    }

    public final ConstraintWidget getViewWidget(View view) {
        if (view == this) {
            return this.mLayoutWidget;
        }
        return view == null ? null : ((LayoutParams)view.getLayoutParams()).widget;
    }

    public void fillMetrics(Metrics metrics) {
        this.mMetrics = metrics;
        this.mLayoutWidget.fillMetrics(metrics);
    }

    protected void resolveSystem(ConstraintWidgetContainer layout, int optimizationLevel, int widthMeasureSpec, int heightMeasureSpec) {
        int paddingX;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int paddingY = Math.max(0, this.getPaddingTop());
        int paddingBottom = Math.max(0, this.getPaddingBottom());
        int paddingHeight = paddingY + paddingBottom;
        int paddingWidth = this.getPaddingWidth();
        this.mMeasurer.captureLayoutInfos(widthMeasureSpec, heightMeasureSpec, paddingY, paddingBottom, paddingWidth, paddingHeight);
        if (Build.VERSION.SDK_INT >= 17) {
            int paddingStart = Math.max(0, this.getPaddingStart());
            int paddingEnd = Math.max(0, this.getPaddingEnd());
            paddingX = paddingStart > 0 || paddingEnd > 0 ? (this.isRtl() ? paddingEnd : paddingStart) : Math.max(0, this.getPaddingLeft());
        } else {
            paddingX = Math.max(0, this.getPaddingLeft());
        }
        this.setSelfDimensionBehaviour(layout, widthMode, widthSize -= paddingWidth, heightMode, heightSize -= paddingHeight);
        layout.measure(optimizationLevel, widthMode, widthSize, heightMode, heightSize, this.mLastMeasureWidth, this.mLastMeasureHeight, paddingX, paddingY);
    }

    protected void resolveMeasuredDimension(int widthMeasureSpec, int heightMeasureSpec, int measuredWidth, int measuredHeight, boolean isWidthMeasuredTooSmall, boolean isHeightMeasuredTooSmall) {
        int childState = 0;
        int heightPadding = this.mMeasurer.paddingHeight;
        int widthPadding = this.mMeasurer.paddingWidth;
        int androidLayoutWidth = measuredWidth + widthPadding;
        int androidLayoutHeight = measuredHeight + heightPadding;
        if (Build.VERSION.SDK_INT >= 11) {
            int resolvedWidthSize = ConstraintLayout.resolveSizeAndState((int)androidLayoutWidth, (int)widthMeasureSpec, (int)childState);
            int resolvedHeightSize = ConstraintLayout.resolveSizeAndState((int)androidLayoutHeight, (int)heightMeasureSpec, (int)(childState << 16));
            resolvedWidthSize &= 0xFFFFFF;
            resolvedHeightSize &= 0xFFFFFF;
            resolvedWidthSize = Math.min(this.mMaxWidth, resolvedWidthSize);
            resolvedHeightSize = Math.min(this.mMaxHeight, resolvedHeightSize);
            if (isWidthMeasuredTooSmall) {
                resolvedWidthSize |= 0x1000000;
            }
            if (isHeightMeasuredTooSmall) {
                resolvedHeightSize |= 0x1000000;
            }
            this.setMeasuredDimension(resolvedWidthSize, resolvedHeightSize);
            this.mLastMeasureWidth = resolvedWidthSize;
            this.mLastMeasureHeight = resolvedHeightSize;
        } else {
            this.setMeasuredDimension(androidLayoutWidth, androidLayoutHeight);
            this.mLastMeasureWidth = androidLayoutWidth;
            this.mLastMeasureHeight = androidLayoutHeight;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        long time = 0L;
        this.mOnMeasureWidthMeasureSpec = widthMeasureSpec;
        this.mOnMeasureHeightMeasureSpec = heightMeasureSpec;
        this.mLayoutWidget.setRtl(this.isRtl());
        if (this.mDirtyHierarchy) {
            this.mDirtyHierarchy = false;
            if (this.updateHierarchy()) {
                this.mLayoutWidget.updateHierarchy();
            }
        }
        this.resolveSystem(this.mLayoutWidget, this.mOptimizationLevel, widthMeasureSpec, heightMeasureSpec);
        this.resolveMeasuredDimension(widthMeasureSpec, heightMeasureSpec, this.mLayoutWidget.getWidth(), this.mLayoutWidget.getHeight(), this.mLayoutWidget.isWidthMeasuredTooSmall(), this.mLayoutWidget.isHeightMeasuredTooSmall());
    }

    protected boolean isRtl() {
        if (Build.VERSION.SDK_INT >= 17) {
            boolean isRtlSupported = (this.getContext().getApplicationInfo().flags & 0x400000) != 0;
            return isRtlSupported && 1 == this.getLayoutDirection();
        }
        return false;
    }

    private int getPaddingWidth() {
        int widthPadding = Math.max(0, this.getPaddingLeft()) + Math.max(0, this.getPaddingRight());
        int rtlPadding = 0;
        if (Build.VERSION.SDK_INT >= 17) {
            rtlPadding = Math.max(0, this.getPaddingStart()) + Math.max(0, this.getPaddingEnd());
        }
        if (rtlPadding > 0) {
            widthPadding = rtlPadding;
        }
        return widthPadding;
    }

    protected void setSelfDimensionBehaviour(ConstraintWidgetContainer layout, int widthMode, int widthSize, int heightMode, int heightSize) {
        int heightPadding = this.mMeasurer.paddingHeight;
        int widthPadding = this.mMeasurer.paddingWidth;
        ConstraintWidget.DimensionBehaviour widthBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
        ConstraintWidget.DimensionBehaviour heightBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
        int desiredWidth = 0;
        int desiredHeight = 0;
        int childCount = this.getChildCount();
        switch (widthMode) {
            case -2147483648: {
                widthBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                desiredWidth = widthSize;
                if (childCount != 0) break;
                desiredWidth = Math.max(0, this.mMinWidth);
                break;
            }
            case 0: {
                widthBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                if (childCount != 0) break;
                desiredWidth = Math.max(0, this.mMinWidth);
                break;
            }
            case 0x40000000: {
                desiredWidth = Math.min(this.mMaxWidth - widthPadding, widthSize);
            }
        }
        switch (heightMode) {
            case -2147483648: {
                heightBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                desiredHeight = heightSize;
                if (childCount != 0) break;
                desiredHeight = Math.max(0, this.mMinHeight);
                break;
            }
            case 0: {
                heightBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                if (childCount != 0) break;
                desiredHeight = Math.max(0, this.mMinHeight);
                break;
            }
            case 0x40000000: {
                desiredHeight = Math.min(this.mMaxHeight - heightPadding, heightSize);
            }
        }
        if (desiredWidth != layout.getWidth() || desiredHeight != layout.getHeight()) {
            layout.invalidateMeasures();
        }
        layout.setX(0);
        layout.setY(0);
        layout.setMaxWidth(this.mMaxWidth - widthPadding);
        layout.setMaxHeight(this.mMaxHeight - heightPadding);
        layout.setMinWidth(0);
        layout.setMinHeight(0);
        layout.setHorizontalDimensionBehaviour(widthBehaviour);
        layout.setWidth(desiredWidth);
        layout.setVerticalDimensionBehaviour(heightBehaviour);
        layout.setHeight(desiredHeight);
        layout.setMinWidth(this.mMinWidth - widthPadding);
        layout.setMinHeight(this.mMinHeight - heightPadding);
    }

    public void setState(int id2, int screenWidth, int screenHeight) {
        if (this.mConstraintLayoutSpec != null) {
            this.mConstraintLayoutSpec.updateConstraints(id2, screenWidth, screenHeight);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int widgetsCount = this.getChildCount();
        boolean isInEditMode = this.isInEditMode();
        for (int i = 0; i < widgetsCount; ++i) {
            Placeholder holder;
            View content;
            View child = this.getChildAt(i);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            ConstraintWidget widget = params.widget;
            if (child.getVisibility() == 8 && !params.isGuideline && !params.isHelper && !params.isVirtualGroup && !isInEditMode || params.isInPlaceholder) continue;
            int l = widget.getX();
            int t = widget.getY();
            int r = l + widget.getWidth();
            int b = t + widget.getHeight();
            child.layout(l, t, r, b);
            if (!(child instanceof Placeholder) || (content = (holder = (Placeholder)child).getContent()) == null) continue;
            content.setVisibility(0);
            content.layout(l, t, r, b);
        }
        int helperCount = this.mConstraintHelpers.size();
        if (helperCount > 0) {
            for (int i = 0; i < helperCount; ++i) {
                ConstraintHelper helper = this.mConstraintHelpers.get(i);
                helper.updatePostLayout(this);
            }
        }
    }

    public void setOptimizationLevel(int level) {
        this.mOptimizationLevel = level;
        this.mLayoutWidget.setOptimizationLevel(level);
    }

    public int getOptimizationLevel() {
        return this.mLayoutWidget.getOptimizationLevel();
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public void setConstraintSet(ConstraintSet set) {
        this.mConstraintSet = set;
    }

    public View getViewById(int id2) {
        return (View)this.mChildrenByIds.get(id2);
    }

    protected void dispatchDraw(Canvas canvas) {
        int helperCount;
        if (this.mConstraintHelpers != null && (helperCount = this.mConstraintHelpers.size()) > 0) {
            for (int i = 0; i < helperCount; ++i) {
                ConstraintHelper helper = this.mConstraintHelpers.get(i);
                helper.updatePreDraw(this);
            }
        }
        super.dispatchDraw(canvas);
        if (this.isInEditMode()) {
            int count = this.getChildCount();
            float cw = this.getWidth();
            float ch = this.getHeight();
            float ow = 1080.0f;
            float oh = 1920.0f;
            for (int i = 0; i < count; ++i) {
                String coordinates;
                String[] split;
                Object tag;
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8 || (tag = child.getTag()) == null || !(tag instanceof String) || (split = (coordinates = (String)tag).split(",")).length != 4) continue;
                int x = Integer.parseInt(split[0]);
                int y = Integer.parseInt(split[1]);
                int w = Integer.parseInt(split[2]);
                int h = Integer.parseInt(split[3]);
                x = (int)((float)x / ow * cw);
                y = (int)((float)y / oh * ch);
                w = (int)((float)w / ow * cw);
                h = (int)((float)h / oh * ch);
                Paint paint = new Paint();
                paint.setColor(-65536);
                canvas.drawLine((float)x, (float)y, (float)(x + w), (float)y, paint);
                canvas.drawLine((float)(x + w), (float)y, (float)(x + w), (float)(y + h), paint);
                canvas.drawLine((float)(x + w), (float)(y + h), (float)x, (float)(y + h), paint);
                canvas.drawLine((float)x, (float)(y + h), (float)x, (float)y, paint);
                paint.setColor(-16711936);
                canvas.drawLine((float)x, (float)y, (float)(x + w), (float)(y + h), paint);
                canvas.drawLine((float)x, (float)(y + h), (float)(x + w), (float)y, paint);
            }
        }
    }

    public void setOnConstraintsChanged(ConstraintsChangedListener constraintsChangedListener) {
        this.mConstraintsChangedListener = constraintsChangedListener;
        if (this.mConstraintLayoutSpec != null) {
            this.mConstraintLayoutSpec.setOnConstraintsChanged(constraintsChangedListener);
        }
    }

    public void loadLayoutDescription(int layoutDescription) {
        if (layoutDescription != 0) {
            try {
                this.mConstraintLayoutSpec = new ConstraintLayoutStates(this.getContext(), this, layoutDescription);
            }
            catch (Resources.NotFoundException e) {
                this.mConstraintLayoutSpec = null;
            }
        } else {
            this.mConstraintLayoutSpec = null;
        }
    }

    public void requestLayout() {
        this.markHierarchyDirty();
        super.requestLayout();
    }

    public void forceLayout() {
        this.markHierarchyDirty();
        super.forceLayout();
    }

    private void markHierarchyDirty() {
        this.mDirtyHierarchy = true;
        this.mLastMeasureWidth = -1;
        this.mLastMeasureHeight = -1;
        this.mLastMeasureWidthSize = -1;
        this.mLastMeasureHeightSize = -1;
        this.mLastMeasureWidthMode = 0;
        this.mLastMeasureHeightMode = 0;
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public static final int MATCH_CONSTRAINT = 0;
        public static final int PARENT_ID = 0;
        public static final int UNSET = -1;
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
        public static final int LEFT = 1;
        public static final int RIGHT = 2;
        public static final int TOP = 3;
        public static final int BOTTOM = 4;
        public static final int BASELINE = 5;
        public static final int START = 6;
        public static final int END = 7;
        public static final int MATCH_CONSTRAINT_WRAP = 1;
        public static final int MATCH_CONSTRAINT_SPREAD = 0;
        public static final int MATCH_CONSTRAINT_PERCENT = 2;
        public static final int CHAIN_SPREAD = 0;
        public static final int CHAIN_SPREAD_INSIDE = 1;
        public static final int CHAIN_PACKED = 2;
        public int guideBegin = -1;
        public int guideEnd = -1;
        public float guidePercent = -1.0f;
        public int leftToLeft = -1;
        public int leftToRight = -1;
        public int rightToLeft = -1;
        public int rightToRight = -1;
        public int topToTop = -1;
        public int topToBottom = -1;
        public int bottomToTop = -1;
        public int bottomToBottom = -1;
        public int baselineToBaseline = -1;
        public int circleConstraint = -1;
        public int circleRadius = 0;
        public float circleAngle = 0.0f;
        public int startToEnd = -1;
        public int startToStart = -1;
        public int endToStart = -1;
        public int endToEnd = -1;
        public int goneLeftMargin = -1;
        public int goneTopMargin = -1;
        public int goneRightMargin = -1;
        public int goneBottomMargin = -1;
        public int goneStartMargin = -1;
        public int goneEndMargin = -1;
        public float horizontalBias = 0.5f;
        public float verticalBias = 0.5f;
        public String dimensionRatio = null;
        float dimensionRatioValue = 0.0f;
        int dimensionRatioSide = 1;
        public float horizontalWeight = -1.0f;
        public float verticalWeight = -1.0f;
        public int horizontalChainStyle = 0;
        public int verticalChainStyle = 0;
        public int matchConstraintDefaultWidth = 0;
        public int matchConstraintDefaultHeight = 0;
        public int matchConstraintMinWidth = 0;
        public int matchConstraintMinHeight = 0;
        public int matchConstraintMaxWidth = 0;
        public int matchConstraintMaxHeight = 0;
        public float matchConstraintPercentWidth = 1.0f;
        public float matchConstraintPercentHeight = 1.0f;
        public int editorAbsoluteX = -1;
        public int editorAbsoluteY = -1;
        public int orientation = -1;
        public boolean constrainedWidth = false;
        public boolean constrainedHeight = false;
        public String constraintTag = null;
        boolean horizontalDimensionFixed = true;
        boolean verticalDimensionFixed = true;
        boolean needsBaseline = false;
        boolean isGuideline = false;
        boolean isHelper = false;
        boolean isInPlaceholder = false;
        boolean isVirtualGroup = false;
        int resolvedLeftToLeft = -1;
        int resolvedLeftToRight = -1;
        int resolvedRightToLeft = -1;
        int resolvedRightToRight = -1;
        int resolveGoneLeftMargin = -1;
        int resolveGoneRightMargin = -1;
        float resolvedHorizontalBias = 0.5f;
        int resolvedGuideBegin;
        int resolvedGuideEnd;
        float resolvedGuidePercent;
        ConstraintWidget widget = new ConstraintWidget();
        public boolean helped = false;

        public ConstraintWidget getConstraintWidget() {
            return this.widget;
        }

        public void setWidgetDebugName(String text) {
            this.widget.setDebugName(text);
        }

        public void reset() {
            if (this.widget != null) {
                this.widget.reset();
            }
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.guideBegin = source.guideBegin;
            this.guideEnd = source.guideEnd;
            this.guidePercent = source.guidePercent;
            this.leftToLeft = source.leftToLeft;
            this.leftToRight = source.leftToRight;
            this.rightToLeft = source.rightToLeft;
            this.rightToRight = source.rightToRight;
            this.topToTop = source.topToTop;
            this.topToBottom = source.topToBottom;
            this.bottomToTop = source.bottomToTop;
            this.bottomToBottom = source.bottomToBottom;
            this.baselineToBaseline = source.baselineToBaseline;
            this.circleConstraint = source.circleConstraint;
            this.circleRadius = source.circleRadius;
            this.circleAngle = source.circleAngle;
            this.startToEnd = source.startToEnd;
            this.startToStart = source.startToStart;
            this.endToStart = source.endToStart;
            this.endToEnd = source.endToEnd;
            this.goneLeftMargin = source.goneLeftMargin;
            this.goneTopMargin = source.goneTopMargin;
            this.goneRightMargin = source.goneRightMargin;
            this.goneBottomMargin = source.goneBottomMargin;
            this.goneStartMargin = source.goneStartMargin;
            this.goneEndMargin = source.goneEndMargin;
            this.horizontalBias = source.horizontalBias;
            this.verticalBias = source.verticalBias;
            this.dimensionRatio = source.dimensionRatio;
            this.dimensionRatioValue = source.dimensionRatioValue;
            this.dimensionRatioSide = source.dimensionRatioSide;
            this.horizontalWeight = source.horizontalWeight;
            this.verticalWeight = source.verticalWeight;
            this.horizontalChainStyle = source.horizontalChainStyle;
            this.verticalChainStyle = source.verticalChainStyle;
            this.constrainedWidth = source.constrainedWidth;
            this.constrainedHeight = source.constrainedHeight;
            this.matchConstraintDefaultWidth = source.matchConstraintDefaultWidth;
            this.matchConstraintDefaultHeight = source.matchConstraintDefaultHeight;
            this.matchConstraintMinWidth = source.matchConstraintMinWidth;
            this.matchConstraintMaxWidth = source.matchConstraintMaxWidth;
            this.matchConstraintMinHeight = source.matchConstraintMinHeight;
            this.matchConstraintMaxHeight = source.matchConstraintMaxHeight;
            this.matchConstraintPercentWidth = source.matchConstraintPercentWidth;
            this.matchConstraintPercentHeight = source.matchConstraintPercentHeight;
            this.editorAbsoluteX = source.editorAbsoluteX;
            this.editorAbsoluteY = source.editorAbsoluteY;
            this.orientation = source.orientation;
            this.horizontalDimensionFixed = source.horizontalDimensionFixed;
            this.verticalDimensionFixed = source.verticalDimensionFixed;
            this.needsBaseline = source.needsBaseline;
            this.isGuideline = source.isGuideline;
            this.resolvedLeftToLeft = source.resolvedLeftToLeft;
            this.resolvedLeftToRight = source.resolvedLeftToRight;
            this.resolvedRightToLeft = source.resolvedRightToLeft;
            this.resolvedRightToRight = source.resolvedRightToRight;
            this.resolveGoneLeftMargin = source.resolveGoneLeftMargin;
            this.resolveGoneRightMargin = source.resolveGoneRightMargin;
            this.resolvedHorizontalBias = source.resolvedHorizontalBias;
            this.constraintTag = source.constraintTag;
            this.widget = source.widget;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout);
            int N = a.getIndexCount();
            block65: for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                int look = Table.map.get(attr);
                switch (look) {
                    case 0: {
                        continue block65;
                    }
                    case 8: {
                        this.leftToLeft = a.getResourceId(attr, this.leftToLeft);
                        if (this.leftToLeft != -1) continue block65;
                        this.leftToLeft = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 9: {
                        this.leftToRight = a.getResourceId(attr, this.leftToRight);
                        if (this.leftToRight != -1) continue block65;
                        this.leftToRight = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 10: {
                        this.rightToLeft = a.getResourceId(attr, this.rightToLeft);
                        if (this.rightToLeft != -1) continue block65;
                        this.rightToLeft = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 11: {
                        this.rightToRight = a.getResourceId(attr, this.rightToRight);
                        if (this.rightToRight != -1) continue block65;
                        this.rightToRight = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 12: {
                        this.topToTop = a.getResourceId(attr, this.topToTop);
                        if (this.topToTop != -1) continue block65;
                        this.topToTop = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 13: {
                        this.topToBottom = a.getResourceId(attr, this.topToBottom);
                        if (this.topToBottom != -1) continue block65;
                        this.topToBottom = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 14: {
                        this.bottomToTop = a.getResourceId(attr, this.bottomToTop);
                        if (this.bottomToTop != -1) continue block65;
                        this.bottomToTop = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 15: {
                        this.bottomToBottom = a.getResourceId(attr, this.bottomToBottom);
                        if (this.bottomToBottom != -1) continue block65;
                        this.bottomToBottom = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 16: {
                        this.baselineToBaseline = a.getResourceId(attr, this.baselineToBaseline);
                        if (this.baselineToBaseline != -1) continue block65;
                        this.baselineToBaseline = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 2: {
                        this.circleConstraint = a.getResourceId(attr, this.circleConstraint);
                        if (this.circleConstraint != -1) continue block65;
                        this.circleConstraint = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 3: {
                        this.circleRadius = a.getDimensionPixelSize(attr, this.circleRadius);
                        continue block65;
                    }
                    case 4: {
                        this.circleAngle = a.getFloat(attr, this.circleAngle) % 360.0f;
                        if (!(this.circleAngle < 0.0f)) continue block65;
                        this.circleAngle = (360.0f - this.circleAngle) % 360.0f;
                        continue block65;
                    }
                    case 49: {
                        this.editorAbsoluteX = a.getDimensionPixelOffset(attr, this.editorAbsoluteX);
                        continue block65;
                    }
                    case 50: {
                        this.editorAbsoluteY = a.getDimensionPixelOffset(attr, this.editorAbsoluteY);
                        continue block65;
                    }
                    case 5: {
                        this.guideBegin = a.getDimensionPixelOffset(attr, this.guideBegin);
                        continue block65;
                    }
                    case 6: {
                        this.guideEnd = a.getDimensionPixelOffset(attr, this.guideEnd);
                        continue block65;
                    }
                    case 7: {
                        this.guidePercent = a.getFloat(attr, this.guidePercent);
                        continue block65;
                    }
                    case 1: {
                        this.orientation = a.getInt(attr, this.orientation);
                        continue block65;
                    }
                    case 17: {
                        this.startToEnd = a.getResourceId(attr, this.startToEnd);
                        if (this.startToEnd != -1) continue block65;
                        this.startToEnd = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 18: {
                        this.startToStart = a.getResourceId(attr, this.startToStart);
                        if (this.startToStart != -1) continue block65;
                        this.startToStart = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 19: {
                        this.endToStart = a.getResourceId(attr, this.endToStart);
                        if (this.endToStart != -1) continue block65;
                        this.endToStart = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 20: {
                        this.endToEnd = a.getResourceId(attr, this.endToEnd);
                        if (this.endToEnd != -1) continue block65;
                        this.endToEnd = a.getInt(attr, -1);
                        continue block65;
                    }
                    case 21: {
                        this.goneLeftMargin = a.getDimensionPixelSize(attr, this.goneLeftMargin);
                        continue block65;
                    }
                    case 22: {
                        this.goneTopMargin = a.getDimensionPixelSize(attr, this.goneTopMargin);
                        continue block65;
                    }
                    case 23: {
                        this.goneRightMargin = a.getDimensionPixelSize(attr, this.goneRightMargin);
                        continue block65;
                    }
                    case 24: {
                        this.goneBottomMargin = a.getDimensionPixelSize(attr, this.goneBottomMargin);
                        continue block65;
                    }
                    case 25: {
                        this.goneStartMargin = a.getDimensionPixelSize(attr, this.goneStartMargin);
                        continue block65;
                    }
                    case 26: {
                        this.goneEndMargin = a.getDimensionPixelSize(attr, this.goneEndMargin);
                        continue block65;
                    }
                    case 29: {
                        this.horizontalBias = a.getFloat(attr, this.horizontalBias);
                        continue block65;
                    }
                    case 30: {
                        this.verticalBias = a.getFloat(attr, this.verticalBias);
                        continue block65;
                    }
                    case 44: {
                        this.dimensionRatio = a.getString(attr);
                        this.dimensionRatioValue = Float.NaN;
                        this.dimensionRatioSide = -1;
                        if (this.dimensionRatio == null) continue block65;
                        int len = this.dimensionRatio.length();
                        int commaIndex = this.dimensionRatio.indexOf(44);
                        if (commaIndex > 0 && commaIndex < len - 1) {
                            String dimension = this.dimensionRatio.substring(0, commaIndex);
                            if (dimension.equalsIgnoreCase("W")) {
                                this.dimensionRatioSide = 0;
                            } else if (dimension.equalsIgnoreCase("H")) {
                                this.dimensionRatioSide = 1;
                            }
                            ++commaIndex;
                        } else {
                            commaIndex = 0;
                        }
                        int colonIndex = this.dimensionRatio.indexOf(58);
                        if (colonIndex >= 0 && colonIndex < len - 1) {
                            String nominator = this.dimensionRatio.substring(commaIndex, colonIndex);
                            String denominator = this.dimensionRatio.substring(colonIndex + 1);
                            if (nominator.length() <= 0 || denominator.length() <= 0) continue block65;
                            try {
                                float nominatorValue = Float.parseFloat(nominator);
                                float denominatorValue = Float.parseFloat(denominator);
                                if (!(nominatorValue > 0.0f) || !(denominatorValue > 0.0f)) continue block65;
                                if (this.dimensionRatioSide == 1) {
                                    this.dimensionRatioValue = Math.abs(denominatorValue / nominatorValue);
                                    continue block65;
                                }
                                this.dimensionRatioValue = Math.abs(nominatorValue / denominatorValue);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            continue block65;
                        }
                        String r = this.dimensionRatio.substring(commaIndex);
                        if (r.length() <= 0) continue block65;
                        try {
                            this.dimensionRatioValue = Float.parseFloat(r);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block65;
                    }
                    case 45: {
                        this.horizontalWeight = a.getFloat(attr, this.horizontalWeight);
                        continue block65;
                    }
                    case 46: {
                        this.verticalWeight = a.getFloat(attr, this.verticalWeight);
                        continue block65;
                    }
                    case 47: {
                        this.horizontalChainStyle = a.getInt(attr, 0);
                        continue block65;
                    }
                    case 48: {
                        this.verticalChainStyle = a.getInt(attr, 0);
                        continue block65;
                    }
                    case 27: {
                        this.constrainedWidth = a.getBoolean(attr, this.constrainedWidth);
                        continue block65;
                    }
                    case 28: {
                        this.constrainedHeight = a.getBoolean(attr, this.constrainedHeight);
                        continue block65;
                    }
                    case 31: {
                        this.matchConstraintDefaultWidth = a.getInt(attr, 0);
                        if (this.matchConstraintDefaultWidth != 1) continue block65;
                        Log.e((String)ConstraintLayout.TAG, (String)"layout_constraintWidth_default=\"wrap\" is deprecated.\nUse layout_width=\"WRAP_CONTENT\" and layout_constrainedWidth=\"true\" instead.");
                        continue block65;
                    }
                    case 32: {
                        this.matchConstraintDefaultHeight = a.getInt(attr, 0);
                        if (this.matchConstraintDefaultHeight != 1) continue block65;
                        Log.e((String)ConstraintLayout.TAG, (String)"layout_constraintHeight_default=\"wrap\" is deprecated.\nUse layout_height=\"WRAP_CONTENT\" and layout_constrainedHeight=\"true\" instead.");
                        continue block65;
                    }
                    case 33: {
                        int value;
                        try {
                            this.matchConstraintMinWidth = a.getDimensionPixelSize(attr, this.matchConstraintMinWidth);
                        }
                        catch (Exception e) {
                            value = a.getInt(attr, this.matchConstraintMinWidth);
                            if (value != -2) continue block65;
                            this.matchConstraintMinWidth = -2;
                        }
                        continue block65;
                    }
                    case 34: {
                        int value;
                        try {
                            this.matchConstraintMaxWidth = a.getDimensionPixelSize(attr, this.matchConstraintMaxWidth);
                        }
                        catch (Exception e) {
                            value = a.getInt(attr, this.matchConstraintMaxWidth);
                            if (value != -2) continue block65;
                            this.matchConstraintMaxWidth = -2;
                        }
                        continue block65;
                    }
                    case 35: {
                        this.matchConstraintPercentWidth = Math.max(0.0f, a.getFloat(attr, this.matchConstraintPercentWidth));
                        this.matchConstraintDefaultWidth = 2;
                        continue block65;
                    }
                    case 36: {
                        int value;
                        try {
                            this.matchConstraintMinHeight = a.getDimensionPixelSize(attr, this.matchConstraintMinHeight);
                        }
                        catch (Exception e) {
                            value = a.getInt(attr, this.matchConstraintMinHeight);
                            if (value != -2) continue block65;
                            this.matchConstraintMinHeight = -2;
                        }
                        continue block65;
                    }
                    case 37: {
                        int value;
                        try {
                            this.matchConstraintMaxHeight = a.getDimensionPixelSize(attr, this.matchConstraintMaxHeight);
                        }
                        catch (Exception e) {
                            value = a.getInt(attr, this.matchConstraintMaxHeight);
                            if (value != -2) continue block65;
                            this.matchConstraintMaxHeight = -2;
                        }
                        continue block65;
                    }
                    case 38: {
                        this.matchConstraintPercentHeight = Math.max(0.0f, a.getFloat(attr, this.matchConstraintPercentHeight));
                        this.matchConstraintDefaultHeight = 2;
                        continue block65;
                    }
                    case 51: {
                        this.constraintTag = a.getString(attr);
                        continue block65;
                    }
                    case 39: {
                        continue block65;
                    }
                    case 40: {
                        continue block65;
                    }
                    case 41: {
                        continue block65;
                    }
                    case 42: {
                        continue block65;
                    }
                }
            }
            a.recycle();
            this.validate();
        }

        public void validate() {
            this.isGuideline = false;
            this.horizontalDimensionFixed = true;
            this.verticalDimensionFixed = true;
            if (this.width == -2 && this.constrainedWidth) {
                this.horizontalDimensionFixed = false;
                if (this.matchConstraintDefaultWidth == 0) {
                    this.matchConstraintDefaultWidth = 1;
                }
            }
            if (this.height == -2 && this.constrainedHeight) {
                this.verticalDimensionFixed = false;
                if (this.matchConstraintDefaultHeight == 0) {
                    this.matchConstraintDefaultHeight = 1;
                }
            }
            if (this.width == 0 || this.width == -1) {
                this.horizontalDimensionFixed = false;
                if (this.width == 0 && this.matchConstraintDefaultWidth == 1) {
                    this.width = -2;
                    this.constrainedWidth = true;
                }
            }
            if (this.height == 0 || this.height == -1) {
                this.verticalDimensionFixed = false;
                if (this.height == 0 && this.matchConstraintDefaultHeight == 1) {
                    this.height = -2;
                    this.constrainedHeight = true;
                }
            }
            if (this.guidePercent != -1.0f || this.guideBegin != -1 || this.guideEnd != -1) {
                this.isGuideline = true;
                this.horizontalDimensionFixed = true;
                this.verticalDimensionFixed = true;
                if (!(this.widget instanceof android.support.constraint.solver.widgets.Guideline)) {
                    this.widget = new android.support.constraint.solver.widgets.Guideline();
                }
                ((android.support.constraint.solver.widgets.Guideline)this.widget).setOrientation(this.orientation);
            }
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        @TargetApi(value=17)
        public void resolveLayoutDirection(int layoutDirection) {
            int preLeftMargin = this.leftMargin;
            int preRightMargin = this.rightMargin;
            boolean isRtl = false;
            if (Build.VERSION.SDK_INT >= 17) {
                super.resolveLayoutDirection(layoutDirection);
                isRtl = 1 == this.getLayoutDirection();
            }
            this.resolvedRightToLeft = -1;
            this.resolvedRightToRight = -1;
            this.resolvedLeftToLeft = -1;
            this.resolvedLeftToRight = -1;
            this.resolveGoneLeftMargin = -1;
            this.resolveGoneRightMargin = -1;
            this.resolveGoneLeftMargin = this.goneLeftMargin;
            this.resolveGoneRightMargin = this.goneRightMargin;
            this.resolvedHorizontalBias = this.horizontalBias;
            this.resolvedGuideBegin = this.guideBegin;
            this.resolvedGuideEnd = this.guideEnd;
            this.resolvedGuidePercent = this.guidePercent;
            if (isRtl) {
                boolean startEndDefined = false;
                if (this.startToEnd != -1) {
                    this.resolvedRightToLeft = this.startToEnd;
                    startEndDefined = true;
                } else if (this.startToStart != -1) {
                    this.resolvedRightToRight = this.startToStart;
                    startEndDefined = true;
                }
                if (this.endToStart != -1) {
                    this.resolvedLeftToRight = this.endToStart;
                    startEndDefined = true;
                }
                if (this.endToEnd != -1) {
                    this.resolvedLeftToLeft = this.endToEnd;
                    startEndDefined = true;
                }
                if (this.goneStartMargin != -1) {
                    this.resolveGoneRightMargin = this.goneStartMargin;
                }
                if (this.goneEndMargin != -1) {
                    this.resolveGoneLeftMargin = this.goneEndMargin;
                }
                if (startEndDefined) {
                    this.resolvedHorizontalBias = 1.0f - this.horizontalBias;
                }
                if (this.isGuideline && this.orientation == 1) {
                    if (this.guidePercent != -1.0f) {
                        this.resolvedGuidePercent = 1.0f - this.guidePercent;
                        this.resolvedGuideBegin = -1;
                        this.resolvedGuideEnd = -1;
                    } else if (this.guideBegin != -1) {
                        this.resolvedGuideEnd = this.guideBegin;
                        this.resolvedGuideBegin = -1;
                        this.resolvedGuidePercent = -1.0f;
                    } else if (this.guideEnd != -1) {
                        this.resolvedGuideBegin = this.guideEnd;
                        this.resolvedGuideEnd = -1;
                        this.resolvedGuidePercent = -1.0f;
                    }
                }
            } else {
                if (this.startToEnd != -1) {
                    this.resolvedLeftToRight = this.startToEnd;
                }
                if (this.startToStart != -1) {
                    this.resolvedLeftToLeft = this.startToStart;
                }
                if (this.endToStart != -1) {
                    this.resolvedRightToLeft = this.endToStart;
                }
                if (this.endToEnd != -1) {
                    this.resolvedRightToRight = this.endToEnd;
                }
                if (this.goneStartMargin != -1) {
                    this.resolveGoneLeftMargin = this.goneStartMargin;
                }
                if (this.goneEndMargin != -1) {
                    this.resolveGoneRightMargin = this.goneEndMargin;
                }
            }
            if (this.endToStart == -1 && this.endToEnd == -1 && this.startToStart == -1 && this.startToEnd == -1) {
                if (this.rightToLeft != -1) {
                    this.resolvedRightToLeft = this.rightToLeft;
                    if (this.rightMargin <= 0 && preRightMargin > 0) {
                        this.rightMargin = preRightMargin;
                    }
                } else if (this.rightToRight != -1) {
                    this.resolvedRightToRight = this.rightToRight;
                    if (this.rightMargin <= 0 && preRightMargin > 0) {
                        this.rightMargin = preRightMargin;
                    }
                }
                if (this.leftToLeft != -1) {
                    this.resolvedLeftToLeft = this.leftToLeft;
                    if (this.leftMargin <= 0 && preLeftMargin > 0) {
                        this.leftMargin = preLeftMargin;
                    }
                } else if (this.leftToRight != -1) {
                    this.resolvedLeftToRight = this.leftToRight;
                    if (this.leftMargin <= 0 && preLeftMargin > 0) {
                        this.leftMargin = preLeftMargin;
                    }
                }
            }
        }

        public String getConstraintTag() {
            return this.constraintTag;
        }

        private static class Table {
            public static final int UNUSED = 0;
            public static final int ANDROID_ORIENTATION = 1;
            public static final int LAYOUT_CONSTRAINT_CIRCLE = 2;
            public static final int LAYOUT_CONSTRAINT_CIRCLE_RADIUS = 3;
            public static final int LAYOUT_CONSTRAINT_CIRCLE_ANGLE = 4;
            public static final int LAYOUT_CONSTRAINT_GUIDE_BEGIN = 5;
            public static final int LAYOUT_CONSTRAINT_GUIDE_END = 6;
            public static final int LAYOUT_CONSTRAINT_GUIDE_PERCENT = 7;
            public static final int LAYOUT_CONSTRAINT_LEFT_TO_LEFT_OF = 8;
            public static final int LAYOUT_CONSTRAINT_LEFT_TO_RIGHT_OF = 9;
            public static final int LAYOUT_CONSTRAINT_RIGHT_TO_LEFT_OF = 10;
            public static final int LAYOUT_CONSTRAINT_RIGHT_TO_RIGHT_OF = 11;
            public static final int LAYOUT_CONSTRAINT_TOP_TO_TOP_OF = 12;
            public static final int LAYOUT_CONSTRAINT_TOP_TO_BOTTOM_OF = 13;
            public static final int LAYOUT_CONSTRAINT_BOTTOM_TO_TOP_OF = 14;
            public static final int LAYOUT_CONSTRAINT_BOTTOM_TO_BOTTOM_OF = 15;
            public static final int LAYOUT_CONSTRAINT_BASELINE_TO_BASELINE_OF = 16;
            public static final int LAYOUT_CONSTRAINT_START_TO_END_OF = 17;
            public static final int LAYOUT_CONSTRAINT_START_TO_START_OF = 18;
            public static final int LAYOUT_CONSTRAINT_END_TO_START_OF = 19;
            public static final int LAYOUT_CONSTRAINT_END_TO_END_OF = 20;
            public static final int LAYOUT_GONE_MARGIN_LEFT = 21;
            public static final int LAYOUT_GONE_MARGIN_TOP = 22;
            public static final int LAYOUT_GONE_MARGIN_RIGHT = 23;
            public static final int LAYOUT_GONE_MARGIN_BOTTOM = 24;
            public static final int LAYOUT_GONE_MARGIN_START = 25;
            public static final int LAYOUT_GONE_MARGIN_END = 26;
            public static final int LAYOUT_CONSTRAINED_WIDTH = 27;
            public static final int LAYOUT_CONSTRAINED_HEIGHT = 28;
            public static final int LAYOUT_CONSTRAINT_HORIZONTAL_BIAS = 29;
            public static final int LAYOUT_CONSTRAINT_VERTICAL_BIAS = 30;
            public static final int LAYOUT_CONSTRAINT_WIDTH_DEFAULT = 31;
            public static final int LAYOUT_CONSTRAINT_HEIGHT_DEFAULT = 32;
            public static final int LAYOUT_CONSTRAINT_WIDTH_MIN = 33;
            public static final int LAYOUT_CONSTRAINT_WIDTH_MAX = 34;
            public static final int LAYOUT_CONSTRAINT_WIDTH_PERCENT = 35;
            public static final int LAYOUT_CONSTRAINT_HEIGHT_MIN = 36;
            public static final int LAYOUT_CONSTRAINT_HEIGHT_MAX = 37;
            public static final int LAYOUT_CONSTRAINT_HEIGHT_PERCENT = 38;
            public static final int LAYOUT_CONSTRAINT_LEFT_CREATOR = 39;
            public static final int LAYOUT_CONSTRAINT_TOP_CREATOR = 40;
            public static final int LAYOUT_CONSTRAINT_RIGHT_CREATOR = 41;
            public static final int LAYOUT_CONSTRAINT_BOTTOM_CREATOR = 42;
            public static final int LAYOUT_CONSTRAINT_BASELINE_CREATOR = 43;
            public static final int LAYOUT_CONSTRAINT_DIMENSION_RATIO = 44;
            public static final int LAYOUT_CONSTRAINT_HORIZONTAL_WEIGHT = 45;
            public static final int LAYOUT_CONSTRAINT_VERTICAL_WEIGHT = 46;
            public static final int LAYOUT_CONSTRAINT_HORIZONTAL_CHAINSTYLE = 47;
            public static final int LAYOUT_CONSTRAINT_VERTICAL_CHAINSTYLE = 48;
            public static final int LAYOUT_EDITOR_ABSOLUTEX = 49;
            public static final int LAYOUT_EDITOR_ABSOLUTEY = 50;
            public static final int LAYOUT_CONSTRAINT_TAG = 51;
            public static final SparseIntArray map = new SparseIntArray();

            private Table() {
            }

            static {
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintLeft_toLeftOf, 8);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintLeft_toRightOf, 9);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintRight_toLeftOf, 10);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintRight_toRightOf, 11);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintTop_toTopOf, 12);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintTop_toBottomOf, 13);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintBottom_toTopOf, 14);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintBottom_toBottomOf, 15);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintBaseline_toBaselineOf, 16);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintCircle, 2);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintCircleRadius, 3);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintCircleAngle, 4);
                map.append(R.styleable.ConstraintLayout_Layout_layout_editor_absoluteX, 49);
                map.append(R.styleable.ConstraintLayout_Layout_layout_editor_absoluteY, 50);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintGuide_begin, 5);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintGuide_end, 6);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintGuide_percent, 7);
                map.append(R.styleable.ConstraintLayout_Layout_android_orientation, 1);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintStart_toEndOf, 17);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintStart_toStartOf, 18);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintEnd_toStartOf, 19);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintEnd_toEndOf, 20);
                map.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginLeft, 21);
                map.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginTop, 22);
                map.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginRight, 23);
                map.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginBottom, 24);
                map.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginStart, 25);
                map.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginEnd, 26);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintHorizontal_bias, 29);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintVertical_bias, 30);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintDimensionRatio, 44);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintHorizontal_weight, 45);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintVertical_weight, 46);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintHorizontal_chainStyle, 47);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintVertical_chainStyle, 48);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constrainedWidth, 27);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constrainedHeight, 28);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintWidth_default, 31);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintHeight_default, 32);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintWidth_min, 33);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintWidth_max, 34);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintWidth_percent, 35);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintHeight_min, 36);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintHeight_max, 37);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintHeight_percent, 38);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintLeft_creator, 39);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintTop_creator, 40);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintRight_creator, 41);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintBottom_creator, 42);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintBaseline_creator, 43);
                map.append(R.styleable.ConstraintLayout_Layout_layout_constraintTag, 51);
            }
        }
    }

    class Measurer
    implements BasicMeasure.Measurer {
        ConstraintLayout layout;
        int paddingTop;
        int paddingBottom;
        int paddingWidth;
        int paddingHeight;
        int layoutWidthSpec;
        int layoutHeightSpec;

        public void captureLayoutInfos(int widthSpec, int heightSpec, int top, int bottom, int width, int height) {
            this.paddingTop = top;
            this.paddingBottom = bottom;
            this.paddingWidth = width;
            this.paddingHeight = height;
            this.layoutWidthSpec = widthSpec;
            this.layoutHeightSpec = heightSpec;
        }

        public Measurer(ConstraintLayout l) {
            this.layout = l;
        }

        @SuppressLint(value={"WrongCall"})
        public final void measure(ConstraintWidget widget, BasicMeasure.Measure measure) {
            boolean useCurrent;
            boolean shouldDoWrap;
            if (widget == null) {
                return;
            }
            if (widget.getVisibility() == 8 && !widget.isInPlaceholder()) {
                measure.measuredWidth = 0;
                measure.measuredHeight = 0;
                measure.measuredBaseline = 0;
                return;
            }
            ConstraintWidget.DimensionBehaviour horizontalBehavior = measure.horizontalBehavior;
            ConstraintWidget.DimensionBehaviour verticalBehavior = measure.verticalBehavior;
            int horizontalDimension = measure.horizontalDimension;
            int verticalDimension = measure.verticalDimension;
            int horizontalSpec = 0;
            int verticalSpec = 0;
            int heightPadding = this.paddingTop + this.paddingBottom;
            int widthPadding = this.paddingWidth;
            boolean didHorizontalWrap = false;
            boolean didVerticalWrap = false;
            View child = (View)widget.getCompanionWidget();
            switch (horizontalBehavior) {
                case FIXED: {
                    horizontalSpec = View.MeasureSpec.makeMeasureSpec((int)horizontalDimension, (int)0x40000000);
                    widget.wrapMeasure[2] = horizontalDimension;
                    break;
                }
                case WRAP_CONTENT: {
                    horizontalSpec = ViewGroup.getChildMeasureSpec((int)this.layoutWidthSpec, (int)widthPadding, (int)-2);
                    didHorizontalWrap = true;
                    widget.wrapMeasure[2] = -2;
                    break;
                }
                case MATCH_PARENT: {
                    horizontalSpec = ViewGroup.getChildMeasureSpec((int)this.layoutWidthSpec, (int)(widthPadding + widget.getHorizontalMargin()), (int)-1);
                    widget.wrapMeasure[2] = -1;
                    break;
                }
                case MATCH_CONSTRAINT: {
                    horizontalSpec = ViewGroup.getChildMeasureSpec((int)this.layoutWidthSpec, (int)widthPadding, (int)-2);
                    didHorizontalWrap = true;
                    shouldDoWrap = widget.mMatchConstraintDefaultWidth == 1;
                    widget.wrapMeasure[2] = 0;
                    if (!measure.useCurrentDimensions) break;
                    boolean bl = useCurrent = shouldDoWrap && widget.wrapMeasure[3] != 0 && widget.wrapMeasure[0] != widget.getWidth() || child instanceof Placeholder;
                    if (shouldDoWrap && !useCurrent) break;
                    horizontalSpec = View.MeasureSpec.makeMeasureSpec((int)widget.getWidth(), (int)0x40000000);
                    didHorizontalWrap = false;
                }
            }
            switch (verticalBehavior) {
                case FIXED: {
                    verticalSpec = View.MeasureSpec.makeMeasureSpec((int)verticalDimension, (int)0x40000000);
                    widget.wrapMeasure[3] = verticalDimension;
                    break;
                }
                case WRAP_CONTENT: {
                    verticalSpec = ViewGroup.getChildMeasureSpec((int)this.layoutHeightSpec, (int)heightPadding, (int)-2);
                    didVerticalWrap = true;
                    widget.wrapMeasure[3] = -2;
                    break;
                }
                case MATCH_PARENT: {
                    verticalSpec = ViewGroup.getChildMeasureSpec((int)this.layoutHeightSpec, (int)(heightPadding + widget.getVerticalMargin()), (int)-1);
                    widget.wrapMeasure[3] = -1;
                    break;
                }
                case MATCH_CONSTRAINT: {
                    verticalSpec = ViewGroup.getChildMeasureSpec((int)this.layoutHeightSpec, (int)heightPadding, (int)-2);
                    didVerticalWrap = true;
                    shouldDoWrap = widget.mMatchConstraintDefaultHeight == 1;
                    widget.wrapMeasure[3] = 0;
                    if (!measure.useCurrentDimensions) break;
                    boolean bl = useCurrent = shouldDoWrap && widget.wrapMeasure[2] != 0 && widget.wrapMeasure[1] != widget.getHeight() || child instanceof Placeholder;
                    if (shouldDoWrap && !useCurrent) break;
                    verticalSpec = View.MeasureSpec.makeMeasureSpec((int)widget.getHeight(), (int)0x40000000);
                    didVerticalWrap = false;
                }
            }
            boolean horizontalMatchConstraints = horizontalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
            boolean verticalMatchConstraints = verticalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
            boolean verticalDimensionKnown = verticalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT || verticalBehavior == ConstraintWidget.DimensionBehaviour.FIXED;
            boolean horizontalDimensionKnown = horizontalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT || horizontalBehavior == ConstraintWidget.DimensionBehaviour.FIXED;
            boolean horizontalUseRatio = horizontalMatchConstraints && widget.mDimensionRatio > 0.0f;
            boolean verticalUseRatio = verticalMatchConstraints && widget.mDimensionRatio > 0.0f;
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            int width = 0;
            int height = 0;
            int baseline = 0;
            if (measure.useCurrentDimensions || !horizontalMatchConstraints || widget.mMatchConstraintDefaultWidth != 0 || !verticalMatchConstraints || widget.mMatchConstraintDefaultHeight != 0) {
                if (child instanceof VirtualLayout && widget instanceof android.support.constraint.solver.widgets.VirtualLayout) {
                    android.support.constraint.solver.widgets.VirtualLayout layout = (android.support.constraint.solver.widgets.VirtualLayout)widget;
                    ((VirtualLayout)child).onMeasure(layout, horizontalSpec, verticalSpec);
                } else {
                    child.measure(horizontalSpec, verticalSpec);
                }
                int w = child.getMeasuredWidth();
                int h = child.getMeasuredHeight();
                baseline = child.getBaseline();
                width = w;
                height = h;
                if (didHorizontalWrap) {
                    widget.wrapMeasure[0] = w;
                    widget.wrapMeasure[2] = h;
                } else {
                    widget.wrapMeasure[0] = 0;
                    widget.wrapMeasure[2] = 0;
                }
                if (didVerticalWrap) {
                    widget.wrapMeasure[1] = h;
                    widget.wrapMeasure[3] = w;
                } else {
                    widget.wrapMeasure[1] = 0;
                    widget.wrapMeasure[3] = 0;
                }
                if (widget.mMatchConstraintMinWidth > 0) {
                    width = Math.max(widget.mMatchConstraintMinWidth, width);
                }
                if (widget.mMatchConstraintMaxWidth > 0) {
                    width = Math.min(widget.mMatchConstraintMaxWidth, width);
                }
                if (widget.mMatchConstraintMinHeight > 0) {
                    height = Math.max(widget.mMatchConstraintMinHeight, height);
                }
                if (widget.mMatchConstraintMaxHeight > 0) {
                    height = Math.min(widget.mMatchConstraintMaxHeight, height);
                }
                if (horizontalUseRatio && verticalDimensionKnown) {
                    float ratio = widget.mDimensionRatio;
                    width = (int)(0.5f + (float)height * ratio);
                } else if (verticalUseRatio && horizontalDimensionKnown) {
                    float ratio = widget.mDimensionRatio;
                    height = (int)(0.5f + (float)width / ratio);
                }
                if (w != width || h != height) {
                    if (w != width) {
                        horizontalSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
                    }
                    if (h != height) {
                        verticalSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
                    }
                    child.measure(horizontalSpec, verticalSpec);
                    width = child.getMeasuredWidth();
                    height = child.getMeasuredHeight();
                    baseline = child.getBaseline();
                }
            }
            boolean hasBaseline = baseline != -1;
            boolean bl = measure.measuredNeedsSolverPass = width != measure.horizontalDimension || height != measure.verticalDimension;
            if (params.needsBaseline) {
                hasBaseline = true;
            }
            if (hasBaseline && baseline != -1 && widget.getBaselineDistance() != baseline) {
                measure.measuredNeedsSolverPass = true;
            }
            measure.measuredWidth = width;
            measure.measuredHeight = height;
            measure.measuredHasBaseline = hasBaseline;
            measure.measuredBaseline = baseline;
        }

        public final void didMeasures() {
            int widgetsCount = this.layout.getChildCount();
            for (int i = 0; i < widgetsCount; ++i) {
                View child = this.layout.getChildAt(i);
                if (!(child instanceof Placeholder)) continue;
                ((Placeholder)child).updatePostMeasure(this.layout);
            }
            int helperCount = this.layout.mConstraintHelpers.size();
            if (helperCount > 0) {
                for (int i = 0; i < helperCount; ++i) {
                    ConstraintHelper helper = (ConstraintHelper)((Object)this.layout.mConstraintHelpers.get(i));
                    helper.updatePostMeasure(this.layout);
                }
            }
        }
    }
}

