/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.constraint.ConstraintSet;
import android.support.constraint.ConstraintsChangedListener;
import android.support.constraint.R;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.Xml;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateSet {
    public static final String TAG = "ConstraintLayoutStates";
    private static final boolean DEBUG = false;
    int mDefaultState = -1;
    ConstraintSet mDefaultConstraintSet;
    int mCurrentStateId = -1;
    int mCurrentConstraintNumber = -1;
    private SparseArray<State> mStateList = new SparseArray();
    private SparseArray<ConstraintSet> mConstraintSetMap = new SparseArray();
    private ConstraintsChangedListener mConstraintsChangedListener = null;

    public StateSet(Context context, XmlPullParser parser) {
        this.load(context, parser);
    }

    private void load(Context context, XmlPullParser parser) {
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StateSet);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr != R.styleable.StateSet_defaultState) continue;
            this.mDefaultState = a.getResourceId(attr, this.mDefaultState);
        }
        String tagName = null;
        try {
            String document = null;
            State state = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                block1 : switch (eventType) {
                    case 0: {
                        document = parser.getName();
                        break;
                    }
                    case 2: {
                        switch (tagName = parser.getName()) {
                            case "LayoutDescription": {
                                break;
                            }
                            case "StateSet": {
                                break;
                            }
                            case "State": {
                                state = new State(context, parser);
                                this.mStateList.put(state.mId, (Object)state);
                                break;
                            }
                            case "Variant": {
                                Variant match = new Variant(context, parser);
                                if (state == null) break block1;
                                state.add(match);
                                break;
                            }
                            default: {
                                Log.v((String)TAG, (String)("unknown tag " + tagName));
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if ("StateSet".equals(parser.getName())) {
                            return;
                        }
                        tagName = null;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean needsToChange(int id2, float width, float height) {
        State state;
        if (this.mCurrentStateId != id2) {
            return true;
        }
        State state2 = state = id2 == -1 ? (State)this.mStateList.valueAt(0) : (State)this.mStateList.get(this.mCurrentStateId);
        if (this.mCurrentConstraintNumber != -1 && state.mVariants.get(this.mCurrentConstraintNumber).match(width, height)) {
            return false;
        }
        return this.mCurrentConstraintNumber != state.findMatch(width, height);
    }

    public void setOnConstraintsChanged(ConstraintsChangedListener constraintsChangedListener) {
        this.mConstraintsChangedListener = constraintsChangedListener;
    }

    public int stateGetConstraintID(int id2, int width, int height) {
        return this.updateConstraints(-1, id2, width, height);
    }

    public int convertToConstraintSet(int currentConstrainSettId, int stateId, float width, float height) {
        State state = (State)this.mStateList.get(stateId);
        if (state == null) {
            return stateId;
        }
        if (width == -1.0f || height == -1.0f) {
            if (state.mConstraintID == currentConstrainSettId) {
                return currentConstrainSettId;
            }
            for (Variant mVariant : state.mVariants) {
                if (currentConstrainSettId != mVariant.mConstraintID) continue;
                return currentConstrainSettId;
            }
            return state.mConstraintID;
        }
        Variant match = null;
        for (Variant mVariant : state.mVariants) {
            if (!mVariant.match(width, height)) continue;
            if (currentConstrainSettId == mVariant.mConstraintID) {
                return currentConstrainSettId;
            }
            match = mVariant;
        }
        if (match != null) {
            return match.mConstraintID;
        }
        return state.mConstraintID;
    }

    public int updateConstraints(int currentid, int id2, float width, float height) {
        if (currentid == id2) {
            State state = id2 == -1 ? (State)this.mStateList.valueAt(0) : (State)this.mStateList.get(this.mCurrentStateId);
            if (state == null) {
                return -1;
            }
            if (this.mCurrentConstraintNumber != -1 && state.mVariants.get(currentid).match(width, height)) {
                return currentid;
            }
            int match = state.findMatch(width, height);
            if (currentid == match) {
                return currentid;
            }
            return match == -1 ? state.mConstraintID : state.mVariants.get((int)match).mConstraintID;
        }
        State state = (State)this.mStateList.get(id2);
        if (state == null) {
            return -1;
        }
        int match = state.findMatch(width, height);
        return match == -1 ? state.mConstraintID : state.mVariants.get((int)match).mConstraintID;
    }

    static class Variant {
        int mId;
        float mMinWidth = Float.NaN;
        float mMinHeight = Float.NaN;
        float mMaxWidth = Float.NaN;
        float mMaxHeight = Float.NaN;
        int mConstraintID = -1;
        boolean mIsLayout = false;

        public Variant(Context context, XmlPullParser parser) {
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Variant);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.Variant_constraints) {
                    this.mConstraintID = a.getResourceId(attr, this.mConstraintID);
                    String type = context.getResources().getResourceTypeName(this.mConstraintID);
                    String name = context.getResources().getResourceName(this.mConstraintID);
                    if (!"layout".equals(type)) continue;
                    this.mIsLayout = true;
                    continue;
                }
                if (attr == R.styleable.Variant_region_heightLessThan) {
                    this.mMaxHeight = a.getDimension(attr, this.mMaxHeight);
                    continue;
                }
                if (attr == R.styleable.Variant_region_heightMoreThan) {
                    this.mMinHeight = a.getDimension(attr, this.mMinHeight);
                    continue;
                }
                if (attr == R.styleable.Variant_region_widthLessThan) {
                    this.mMaxWidth = a.getDimension(attr, this.mMaxWidth);
                    continue;
                }
                if (attr == R.styleable.Variant_region_widthMoreThan) {
                    this.mMinWidth = a.getDimension(attr, this.mMinWidth);
                    continue;
                }
                Log.v((String)StateSet.TAG, (String)"Unknown tag");
            }
            a.recycle();
        }

        boolean match(float widthDp, float heightDp) {
            if (!Float.isNaN(this.mMinWidth) && widthDp < this.mMinWidth) {
                return false;
            }
            if (!Float.isNaN(this.mMinHeight) && heightDp < this.mMinHeight) {
                return false;
            }
            if (!Float.isNaN(this.mMaxWidth) && widthDp > this.mMaxWidth) {
                return false;
            }
            return Float.isNaN(this.mMaxHeight) || !(heightDp > this.mMaxHeight);
        }
    }

    static class State {
        int mId;
        ArrayList<Variant> mVariants = new ArrayList();
        int mConstraintID = -1;
        boolean mIsLayout = false;

        public State(Context context, XmlPullParser parser) {
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.State);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.State_android_id) {
                    this.mId = a.getResourceId(attr, this.mId);
                    continue;
                }
                if (attr != R.styleable.State_constraints) continue;
                this.mConstraintID = a.getResourceId(attr, this.mConstraintID);
                String type = context.getResources().getResourceTypeName(this.mConstraintID);
                String name = context.getResources().getResourceName(this.mConstraintID);
                if (!"layout".equals(type)) continue;
                this.mIsLayout = true;
            }
            a.recycle();
        }

        void add(Variant size) {
            this.mVariants.add(size);
        }

        public int findMatch(float width, float height) {
            for (int i = 0; i < this.mVariants.size(); ++i) {
                if (!this.mVariants.get(i).match(width, height)) continue;
                return i;
            }
            return -1;
        }
    }
}

