/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.constraint.ConstraintHelper;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.R;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;

public abstract class VirtualLayout
extends ConstraintHelper {
    private boolean mApplyVisibilityOnAttach;
    private boolean mApplyElevationOnAttach;

    public VirtualLayout(Context context) {
        super(context);
    }

    public VirtualLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VirtualLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.ConstraintLayout_Layout_android_visibility) {
                    this.mApplyVisibilityOnAttach = true;
                    continue;
                }
                if (attr != R.styleable.ConstraintLayout_Layout_android_elevation) continue;
                this.mApplyElevationOnAttach = true;
            }
        }
    }

    public void onMeasure(android.support.constraint.solver.widgets.VirtualLayout layout, int widthMeasureSpec, int heightMeasureSpec) {
    }

    @Override
    public void onAttachedToWindow() {
        ViewParent parent;
        super.onAttachedToWindow();
        if ((this.mApplyVisibilityOnAttach || this.mApplyElevationOnAttach) && (parent = this.getParent()) != null && parent instanceof ConstraintLayout) {
            ConstraintLayout container = (ConstraintLayout)parent;
            int visibility = this.getVisibility();
            float elevation = 0.0f;
            if (Build.VERSION.SDK_INT >= 21) {
                elevation = this.getElevation();
            }
            for (int i = 0; i < this.mCount; ++i) {
                int id2 = this.mIds[i];
                View view = container.getViewById(id2);
                if (view == null) continue;
                if (this.mApplyVisibilityOnAttach) {
                    view.setVisibility(visibility);
                }
                if (!this.mApplyElevationOnAttach || !(elevation > 0.0f) || Build.VERSION.SDK_INT < 21) continue;
                view.setTranslationZ(view.getTranslationZ() + elevation);
            }
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.applyLayoutFeatures();
    }

    public void setElevation(float elevation) {
        super.setElevation(elevation);
        this.applyLayoutFeatures();
    }
}

