/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.Barrier;
import android.support.constraint.ConstraintHelper;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.constraint.Constraints;
import android.support.constraint.R;
import android.support.constraint.motion.Debug;
import android.support.constraint.motion.DesignTool;
import android.support.constraint.motion.KeyCache;
import android.support.constraint.motion.MotionController;
import android.support.constraint.motion.MotionHelper;
import android.support.constraint.motion.MotionInterpolator;
import android.support.constraint.motion.MotionPaths;
import android.support.constraint.motion.MotionScene;
import android.support.constraint.motion.TouchResponse;
import android.support.constraint.motion.utils.StopLogic;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Flow;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.Helper;
import android.support.constraint.solver.widgets.HelperWidget;
import android.support.constraint.solver.widgets.VirtualLayout;
import android.support.v4.view.NestedScrollingParent2;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MotionLayout
extends ConstraintLayout
implements NestedScrollingParent2 {
    public static final int TOUCH_UP_COMPLETE = 0;
    public static final int TOUCH_UP_COMPLETE_TO_START = 1;
    public static final int TOUCH_UP_COMPLETE_TO_END = 2;
    public static final int TOUCH_UP_STOP = 3;
    public static final int TOUCH_UP_DECELERATE = 4;
    public static final int TOUCH_UP_DECELERATE_AND_COMPLETE = 5;
    static final String TAG = "MotionLayout";
    private static final boolean DEBUG = false;
    public static boolean IS_IN_EDIT_MODE;
    MotionScene mScene;
    Interpolator mInterpolator;
    float mLastVelocity = 0.0f;
    private int mBeginState = -1;
    int mCurrentState = -1;
    private int mEndState = -1;
    private int mLastWidthMeasureSpec = 0;
    private int mLastHeightMeasureSpec = 0;
    private boolean mInteractionEnabled = true;
    HashMap<View, MotionController> mFrameArrayList = new HashMap();
    private long mAnimationStartTime = 0L;
    private float mTransitionDuration = 1.0f;
    float mTransitionPosition = 0.0f;
    float mTransitionLastPosition = 0.0f;
    private long mTransitionLastTime;
    float mTransitionGoalPosition = 0.0f;
    private boolean mTransitionInstantly;
    boolean mInTransition = false;
    boolean mIndirectTransition = false;
    private TransitionListener mTransitionListener;
    private float lastPos;
    private float lastY;
    public static final int DEBUG_SHOW_NONE = 0;
    public static final int DEBUG_SHOW_PROGRESS = 1;
    public static final int DEBUG_SHOW_PATH = 2;
    int mDebugPath = 0;
    static final int MAX_KEY_FRAMES = 50;
    DevModeDraw mDevModeDraw;
    private boolean mTemporalInterpolator = false;
    private StopLogic mStopLogic = new StopLogic();
    private DecelerateInterpolator mDecelerateLogic = new DecelerateInterpolator();
    private DesignTool mDesignTool;
    boolean firstDown = true;
    int mOldWidth;
    int mOldHeight;
    int mLastLayoutWidth;
    int mLastLayoutHeight;
    boolean mUndergoingMotion = false;
    float mScrollTargetDX;
    float mScrollTargetDY;
    long mScrollTargetTime;
    float mScrollTargetDT;
    private boolean mKeepAnimating = false;
    private ArrayList<MotionHelper> mOnShowHelpers = null;
    private ArrayList<MotionHelper> mOnHideHelpers = null;
    private ArrayList<TransitionListener> mTransitionListeners = null;
    private int mFrames = 0;
    private long mLastDrawTime = -1L;
    private float mLastFps = 0.0f;
    private int mListenerState = 0;
    private float mListenerPosition = 0.0f;
    boolean mIsAnimating = false;
    public static final int VELOCITY_POST_LAYOUT = 0;
    public static final int VELOCITY_LAYOUT = 1;
    public static final int VELOCITY_STATIC_POST_LAYOUT = 2;
    public static final int VELOCITY_STATIC_LAYOUT = 3;
    protected boolean mMeasureDuringTransition = false;
    int mStartWrapWidth;
    int mStartWrapHeight;
    int mEndWrapWidth;
    int mEndWrapHeight;
    int mWidthMeasureMode;
    int mHeightMeasureMode;
    float mPostInterpolationPosition;
    private KeyCache mKeyCache = new KeyCache();
    private boolean mInLayout = false;
    private StateCache mStateCache;
    TransitionState mTransitionState = TransitionState.UNDEFINED;
    private static final float EPSILON = 1.0E-5f;
    Model mModel = new Model();
    private boolean mNeedsFireTransitionCompleted = false;
    private RectF mBoundsCheck = new RectF();
    private View mRegionView = null;
    ArrayList<Integer> mTransitionCompleted = new ArrayList();

    public MotionLayout(@NonNull Context context) {
        super(context);
        this.init(null);
    }

    public MotionLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MotionLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    protected long getNanoTime() {
        return System.nanoTime();
    }

    protected MotionTracker obtainVelocityTracker() {
        return MyTracker.obtain();
    }

    public void enableTransition(int transitionID, boolean enable) {
        MotionScene.Transition t = this.getTransition(transitionID);
        if (enable) {
            t.setEnable(true);
            return;
        }
        if (t == this.mScene.mCurrentTransition) {
            List<MotionScene.Transition> transitions = this.mScene.getTransitionsWithState(this.mCurrentState);
            for (MotionScene.Transition transition : transitions) {
                if (!transition.isEnabled()) continue;
                this.mScene.mCurrentTransition = transition;
                break;
            }
        }
        t.setEnable(false);
    }

    void setState(TransitionState newState) {
        if (newState == TransitionState.FINISHED && this.mCurrentState == -1) {
            return;
        }
        TransitionState oldState = this.mTransitionState;
        this.mTransitionState = newState;
        if (oldState == TransitionState.MOVING && newState == TransitionState.MOVING) {
            this.fireTransitionChange();
        }
        switch (oldState) {
            case UNDEFINED: 
            case SETUP: {
                if (newState == TransitionState.MOVING) {
                    this.fireTransitionChange();
                }
                if (newState != TransitionState.FINISHED) break;
                this.fireTransitionCompleted();
                break;
            }
            case MOVING: {
                if (newState != TransitionState.FINISHED) break;
                this.fireTransitionCompleted();
                break;
            }
        }
    }

    public void setTransition(int beginId, int endId) {
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setStartState(beginId);
            this.mStateCache.setEndState(endId);
            return;
        }
        if (this.mScene != null) {
            this.mBeginState = beginId;
            this.mEndState = endId;
            this.mScene.setTransition(beginId, endId);
            this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(beginId), this.mScene.getConstraintSet(endId));
            this.rebuildScene();
            this.mTransitionLastPosition = 0.0f;
            this.transitionToStart();
        }
    }

    public void setTransition(int transitionId) {
        if (this.mScene != null) {
            MotionScene.Transition transition = this.getTransition(transitionId);
            int current = this.mCurrentState;
            this.mBeginState = transition.getStartConstraintSetId();
            this.mEndState = transition.getEndConstraintSetId();
            if (!this.isAttachedToWindow()) {
                if (this.mStateCache == null) {
                    this.mStateCache = new StateCache();
                }
                this.mStateCache.setStartState(this.mBeginState);
                this.mStateCache.setEndState(this.mEndState);
                return;
            }
            float pos = Float.NaN;
            if (this.mCurrentState == this.mBeginState) {
                pos = 0.0f;
            } else if (this.mCurrentState == this.mEndState) {
                pos = 1.0f;
            }
            this.mScene.setTransition(transition);
            this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(this.mBeginState), this.mScene.getConstraintSet(this.mEndState));
            this.rebuildScene();
            float f = this.mTransitionLastPosition = Float.isNaN(pos) ? 0.0f : pos;
            if (Float.isNaN(pos)) {
                Log.v((String)TAG, (String)(Debug.getLocation() + " transitionToStart "));
                this.transitionToStart();
            } else {
                this.setProgress(pos);
            }
        }
    }

    protected void setTransition(MotionScene.Transition transition) {
        this.mScene.setTransition(transition);
        this.setState(TransitionState.SETUP);
        if (this.mCurrentState == this.mScene.getEndId()) {
            this.mTransitionLastPosition = 1.0f;
            this.mTransitionPosition = 1.0f;
            this.mTransitionGoalPosition = 1.0f;
        } else {
            this.mTransitionLastPosition = 0.0f;
            this.mTransitionPosition = 0.0f;
            this.mTransitionGoalPosition = 0.0f;
        }
        this.mTransitionLastTime = transition.isTransitionFlag(1) ? -1L : this.getNanoTime();
        int newBeginState = this.mScene.getStartId();
        int newEndState = this.mScene.getEndId();
        if (newBeginState == this.mBeginState && newEndState == this.mEndState) {
            return;
        }
        this.mBeginState = newBeginState;
        this.mEndState = newEndState;
        this.mScene.setTransition(this.mBeginState, this.mEndState);
        this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(this.mBeginState), this.mScene.getConstraintSet(this.mEndState));
        this.mModel.setMeasuredId(this.mBeginState, this.mEndState);
        this.mModel.reEvaluateState();
        this.rebuildScene();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadLayoutDescription(int motionScene) {
        if (motionScene != 0) {
            try {
                this.mScene = new MotionScene(this.getContext(), this, motionScene);
                if (Build.VERSION.SDK_INT >= 19 && !this.isAttachedToWindow()) return;
                this.mScene.readFallback(this);
                this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(this.mBeginState), this.mScene.getConstraintSet(this.mEndState));
                this.rebuildScene();
                this.mScene.setRtl(this.isRtl());
                return;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("unable to parse MotionScene file", ex);
            }
        } else {
            this.mScene = null;
        }
    }

    public boolean isAttachedToWindow() {
        if (Build.VERSION.SDK_INT >= 19) {
            return super.isAttachedToWindow();
        }
        return this.getWindowToken() != null;
    }

    @Override
    public void setState(int id2, int screenWidth, int screenHeight) {
        this.setState(TransitionState.SETUP);
        this.mCurrentState = id2;
        this.mBeginState = -1;
        this.mEndState = -1;
        if (this.mConstraintLayoutSpec != null) {
            this.mConstraintLayoutSpec.updateConstraints(id2, screenWidth, screenHeight);
        } else if (this.mScene != null) {
            this.mScene.getConstraintSet(id2).applyTo(this);
        }
    }

    public void setInterpolatedProgress(float pos) {
        if (this.mScene != null) {
            this.setState(TransitionState.MOVING);
            Interpolator interpolator = this.mScene.getInterpolator();
            if (interpolator != null) {
                this.setProgress(interpolator.getInterpolation(pos));
                return;
            }
        }
        this.setProgress(pos);
    }

    public void setProgress(float pos, float velocity) {
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setProgress(pos);
            this.mStateCache.setVelocity(velocity);
            return;
        }
        this.setProgress(pos);
        this.setState(TransitionState.MOVING);
        this.mLastVelocity = velocity;
        this.animateTo(1.0f);
    }

    public void setTransitionState(Bundle bundle) {
        if (this.mStateCache == null) {
            this.mStateCache = new StateCache();
        }
        this.mStateCache.setTransitionState(bundle);
        if (this.isAttachedToWindow()) {
            this.mStateCache.apply();
        }
    }

    public Bundle getTransitionState() {
        if (this.mStateCache == null) {
            this.mStateCache = new StateCache();
        }
        this.mStateCache.recordState();
        return this.mStateCache.getTransitionState();
    }

    public void setProgress(float pos) {
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setProgress(pos);
            return;
        }
        if (pos <= 0.0f) {
            this.mCurrentState = this.mBeginState;
            if (this.mTransitionLastPosition == 0.0f) {
                this.setState(TransitionState.FINISHED);
            }
        } else if (pos >= 1.0f) {
            this.mCurrentState = this.mEndState;
            if (this.mTransitionLastPosition == 1.0f) {
                this.setState(TransitionState.FINISHED);
            }
        } else {
            this.mCurrentState = -1;
            this.setState(TransitionState.MOVING);
        }
        if (this.mScene == null) {
            return;
        }
        this.mTransitionInstantly = true;
        this.mTransitionGoalPosition = pos;
        this.mTransitionPosition = pos;
        this.mTransitionLastTime = -1L;
        this.mAnimationStartTime = -1L;
        this.mInterpolator = null;
        this.mInTransition = true;
        this.invalidate();
    }

    private void setupMotionViews() {
        block10: {
            float mdist;
            float y;
            float x;
            MotionController f;
            int i;
            MotionController motionController;
            int i2;
            int n = this.getChildCount();
            this.mModel.build();
            this.mInTransition = true;
            int layoutWidth = this.getWidth();
            int layoutHeight = this.getHeight();
            int arc = this.mScene.gatPathMotionArc();
            if (arc != -1) {
                for (i2 = 0; i2 < n; ++i2) {
                    motionController = this.mFrameArrayList.get(this.getChildAt(i2));
                    if (motionController == null) continue;
                    motionController.setPathMotionArc(arc);
                }
            }
            for (i2 = 0; i2 < n; ++i2) {
                motionController = this.mFrameArrayList.get(this.getChildAt(i2));
                if (motionController == null) continue;
                this.mScene.getKeyFrames(motionController);
                motionController.setup(layoutWidth, layoutHeight, this.mTransitionDuration, this.getNanoTime());
            }
            float stagger = this.mScene.getStaggered();
            if (stagger == 0.0f) break block10;
            boolean flip = (double)stagger < 0.0;
            boolean useMotionStagger = false;
            stagger = Math.abs(stagger);
            float min = Float.MAX_VALUE;
            float max = -3.4028235E38f;
            for (i = 0; i < n; ++i) {
                f = this.mFrameArrayList.get(this.getChildAt(i));
                if (!Float.isNaN(f.mMotionStagger)) {
                    useMotionStagger = true;
                    break;
                }
                x = f.getFinalX();
                y = f.getFinalY();
                mdist = flip ? y - x : y + x;
                min = Math.min(min, mdist);
                max = Math.max(max, mdist);
            }
            if (useMotionStagger) {
                min = Float.MAX_VALUE;
                max = -3.4028235E38f;
                for (i = 0; i < n; ++i) {
                    f = this.mFrameArrayList.get(this.getChildAt(i));
                    if (Float.isNaN(f.mMotionStagger)) continue;
                    min = Math.min(min, f.mMotionStagger);
                    max = Math.max(max, f.mMotionStagger);
                }
                for (i = 0; i < n; ++i) {
                    f = this.mFrameArrayList.get(this.getChildAt(i));
                    if (Float.isNaN(f.mMotionStagger)) continue;
                    f.mStaggerScale = 1.0f / (1.0f - stagger);
                    f.mStaggerOffset = flip ? stagger - stagger * ((max - f.mMotionStagger) / (max - min)) : stagger - stagger * (f.mMotionStagger - min) / (max - min);
                }
            } else {
                for (i = 0; i < n; ++i) {
                    f = this.mFrameArrayList.get(this.getChildAt(i));
                    x = f.getFinalX();
                    y = f.getFinalY();
                    mdist = flip ? y - x : y + x;
                    f.mStaggerScale = 1.0f / (1.0f - stagger);
                    f.mStaggerOffset = stagger - stagger * (mdist - min) / (max - min);
                }
            }
        }
    }

    public void touchAnimateTo(int touchUpMode, float position, float currentVelocity) {
        if (this.mScene == null) {
            return;
        }
        if (this.mTransitionLastPosition == position) {
            return;
        }
        this.mTemporalInterpolator = true;
        this.mAnimationStartTime = this.getNanoTime();
        this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        this.mTransitionGoalPosition = position;
        this.mInTransition = true;
        switch (touchUpMode) {
            case 0: 
            case 1: 
            case 2: {
                if (touchUpMode == 1) {
                    position = 0.0f;
                } else if (touchUpMode == 2) {
                    position = 1.0f;
                }
                this.mStopLogic.config(this.mTransitionLastPosition, position, currentVelocity, this.mTransitionDuration, this.mScene.getMaxAcceleration(), this.mScene.getMaxVelocity());
                int currentState = this.mCurrentState;
                this.mTransitionGoalPosition = position;
                this.mCurrentState = currentState;
                this.mInterpolator = this.mStopLogic;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.mDecelerateLogic.config(currentVelocity, this.mTransitionLastPosition, this.mScene.getMaxAcceleration());
                this.mInterpolator = this.mDecelerateLogic;
                break;
            }
            case 5: {
                if (MotionLayout.willJump(currentVelocity, this.mTransitionLastPosition, this.mScene.getMaxAcceleration())) {
                    this.mDecelerateLogic.config(currentVelocity, this.mTransitionLastPosition, this.mScene.getMaxAcceleration());
                    this.mInterpolator = this.mDecelerateLogic;
                    break;
                }
                this.mStopLogic.config(this.mTransitionLastPosition, position, currentVelocity, this.mTransitionDuration, this.mScene.getMaxAcceleration(), this.mScene.getMaxVelocity());
                this.mLastVelocity = 0.0f;
                int currentState = this.mCurrentState;
                this.mTransitionGoalPosition = position;
                this.mCurrentState = currentState;
                this.mInterpolator = this.mStopLogic;
            }
        }
        this.mTransitionInstantly = false;
        this.mAnimationStartTime = this.getNanoTime();
        this.invalidate();
    }

    private static boolean willJump(float velocity, float position, float maxAcceleration) {
        if (velocity > 0.0f) {
            float time = velocity / maxAcceleration;
            float pos = velocity * time - maxAcceleration * time * time / 2.0f;
            return position + pos > 1.0f;
        }
        float time = -velocity / maxAcceleration;
        float pos = velocity * time + maxAcceleration * time * time / 2.0f;
        return position + pos < 0.0f;
    }

    void animateTo(float position) {
        if (this.mScene == null) {
            return;
        }
        if (this.mTransitionLastPosition != this.mTransitionPosition && this.mTransitionInstantly) {
            this.mTransitionLastPosition = this.mTransitionPosition;
        }
        if (this.mTransitionLastPosition == position) {
            return;
        }
        this.mTemporalInterpolator = false;
        float currentPosition = this.mTransitionLastPosition;
        this.mTransitionGoalPosition = position;
        this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        this.setProgress(this.mTransitionGoalPosition);
        this.mInterpolator = this.mScene.getInterpolator();
        this.mTransitionInstantly = false;
        this.mAnimationStartTime = this.getNanoTime();
        this.mInTransition = true;
        this.mTransitionPosition = currentPosition;
        this.mTransitionLastPosition = currentPosition;
        this.invalidate();
    }

    private void computeCurrentPositions() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getChildAt(i);
            MotionController frame = this.mFrameArrayList.get(v);
            if (frame == null) continue;
            frame.setStartCurrentState(v);
        }
    }

    public void transitionToStart() {
        this.animateTo(0.0f);
    }

    public void transitionToEnd() {
        this.animateTo(1.0f);
    }

    public void transitionToState(int id2) {
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setEndState(id2);
            return;
        }
        this.transitionToState(id2, -1, -1);
    }

    public void transitionToState(int id2, int screenWidth, int screenHeight) {
        int tmp_id;
        if (this.mScene != null && this.mScene.mStateSet != null && (tmp_id = this.mScene.mStateSet.convertToConstraintSet(this.mCurrentState, id2, screenWidth, screenHeight)) != -1) {
            id2 = tmp_id;
        }
        if (this.mCurrentState == id2) {
            return;
        }
        if (this.mBeginState == id2) {
            this.animateTo(0.0f);
            return;
        }
        if (this.mEndState == id2) {
            this.animateTo(1.0f);
            return;
        }
        this.mEndState = id2;
        if (this.mCurrentState != -1) {
            this.setTransition(this.mCurrentState, id2);
            this.animateTo(1.0f);
            this.mTransitionLastPosition = 0.0f;
            this.transitionToEnd();
            return;
        }
        this.mTemporalInterpolator = false;
        this.mTransitionGoalPosition = 1.0f;
        this.mTransitionPosition = 0.0f;
        this.mTransitionLastPosition = 0.0f;
        this.mTransitionLastTime = this.getNanoTime();
        this.mAnimationStartTime = this.getNanoTime();
        this.mTransitionInstantly = false;
        this.mInterpolator = null;
        this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        this.mBeginState = -1;
        this.mScene.setTransition(this.mBeginState, this.mEndState);
        int startId = this.mScene.getStartId();
        int targetID = id2;
        int n = this.getChildCount();
        this.mFrameArrayList.clear();
        for (int i = 0; i < n; ++i) {
            View v = this.getChildAt(i);
            MotionController f = new MotionController(v);
            this.mFrameArrayList.put(v, f);
        }
        this.mInTransition = true;
        this.mModel.initFrom(this.mLayoutWidget, null, this.mScene.getConstraintSet(id2));
        this.rebuildScene();
        this.mModel.build();
        this.computeCurrentPositions();
        int layoutWidth = this.getWidth();
        int layoutHeight = this.getHeight();
        for (int i = 0; i < n; ++i) {
            MotionController motionController = this.mFrameArrayList.get(this.getChildAt(i));
            this.mScene.getKeyFrames(motionController);
            motionController.setup(layoutWidth, layoutHeight, this.mTransitionDuration, this.getNanoTime());
        }
        float stagger = this.mScene.getStaggered();
        if (stagger != 0.0f) {
            float y;
            float x;
            MotionController f;
            int i;
            float min = Float.MAX_VALUE;
            float max = -3.4028235E38f;
            for (i = 0; i < n; ++i) {
                f = this.mFrameArrayList.get(this.getChildAt(i));
                x = f.getFinalX();
                y = f.getFinalY();
                min = Math.min(min, y + x);
                max = Math.max(max, y + x);
            }
            for (i = 0; i < n; ++i) {
                f = this.mFrameArrayList.get(this.getChildAt(i));
                x = f.getFinalX();
                y = f.getFinalY();
                f.mStaggerScale = 1.0f / (1.0f - stagger);
                f.mStaggerOffset = stagger - stagger * (x + y - min) / (max - min);
            }
        }
        this.mTransitionPosition = 0.0f;
        this.mTransitionLastPosition = 0.0f;
        this.mInTransition = true;
        this.invalidate();
    }

    public float getVelocity() {
        return this.mLastVelocity;
    }

    public void getViewVelocity(View view, float posOnViewX, float posOnViewY, float[] returnVelocity, int type) {
        float v = this.mLastVelocity;
        float position = this.mTransitionLastPosition;
        if (this.mInterpolator != null) {
            float deltaT = 1.0E-5f;
            float dir = Math.signum(this.mTransitionGoalPosition - this.mTransitionLastPosition);
            float interpos = this.mInterpolator.getInterpolation(this.mTransitionLastPosition + deltaT);
            position = this.mInterpolator.getInterpolation(this.mTransitionLastPosition);
            interpos -= position;
            v = dir * (interpos /= deltaT) / this.mTransitionDuration;
        }
        if (this.mInterpolator instanceof MotionInterpolator) {
            v = ((MotionInterpolator)this.mInterpolator).getVelocity();
        }
        MotionController f = this.mFrameArrayList.get(view);
        if ((type & 1) == 0) {
            f.getPostLayoutDvDp(position, view.getWidth(), view.getHeight(), posOnViewX, posOnViewY, returnVelocity);
        } else {
            f.getDpDt(position, posOnViewX, posOnViewY, returnVelocity);
        }
        if (type < 2) {
            returnVelocity[0] = returnVelocity[0] * v;
            returnVelocity[1] = returnVelocity[1] * v;
        }
    }

    @Override
    public void requestLayout() {
        if (!this.mMeasureDuringTransition && this.mCurrentState == -1 && this.mScene != null && this.mScene.mCurrentTransition != null && this.mScene.mCurrentTransition.getLayoutDuringTransition() == 0) {
            return;
        }
        super.requestLayout();
    }

    public String toString() {
        Context context = this.getContext();
        return Debug.getName(context, this.mBeginState) + "->" + Debug.getName(context, this.mEndState) + " (pos:" + this.mTransitionLastPosition + " Dpos/Dt:" + this.mLastVelocity;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean recalc;
        if (this.mScene == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        boolean bl = recalc = this.mLastWidthMeasureSpec != widthMeasureSpec || this.mLastHeightMeasureSpec != heightMeasureSpec;
        if (this.mNeedsFireTransitionCompleted) {
            this.mNeedsFireTransitionCompleted = false;
            this.onNewStateAttachHandlers();
            this.processTransitionCompleted();
            recalc = true;
        }
        if (this.mDirtyHierarchy) {
            recalc = true;
        }
        this.mLastWidthMeasureSpec = widthMeasureSpec;
        this.mLastHeightMeasureSpec = heightMeasureSpec;
        int startId = this.mScene.getStartId();
        int endId = this.mScene.getEndId();
        boolean setMeasure = true;
        if ((recalc || this.mModel.isNotConfiguredWith(startId, endId)) && this.mBeginState != -1) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(startId), this.mScene.getConstraintSet(endId));
            this.mModel.reEvaluateState();
            this.mModel.setMeasuredId(startId, endId);
            setMeasure = false;
        }
        if (this.mMeasureDuringTransition || setMeasure) {
            int heightPadding = this.getPaddingTop() + this.getPaddingBottom();
            int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
            int androidLayoutWidth = this.mLayoutWidget.getWidth() + widthPadding;
            int androidLayoutHeight = this.mLayoutWidget.getHeight() + heightPadding;
            if (this.mWidthMeasureMode == Integer.MIN_VALUE || this.mWidthMeasureMode == 0) {
                androidLayoutWidth = (int)((float)this.mStartWrapWidth + this.mPostInterpolationPosition * (float)(this.mEndWrapWidth - this.mStartWrapWidth));
                this.requestLayout();
            }
            if (this.mHeightMeasureMode == Integer.MIN_VALUE || this.mHeightMeasureMode == 0) {
                androidLayoutHeight = (int)((float)this.mStartWrapHeight + this.mPostInterpolationPosition * (float)(this.mEndWrapHeight - this.mStartWrapHeight));
                this.requestLayout();
            }
            this.setMeasuredDimension(androidLayoutWidth, androidLayoutHeight);
        }
        this.evaluateLayout();
    }

    public boolean onStartNestedScroll(View child, View target, int axes, int type) {
        return this.mScene != null && this.mScene.mCurrentTransition != null && this.mScene.mCurrentTransition.getTouchResponse() != null && (this.mScene.mCurrentTransition.getTouchResponse().getFlags() & 2) == 0;
    }

    public void onNestedScrollAccepted(View child, View target, int axes, int type) {
    }

    public void onStopNestedScroll(View target, int type) {
        if (this.mScene == null) {
            return;
        }
        this.mScene.processScrollUp(this.mScrollTargetDX / this.mScrollTargetDT, this.mScrollTargetDY / this.mScrollTargetDT);
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
    }

    public void onNestedPreScroll(final View target, int dx, int dy, int[] consumed, int type) {
        int regionId;
        TouchResponse touchResponse;
        if (this.mScene == null || this.mScene.mCurrentTransition == null) {
            return;
        }
        if (!this.mScene.mCurrentTransition.isEnabled()) {
            return;
        }
        MotionScene.Transition currentTransition = this.mScene.mCurrentTransition;
        if (currentTransition != null && currentTransition.isEnabled() && (touchResponse = currentTransition.getTouchResponse()) != null && (regionId = touchResponse.getTouchRegionId()) != -1 && target.getId() != regionId) {
            return;
        }
        if (this.mScene != null && this.mScene.getMoveWhenScrollAtTop() && (this.mTransitionPosition == 1.0f || this.mTransitionPosition == 0.0f) && target.canScrollVertically(-1)) {
            return;
        }
        if (currentTransition.getTouchResponse() != null && (this.mScene.mCurrentTransition.getTouchResponse().getFlags() & 1) != 0) {
            float dir = this.mScene.getProgressDirection(dx, dy);
            if (this.mTransitionLastPosition <= 0.0f && dir < 0.0f || this.mTransitionLastPosition >= 1.0f && dir > 0.0f) {
                if (Build.VERSION.SDK_INT >= 21) {
                    target.setNestedScrollingEnabled(false);
                    target.post(new Runnable(){

                        @Override
                        public void run() {
                            target.setNestedScrollingEnabled(true);
                        }
                    });
                }
                return;
            }
        }
        float progress = this.mTransitionPosition;
        long time = this.getNanoTime();
        this.mScrollTargetDX = dx;
        this.mScrollTargetDY = dy;
        this.mScrollTargetDT = (float)((double)(time - this.mScrollTargetTime) * 1.0E-9);
        this.mScrollTargetTime = time;
        this.mScene.processScrollMove(dx, dy);
        if (progress != this.mTransitionPosition) {
            consumed[0] = dx;
            consumed[1] = dy;
        }
        this.evaluate(false);
        if (consumed[0] != 0 || consumed[1] != 0) {
            this.mUndergoingMotion = true;
        }
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    private void debugPos() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            Log.v((String)TAG, (String)(" " + Debug.getLocation() + " " + Debug.getName((View)this) + " " + Debug.getName(this.getContext(), this.mCurrentState) + " " + Debug.getName(child) + child.getLeft() + " " + child.getTop()));
        }
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        this.evaluate(false);
        super.dispatchDraw(canvas);
        if (this.mScene == null) {
            return;
        }
        if ((this.mDebugPath & 1) == 1 && !this.isInEditMode()) {
            ++this.mFrames;
            long currentDrawTime = this.getNanoTime();
            if (this.mLastDrawTime != -1L) {
                long delay = currentDrawTime - this.mLastDrawTime;
                if (delay > 200000000L) {
                    float fps = (float)this.mFrames / ((float)delay * 1.0E-9f);
                    this.mLastFps = (float)((int)(fps * 100.0f)) / 100.0f;
                    this.mFrames = 0;
                    this.mLastDrawTime = currentDrawTime;
                }
            } else {
                this.mLastDrawTime = currentDrawTime;
            }
            Paint paint = new Paint();
            paint.setTextSize(42.0f);
            float p = (float)((int)(this.getProgress() * 1000.0f)) / 10.0f;
            String str = this.mLastFps + " fps " + Debug.getState(this, this.mBeginState) + " -> ";
            str = str + Debug.getState(this, this.mEndState) + " (progress: " + p + " ) state=" + (this.mCurrentState == -1 ? "undefined" : Debug.getState(this, this.mCurrentState));
            paint.setColor(-16777216);
            canvas.drawText(str, 11.0f, (float)(this.getHeight() - 29), paint);
            paint.setColor(-7864184);
            canvas.drawText(str, 10.0f, (float)(this.getHeight() - 30), paint);
        }
        if (this.mDebugPath > 1) {
            if (this.mDevModeDraw == null) {
                this.mDevModeDraw = new DevModeDraw();
            }
            this.mDevModeDraw.draw(canvas, this.mFrameArrayList, this.mScene.getDuration(), this.mDebugPath);
        }
    }

    private void evaluateLayout() {
        float dir = Math.signum(this.mTransitionGoalPosition - this.mTransitionLastPosition);
        long currentTime = this.getNanoTime();
        float deltaPos = 0.0f;
        if (!(this.mInterpolator instanceof StopLogic)) {
            deltaPos = dir * (float)(currentTime - this.mTransitionLastTime) * 1.0E-9f / this.mTransitionDuration;
        }
        float position = this.mTransitionLastPosition + deltaPos;
        boolean done = false;
        if (this.mTransitionInstantly) {
            position = this.mTransitionGoalPosition;
        }
        if (dir > 0.0f && position >= this.mTransitionGoalPosition || dir <= 0.0f && position <= this.mTransitionGoalPosition) {
            position = this.mTransitionGoalPosition;
            done = true;
        }
        if (this.mInterpolator != null && !done) {
            if (this.mTemporalInterpolator) {
                float time = (float)(currentTime - this.mAnimationStartTime) * 1.0E-9f;
                position = this.mInterpolator.getInterpolation(time);
            } else {
                position = this.mInterpolator.getInterpolation(position);
            }
        }
        if (dir > 0.0f && position >= this.mTransitionGoalPosition || dir <= 0.0f && position <= this.mTransitionGoalPosition) {
            position = this.mTransitionGoalPosition;
        }
        this.mPostInterpolationPosition = position;
        int n = this.getChildCount();
        long time = this.getNanoTime();
        for (int i = 0; i < n; ++i) {
            View child = this.getChildAt(i);
            MotionController frame = this.mFrameArrayList.get(child);
            if (frame == null) continue;
            frame.interpolate(child, position, time, this.mKeyCache);
        }
        if (this.mMeasureDuringTransition) {
            this.requestLayout();
        }
    }

    void evaluate(boolean force) {
        if (this.mTransitionLastTime == -1L) {
            this.mTransitionLastTime = this.getNanoTime();
        }
        if (this.mTransitionLastPosition > 0.0f && this.mTransitionLastPosition < 1.0f) {
            this.mCurrentState = -1;
        }
        boolean newState = false;
        if (this.mKeepAnimating || this.mInTransition && (force || this.mTransitionGoalPosition != this.mTransitionLastPosition)) {
            ConstraintSet set;
            boolean end;
            float dir = Math.signum(this.mTransitionGoalPosition - this.mTransitionLastPosition);
            long currentTime = this.getNanoTime();
            float deltaPos = 0.0f;
            if (!(this.mInterpolator instanceof MotionInterpolator)) {
                this.mLastVelocity = deltaPos = dir * (float)(currentTime - this.mTransitionLastTime) * 1.0E-9f / this.mTransitionDuration;
            }
            float position = this.mTransitionLastPosition + deltaPos;
            boolean done = false;
            if (this.mTransitionInstantly) {
                position = this.mTransitionGoalPosition;
            }
            if (dir > 0.0f && position >= this.mTransitionGoalPosition || dir <= 0.0f && position <= this.mTransitionGoalPosition) {
                position = this.mTransitionGoalPosition;
                this.mInTransition = false;
                done = true;
            }
            this.mTransitionLastPosition = position;
            this.mTransitionPosition = position;
            this.mTransitionLastTime = currentTime;
            if (this.mInterpolator != null && !done) {
                if (this.mTemporalInterpolator) {
                    float time = (float)(currentTime - this.mAnimationStartTime) * 1.0E-9f;
                    this.mTransitionLastPosition = position = this.mInterpolator.getInterpolation(time);
                    this.mTransitionLastTime = currentTime;
                    if (this.mInterpolator instanceof MotionInterpolator) {
                        float lastVelocity;
                        this.mLastVelocity = lastVelocity = ((MotionInterpolator)this.mInterpolator).getVelocity();
                        if (Math.abs(lastVelocity) * this.mTransitionDuration <= 1.0E-5f) {
                            this.mInTransition = false;
                        }
                        if (lastVelocity > 0.0f && position >= 1.0f) {
                            position = 1.0f;
                            this.mTransitionLastPosition = 1.0f;
                            this.mInTransition = false;
                        }
                        if (lastVelocity < 0.0f && position <= 0.0f) {
                            position = 0.0f;
                            this.mTransitionLastPosition = 0.0f;
                            this.mInTransition = false;
                        }
                    }
                } else {
                    float p2 = position;
                    position = this.mInterpolator.getInterpolation(position);
                    if (this.mInterpolator instanceof MotionInterpolator) {
                        this.mLastVelocity = ((MotionInterpolator)this.mInterpolator).getVelocity();
                    } else {
                        p2 = this.mInterpolator.getInterpolation(p2 + deltaPos);
                        this.mLastVelocity = dir * (p2 - position) / deltaPos;
                    }
                }
            }
            if (Math.abs(this.mLastVelocity) > 1.0E-5f) {
                this.setState(TransitionState.MOVING);
            }
            if (dir > 0.0f && position >= this.mTransitionGoalPosition || dir <= 0.0f && position <= this.mTransitionGoalPosition) {
                position = this.mTransitionGoalPosition;
                this.mInTransition = false;
            }
            if (position >= 1.0f || position <= 0.0f) {
                this.mInTransition = false;
                this.setState(TransitionState.FINISHED);
            }
            int n = this.getChildCount();
            this.mKeepAnimating = false;
            long time = this.getNanoTime();
            this.mPostInterpolationPosition = position;
            for (int i = 0; i < n; ++i) {
                View child = this.getChildAt(i);
                MotionController frame = this.mFrameArrayList.get(child);
                if (frame == null) continue;
                this.mKeepAnimating |= frame.interpolate(child, position, time, this.mKeyCache);
            }
            boolean bl = end = dir > 0.0f && position >= this.mTransitionGoalPosition || dir <= 0.0f && position <= this.mTransitionGoalPosition;
            if (!this.mKeepAnimating && !this.mInTransition && end) {
                this.setState(TransitionState.FINISHED);
            }
            if (this.mMeasureDuringTransition) {
                this.requestLayout();
            }
            this.mKeepAnimating |= !end;
            if (position <= 0.0f && this.mBeginState != -1 && this.mCurrentState != this.mBeginState) {
                newState = true;
                this.mCurrentState = this.mBeginState;
                set = this.mScene.getConstraintSet(this.mBeginState);
                set.applyCustomAttributes(this);
                this.setState(TransitionState.FINISHED);
            }
            if ((double)position >= 1.0 && this.mCurrentState != this.mEndState) {
                newState = true;
                this.mCurrentState = this.mEndState;
                set = this.mScene.getConstraintSet(this.mEndState);
                set.applyCustomAttributes(this);
                this.setState(TransitionState.FINISHED);
            }
            if (this.mKeepAnimating || this.mInTransition) {
                this.invalidate();
            } else if (dir > 0.0f && position == 1.0f || dir < 0.0f && position == 0.0f) {
                this.setState(TransitionState.FINISHED);
            }
            if (!this.mKeepAnimating && this.mInTransition && dir > 0.0f && position == 1.0f || dir < 0.0f && position == 0.0f) {
                this.onNewStateAttachHandlers();
            }
        }
        if (this.mTransitionLastPosition >= 1.0f) {
            if (this.mCurrentState != this.mEndState) {
                newState = true;
            }
            this.mCurrentState = this.mEndState;
        } else if (this.mTransitionLastPosition <= 0.0f) {
            if (this.mCurrentState != this.mBeginState) {
                newState = true;
            }
            this.mCurrentState = this.mBeginState;
        }
        this.mNeedsFireTransitionCompleted |= newState;
        if (newState && !this.mInLayout) {
            this.requestLayout();
        }
        this.mTransitionPosition = this.mTransitionLastPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mInLayout = true;
        try {
            if (this.mScene == null) {
                super.onLayout(changed, left, top, right, bottom);
                return;
            }
            int w = right - left;
            int h = bottom - top;
            if (this.mLastLayoutWidth != w || this.mLastLayoutHeight != h) {
                this.rebuildScene();
                this.evaluate(true);
            }
            this.mLastLayoutWidth = w;
            this.mLastLayoutHeight = h;
            this.mOldWidth = w;
            this.mOldHeight = h;
        }
        finally {
            this.mInLayout = false;
        }
    }

    @Override
    protected void parseLayoutDescription(int id2) {
        this.mConstraintLayoutSpec = null;
    }

    private void init(AttributeSet attrs) {
        IS_IN_EDIT_MODE = this.isInEditMode();
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MotionLayout);
            int N = a.getIndexCount();
            boolean apply = true;
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.MotionLayout_layoutDescription) {
                    int n = a.getResourceId(attr, -1);
                    this.mScene = new MotionScene(this.getContext(), this, n);
                    continue;
                }
                if (attr == R.styleable.MotionLayout_currentState) {
                    this.mCurrentState = a.getResourceId(attr, -1);
                    continue;
                }
                if (attr == R.styleable.MotionLayout_motionProgress) {
                    this.mTransitionGoalPosition = a.getFloat(attr, 0.0f);
                    this.mInTransition = true;
                    continue;
                }
                if (attr == R.styleable.MotionLayout_applyMotionScene) {
                    apply = a.getBoolean(attr, apply);
                    continue;
                }
                if (attr == R.styleable.MotionLayout_showPaths) {
                    if (this.mDebugPath != 0) continue;
                    this.mDebugPath = a.getBoolean(attr, false) ? 2 : 0;
                    continue;
                }
                if (attr != R.styleable.MotionLayout_motionDebug) continue;
                this.mDebugPath = a.getInt(attr, 0);
            }
            a.recycle();
            if (this.mScene == null) {
                Log.e((String)TAG, (String)"WARNING NO app:layoutDescription tag");
            }
            if (!apply) {
                this.mScene = null;
            }
        }
        if (this.mDebugPath != 0) {
            this.checkStructure();
        }
        if (this.mCurrentState == -1 && this.mScene != null) {
            this.mCurrentState = this.mScene.getStartId();
            this.mBeginState = this.mScene.getStartId();
            this.mEndState = this.mScene.getEndId();
        }
    }

    public void setScene(MotionScene scene) {
        this.mScene = scene;
        this.mScene.setRtl(this.isRtl());
        this.rebuildScene();
    }

    private void checkStructure() {
        if (this.mScene == null) {
            Log.e((String)TAG, (String)"CHECK: motion scene not set! set \"app:layoutDescription=\"@xml/file\"");
            return;
        }
        this.checkStructure(this.mScene.getStartId(), this.mScene.getConstraintSet(this.mScene.getStartId()));
        SparseIntArray startToEnd = new SparseIntArray();
        SparseIntArray endToStart = new SparseIntArray();
        for (MotionScene.Transition definedTransition : this.mScene.getDefinedTransitions()) {
            if (definedTransition == this.mScene.mCurrentTransition) {
                Log.v((String)TAG, (String)"CHECK: CURRENT");
            }
            this.checkStructure(definedTransition);
            int startId = definedTransition.getStartConstraintSetId();
            int endId = definedTransition.getEndConstraintSetId();
            String startString = Debug.getName(this.getContext(), startId);
            String endString = Debug.getName(this.getContext(), endId);
            if (startToEnd.get(startId) == endId) {
                Log.e((String)TAG, (String)("CHECK: two transitions with the same start and end " + startString + "->" + endString));
            }
            if (endToStart.get(endId) == startId) {
                Log.e((String)TAG, (String)("CHECK: you can't have reverse transitions" + startString + "->" + endString));
            }
            startToEnd.put(startId, endId);
            endToStart.put(endId, startId);
            if (this.mScene.getConstraintSet(startId) == null) {
                Log.e((String)TAG, (String)(" no such constraintSetStart " + startString));
            }
            if (this.mScene.getConstraintSet(endId) != null) continue;
            Log.e((String)TAG, (String)(" no such constraintSetEnd " + startString));
        }
    }

    private void checkStructure(int csetId, ConstraintSet set) {
        int id2;
        String setName = Debug.getName(this.getContext(), csetId);
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            ConstraintSet.Constraint c;
            View v = this.getChildAt(i);
            id2 = v.getId();
            if (id2 == -1) {
                Log.w((String)TAG, (String)("CHECK: " + setName + " ALL VIEWS SHOULD HAVE ID's " + v.getClass().getName() + " does not!"));
            }
            if ((c = set.getConstraint(id2)) != null) continue;
            Log.w((String)TAG, (String)("CHECK: " + setName + " NO CONSTRAINTS for " + Debug.getName(v)));
        }
        int[] ids = set.getKnownIds();
        for (int i = 0; i < ids.length; ++i) {
            id2 = ids[i];
            String idString = Debug.getName(this.getContext(), id2);
            if (null == this.findViewById(ids[i])) {
                Log.w((String)TAG, (String)("CHECK: " + setName + " NO View matches id " + idString));
            }
            if (set.getHeight(id2) == -1) {
                Log.w((String)TAG, (String)("CHECK: " + setName + "(" + idString + ") no LAYOUT_HEIGHT"));
            }
            if (set.getWidth(id2) != -1) continue;
            Log.w((String)TAG, (String)("CHECK: " + setName + "(" + idString + ") no LAYOUT_HEIGHT"));
        }
    }

    private void checkStructure(MotionScene.Transition transition) {
        Log.v((String)TAG, (String)("CHECK: transition = " + transition.debugString(this.getContext())));
        Log.v((String)TAG, (String)("CHECK: transition.setDuration = " + transition.getDuration()));
        if (transition.getStartConstraintSetId() == transition.getEndConstraintSetId()) {
            Log.e((String)TAG, (String)"CHECK: start and end constraint set should not be the same!");
        }
    }

    public void setDebugMode(int debugMode) {
        this.mDebugPath = debugMode;
        this.invalidate();
    }

    public void getDebugMode(boolean showPaths) {
        this.mDebugPath = showPaths ? 2 : 1;
        this.invalidate();
    }

    private boolean handlesTouchEvent(float x, float y, View view, MotionEvent event) {
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = group.getChildAt(i);
                if (!this.handlesTouchEvent(x + (float)view.getLeft(), y + (float)view.getTop(), child, event)) continue;
                return true;
            }
        }
        this.mBoundsCheck.set(x + (float)view.getLeft(), y + (float)view.getTop(), x + (float)view.getRight(), y + (float)view.getBottom());
        return event.getAction() == 0 ? this.mBoundsCheck.contains(event.getX(), event.getY()) && view.onTouchEvent(event) : view.onTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        TouchResponse touchResponse;
        if (this.mScene == null || !this.mInteractionEnabled) {
            return false;
        }
        MotionScene.Transition currentTransition = this.mScene.mCurrentTransition;
        if (currentTransition != null && currentTransition.isEnabled() && (touchResponse = currentTransition.getTouchResponse()) != null) {
            RectF region;
            if (event.getAction() == 0 && (region = touchResponse.getTouchRegion(this, new RectF())) != null && !region.contains(event.getX(), event.getY())) {
                return false;
            }
            int regionId = touchResponse.getTouchRegionId();
            if (regionId != -1) {
                if (this.mRegionView == null || this.mRegionView.getId() != regionId) {
                    this.mRegionView = this.findViewById(regionId);
                }
                if (this.mRegionView != null) {
                    this.mBoundsCheck.set((float)this.mRegionView.getLeft(), (float)this.mRegionView.getTop(), (float)this.mRegionView.getRight(), (float)this.mRegionView.getBottom());
                    if (this.mBoundsCheck.contains(event.getX(), event.getY()) && !this.handlesTouchEvent(0.0f, 0.0f, this.mRegionView, event)) {
                        return this.onTouchEvent(event);
                    }
                }
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mScene != null && this.mInteractionEnabled && this.mScene.supportTouch()) {
            MotionScene.Transition currentTransition = this.mScene.mCurrentTransition;
            if (currentTransition != null && !currentTransition.isEnabled()) {
                return super.onTouchEvent(event);
            }
            this.mScene.processTouchEvent(event, this.getCurrentState(), this);
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mScene != null && this.mCurrentState != -1) {
            ConstraintSet cSet = this.mScene.getConstraintSet(this.mCurrentState);
            this.mScene.readFallback(this);
            if (cSet != null) {
                cSet.applyTo(this);
            }
            this.mBeginState = this.mCurrentState;
        }
        this.onNewStateAttachHandlers();
        if (this.mStateCache != null) {
            this.mStateCache.apply();
        }
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        if (this.mScene != null) {
            this.mScene.setRtl(this.isRtl());
        }
    }

    private void onNewStateAttachHandlers() {
        if (this.mScene == null) {
            return;
        }
        if (this.mScene.autoTransition(this, this.mCurrentState)) {
            this.requestLayout();
            return;
        }
        if (this.mCurrentState != -1) {
            this.mScene.addOnClickListeners(this, this.mCurrentState);
        }
        if (this.mScene.supportTouch()) {
            this.mScene.setupTouch();
        }
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public float getProgress() {
        return this.mTransitionLastPosition;
    }

    void getAnchorDpDt(int mTouchAnchorId, float pos, float locationX, float locationY, float[] mAnchorDpDt) {
        View v = this.getViewById(mTouchAnchorId);
        MotionController f = this.mFrameArrayList.get(v);
        if (f != null) {
            f.getDpDt(pos, locationX, locationY, mAnchorDpDt);
            float y = v.getY();
            float deltaPos = pos - this.lastPos;
            float deltaY = y - this.lastY;
            float dydp = deltaPos != 0.0f ? deltaY / deltaPos : Float.NaN;
            this.lastPos = pos;
            this.lastY = y;
        } else {
            String idName = v == null ? "" + mTouchAnchorId : v.getContext().getResources().getResourceName(mTouchAnchorId);
            Log.w((String)TAG, (String)("WARNING could not find view id " + idName));
        }
    }

    public long getTransitionTimeMs() {
        if (this.mScene != null) {
            this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        }
        return (long)(this.mTransitionDuration * 1000.0f);
    }

    public void setTransitionListener(TransitionListener listener) {
        this.mTransitionListener = listener;
    }

    public void addTransitionListener(TransitionListener listener) {
        if (this.mTransitionListeners == null) {
            this.mTransitionListeners = new ArrayList();
        }
        this.mTransitionListeners.add(listener);
    }

    public boolean removeTransitionListener(TransitionListener listener) {
        if (this.mTransitionListeners == null) {
            return false;
        }
        return this.mTransitionListeners.remove(listener);
    }

    public void fireTrigger(int triggerId, boolean positive, float progress) {
        if (this.mTransitionListener != null) {
            this.mTransitionListener.onTransitionTrigger(this, triggerId, positive, progress);
        }
        if (this.mTransitionListeners != null) {
            for (TransitionListener listeners : this.mTransitionListeners) {
                listeners.onTransitionTrigger(this, triggerId, positive, progress);
            }
        }
    }

    private void fireTransitionChange() {
        if ((this.mTransitionListener != null || this.mTransitionListeners != null && !this.mTransitionListeners.isEmpty()) && this.mListenerPosition != this.mTransitionPosition) {
            if (this.mListenerState != -1) {
                if (this.mTransitionListener != null) {
                    this.mTransitionListener.onTransitionStarted(this, this.mBeginState, this.mEndState);
                }
                if (this.mTransitionListeners != null) {
                    for (TransitionListener listeners : this.mTransitionListeners) {
                        listeners.onTransitionStarted(this, this.mBeginState, this.mEndState);
                    }
                }
                this.mIsAnimating = true;
            }
            this.mListenerState = -1;
            this.mListenerPosition = this.mTransitionPosition;
            if (this.mTransitionListener != null) {
                this.mTransitionListener.onTransitionChange(this, this.mBeginState, this.mEndState, this.mTransitionPosition);
            }
            if (this.mTransitionListeners != null) {
                for (TransitionListener listeners : this.mTransitionListeners) {
                    listeners.onTransitionChange(this, this.mBeginState, this.mEndState, this.mTransitionPosition);
                }
            }
            this.mIsAnimating = true;
        }
    }

    protected void fireTransitionCompleted() {
        if ((this.mTransitionListener != null || this.mTransitionListeners != null && !this.mTransitionListeners.isEmpty()) && this.mListenerState == -1) {
            this.mListenerState = this.mCurrentState;
            int lastState = -1;
            if (!this.mTransitionCompleted.isEmpty()) {
                lastState = this.mTransitionCompleted.get(this.mTransitionCompleted.size() - 1);
            }
            if (lastState != this.mCurrentState && this.mCurrentState != -1) {
                this.mTransitionCompleted.add(this.mCurrentState);
            }
        }
        this.processTransitionCompleted();
    }

    private void processTransitionCompleted() {
        if (this.mTransitionListener == null && (this.mTransitionListeners == null || this.mTransitionListeners.isEmpty())) {
            return;
        }
        this.mIsAnimating = false;
        for (Integer state : this.mTransitionCompleted) {
            if (this.mTransitionListener != null) {
                this.mTransitionListener.onTransitionCompleted(this, state);
            }
            if (this.mTransitionListeners == null) continue;
            for (TransitionListener listeners : this.mTransitionListeners) {
                listeners.onTransitionCompleted(this, state);
            }
        }
        this.mTransitionCompleted.clear();
    }

    public DesignTool getDesignTool() {
        if (this.mDesignTool == null) {
            this.mDesignTool = new DesignTool(this);
        }
        return this.mDesignTool;
    }

    @Override
    public void onViewAdded(View view) {
        super.onViewAdded(view);
        if (view instanceof MotionHelper) {
            MotionHelper helper = (MotionHelper)view;
            if (this.mTransitionListeners == null) {
                this.mTransitionListeners = new ArrayList();
            }
            this.mTransitionListeners.add(helper);
            if (helper.isUsedOnShow()) {
                if (this.mOnShowHelpers == null) {
                    this.mOnShowHelpers = new ArrayList();
                }
                this.mOnShowHelpers.add(helper);
            }
            if (helper.isUseOnHide()) {
                if (this.mOnHideHelpers == null) {
                    this.mOnHideHelpers = new ArrayList();
                }
                this.mOnHideHelpers.add(helper);
            }
        }
    }

    @Override
    public void onViewRemoved(View view) {
        super.onViewRemoved(view);
        if (this.mOnShowHelpers != null) {
            this.mOnShowHelpers.remove(view);
        }
        if (this.mOnHideHelpers != null) {
            this.mOnHideHelpers.remove(view);
        }
    }

    public void setOnShow(float progress) {
        if (this.mOnShowHelpers != null) {
            int count = this.mOnShowHelpers.size();
            for (int i = 0; i < count; ++i) {
                MotionHelper helper = this.mOnShowHelpers.get(i);
                helper.setProgress(progress);
            }
        }
    }

    public void setOnHide(float progress) {
        if (this.mOnHideHelpers != null) {
            int count = this.mOnHideHelpers.size();
            for (int i = 0; i < count; ++i) {
                MotionHelper helper = this.mOnHideHelpers.get(i);
                helper.setProgress(progress);
            }
        }
    }

    public int[] getConstraintSetIds() {
        if (this.mScene == null) {
            return null;
        }
        return this.mScene.getConstraintSetIds();
    }

    public ConstraintSet getConstraintSet(int id2) {
        if (this.mScene == null) {
            return null;
        }
        return this.mScene.getConstraintSet(id2);
    }

    @Deprecated
    public void rebuildMotion() {
        Log.e((String)TAG, (String)"This method is deprecated. Please call rebuildScene() instead.");
        this.rebuildScene();
    }

    public void rebuildScene() {
        this.mModel.reEvaluateState();
        this.invalidate();
    }

    public void updateState(int stateId, ConstraintSet set) {
        if (this.mScene != null) {
            this.mScene.setConstraintSet(stateId, set);
        }
        this.updateState();
        if (this.mCurrentState == stateId) {
            set.applyTo(this);
        }
    }

    public void updateState() {
        this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(this.mBeginState), this.mScene.getConstraintSet(this.mEndState));
        this.rebuildScene();
    }

    public ArrayList<MotionScene.Transition> getDefinedTransitions() {
        if (this.mScene == null) {
            return null;
        }
        return this.mScene.getDefinedTransitions();
    }

    public int getStartState() {
        return this.mBeginState;
    }

    public int getEndState() {
        return this.mEndState;
    }

    public float getTargetPosition() {
        return this.mTransitionGoalPosition;
    }

    public void setTransitionDuration(int milliseconds) {
        if (this.mScene == null) {
            Log.e((String)TAG, (String)"MotionScene not defined");
            return;
        }
        this.mScene.setDuration(milliseconds);
    }

    public MotionScene.Transition getTransition(int id2) {
        return this.mScene.getTransitionById(id2);
    }

    int lookUpConstraintId(String id2) {
        if (this.mScene == null) {
            return 0;
        }
        return this.mScene.lookUpConstraintId(id2);
    }

    String getConstraintSetNames(int id2) {
        if (this.mScene == null) {
            return null;
        }
        return this.mScene.lookUpConstraintName(id2);
    }

    void disableAutoTransition(boolean disable) {
        if (this.mScene == null) {
            return;
        }
        this.mScene.disableAutoTransition(disable);
    }

    public void setInteractionEnabled(boolean enabled) {
        this.mInteractionEnabled = enabled;
    }

    public boolean isInteractionEnabled() {
        return this.mInteractionEnabled;
    }

    private void fireTransitionStarted(MotionLayout motionLayout, int mBeginState, int mEndState) {
        if (this.mTransitionListener != null) {
            this.mTransitionListener.onTransitionStarted(this, mBeginState, mEndState);
        }
        if (this.mTransitionListeners != null) {
            for (TransitionListener listeners : this.mTransitionListeners) {
                listeners.onTransitionStarted(motionLayout, mBeginState, mEndState);
            }
        }
    }

    public static interface TransitionListener {
        public void onTransitionStarted(MotionLayout var1, int var2, int var3);

        public void onTransitionChange(MotionLayout var1, int var2, int var3, float var4);

        public void onTransitionCompleted(MotionLayout var1, int var2);

        public void onTransitionTrigger(MotionLayout var1, int var2, boolean var3, float var4);
    }

    private class DevModeDraw {
        private static final int DEBUG_PATH_TICKS_PER_MS = 16;
        float[] mPoints;
        int[] mPathMode;
        float[] mKeyFramePoints;
        Path mPath;
        Paint mPaint;
        Paint mPaintKeyframes;
        Paint mPaintGraph;
        Paint mTextPaint;
        Paint mFillPaint;
        private float[] mRectangle;
        final int RED_COLOR = -21965;
        final int KEYFRAME_COLOR = -2067046;
        final int GRAPH_COLOR = -13391360;
        final int SHADOW_COLOR = 0x77000000;
        final int DIAMOND_SIZE = 10;
        DashPathEffect mDashPathEffect;
        int mKeyFrameCount;
        Rect mBounds = new Rect();
        boolean mPresentationMode = false;
        int mShadowTranslate = 1;

        public DevModeDraw() {
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setColor(-21965);
            this.mPaint.setStrokeWidth(2.0f);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaintKeyframes = new Paint();
            this.mPaintKeyframes.setAntiAlias(true);
            this.mPaintKeyframes.setColor(-2067046);
            this.mPaintKeyframes.setStrokeWidth(2.0f);
            this.mPaintKeyframes.setStyle(Paint.Style.STROKE);
            this.mPaintGraph = new Paint();
            this.mPaintGraph.setAntiAlias(true);
            this.mPaintGraph.setColor(-13391360);
            this.mPaintGraph.setStrokeWidth(2.0f);
            this.mPaintGraph.setStyle(Paint.Style.STROKE);
            this.mTextPaint = new Paint();
            this.mTextPaint.setAntiAlias(true);
            this.mTextPaint.setColor(-13391360);
            this.mTextPaint.setTextSize(12.0f * MotionLayout.this.getContext().getResources().getDisplayMetrics().density);
            this.mRectangle = new float[8];
            this.mFillPaint = new Paint();
            this.mFillPaint.setAntiAlias(true);
            this.mDashPathEffect = new DashPathEffect(new float[]{4.0f, 8.0f}, 0.0f);
            this.mPaintGraph.setPathEffect((PathEffect)this.mDashPathEffect);
            this.mKeyFramePoints = new float[100];
            this.mPathMode = new int[50];
            if (this.mPresentationMode) {
                this.mPaint.setStrokeWidth(8.0f);
                this.mFillPaint.setStrokeWidth(8.0f);
                this.mPaintKeyframes.setStrokeWidth(8.0f);
                this.mShadowTranslate = 4;
            }
        }

        public void draw(Canvas canvas, HashMap<View, MotionController> frameArrayList, int duration, int debugPath) {
            if (frameArrayList == null || frameArrayList.size() == 0) {
                return;
            }
            canvas.save();
            if (!MotionLayout.this.isInEditMode() && (1 & debugPath) == 2) {
                String str = MotionLayout.this.getContext().getResources().getResourceName(MotionLayout.this.mEndState) + ":" + MotionLayout.this.getProgress();
                canvas.drawText(str, 10.0f, (float)(MotionLayout.this.getHeight() - 30), this.mTextPaint);
                canvas.drawText(str, 11.0f, (float)(MotionLayout.this.getHeight() - 29), this.mPaint);
            }
            for (MotionController motionController : frameArrayList.values()) {
                int mode = motionController.getDrawPath();
                if (debugPath > 0 && mode == 0) {
                    mode = 1;
                }
                if (mode == 0) continue;
                this.mKeyFrameCount = motionController.buildKeyFrames(this.mKeyFramePoints, this.mPathMode);
                if (mode < 1) continue;
                int frames = duration / 16;
                if (this.mPoints == null || this.mPoints.length != frames * 2) {
                    this.mPoints = new float[frames * 2];
                    this.mPath = new Path();
                }
                canvas.translate((float)this.mShadowTranslate, (float)this.mShadowTranslate);
                this.mPaint.setColor(0x77000000);
                this.mFillPaint.setColor(0x77000000);
                this.mPaintKeyframes.setColor(0x77000000);
                this.mPaintGraph.setColor(0x77000000);
                motionController.buildPath(this.mPoints, frames);
                this.drawAll(canvas, mode, this.mKeyFrameCount, motionController);
                this.mPaint.setColor(-21965);
                this.mPaintKeyframes.setColor(-2067046);
                this.mFillPaint.setColor(-2067046);
                this.mPaintGraph.setColor(-13391360);
                canvas.translate((float)(-this.mShadowTranslate), (float)(-this.mShadowTranslate));
                this.drawAll(canvas, mode, this.mKeyFrameCount, motionController);
                if (mode != 5) continue;
                this.drawRectangle(canvas, motionController);
            }
            canvas.restore();
        }

        public void drawAll(Canvas canvas, int mode, int keyFrames, MotionController motionController) {
            if (mode == 4) {
                this.drawPathAsConfigured(canvas);
            }
            if (mode == 2) {
                this.drawPathRelative(canvas);
            }
            if (mode == 3) {
                this.drawPathCartesian(canvas);
            }
            this.drawBasicPath(canvas);
            this.drawTicks(canvas, mode, keyFrames, motionController);
        }

        private void drawBasicPath(Canvas canvas) {
            canvas.drawLines(this.mPoints, this.mPaint);
        }

        private void drawTicks(Canvas canvas, int mode, int keyFrames, MotionController motionController) {
            int viewWidth = 0;
            int viewHeight = 0;
            if (motionController.mView != null) {
                viewWidth = motionController.mView.getWidth();
                viewHeight = motionController.mView.getHeight();
            }
            for (int i = 1; i < keyFrames - 1; ++i) {
                if (mode == 4 && this.mPathMode[i - 1] == 0) continue;
                float x = this.mKeyFramePoints[i * 2];
                float y = this.mKeyFramePoints[i * 2 + 1];
                this.mPath.reset();
                this.mPath.moveTo(x, y + 10.0f);
                this.mPath.lineTo(x + 10.0f, y);
                this.mPath.lineTo(x, y - 10.0f);
                this.mPath.lineTo(x - 10.0f, y);
                this.mPath.close();
                MotionPaths framePoint = motionController.getKeyFrame(i - 1);
                float dx = 0.0f;
                float dy = 0.0f;
                if (mode == 4) {
                    if (this.mPathMode[i - 1] == 1) {
                        this.drawPathRelativeTicks(canvas, x - dx, y - dy);
                    } else if (this.mPathMode[i - 1] == 2) {
                        this.drawPathCartesianTicks(canvas, x - dx, y - dy);
                    } else if (this.mPathMode[i - 1] == 3) {
                        this.drawPathScreenTicks(canvas, x - dx, y - dy, viewWidth, viewHeight);
                    }
                    canvas.drawPath(this.mPath, this.mFillPaint);
                }
                if (mode == 2) {
                    this.drawPathRelativeTicks(canvas, x - dx, y - dy);
                }
                if (mode == 3) {
                    this.drawPathCartesianTicks(canvas, x - dx, y - dy);
                }
                if (mode == 6) {
                    this.drawPathScreenTicks(canvas, x - dx, y - dy, viewWidth, viewHeight);
                }
                if (dx != 0.0f || dy != 0.0f) {
                    this.drawTranslation(canvas, x - dx, y - dy, x, y);
                    continue;
                }
                canvas.drawPath(this.mPath, this.mFillPaint);
            }
            if (this.mPoints.length > 1) {
                canvas.drawCircle(this.mPoints[0], this.mPoints[1], 8.0f, this.mPaintKeyframes);
                canvas.drawCircle(this.mPoints[this.mPoints.length - 2], this.mPoints[this.mPoints.length - 1], 8.0f, this.mPaintKeyframes);
            }
        }

        private void drawTranslation(Canvas canvas, float x1, float y1, float x2, float y2) {
            canvas.drawRect(x1, y1, x2, y2, this.mPaintGraph);
            canvas.drawLine(x1, y1, x2, y2, this.mPaintGraph);
        }

        private void drawPathRelative(Canvas canvas) {
            canvas.drawLine(this.mPoints[0], this.mPoints[1], this.mPoints[this.mPoints.length - 2], this.mPoints[this.mPoints.length - 1], this.mPaintGraph);
        }

        private void drawPathAsConfigured(Canvas canvas) {
            boolean path = false;
            boolean cart = false;
            for (int i = 0; i < this.mKeyFrameCount; ++i) {
                if (this.mPathMode[i] == 1) {
                    path = true;
                }
                if (this.mPathMode[i] != 2) continue;
                cart = true;
            }
            if (path) {
                this.drawPathRelative(canvas);
            }
            if (cart) {
                this.drawPathCartesian(canvas);
            }
        }

        private void drawPathRelativeTicks(Canvas canvas, float x, float y) {
            float x1 = this.mPoints[0];
            float y1 = this.mPoints[1];
            float x2 = this.mPoints[this.mPoints.length - 2];
            float y2 = this.mPoints[this.mPoints.length - 1];
            float dist = (float)Math.hypot(x1 - x2, y1 - y2);
            float t = ((x - x1) * (x2 - x1) + (y - y1) * (y2 - y1)) / (dist * dist);
            float xp = x1 + t * (x2 - x1);
            float yp = y1 + t * (y2 - y1);
            Path path = new Path();
            path.moveTo(x, y);
            path.lineTo(xp, yp);
            float len = (float)Math.hypot(xp - x, yp - y);
            String text = "" + (float)((int)(100.0f * len / dist)) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            float off = len / 2.0f - (float)(this.mBounds.width() / 2);
            canvas.drawTextOnPath(text, path, off, -20.0f, this.mTextPaint);
            canvas.drawLine(x, y, xp, yp, this.mPaintGraph);
        }

        void getTextBounds(String text, Paint paint) {
            paint.getTextBounds(text, 0, text.length(), this.mBounds);
        }

        private void drawPathCartesian(Canvas canvas) {
            float x1 = this.mPoints[0];
            float y1 = this.mPoints[1];
            float x2 = this.mPoints[this.mPoints.length - 2];
            float y2 = this.mPoints[this.mPoints.length - 1];
            canvas.drawLine(Math.min(x1, x2), Math.max(y1, y2), Math.max(x1, x2), Math.max(y1, y2), this.mPaintGraph);
            canvas.drawLine(Math.min(x1, x2), Math.min(y1, y2), Math.min(x1, x2), Math.max(y1, y2), this.mPaintGraph);
        }

        private void drawPathCartesianTicks(Canvas canvas, float x, float y) {
            float x1 = this.mPoints[0];
            float y1 = this.mPoints[1];
            float x2 = this.mPoints[this.mPoints.length - 2];
            float y2 = this.mPoints[this.mPoints.length - 1];
            float minx = Math.min(x1, x2);
            float maxy = Math.max(y1, y2);
            float xgap = x - Math.min(x1, x2);
            float ygap = Math.max(y1, y2) - y;
            String text = "" + (float)((int)(0.5 + (double)(100.0f * xgap / Math.abs(x2 - x1)))) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            float off = xgap / 2.0f - (float)(this.mBounds.width() / 2);
            canvas.drawText(text, off + minx, y - 20.0f, this.mTextPaint);
            canvas.drawLine(x, y, Math.min(x1, x2), y, this.mPaintGraph);
            text = "" + (float)((int)(0.5 + (double)(100.0f * ygap / Math.abs(y2 - y1)))) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            off = ygap / 2.0f - (float)(this.mBounds.height() / 2);
            canvas.drawText(text, x + 5.0f, maxy - off, this.mTextPaint);
            canvas.drawLine(x, y, x, Math.max(y1, y2), this.mPaintGraph);
        }

        private void drawPathScreenTicks(Canvas canvas, float x, float y, int viewWidth, int viewHeight) {
            float x1 = 0.0f;
            float y1 = 0.0f;
            float x2 = 1.0f;
            float y2 = 1.0f;
            float minx = 0.0f;
            float maxy = 0.0f;
            float xgap = x;
            float ygap = y;
            String text = "" + (float)((int)(0.5 + (double)(100.0f * (xgap - (float)(viewWidth / 2)) / (float)(MotionLayout.this.getWidth() - viewWidth)))) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            float off = xgap / 2.0f - (float)(this.mBounds.width() / 2);
            canvas.drawText(text, off + minx, y - 20.0f, this.mTextPaint);
            canvas.drawLine(x, y, Math.min(x1, x2), y, this.mPaintGraph);
            text = "" + (float)((int)(0.5 + (double)(100.0f * (ygap - (float)(viewHeight / 2)) / (float)(MotionLayout.this.getHeight() - viewHeight)))) / 100.0f;
            this.getTextBounds(text, this.mTextPaint);
            off = ygap / 2.0f - (float)(this.mBounds.height() / 2);
            canvas.drawText(text, x + 5.0f, maxy - off, this.mTextPaint);
            canvas.drawLine(x, y, x, Math.max(y1, y2), this.mPaintGraph);
        }

        private void drawRectangle(Canvas canvas, MotionController motionController) {
            this.mPath.reset();
            int rectFrames = 50;
            for (int i = 0; i <= rectFrames; ++i) {
                float p = (float)i / (float)rectFrames;
                motionController.buildRect(p, this.mRectangle, 0);
                this.mPath.moveTo(this.mRectangle[0], this.mRectangle[1]);
                this.mPath.lineTo(this.mRectangle[2], this.mRectangle[3]);
                this.mPath.lineTo(this.mRectangle[4], this.mRectangle[5]);
                this.mPath.lineTo(this.mRectangle[6], this.mRectangle[7]);
                this.mPath.close();
            }
            this.mPaint.setColor(0x44000000);
            canvas.translate(2.0f, 2.0f);
            canvas.drawPath(this.mPath, this.mPaint);
            canvas.translate(-2.0f, -2.0f);
            this.mPaint.setColor(-65536);
            canvas.drawPath(this.mPath, this.mPaint);
        }
    }

    class Model {
        ConstraintWidgetContainer mLayoutStart = new ConstraintWidgetContainer();
        ConstraintWidgetContainer mLayoutEnd = new ConstraintWidgetContainer();
        ConstraintSet mStart = null;
        ConstraintSet mEnd = null;
        int mStartId;
        int mEndId;

        Model() {
        }

        void copy(ConstraintWidgetContainer src, ConstraintWidgetContainer dest) {
            ArrayList children = src.getChildren();
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put(src, dest);
            dest.getChildren().clear();
            dest.copy((ConstraintWidget)src, map);
            for (ConstraintWidget child_s : children) {
                Object child_d = child_s instanceof android.support.constraint.solver.widgets.Barrier ? new android.support.constraint.solver.widgets.Barrier() : (child_s instanceof Guideline ? new Guideline() : (child_s instanceof Flow ? new Flow() : (child_s instanceof Helper ? new HelperWidget() : new ConstraintWidget())));
                dest.add((ConstraintWidget)child_d);
                map.put(child_s, child_d);
            }
            for (ConstraintWidget child_s : children) {
                ((ConstraintWidget)map.get(child_s)).copy(child_s, map);
            }
        }

        void initFrom(ConstraintWidgetContainer baseLayout, ConstraintSet start, ConstraintSet end) {
            this.mStart = start;
            this.mEnd = end;
            this.mLayoutStart = new ConstraintWidgetContainer();
            this.mLayoutEnd = new ConstraintWidgetContainer();
            this.mLayoutStart.setMeasurer(MotionLayout.this.mLayoutWidget.getMeasurer());
            this.mLayoutEnd.setMeasurer(MotionLayout.this.mLayoutWidget.getMeasurer());
            this.mLayoutStart.removeAllChildren();
            this.mLayoutEnd.removeAllChildren();
            this.copy(MotionLayout.this.mLayoutWidget, this.mLayoutStart);
            this.copy(MotionLayout.this.mLayoutWidget, this.mLayoutEnd);
            if ((double)MotionLayout.this.mTransitionLastPosition > 0.5) {
                if (start != null) {
                    this.setupConstraintWidget(this.mLayoutStart, start);
                }
                this.setupConstraintWidget(this.mLayoutEnd, end);
            } else {
                this.setupConstraintWidget(this.mLayoutEnd, end);
                if (start != null) {
                    this.setupConstraintWidget(this.mLayoutStart, start);
                }
            }
            this.mLayoutStart.setRtl(MotionLayout.this.isRtl());
            this.mLayoutStart.updateHierarchy();
            this.mLayoutEnd.setRtl(MotionLayout.this.isRtl());
            this.mLayoutEnd.updateHierarchy();
            ViewGroup.LayoutParams layoutParams = MotionLayout.this.getLayoutParams();
            if (layoutParams != null) {
                if (layoutParams.width == -2) {
                    this.mLayoutStart.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                    this.mLayoutEnd.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
                if (layoutParams.height == -2) {
                    this.mLayoutStart.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                    this.mLayoutEnd.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
        }

        private void setupConstraintWidget(ConstraintWidgetContainer base, ConstraintSet cset) {
            View view;
            SparseArray mapIdToWidget = new SparseArray();
            Constraints.LayoutParams layoutParams = new Constraints.LayoutParams(-2, -2);
            mapIdToWidget.clear();
            mapIdToWidget.put(0, (Object)base);
            mapIdToWidget.put(MotionLayout.this.getId(), (Object)base);
            for (ConstraintWidget child : base.getChildren()) {
                view = (View)child.getCompanionWidget();
                mapIdToWidget.put(view.getId(), (Object)child);
            }
            for (ConstraintWidget child : base.getChildren()) {
                view = (View)child.getCompanionWidget();
                cset.applyToLayoutParams(view.getId(), layoutParams);
                child.setWidth(cset.getWidth(view.getId()));
                child.setHeight(cset.getHeight(view.getId()));
                if (view instanceof ConstraintHelper) {
                    cset.applyToHelper((ConstraintHelper)view, child, layoutParams, (SparseArray<ConstraintWidget>)mapIdToWidget);
                    if (view instanceof Barrier) {
                        ((Barrier)view).validateParams();
                    }
                }
                if (Build.VERSION.SDK_INT >= 17) {
                    layoutParams.resolveLayoutDirection(MotionLayout.this.getLayoutDirection());
                } else {
                    layoutParams.resolveLayoutDirection(0);
                }
                MotionLayout.this.applyConstraintsFromLayoutParams(false, view, child, layoutParams, (SparseArray<ConstraintWidget>)mapIdToWidget);
                if (cset.getVisibilityMode(view.getId()) == 1) {
                    child.setVisibility(view.getVisibility());
                    continue;
                }
                child.setVisibility(cset.getVisibility(view.getId()));
            }
            for (ConstraintWidget child : base.getChildren()) {
                if (!(child instanceof VirtualLayout)) continue;
                view = (ConstraintHelper)((Object)child.getCompanionWidget());
                Helper helper = (Helper)child;
                view.updatePreLayout(base, helper, (SparseArray<ConstraintWidget>)mapIdToWidget);
                VirtualLayout virtualLayout = (VirtualLayout)helper;
                virtualLayout.captureWidgets();
            }
        }

        ConstraintWidget getWidget(ConstraintWidgetContainer container, View view) {
            if (container.getCompanionWidget() == view) {
                return container;
            }
            ArrayList children = container.getChildren();
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                ConstraintWidget widget = (ConstraintWidget)children.get(i);
                if (widget.getCompanionWidget() != view) continue;
                return widget;
            }
            return null;
        }

        private void debugLayoutParam(String str, ConstraintLayout.LayoutParams params) {
            String a = " ";
            a = a + (params.startToStart != -1 ? "SS" : "__");
            a = a + (params.startToEnd != -1 ? "|SE" : "|__");
            a = a + (params.endToStart != -1 ? "|ES" : "|__");
            a = a + (params.endToEnd != -1 ? "|EE" : "|__");
            a = a + (params.leftToLeft != -1 ? "|LL" : "|__");
            a = a + (params.leftToRight != -1 ? "|LR" : "|__");
            a = a + (params.rightToLeft != -1 ? "|RL" : "|__");
            a = a + (params.rightToRight != -1 ? "|RR" : "|__");
            a = a + (params.topToTop != -1 ? "|TT" : "|__");
            a = a + (params.topToBottom != -1 ? "|TB" : "|__");
            a = a + (params.bottomToTop != -1 ? "|BT" : "|__");
            a = a + (params.bottomToBottom != -1 ? "|BB" : "|__");
            Log.v((String)MotionLayout.TAG, (String)(str + a));
        }

        private void debugWidget(String str, ConstraintWidget child) {
            String a = " ";
            a = a + (child.mTop.mTarget != null ? "T" + (child.mTop.mTarget.mType == ConstraintAnchor.Type.TOP ? "T" : "B") : "__");
            a = a + (child.mBottom.mTarget != null ? "B" + (child.mBottom.mTarget.mType == ConstraintAnchor.Type.TOP ? "T" : "B") : "__");
            a = a + (child.mLeft.mTarget != null ? "L" + (child.mLeft.mTarget.mType == ConstraintAnchor.Type.LEFT ? "L" : "R") : "__");
            a = a + (child.mRight.mTarget != null ? "R" + (child.mRight.mTarget.mType == ConstraintAnchor.Type.LEFT ? "L" : "R") : "__");
            Log.v((String)MotionLayout.TAG, (String)(str + a + " ---  " + child));
        }

        private void debugLayout(String title, ConstraintWidgetContainer c) {
            View v = (View)c.getCompanionWidget();
            String cName = title + " " + Debug.getName(v);
            Log.v((String)MotionLayout.TAG, (String)(cName + "  ========= " + c));
            int count = c.getChildren().size();
            for (int i = 0; i < count; ++i) {
                String str = cName + "[" + i + "] ";
                ConstraintWidget child = (ConstraintWidget)c.getChildren().get(i);
                String a = "";
                a = a + (child.mTop.mTarget != null ? "T" : "_");
                a = a + (child.mBottom.mTarget != null ? "B" : "_");
                a = a + (child.mLeft.mTarget != null ? "L" : "_");
                a = a + (child.mRight.mTarget != null ? "R" : "_");
                v = (View)child.getCompanionWidget();
                String name = Debug.getName(v);
                if (v instanceof TextView) {
                    name = name + "(" + ((TextView)v).getText() + ")";
                }
                Log.v((String)MotionLayout.TAG, (String)(str + "  " + name + " " + child + " " + a));
            }
            Log.v((String)MotionLayout.TAG, (String)(cName + " done. "));
        }

        public void reEvaluateState() {
            this.measure(MotionLayout.this.mLastWidthMeasureSpec, MotionLayout.this.mLastHeightMeasureSpec);
            MotionLayout.this.setupMotionViews();
        }

        public void measure(int widthMeasureSpec, int heightMeasureSpec) {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            MotionLayout.this.mWidthMeasureMode = widthMode;
            MotionLayout.this.mHeightMeasureMode = heightMode;
            int optimisationLevel = MotionLayout.this.getOptimizationLevel();
            if (MotionLayout.this.mCurrentState == MotionLayout.this.getStartState()) {
                MotionLayout.this.resolveSystem(this.mLayoutEnd, optimisationLevel, widthMeasureSpec, heightMeasureSpec);
                if (this.mStart != null) {
                    MotionLayout.this.resolveSystem(this.mLayoutStart, optimisationLevel, widthMeasureSpec, heightMeasureSpec);
                }
            } else {
                if (this.mStart != null) {
                    MotionLayout.this.resolveSystem(this.mLayoutStart, optimisationLevel, widthMeasureSpec, heightMeasureSpec);
                }
                MotionLayout.this.resolveSystem(this.mLayoutEnd, optimisationLevel, widthMeasureSpec, heightMeasureSpec);
            }
            boolean recompute_start_end_size = true;
            if (MotionLayout.this.getParent() instanceof MotionLayout && widthMode == 0x40000000 && heightMode == 0x40000000) {
                recompute_start_end_size = false;
            }
            if (recompute_start_end_size) {
                MotionLayout.this.mWidthMeasureMode = widthMode;
                MotionLayout.this.mHeightMeasureMode = heightMode;
                if (MotionLayout.this.mCurrentState == MotionLayout.this.getStartState()) {
                    MotionLayout.this.resolveSystem(this.mLayoutEnd, optimisationLevel, widthMeasureSpec, heightMeasureSpec);
                    if (this.mStart != null) {
                        MotionLayout.this.resolveSystem(this.mLayoutStart, optimisationLevel, widthMeasureSpec, heightMeasureSpec);
                    }
                } else {
                    if (this.mStart != null) {
                        MotionLayout.this.resolveSystem(this.mLayoutStart, optimisationLevel, widthMeasureSpec, heightMeasureSpec);
                    }
                    MotionLayout.this.resolveSystem(this.mLayoutEnd, optimisationLevel, widthMeasureSpec, heightMeasureSpec);
                }
                MotionLayout.this.mStartWrapWidth = this.mLayoutStart.getWidth();
                MotionLayout.this.mStartWrapHeight = this.mLayoutStart.getHeight();
                MotionLayout.this.mEndWrapWidth = this.mLayoutEnd.getWidth();
                MotionLayout.this.mEndWrapHeight = this.mLayoutEnd.getHeight();
                MotionLayout.this.mMeasureDuringTransition = MotionLayout.this.mStartWrapWidth != MotionLayout.this.mEndWrapWidth || MotionLayout.this.mStartWrapHeight != MotionLayout.this.mEndWrapHeight;
            }
            int width = MotionLayout.this.mStartWrapWidth;
            int height = MotionLayout.this.mStartWrapHeight;
            if (MotionLayout.this.mWidthMeasureMode == Integer.MIN_VALUE || MotionLayout.this.mWidthMeasureMode == 0) {
                width = (int)((float)MotionLayout.this.mStartWrapWidth + MotionLayout.this.mPostInterpolationPosition * (float)(MotionLayout.this.mEndWrapWidth - MotionLayout.this.mStartWrapWidth));
            }
            if (MotionLayout.this.mHeightMeasureMode == Integer.MIN_VALUE || MotionLayout.this.mHeightMeasureMode == 0) {
                height = (int)((float)MotionLayout.this.mStartWrapHeight + MotionLayout.this.mPostInterpolationPosition * (float)(MotionLayout.this.mEndWrapHeight - MotionLayout.this.mStartWrapHeight));
            }
            boolean isWidthMeasuredTooSmall = this.mLayoutStart.isWidthMeasuredTooSmall() || this.mLayoutEnd.isWidthMeasuredTooSmall();
            boolean isHeightMeasuredTooSmall = this.mLayoutStart.isHeightMeasuredTooSmall() || this.mLayoutEnd.isHeightMeasuredTooSmall();
            MotionLayout.this.resolveMeasuredDimension(widthMeasureSpec, heightMeasureSpec, width, height, isWidthMeasuredTooSmall, isHeightMeasuredTooSmall);
        }

        public void build() {
            MotionController motionController;
            View v;
            int i;
            int n = MotionLayout.this.getChildCount();
            MotionLayout.this.mFrameArrayList.clear();
            for (i = 0; i < n; ++i) {
                v = MotionLayout.this.getChildAt(i);
                motionController = new MotionController(v);
                MotionLayout.this.mFrameArrayList.put(v, motionController);
            }
            for (i = 0; i < n; ++i) {
                v = MotionLayout.this.getChildAt(i);
                motionController = MotionLayout.this.mFrameArrayList.get(v);
                if (motionController == null) continue;
                if (this.mStart != null) {
                    ConstraintWidget startWidget = this.getWidget(this.mLayoutStart, v);
                    if (startWidget != null) {
                        motionController.setStartState(startWidget, this.mStart);
                    } else if (MotionLayout.this.mDebugPath != 0) {
                        Log.e((String)MotionLayout.TAG, (String)(Debug.getLocation() + "no widget for  " + Debug.getName(v) + " (" + v.getClass().getName() + ")"));
                    }
                }
                if (this.mEnd == null) continue;
                ConstraintWidget endWidget = this.getWidget(this.mLayoutEnd, v);
                if (endWidget != null) {
                    motionController.setEndState(endWidget, this.mEnd);
                    continue;
                }
                if (MotionLayout.this.mDebugPath == 0) continue;
                Log.e((String)MotionLayout.TAG, (String)(Debug.getLocation() + "no widget for  " + Debug.getName(v) + " (" + v.getClass().getName() + ")"));
            }
        }

        public void setMeasuredId(int startId, int endId) {
            this.mStartId = startId;
            this.mEndId = endId;
        }

        public boolean isNotConfiguredWith(int startId, int endId) {
            return startId != this.mStartId || endId != this.mEndId;
        }
    }

    class DecelerateInterpolator
    extends MotionInterpolator {
        float initalV = 0.0f;
        float currentP = 0.0f;
        float maxA;

        DecelerateInterpolator() {
        }

        public void config(float velocity, float position, float maxAcceleration) {
            this.initalV = velocity;
            this.currentP = position;
            this.maxA = maxAcceleration;
        }

        @Override
        public float getInterpolation(float time) {
            if (this.initalV > 0.0f) {
                if (this.initalV / this.maxA < time) {
                    time = this.initalV / this.maxA;
                }
                MotionLayout.this.mLastVelocity = this.initalV - this.maxA * time;
                float pos = this.initalV * time - this.maxA * time * time / 2.0f;
                return pos + this.currentP;
            }
            if (-this.initalV / this.maxA < time) {
                time = -this.initalV / this.maxA;
            }
            MotionLayout.this.mLastVelocity = this.initalV + this.maxA * time;
            float pos = this.initalV * time + this.maxA * time * time / 2.0f;
            return pos + this.currentP;
        }

        @Override
        public float getVelocity() {
            return MotionLayout.this.mLastVelocity;
        }
    }

    class StateCache {
        float mProgress = Float.NaN;
        float mVelocity = Float.NaN;
        int startState = -1;
        int endState = -1;
        final String KeyProgress = "motion.progress";
        final String KeyVelocity = "motion.velocity";
        final String KeyStartState = "motion.StartState";
        final String KeyEndState = "motion.EndState";

        StateCache() {
        }

        void apply() {
            if (this.startState != -1 || this.endState != -1) {
                if (this.startState == -1) {
                    MotionLayout.this.transitionToState(this.endState);
                } else if (this.endState == -1) {
                    MotionLayout.this.setState(this.startState, -1, -1);
                } else {
                    MotionLayout.this.setTransition(this.startState, this.endState);
                }
                MotionLayout.this.setState(TransitionState.SETUP);
            }
            if (Float.isNaN(this.mVelocity)) {
                if (Float.isNaN(this.mProgress)) {
                    return;
                }
                MotionLayout.this.setProgress(this.mProgress);
                return;
            }
            MotionLayout.this.setProgress(this.mProgress, this.mVelocity);
            this.mProgress = Float.NaN;
            this.mVelocity = Float.NaN;
            this.startState = -1;
            this.endState = -1;
        }

        public Bundle getTransitionState() {
            Bundle bundle = new Bundle();
            bundle.putFloat("motion.progress", this.mProgress);
            bundle.putFloat("motion.velocity", this.mVelocity);
            bundle.putInt("motion.StartState", this.startState);
            bundle.putInt("motion.EndState", this.endState);
            return bundle;
        }

        public void setTransitionState(Bundle bundle) {
            this.mProgress = bundle.getFloat("motion.progress");
            this.mVelocity = bundle.getFloat("motion.velocity");
            this.startState = bundle.getInt("motion.StartState");
            this.endState = bundle.getInt("motion.EndState");
        }

        public void setProgress(float progress) {
            this.mProgress = progress;
        }

        public void setEndState(int endState) {
            this.endState = endState;
        }

        public void setVelocity(float mVelocity) {
            this.mVelocity = mVelocity;
        }

        public void setStartState(int startState) {
            this.startState = startState;
        }

        public void recordState() {
            this.endState = MotionLayout.this.mEndState;
            this.startState = MotionLayout.this.mBeginState;
            this.mVelocity = MotionLayout.this.getVelocity();
            this.mProgress = MotionLayout.this.getProgress();
        }
    }

    private static class MyTracker
    implements MotionTracker {
        VelocityTracker tracker;
        private static MyTracker me = new MyTracker();

        private MyTracker() {
        }

        public static MyTracker obtain() {
            MyTracker.me.tracker = VelocityTracker.obtain();
            return me;
        }

        @Override
        public void recycle() {
            this.tracker.recycle();
            this.tracker = null;
        }

        @Override
        public void clear() {
            this.tracker.clear();
        }

        @Override
        public void addMovement(MotionEvent event) {
            if (this.tracker != null) {
                this.tracker.addMovement(event);
            }
        }

        @Override
        public void computeCurrentVelocity(int units) {
            this.tracker.computeCurrentVelocity(units);
        }

        @Override
        public void computeCurrentVelocity(int units, float maxVelocity) {
            this.tracker.computeCurrentVelocity(units, maxVelocity);
        }

        @Override
        public float getXVelocity() {
            return this.tracker.getXVelocity();
        }

        @Override
        public float getYVelocity() {
            return this.tracker.getYVelocity();
        }

        @Override
        public float getXVelocity(int id2) {
            return this.tracker.getXVelocity(id2);
        }

        @Override
        public float getYVelocity(int id2) {
            return this.getYVelocity(id2);
        }
    }

    protected static interface MotionTracker {
        public void recycle();

        public void clear();

        public void addMovement(MotionEvent var1);

        public void computeCurrentVelocity(int var1);

        public void computeCurrentVelocity(int var1, float var2);

        public float getXVelocity();

        public float getYVelocity();

        public float getXVelocity(int var1);

        public float getYVelocity(int var1);
    }

    static enum TransitionState {
        UNDEFINED,
        SETUP,
        MOVING,
        FINISHED;

    }
}

