/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.os.Build;
import android.support.constraint.ConstraintAttribute;
import android.support.constraint.motion.KeyCache;
import android.support.constraint.motion.MotionLayout;
import android.support.constraint.motion.utils.CurveFit;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;

public abstract class TimeCycleSplineSet {
    private static final String TAG = "SplineSet";
    protected CurveFit mCurveFit;
    protected int mWaveShape = 0;
    protected int[] mTimePoints = new int[10];
    protected float[][] mValues = new float[10][3];
    private int count;
    private String mType;
    private float[] mCache = new float[3];
    private static final int CURVE_VALUE = 0;
    private static final int CURVE_PERIOD = 1;
    private static final int CURVE_OFFSET = 2;
    private static float VAL_2PI = (float)Math.PI * 2;
    protected boolean mContinue = false;
    long last_time;
    float last_cycle = Float.NaN;

    public String toString() {
        String str = this.mType;
        DecimalFormat df = new DecimalFormat("##.##");
        for (int i = 0; i < this.count; ++i) {
            str = str + "[" + this.mTimePoints[i] + " , " + df.format(this.mValues[i]) + "] ";
        }
        return str;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public abstract boolean setProperty(View var1, float var2, long var3, KeyCache var5);

    public float get(float pos, long time, View view, KeyCache cache) {
        this.mCurveFit.getPos((double)pos, this.mCache);
        float period = this.mCache[1];
        if (period == 0.0f) {
            this.mContinue = false;
            return this.mCache[2];
        }
        if (Float.isNaN(this.last_cycle)) {
            this.last_cycle = cache.getFloatValue(view, this.mType, 0);
            if (Float.isNaN(this.last_cycle)) {
                this.last_cycle = 0.0f;
            }
        }
        long delta_time = time - this.last_time;
        this.last_cycle = (float)(((double)this.last_cycle + (double)delta_time * 1.0E-9 * (double)period) % 1.0);
        cache.setFloatValue(view, this.mType, 0, this.last_cycle);
        this.last_time = time;
        float v = this.mCache[0];
        float wave = this.calcWave(this.last_cycle);
        float offset = this.mCache[2];
        float value = v * wave + offset;
        this.mContinue = v != 0.0f || period != 0.0f;
        return value;
    }

    protected float calcWave(float period) {
        float p = period;
        switch (this.mWaveShape) {
            default: {
                return (float)Math.sin(p * VAL_2PI);
            }
            case 1: {
                return Math.signum(p * VAL_2PI);
            }
            case 2: {
                return 1.0f - Math.abs(p);
            }
            case 3: {
                return (p * 2.0f + 1.0f) % 2.0f - 1.0f;
            }
            case 4: {
                return 1.0f - (p * 2.0f + 1.0f) % 2.0f;
            }
            case 5: {
                return (float)Math.cos(p * VAL_2PI);
            }
            case 6: 
        }
        float x = 1.0f - Math.abs(p * 4.0f % 4.0f - 2.0f);
        return 1.0f - x * x;
    }

    public CurveFit getCurveFit() {
        return this.mCurveFit;
    }

    static TimeCycleSplineSet makeCustomSpline(String str, SparseArray<ConstraintAttribute> attrList) {
        return new CustomSet(str, attrList);
    }

    static TimeCycleSplineSet makeSpline(String str, long currentTime) {
        TimeCycleSplineSet timeCycle;
        switch (str) {
            case "alpha": {
                timeCycle = new AlphaSet();
                break;
            }
            case "elevation": {
                timeCycle = new ElevationSet();
                break;
            }
            case "rotation": {
                timeCycle = new RotationSet();
                break;
            }
            case "rotationX": {
                timeCycle = new RotationXset();
                break;
            }
            case "rotationY": {
                timeCycle = new RotationYset();
                break;
            }
            case "transitionPathRotate": {
                timeCycle = new PathRotate();
                break;
            }
            case "scaleX": {
                timeCycle = new ScaleXset();
                break;
            }
            case "scaleY": {
                timeCycle = new ScaleYset();
                break;
            }
            case "translationX": {
                timeCycle = new TranslationXset();
                break;
            }
            case "translationY": {
                timeCycle = new TranslationYset();
                break;
            }
            case "translationZ": {
                timeCycle = new TranslationZset();
                break;
            }
            case "progress": {
                timeCycle = new ProgressSet();
                break;
            }
            default: {
                return null;
            }
        }
        timeCycle.setStartTime(currentTime);
        return timeCycle;
    }

    protected void setStartTime(long currentTime) {
        this.last_time = currentTime;
    }

    public void setPoint(int position, float value, float period, int shape, float offset) {
        this.mTimePoints[this.count] = position;
        this.mValues[this.count][0] = value;
        this.mValues[this.count][1] = period;
        this.mValues[this.count][2] = offset;
        this.mWaveShape = Math.max(this.mWaveShape, shape);
        ++this.count;
    }

    public void setup(int curveType) {
        if (this.count == 0) {
            Log.e((String)TAG, (String)("Error no points added to " + this.mType));
            return;
        }
        Sort.doubleQuickSort(this.mTimePoints, this.mValues, 0, this.count - 1);
        int unique = 0;
        for (int i = 1; i < this.mTimePoints.length; ++i) {
            if (this.mTimePoints[i] == this.mTimePoints[i - 1]) continue;
            ++unique;
        }
        if (unique == 0) {
            unique = 1;
        }
        double[] time = new double[unique];
        double[][] values = new double[unique][3];
        int k = 0;
        for (int i = 0; i < this.count; ++i) {
            if (i > 0 && this.mTimePoints[i] == this.mTimePoints[i - 1]) continue;
            time[k] = (double)this.mTimePoints[i] * 0.01;
            values[k][0] = this.mValues[i][0];
            values[k][1] = this.mValues[i][1];
            values[k][2] = this.mValues[i][2];
            ++k;
        }
        this.mCurveFit = CurveFit.get(curveType, time, values);
    }

    private static class Sort {
        private Sort() {
        }

        static void doubleQuickSort(int[] key, float[][] value, int low, int hi) {
            int[] stack = new int[key.length + 10];
            int count = 0;
            stack[count++] = hi;
            stack[count++] = low;
            while (count > 0) {
                --count;
                low = stack[count];
                if (low >= (hi = stack[--count])) continue;
                int p = Sort.partition(key, value, low, hi);
                stack[count++] = p - 1;
                stack[count++] = low;
                stack[count++] = hi;
                stack[count++] = p + 1;
            }
        }

        private static int partition(int[] array, float[][] value, int low, int hi) {
            int pivot = array[hi];
            int i = low;
            for (int j = low; j < hi; ++j) {
                if (array[j] > pivot) continue;
                Sort.swap(array, value, i, j);
                ++i;
            }
            Sort.swap(array, value, i, hi);
            return i;
        }

        private static void swap(int[] array, float[][] value, int a, int b) {
            int tmp = array[a];
            array[a] = array[b];
            array[b] = tmp;
            float[] tmpv = value[a];
            value[a] = value[b];
            value[b] = tmpv;
        }
    }

    static class ProgressSet
    extends TimeCycleSplineSet {
        boolean mNoMethod = false;

        ProgressSet() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            if (view instanceof MotionLayout) {
                ((MotionLayout)view).setProgress(this.get(t, time, view, cache));
            } else {
                if (this.mNoMethod) {
                    return false;
                }
                Method method = null;
                try {
                    method = view.getClass().getMethod("setProgress", Float.TYPE);
                }
                catch (NoSuchMethodException e) {
                    this.mNoMethod = true;
                }
                if (method != null) {
                    try {
                        method.invoke((Object)view, Float.valueOf(this.get(t, time, view, cache)));
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)TimeCycleSplineSet.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Log.e((String)TimeCycleSplineSet.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                }
            }
            return this.mContinue;
        }
    }

    static class CustomSet
    extends TimeCycleSplineSet {
        String mAttributeName;
        SparseArray<ConstraintAttribute> mConstraintAttributeList;
        SparseArray<float[]> mWaveProperties = new SparseArray();
        float[] mTempValues;
        float[] mCache;

        public CustomSet(String attribute, SparseArray<ConstraintAttribute> attrList) {
            this.mAttributeName = attribute.split(",")[1];
            this.mConstraintAttributeList = attrList;
        }

        @Override
        public void setup(int curveType) {
            int size = this.mConstraintAttributeList.size();
            int dimensionality = ((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0)).noOfInterpValues();
            double[] time = new double[size];
            this.mTempValues = new float[dimensionality + 2];
            this.mCache = new float[dimensionality];
            double[][] values = new double[size][dimensionality + 2];
            for (int i = 0; i < size; ++i) {
                int key = this.mConstraintAttributeList.keyAt(i);
                ConstraintAttribute ca = (ConstraintAttribute)this.mConstraintAttributeList.valueAt(i);
                float[] waveProp = (float[])this.mWaveProperties.valueAt(i);
                time[i] = (double)key * 0.01;
                ca.getValuesToInterpolate(this.mTempValues);
                for (int k = 0; k < this.mTempValues.length; ++k) {
                    values[i][k] = this.mTempValues[k];
                }
                values[i][dimensionality] = waveProp[0];
                values[i][dimensionality + 1] = waveProp[1];
            }
            this.mCurveFit = CurveFit.get(curveType, time, values);
        }

        @Override
        public void setPoint(int position, float value, float period, int shape, float offset) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute,...)");
        }

        public void setPoint(int position, ConstraintAttribute value, float period, int shape, float offset) {
            this.mConstraintAttributeList.append(position, (Object)value);
            this.mWaveProperties.append(position, (Object)new float[]{period, offset});
            this.mWaveShape = Math.max(this.mWaveShape, shape);
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            this.mCurveFit.getPos((double)t, this.mTempValues);
            float period = this.mTempValues[this.mTempValues.length - 2];
            float offset = this.mTempValues[this.mTempValues.length - 1];
            long delta_time = time - this.last_time;
            this.last_cycle = (float)(((double)this.last_cycle + (double)delta_time * 1.0E-9 * (double)period) % 1.0);
            this.last_time = time;
            float wave = this.calcWave(this.last_cycle);
            this.mContinue = false;
            for (int i = 0; i < this.mCache.length; ++i) {
                this.mContinue |= (double)this.mTempValues[i] != 0.0;
                this.mCache[i] = this.mTempValues[i] * wave + offset;
            }
            ((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0)).setInterpolatedValue(view, this.mCache);
            if (period != 0.0f) {
                this.mContinue = true;
            }
            return this.mContinue;
        }
    }

    static class TranslationZset
    extends TimeCycleSplineSet {
        TranslationZset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(this.get(t, time, view, cache));
            }
            return this.mContinue;
        }
    }

    static class TranslationYset
    extends TimeCycleSplineSet {
        TranslationYset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            view.setTranslationY(this.get(t, time, view, cache));
            return this.mContinue;
        }
    }

    static class TranslationXset
    extends TimeCycleSplineSet {
        TranslationXset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            view.setTranslationX(this.get(t, time, view, cache));
            return this.mContinue;
        }
    }

    static class ScaleYset
    extends TimeCycleSplineSet {
        ScaleYset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            view.setScaleY(this.get(t, time, view, cache));
            return this.mContinue;
        }
    }

    static class ScaleXset
    extends TimeCycleSplineSet {
        ScaleXset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            view.setScaleX(this.get(t, time, view, cache));
            return this.mContinue;
        }
    }

    static class PathRotate
    extends TimeCycleSplineSet {
        PathRotate() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            return this.mContinue;
        }

        public boolean setPathRotate(View view, KeyCache cache, float t, long time, double dx, double dy) {
            view.setRotation(this.get(t, time, view, cache) + (float)Math.toDegrees(Math.atan2(dy, dx)));
            return this.mContinue;
        }
    }

    static class RotationYset
    extends TimeCycleSplineSet {
        RotationYset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            view.setRotationY(this.get(t, time, view, cache));
            return this.mContinue;
        }
    }

    static class RotationXset
    extends TimeCycleSplineSet {
        RotationXset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            view.setRotationX(this.get(t, time, view, cache));
            return this.mContinue;
        }
    }

    static class RotationSet
    extends TimeCycleSplineSet {
        RotationSet() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            view.setRotation(this.get(t, time, view, cache));
            return this.mContinue;
        }
    }

    static class AlphaSet
    extends TimeCycleSplineSet {
        AlphaSet() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            view.setAlpha(this.get(t, time, view, cache));
            return this.mContinue;
        }
    }

    static class ElevationSet
    extends TimeCycleSplineSet {
        ElevationSet() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(this.get(t, time, view, cache));
            }
            return this.mContinue;
        }
    }
}

