/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.constraint.R;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;

public class ImageFilterView
extends AppCompatImageView {
    private ImageMatrix mImageMatrix = new ImageMatrix();
    private boolean mOverlay = true;
    private float mCrossfade = 0.0f;
    private float mRoundPercent = 0.0f;
    private float mRound = Float.NaN;
    private Path mPath;
    ViewOutlineProvider mViewOutlineProvider;
    RectF mRect;
    Drawable[] mLayers;
    LayerDrawable mLayer;

    public ImageFilterView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ImageFilterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ImageFilterView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ImageFilterView);
            int N = a.getIndexCount();
            Drawable drawable = a.getDrawable(R.styleable.ImageFilterView_altSrc);
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.ImageFilterView_crossfade) {
                    this.mCrossfade = a.getFloat(attr, 0.0f);
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_warmth) {
                    this.setWarmth(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_saturation) {
                    this.setSaturation(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_contrast) {
                    this.setContrast(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_round) {
                    this.setRound(a.getDimension(attr, 0.0f));
                    continue;
                }
                if (attr == R.styleable.ImageFilterView_roundPercent) {
                    this.setRoundPercent(a.getFloat(attr, 0.0f));
                    continue;
                }
                if (attr != R.styleable.ImageFilterView_overlay) continue;
                this.setOverlay(a.getBoolean(attr, this.mOverlay));
            }
            a.recycle();
            if (drawable != null) {
                this.mLayers = new Drawable[2];
                this.mLayers[0] = this.getDrawable();
                this.mLayers[1] = drawable;
                this.mLayer = new LayerDrawable(this.mLayers);
                this.mLayer.getDrawable(1).setAlpha((int)(255.0f * this.mCrossfade));
                super.setImageDrawable((Drawable)this.mLayer);
            }
        }
    }

    private void setOverlay(boolean overlay) {
        this.mOverlay = overlay;
    }

    public void setSaturation(float saturation) {
        this.mImageMatrix.mSaturation = saturation;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getSaturation() {
        return this.mImageMatrix.mSaturation;
    }

    public void setContrast(float contrast) {
        this.mImageMatrix.mContrast = contrast;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getContrast() {
        return this.mImageMatrix.mContrast;
    }

    public void setWarmth(float warmth) {
        this.mImageMatrix.mWarmth = warmth;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getWarmth() {
        return this.mImageMatrix.mWarmth;
    }

    public void setCrossfade(float crossfade) {
        this.mCrossfade = crossfade;
        if (this.mLayers != null) {
            if (!this.mOverlay) {
                this.mLayer.getDrawable(0).setAlpha((int)(255.0f * (1.0f - this.mCrossfade)));
            }
            this.mLayer.getDrawable(1).setAlpha((int)(255.0f * this.mCrossfade));
            super.setImageDrawable((Drawable)this.mLayer);
        }
    }

    public float getCrossfade() {
        return this.mCrossfade;
    }

    public void setBrightness(float brightness) {
        this.mImageMatrix.mBrightness = brightness;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public float getBrightness() {
        return this.mImageMatrix.mBrightness;
    }

    @RequiresApi(value=21)
    public void setRoundPercent(float round) {
        boolean change = this.mRoundPercent != round;
        this.mRoundPercent = round;
        if (this.mRoundPercent != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = ImageFilterView.this.getWidth();
                            int h = ImageFilterView.this.getHeight();
                            float r = (float)Math.min(w, h) * ImageFilterView.this.mRoundPercent / 2.0f;
                            outline.setRoundRect(0, 0, w, h, r);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            float r = (float)Math.min(w, h) * this.mRoundPercent / 2.0f;
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, r, r, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    @RequiresApi(value=21)
    public void setRound(float round) {
        if (Float.isNaN(round)) {
            this.mRound = round;
            float tmp = this.mRoundPercent;
            this.mRoundPercent = -1.0f;
            this.setRoundPercent(tmp);
            return;
        }
        boolean change = this.mRound != round;
        this.mRound = round;
        if (this.mRound != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int w = ImageFilterView.this.getWidth();
                            int h = ImageFilterView.this.getHeight();
                            outline.setRoundRect(0, 0, w, h, ImageFilterView.this.mRound);
                        }
                    };
                    this.setOutlineProvider(this.mViewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int w = this.getWidth();
            int h = this.getHeight();
            this.mRect.set(0.0f, 0.0f, (float)w, (float)h);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, this.mRound, this.mRound, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (change && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public float getRoundPercent() {
        return this.mRoundPercent;
    }

    public float getRound() {
        return this.mRound;
    }

    public void draw(Canvas canvas) {
        boolean clip = false;
        if (Build.VERSION.SDK_INT < 21 && this.mRoundPercent != 0.0f && this.mPath != null) {
            clip = true;
            canvas.save();
            canvas.clipPath(this.mPath);
        }
        super.draw(canvas);
        if (clip) {
            canvas.restore();
        }
    }

    static class ImageMatrix {
        float[] m = new float[20];
        ColorMatrix mColorMatrix = new ColorMatrix();
        ColorMatrix mTmpColorMatrix = new ColorMatrix();
        float mBrightness = 1.0f;
        float mSaturation = 1.0f;
        float mContrast = 1.0f;
        float mWarmth = 1.0f;

        ImageMatrix() {
        }

        private void saturation(float saturationStrength) {
            float Rf = 0.2999f;
            float Gf = 0.587f;
            float Bf = 0.114f;
            float S = saturationStrength;
            float MS = 1.0f - S;
            float Rt = Rf * MS;
            float Gt = Gf * MS;
            float Bt = Bf * MS;
            this.m[0] = Rt + S;
            this.m[1] = Gt;
            this.m[2] = Bt;
            this.m[3] = 0.0f;
            this.m[4] = 0.0f;
            this.m[5] = Rt;
            this.m[6] = Gt + S;
            this.m[7] = Bt;
            this.m[8] = 0.0f;
            this.m[9] = 0.0f;
            this.m[10] = Rt;
            this.m[11] = Gt;
            this.m[12] = Bt + S;
            this.m[13] = 0.0f;
            this.m[14] = 0.0f;
            this.m[15] = 0.0f;
            this.m[16] = 0.0f;
            this.m[17] = 0.0f;
            this.m[18] = 1.0f;
            this.m[19] = 0.0f;
        }

        private void warmth(float warmth) {
            float colorG;
            float colorR;
            float colorG2;
            float colorR2;
            float kelvin;
            float centiKelvin;
            float baseTemprature = 5000.0f;
            if (warmth <= 0.0f) {
                warmth = 0.01f;
            }
            if ((centiKelvin = (kelvin = baseTemprature / warmth) / 100.0f) > 66.0f) {
                float tmp = centiKelvin - 60.0f;
                colorR2 = 329.69873f * (float)Math.pow(tmp, -0.13320475816726685);
                colorG2 = 288.12216f * (float)Math.pow(tmp, 0.07551484555006027);
            } else {
                colorG2 = 99.4708f * (float)Math.log(centiKelvin) - 161.11957f;
                colorR2 = 255.0f;
            }
            float colorB = centiKelvin < 66.0f ? (centiKelvin > 19.0f ? 138.51773f * (float)Math.log(centiKelvin - 10.0f) - 305.0448f : 0.0f) : 255.0f;
            float tmpColor_r = Math.min(255.0f, Math.max(colorR2, 0.0f));
            float tmpColor_g = Math.min(255.0f, Math.max(colorG2, 0.0f));
            float tmpColor_b = Math.min(255.0f, Math.max(colorB, 0.0f));
            float color_r = tmpColor_r;
            float color_g = tmpColor_g;
            float color_b = tmpColor_b;
            kelvin = baseTemprature;
            float centiKelvin2 = kelvin / 100.0f;
            if (centiKelvin2 > 66.0f) {
                float tmp = centiKelvin2 - 60.0f;
                colorR = 329.69873f * (float)Math.pow(tmp, -0.13320475816726685);
                colorG = 288.12216f * (float)Math.pow(tmp, 0.07551484555006027);
            } else {
                colorG = 99.4708f * (float)Math.log(centiKelvin2) - 161.11957f;
                colorR = 255.0f;
            }
            float colorB2 = centiKelvin2 < 66.0f ? (centiKelvin2 > 19.0f ? 138.51773f * (float)Math.log(centiKelvin2 - 10.0f) - 305.0448f : 0.0f) : 255.0f;
            tmpColor_r = Math.min(255.0f, Math.max(colorR, 0.0f));
            tmpColor_g = Math.min(255.0f, Math.max(colorG, 0.0f));
            tmpColor_b = Math.min(255.0f, Math.max(colorB2, 0.0f));
            color_g /= tmpColor_g;
            color_b /= tmpColor_b;
            this.m[0] = color_r /= tmpColor_r;
            this.m[1] = 0.0f;
            this.m[2] = 0.0f;
            this.m[3] = 0.0f;
            this.m[4] = 0.0f;
            this.m[5] = 0.0f;
            this.m[6] = color_g;
            this.m[7] = 0.0f;
            this.m[8] = 0.0f;
            this.m[9] = 0.0f;
            this.m[10] = 0.0f;
            this.m[11] = 0.0f;
            this.m[12] = color_b;
            this.m[13] = 0.0f;
            this.m[14] = 0.0f;
            this.m[15] = 0.0f;
            this.m[16] = 0.0f;
            this.m[17] = 0.0f;
            this.m[18] = 1.0f;
            this.m[19] = 0.0f;
        }

        private void brightness(float brightness) {
            this.m[0] = brightness;
            this.m[1] = 0.0f;
            this.m[2] = 0.0f;
            this.m[3] = 0.0f;
            this.m[4] = 0.0f;
            this.m[5] = 0.0f;
            this.m[6] = brightness;
            this.m[7] = 0.0f;
            this.m[8] = 0.0f;
            this.m[9] = 0.0f;
            this.m[10] = 0.0f;
            this.m[11] = 0.0f;
            this.m[12] = brightness;
            this.m[13] = 0.0f;
            this.m[14] = 0.0f;
            this.m[15] = 0.0f;
            this.m[16] = 0.0f;
            this.m[17] = 0.0f;
            this.m[18] = 1.0f;
            this.m[19] = 0.0f;
        }

        void updateMatrix(ImageView view) {
            this.mColorMatrix.reset();
            boolean filter = false;
            if (this.mSaturation != 1.0f) {
                this.saturation(this.mSaturation);
                this.mColorMatrix.set(this.m);
                filter = true;
            }
            if (this.mContrast != 1.0f) {
                this.mTmpColorMatrix.setScale(this.mContrast, this.mContrast, this.mContrast, 1.0f);
                this.mColorMatrix.postConcat(this.mTmpColorMatrix);
                filter = true;
            }
            if (this.mWarmth != 1.0f) {
                this.warmth(this.mWarmth);
                this.mTmpColorMatrix.set(this.m);
                this.mColorMatrix.postConcat(this.mTmpColorMatrix);
                filter = true;
            }
            if (this.mBrightness != 1.0f) {
                this.brightness(this.mBrightness);
                this.mTmpColorMatrix.set(this.m);
                this.mColorMatrix.postConcat(this.mTmpColorMatrix);
                filter = true;
            }
            if (filter) {
                view.setColorFilter((ColorFilter)new ColorMatrixColorFilter(this.mColorMatrix));
            } else {
                view.clearColorFilter();
            }
        }
    }
}

