/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.constraint.R;
import android.util.AttributeSet;
import android.view.View;

public class MockView
extends View {
    private Paint mPaintDiagonals = new Paint();
    private Paint mPaintText = new Paint();
    private Paint mPaintTextBackground = new Paint();
    private boolean mDrawDiagonals = true;
    private boolean mDrawLabel = true;
    protected String mText = null;
    private Rect mTextBounds = new Rect();
    private int mDiagonalsColor = Color.argb((int)255, (int)0, (int)0, (int)0);
    private int mTextColor = Color.argb((int)255, (int)200, (int)200, (int)200);
    private int mTextBackgroundColor = Color.argb((int)255, (int)50, (int)50, (int)50);
    private int mMargin = 4;

    public MockView(Context context) {
        super(context);
        this.init(context, null);
    }

    public MockView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MockView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MockView);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.MockView_mock_label) {
                    this.mText = a.getString(attr);
                    continue;
                }
                if (attr == R.styleable.MockView_mock_showDiagonals) {
                    this.mDrawDiagonals = a.getBoolean(attr, this.mDrawDiagonals);
                    continue;
                }
                if (attr == R.styleable.MockView_mock_diagonalsColor) {
                    this.mDiagonalsColor = a.getColor(attr, this.mDiagonalsColor);
                    continue;
                }
                if (attr == R.styleable.MockView_mock_labelBackgroundColor) {
                    this.mTextBackgroundColor = a.getColor(attr, this.mTextBackgroundColor);
                    continue;
                }
                if (attr == R.styleable.MockView_mock_labelColor) {
                    this.mTextColor = a.getColor(attr, this.mTextColor);
                    continue;
                }
                if (attr != R.styleable.MockView_mock_showLabel) continue;
                this.mDrawLabel = a.getBoolean(attr, this.mDrawLabel);
            }
            a.recycle();
        }
        if (this.mText == null) {
            try {
                this.mText = context.getResources().getResourceEntryName(this.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mPaintDiagonals.setColor(this.mDiagonalsColor);
        this.mPaintDiagonals.setAntiAlias(true);
        this.mPaintText.setColor(this.mTextColor);
        this.mPaintText.setAntiAlias(true);
        this.mPaintTextBackground.setColor(this.mTextBackgroundColor);
        this.mMargin = Math.round((float)this.mMargin * (this.getResources().getDisplayMetrics().xdpi / 160.0f));
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.mDrawDiagonals) {
            canvas.drawLine(0.0f, 0.0f, (float)(--w), (float)(--h), this.mPaintDiagonals);
            canvas.drawLine(0.0f, (float)h, (float)w, 0.0f, this.mPaintDiagonals);
            canvas.drawLine(0.0f, 0.0f, (float)w, 0.0f, this.mPaintDiagonals);
            canvas.drawLine((float)w, 0.0f, (float)w, (float)h, this.mPaintDiagonals);
            canvas.drawLine((float)w, (float)h, 0.0f, (float)h, this.mPaintDiagonals);
            canvas.drawLine(0.0f, (float)h, 0.0f, 0.0f, this.mPaintDiagonals);
        }
        if (this.mText != null && this.mDrawLabel) {
            this.mPaintText.getTextBounds(this.mText, 0, this.mText.length(), this.mTextBounds);
            float tx = (float)(w - this.mTextBounds.width()) / 2.0f;
            float ty = (float)(h - this.mTextBounds.height()) / 2.0f + (float)this.mTextBounds.height();
            this.mTextBounds.offset((int)tx, (int)ty);
            this.mTextBounds.set(this.mTextBounds.left - this.mMargin, this.mTextBounds.top - this.mMargin, this.mTextBounds.right + this.mMargin, this.mTextBounds.bottom + this.mMargin);
            canvas.drawRect(this.mTextBounds, this.mPaintTextBackground);
            canvas.drawText(this.mText, tx, ty, this.mPaintText);
        }
    }
}

