/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.circularreveal;

import android.animation.TypeEvaluator;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.design.circularreveal.CircularRevealHelper;
import android.support.design.math.MathUtils;
import android.util.Property;

public interface CircularRevealWidget
extends CircularRevealHelper.Delegate {
    public void draw(Canvas var1);

    public boolean isOpaque();

    public void buildCircularRevealCache();

    public void destroyCircularRevealCache();

    @Nullable
    public RevealInfo getRevealInfo();

    public void setRevealInfo(@Nullable RevealInfo var1);

    @ColorInt
    public int getCircularRevealScrimColor();

    public void setCircularRevealScrimColor(@ColorInt int var1);

    @Nullable
    public Drawable getCircularRevealOverlayDrawable();

    public void setCircularRevealOverlayDrawable(@Nullable Drawable var1);

    public static class CircularRevealScrimColorProperty
    extends Property<CircularRevealWidget, Integer> {
        public static final Property<CircularRevealWidget, Integer> CIRCULAR_REVEAL_SCRIM_COLOR = new CircularRevealScrimColorProperty("circularRevealScrimColor");

        private CircularRevealScrimColorProperty(String name) {
            super(Integer.class, name);
        }

        public Integer get(CircularRevealWidget object) {
            return object.getCircularRevealScrimColor();
        }

        public void set(CircularRevealWidget object, Integer value) {
            object.setCircularRevealScrimColor(value);
        }
    }

    public static class CircularRevealEvaluator
    implements TypeEvaluator<RevealInfo> {
        public static final TypeEvaluator<RevealInfo> CIRCULAR_REVEAL = new CircularRevealEvaluator();
        private final RevealInfo revealInfo = new RevealInfo();

        public RevealInfo evaluate(float fraction, RevealInfo startValue, RevealInfo endValue) {
            this.revealInfo.set(MathUtils.lerp((float)startValue.centerX, (float)endValue.centerX, (float)fraction), MathUtils.lerp((float)startValue.centerY, (float)endValue.centerY, (float)fraction), MathUtils.lerp((float)startValue.radius, (float)endValue.radius, (float)fraction));
            return this.revealInfo;
        }
    }

    public static class CircularRevealProperty
    extends Property<CircularRevealWidget, RevealInfo> {
        public static final Property<CircularRevealWidget, RevealInfo> CIRCULAR_REVEAL = new CircularRevealProperty("circularReveal");

        private CircularRevealProperty(String name) {
            super(RevealInfo.class, name);
        }

        public RevealInfo get(CircularRevealWidget object) {
            return object.getRevealInfo();
        }

        public void set(CircularRevealWidget object, RevealInfo value) {
            object.setRevealInfo(value);
        }
    }

    public static class RevealInfo {
        public static final float INVALID_RADIUS = Float.MAX_VALUE;
        public float centerX;
        public float centerY;
        public float radius;

        private RevealInfo() {
        }

        public RevealInfo(float centerX, float centerY, float radius) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
        }

        public RevealInfo(RevealInfo other) {
            this(other.centerX, other.centerY, other.radius);
        }

        public void set(float centerX, float centerY, float radius) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
        }

        public void set(RevealInfo other) {
            this.set(other.centerX, other.centerY, other.radius);
        }

        public boolean isInvalid() {
            return this.radius == Float.MAX_VALUE;
        }
    }
}

