/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.design.R;
import android.support.design.internal.BottomNavigationAnimationHelperBase;
import android.support.design.internal.BottomNavigationAnimationHelperIcs;
import android.support.design.internal.BottomNavigationItemView;
import android.support.design.internal.BottomNavigationPresenter;
import android.support.v4.util.Pools;
import android.support.v4.view.ViewCompat;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.view.menu.MenuItemImpl;
import android.support.v7.view.menu.MenuPresenter;
import android.support.v7.view.menu.MenuView;
import android.util.AttributeSet;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;

@RestrictTo(value={RestrictTo.Scope.GROUP_ID})
public class BottomNavigationMenuView
extends ViewGroup
implements MenuView {
    private final int mInactiveItemMaxWidth;
    private final int mInactiveItemMinWidth;
    private final int mActiveItemMaxWidth;
    private final int mItemHeight;
    private final View.OnClickListener mOnClickListener;
    private final BottomNavigationAnimationHelperBase mAnimationHelper;
    private static final Pools.Pool<BottomNavigationItemView> sItemPool = new Pools.SynchronizedPool(5);
    private boolean mShiftingMode = true;
    private BottomNavigationItemView[] mButtons;
    private int mActiveButton = 0;
    private ColorStateList mItemIconTint;
    private ColorStateList mItemTextColor;
    private int mItemBackgroundRes;
    private BottomNavigationPresenter mPresenter;
    private MenuBuilder mMenu;

    public BottomNavigationMenuView(Context context) {
        this(context, null);
    }

    public BottomNavigationMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = this.getResources();
        this.mInactiveItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_max_width);
        this.mInactiveItemMinWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_item_min_width);
        this.mActiveItemMaxWidth = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_active_item_max_width);
        this.mItemHeight = res.getDimensionPixelSize(R.dimen.design_bottom_navigation_height);
        this.mAnimationHelper = Build.VERSION.SDK_INT >= 14 ? new BottomNavigationAnimationHelperIcs() : new BottomNavigationAnimationHelperBase();
        this.mOnClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                BottomNavigationItemView itemView = (BottomNavigationItemView)v;
                int itemPosition = itemView.getItemPosition();
                BottomNavigationMenuView.this.activateNewButton(itemPosition);
                BottomNavigationMenuView.this.mMenu.performItemAction((MenuItem)itemView.getItemData(), (MenuPresenter)BottomNavigationMenuView.this.mPresenter, 0);
            }
        };
    }

    public void initialize(MenuBuilder menu) {
        this.mMenu = menu;
        if (this.mMenu == null) {
            return;
        }
        if (this.mMenu.size() > this.mActiveButton) {
            this.mMenu.getItem(this.mActiveButton).setChecked(true);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int count = this.getChildCount();
        boolean childState = false;
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mItemHeight, (int)0x40000000);
        int[] childWidths = new int[count];
        if (this.mShiftingMode) {
            int inactiveCount = count - 1;
            int activeMaxAvailable = width - inactiveCount * this.mInactiveItemMinWidth;
            int activeWidth = Math.min(activeMaxAvailable, this.mActiveItemMaxWidth);
            int inactiveMaxAvailable = (width - activeWidth) / inactiveCount;
            int inactiveWidth = Math.min(inactiveMaxAvailable, this.mInactiveItemMaxWidth);
            int extra = width - activeWidth - inactiveWidth * inactiveCount;
            for (int i = 0; i < count; ++i) {
                int n = childWidths[i] = i == this.mActiveButton ? activeWidth : inactiveWidth;
                if (extra <= 0) continue;
                int n2 = i;
                childWidths[n2] = childWidths[n2] + 1;
                --extra;
            }
        } else {
            int maxAvailable = width / count;
            int childWidth = Math.min(maxAvailable, this.mActiveItemMaxWidth);
            int extra = width - childWidth * count;
            for (int i = 0; i < count; ++i) {
                childWidths[i] = childWidth;
                if (extra <= 0) continue;
                int n = i;
                childWidths[n] = childWidths[n] + 1;
                --extra;
            }
        }
        int totalWidth = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidths[i], (int)0x40000000), heightSpec);
            ViewGroup.LayoutParams params = child.getLayoutParams();
            params.width = child.getMeasuredWidth();
            totalWidth += child.getMeasuredWidth();
        }
        this.setMeasuredDimension(ViewCompat.resolveSizeAndState((int)totalWidth, (int)View.MeasureSpec.makeMeasureSpec((int)totalWidth, (int)0x40000000), (int)0), ViewCompat.resolveSizeAndState((int)this.mItemHeight, (int)heightSpec, (int)0));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int width = right - left;
        int height = bottom - top;
        int used = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            if (ViewCompat.getLayoutDirection((View)this) == 1) {
                child.layout(width - used - child.getMeasuredWidth(), 0, width - used, height);
            } else {
                child.layout(used, 0, child.getMeasuredWidth() + used, height);
            }
            used += child.getMeasuredWidth();
        }
    }

    public int getWindowAnimations() {
        return 0;
    }

    public void setIconTintList(ColorStateList color) {
        this.mItemIconTint = color;
        if (this.mButtons == null) {
            return;
        }
        for (BottomNavigationItemView item : this.mButtons) {
            item.setIconTintList(color);
        }
    }

    @Nullable
    public ColorStateList getIconTintList() {
        return this.mItemIconTint;
    }

    public void setItemTextColor(ColorStateList color) {
        this.mItemTextColor = color;
        if (this.mButtons == null) {
            return;
        }
        for (BottomNavigationItemView item : this.mButtons) {
            item.setTextColor(color);
        }
    }

    public ColorStateList getItemTextColor() {
        return this.mItemTextColor;
    }

    public void setItemBackgroundRes(int background) {
        this.mItemBackgroundRes = background;
        if (this.mButtons == null) {
            return;
        }
        for (BottomNavigationItemView item : this.mButtons) {
            item.setItemBackground(background);
        }
    }

    public int getItemBackgroundRes() {
        return this.mItemBackgroundRes;
    }

    public void setPresenter(BottomNavigationPresenter presenter) {
        this.mPresenter = presenter;
    }

    public void buildMenuView() {
        if (this.mButtons != null) {
            for (BottomNavigationItemView item : this.mButtons) {
                sItemPool.release((Object)item);
            }
        }
        this.removeAllViews();
        this.mButtons = new BottomNavigationItemView[this.mMenu.size()];
        this.mShiftingMode = this.mMenu.size() > 3;
        for (int i = 0; i < this.mMenu.size(); ++i) {
            BottomNavigationItemView child;
            this.mPresenter.setUpdateSuspended(true);
            this.mMenu.getItem(i).setCheckable(true);
            this.mPresenter.setUpdateSuspended(false);
            this.mButtons[i] = child = this.getNewItem();
            child.setIconTintList(this.mItemIconTint);
            child.setTextColor(this.mItemTextColor);
            child.setItemBackground(this.mItemBackgroundRes);
            child.setShiftingMode(this.mShiftingMode);
            child.initialize((MenuItemImpl)this.mMenu.getItem(i), 0);
            child.setItemPosition(i);
            child.setOnClickListener(this.mOnClickListener);
            this.addView((View)child);
        }
    }

    public void updateMenuView() {
        int menuSize = this.mMenu.size();
        if (menuSize != this.mButtons.length) {
            this.buildMenuView();
            return;
        }
        for (int i = 0; i < menuSize; ++i) {
            this.mPresenter.setUpdateSuspended(true);
            this.mButtons[i].initialize((MenuItemImpl)this.mMenu.getItem(i), 0);
            this.mPresenter.setUpdateSuspended(false);
        }
    }

    private void activateNewButton(int newButton) {
        if (this.mActiveButton == newButton) {
            return;
        }
        this.mAnimationHelper.beginDelayedTransition(this);
        this.mPresenter.setUpdateSuspended(true);
        this.mButtons[this.mActiveButton].setChecked(false);
        this.mButtons[newButton].setChecked(true);
        this.mPresenter.setUpdateSuspended(false);
        this.mActiveButton = newButton;
    }

    private BottomNavigationItemView getNewItem() {
        BottomNavigationItemView item = (BottomNavigationItemView)((Object)sItemPool.acquire());
        if (item == null) {
            item = new BottomNavigationItemView(this.getContext());
        }
        return item;
    }
}

