/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.FloatingActionButtonImpl;
import android.support.design.widget.ShadowDrawableWrapper;
import android.support.design.widget.ShadowViewDelegate;
import android.support.design.widget.StateListAnimator;
import android.support.design.widget.ValueAnimatorCompat;
import android.support.design.widget.VisibilityAwareImageButton;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.view.animation.Animation;

class FloatingActionButtonGingerbread
extends FloatingActionButtonImpl {
    private final StateListAnimator mStateListAnimator = new StateListAnimator();
    ShadowDrawableWrapper mShadowDrawable;

    FloatingActionButtonGingerbread(VisibilityAwareImageButton view, ShadowViewDelegate shadowViewDelegate, ValueAnimatorCompat.Creator animatorCreator) {
        super(view, shadowViewDelegate, animatorCreator);
        this.mStateListAnimator.addState(PRESSED_ENABLED_STATE_SET, this.createAnimator(new ElevateToTranslationZAnimation()));
        this.mStateListAnimator.addState(FOCUSED_ENABLED_STATE_SET, this.createAnimator(new ElevateToTranslationZAnimation()));
        this.mStateListAnimator.addState(ENABLED_STATE_SET, this.createAnimator(new ResetElevationAnimation()));
        this.mStateListAnimator.addState(EMPTY_STATE_SET, this.createAnimator(new DisabledElevationAnimation()));
    }

    @Override
    void setBackgroundDrawable(ColorStateList backgroundTint, PorterDuff.Mode backgroundTintMode, int rippleColor, int borderWidth) {
        Drawable[] layers;
        this.mShapeDrawable = DrawableCompat.wrap((Drawable)this.createShapeDrawable());
        DrawableCompat.setTintList((Drawable)this.mShapeDrawable, (ColorStateList)backgroundTint);
        if (backgroundTintMode != null) {
            DrawableCompat.setTintMode((Drawable)this.mShapeDrawable, (PorterDuff.Mode)backgroundTintMode);
        }
        GradientDrawable touchFeedbackShape = this.createShapeDrawable();
        this.mRippleDrawable = DrawableCompat.wrap((Drawable)touchFeedbackShape);
        DrawableCompat.setTintList((Drawable)this.mRippleDrawable, (ColorStateList)FloatingActionButtonGingerbread.createColorStateList(rippleColor));
        if (borderWidth > 0) {
            this.mBorderDrawable = this.createBorderDrawable(borderWidth, backgroundTint);
            layers = new Drawable[]{this.mBorderDrawable, this.mShapeDrawable, this.mRippleDrawable};
        } else {
            this.mBorderDrawable = null;
            layers = new Drawable[]{this.mShapeDrawable, this.mRippleDrawable};
        }
        this.mContentBackground = new LayerDrawable(layers);
        this.mShadowDrawable = new ShadowDrawableWrapper(this.mView.getContext(), this.mContentBackground, this.mShadowViewDelegate.getRadius(), this.mElevation, this.mElevation + this.mPressedTranslationZ);
        this.mShadowDrawable.setAddPaddingForCorners(false);
        this.mShadowViewDelegate.setBackgroundDrawable((Drawable)this.mShadowDrawable);
    }

    @Override
    void setBackgroundTintList(ColorStateList tint) {
        if (this.mShapeDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mShapeDrawable, (ColorStateList)tint);
        }
        if (this.mBorderDrawable != null) {
            this.mBorderDrawable.setBorderTint(tint);
        }
    }

    @Override
    void setBackgroundTintMode(PorterDuff.Mode tintMode) {
        if (this.mShapeDrawable != null) {
            DrawableCompat.setTintMode((Drawable)this.mShapeDrawable, (PorterDuff.Mode)tintMode);
        }
    }

    @Override
    void setRippleColor(int rippleColor) {
        if (this.mRippleDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mRippleDrawable, (ColorStateList)FloatingActionButtonGingerbread.createColorStateList(rippleColor));
        }
    }

    @Override
    float getElevation() {
        return this.mElevation;
    }

    @Override
    void onElevationsChanged(float elevation, float pressedTranslationZ) {
        if (this.mShadowDrawable != null) {
            this.mShadowDrawable.setShadowSize(elevation, elevation + this.mPressedTranslationZ);
            this.updatePadding();
        }
    }

    @Override
    void onDrawableStateChanged(int[] state) {
        this.mStateListAnimator.setState(state);
    }

    @Override
    void jumpDrawableToCurrentState() {
        this.mStateListAnimator.jumpToCurrentState();
    }

    @Override
    void hide(final @Nullable FloatingActionButtonImpl.InternalVisibilityChangedListener listener, final boolean fromUser) {
        if (this.isOrWillBeHidden()) {
            return;
        }
        this.mAnimState = 1;
        Animation anim2 = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.design_fab_out);
        anim2.setInterpolator(AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR);
        anim2.setDuration(200L);
        anim2.setAnimationListener((Animation.AnimationListener)new AnimationUtils.AnimationListenerAdapter(){

            @Override
            public void onAnimationEnd(Animation animation) {
                FloatingActionButtonGingerbread.this.mAnimState = 0;
                FloatingActionButtonGingerbread.this.mView.internalSetVisibility(8, fromUser);
                if (listener != null) {
                    listener.onHidden();
                }
            }
        });
        this.mView.startAnimation(anim2);
    }

    @Override
    void show(final @Nullable FloatingActionButtonImpl.InternalVisibilityChangedListener listener, boolean fromUser) {
        if (this.isOrWillBeShown()) {
            return;
        }
        this.mAnimState = 2;
        this.mView.internalSetVisibility(0, fromUser);
        Animation anim2 = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.design_fab_in);
        anim2.setDuration(200L);
        anim2.setInterpolator(AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
        anim2.setAnimationListener((Animation.AnimationListener)new AnimationUtils.AnimationListenerAdapter(){

            @Override
            public void onAnimationEnd(Animation animation) {
                FloatingActionButtonGingerbread.this.mAnimState = 0;
                if (listener != null) {
                    listener.onShown();
                }
            }
        });
        this.mView.startAnimation(anim2);
    }

    @Override
    void onCompatShadowChanged() {
    }

    @Override
    void getPadding(Rect rect) {
        this.mShadowDrawable.getPadding(rect);
    }

    private ValueAnimatorCompat createAnimator(@NonNull ShadowAnimatorImpl impl) {
        ValueAnimatorCompat animator = this.mAnimatorCreator.createAnimator();
        animator.setInterpolator(ANIM_INTERPOLATOR);
        animator.setDuration(100L);
        animator.addListener(impl);
        animator.addUpdateListener(impl);
        animator.setFloatValues(0.0f, 1.0f);
        return animator;
    }

    private static ColorStateList createColorStateList(int selectedColor) {
        int[][] states = new int[3][];
        int[] colors = new int[3];
        int i = 0;
        states[i] = FOCUSED_ENABLED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = PRESSED_ENABLED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = new int[0];
        colors[i] = 0;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private class DisabledElevationAnimation
    extends ShadowAnimatorImpl {
        DisabledElevationAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return 0.0f;
        }
    }

    private class ElevateToTranslationZAnimation
    extends ShadowAnimatorImpl {
        ElevateToTranslationZAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return FloatingActionButtonGingerbread.this.mElevation + FloatingActionButtonGingerbread.this.mPressedTranslationZ;
        }
    }

    private class ResetElevationAnimation
    extends ShadowAnimatorImpl {
        ResetElevationAnimation() {
        }

        @Override
        protected float getTargetShadowSize() {
            return FloatingActionButtonGingerbread.this.mElevation;
        }
    }

    private abstract class ShadowAnimatorImpl
    extends ValueAnimatorCompat.AnimatorListenerAdapter
    implements ValueAnimatorCompat.AnimatorUpdateListener {
        private boolean mValidValues;
        private float mShadowSizeStart;
        private float mShadowSizeEnd;

        private ShadowAnimatorImpl() {
        }

        @Override
        public void onAnimationUpdate(ValueAnimatorCompat animator) {
            if (!this.mValidValues) {
                this.mShadowSizeStart = FloatingActionButtonGingerbread.this.mShadowDrawable.getShadowSize();
                this.mShadowSizeEnd = this.getTargetShadowSize();
                this.mValidValues = true;
            }
            FloatingActionButtonGingerbread.this.mShadowDrawable.setShadowSize(this.mShadowSizeStart + (this.mShadowSizeEnd - this.mShadowSizeStart) * animator.getAnimatedFraction());
        }

        @Override
        public void onAnimationEnd(ValueAnimatorCompat animator) {
            FloatingActionButtonGingerbread.this.mShadowDrawable.setShadowSize(this.mShadowSizeEnd);
            this.mValidValues = false;
        }

        protected abstract float getTargetShadowSize();
    }
}

