/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.support.design.widget.ValueAnimatorCompat;
import android.util.StateSet;
import java.util.ArrayList;

final class StateListAnimator {
    private final ArrayList<Tuple> mTuples = new ArrayList();
    private Tuple mLastMatch = null;
    ValueAnimatorCompat mRunningAnimator = null;
    private final ValueAnimatorCompat.AnimatorListener mAnimationListener = new ValueAnimatorCompat.AnimatorListenerAdapter(){

        @Override
        public void onAnimationEnd(ValueAnimatorCompat animator) {
            if (StateListAnimator.this.mRunningAnimator == animator) {
                StateListAnimator.this.mRunningAnimator = null;
            }
        }
    };

    StateListAnimator() {
    }

    public void addState(int[] specs, ValueAnimatorCompat animator) {
        Tuple tuple = new Tuple(specs, animator);
        animator.addListener(this.mAnimationListener);
        this.mTuples.add(tuple);
    }

    void setState(int[] state) {
        Tuple match = null;
        int count = this.mTuples.size();
        for (int i = 0; i < count; ++i) {
            Tuple tuple = this.mTuples.get(i);
            if (!StateSet.stateSetMatches((int[])tuple.mSpecs, (int[])state)) continue;
            match = tuple;
            break;
        }
        if (match == this.mLastMatch) {
            return;
        }
        if (this.mLastMatch != null) {
            this.cancel();
        }
        this.mLastMatch = match;
        if (match != null) {
            this.start(match);
        }
    }

    private void start(Tuple match) {
        this.mRunningAnimator = match.mAnimator;
        this.mRunningAnimator.start();
    }

    private void cancel() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.cancel();
            this.mRunningAnimator = null;
        }
    }

    public void jumpToCurrentState() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.end();
            this.mRunningAnimator = null;
        }
    }

    static class Tuple {
        final int[] mSpecs;
        final ValueAnimatorCompat mAnimator;

        Tuple(int[] specs, ValueAnimatorCompat animator) {
            this.mSpecs = specs;
            this.mAnimator = animator;
        }
    }
}

