/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.bottomappbar;

import android.support.design.shape.EdgeTreatment;
import android.support.design.shape.ShapePath;

public class BottomAppBarTopEdgeTreatment
extends EdgeTreatment {
    private static final int ARC_QUARTER = 90;
    private static final int ARC_HALF = 180;
    private static final int ANGLE_UP = 270;
    private static final int ANGLE_LEFT = 180;
    private float roundedCornerRadius;
    private float fabMargin;
    private float fabDiameter;
    private float cradleVerticalOffset;
    private float horizontalOffset;

    public BottomAppBarTopEdgeTreatment(float fabMargin, float roundedCornerRadius, float cradleVerticalOffset) {
        this.fabMargin = fabMargin;
        this.roundedCornerRadius = roundedCornerRadius;
        this.cradleVerticalOffset = cradleVerticalOffset;
        if (cradleVerticalOffset < 0.0f) {
            throw new IllegalArgumentException("cradleVerticalOffset must be positive.");
        }
        this.horizontalOffset = 0.0f;
    }

    @Override
    public void getEdgePath(float length, float interpolation, ShapePath shapePath) {
        float cradleDiameter = this.fabMargin * 2.0f + this.fabDiameter;
        float cradleRadius = cradleDiameter / 2.0f;
        float roundedCornerOffset = interpolation * this.roundedCornerRadius;
        float middle = length / 2.0f + this.horizontalOffset;
        float verticalOffset = interpolation * this.cradleVerticalOffset + (1.0f - interpolation) * cradleRadius;
        float verticalOffsetRatio = verticalOffset / cradleRadius;
        if (verticalOffsetRatio >= 1.0f) {
            shapePath.lineTo(length, 0.0f);
            return;
        }
        float distanceBetweenCenters = cradleRadius + roundedCornerOffset;
        float distanceBetweenCentersSquared = distanceBetweenCenters * distanceBetweenCenters;
        float distanceY = verticalOffset + roundedCornerOffset;
        float distanceX = (float)Math.sqrt(distanceBetweenCentersSquared - distanceY * distanceY);
        float leftRoundedCornerCircleX = middle - distanceX;
        float rightRoundedCornerCircleX = middle + distanceX;
        float cornerRadiusArcLength = (float)Math.toDegrees(Math.atan(distanceX / distanceY));
        float cutoutArcOffset = 90.0f - cornerRadiusArcLength;
        shapePath.lineTo(leftRoundedCornerCircleX - roundedCornerOffset, 0.0f);
        shapePath.addArc(leftRoundedCornerCircleX - roundedCornerOffset, 0.0f, leftRoundedCornerCircleX + roundedCornerOffset, roundedCornerOffset * 2.0f, 270.0f, cornerRadiusArcLength);
        shapePath.addArc(middle - cradleRadius, -cradleRadius - verticalOffset, middle + cradleRadius, cradleRadius - verticalOffset, 180.0f - cutoutArcOffset, cutoutArcOffset * 2.0f - 180.0f);
        shapePath.addArc(rightRoundedCornerCircleX - roundedCornerOffset, 0.0f, rightRoundedCornerCircleX + roundedCornerOffset, roundedCornerOffset * 2.0f, 270.0f - cornerRadiusArcLength, cornerRadiusArcLength);
        shapePath.lineTo(length, 0.0f);
    }

    void setHorizontalOffset(float horizontalOffset) {
        this.horizontalOffset = horizontalOffset;
    }

    float getHorizontalOffset() {
        return this.horizontalOffset;
    }

    float getCradleVerticalOffset() {
        return this.cradleVerticalOffset;
    }

    void setCradleVerticalOffset(float cradleVerticalOffset) {
        this.cradleVerticalOffset = cradleVerticalOffset;
    }

    float getFabDiameter() {
        return this.fabDiameter;
    }

    void setFabDiameter(float fabDiameter) {
        this.fabDiameter = fabDiameter;
    }

    float getFabCradleMargin() {
        return this.fabMargin;
    }

    void setFabCradleMargin(float fabMargin) {
        this.fabMargin = fabMargin;
    }

    float getFabCradleRoundedCornerRadius() {
        return this.roundedCornerRadius;
    }

    void setFabCradleRoundedCornerRadius(float roundedCornerRadius) {
        this.roundedCornerRadius = roundedCornerRadius;
    }
}

