/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.annotation.RestrictTo;
import android.support.design.R;
import android.support.design.button.MaterialButtonHelper;
import android.support.design.internal.ThemeEnforcement;
import android.support.design.internal.ViewUtils;
import android.support.design.resources.MaterialResources;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

public class MaterialButton
extends AppCompatButton {
    private static final String LOG_TAG = "MaterialButton";
    @Nullable
    private final MaterialButtonHelper materialButtonHelper;
    @Px
    private int paddingStart;
    @Px
    private int paddingEnd;
    @Px
    private int paddingTop;
    @Px
    private int paddingBottom;
    @Px
    private final int insetLeft;
    @Px
    private final int insetRight;
    @Px
    private final int insetTop;
    @Px
    private final int insetBottom;
    @Px
    private int additionalPaddingStartForIcon;
    @Px
    private int additionalPaddingEndForIcon;
    @Px
    private int iconPadding;
    private PorterDuff.Mode iconTintMode;
    private ColorStateList iconTint;
    private Drawable icon;
    @Px
    private int iconSize;

    public MaterialButton(Context context) {
        this(context, null);
    }

    public MaterialButton(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.materialButtonStyle);
    }

    public MaterialButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.MaterialButton, defStyleAttr, R.style.Widget_MaterialComponents_Button);
        int padding = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_padding, 0);
        int paddingLeft = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_paddingLeft, padding);
        this.paddingStart = Build.VERSION.SDK_INT >= 17 ? attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_paddingStart, paddingLeft) : paddingLeft;
        int paddingRight = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_paddingRight, padding);
        this.paddingEnd = Build.VERSION.SDK_INT >= 17 ? attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_paddingEnd, paddingRight) : paddingRight;
        this.paddingTop = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_paddingTop, padding);
        this.paddingBottom = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_paddingBottom, padding);
        this.insetLeft = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetLeft, 0);
        this.insetRight = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetRight, 0);
        this.insetTop = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetTop, 0);
        this.insetBottom = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_android_insetBottom, 0);
        this.additionalPaddingStartForIcon = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_additionalPaddingStartForIcon, 0);
        this.additionalPaddingEndForIcon = attributes.getDimensionPixelOffset(R.styleable.MaterialButton_additionalPaddingEndForIcon, 0);
        this.iconPadding = attributes.getDimensionPixelSize(R.styleable.MaterialButton_iconPadding, 0);
        this.iconTintMode = ViewUtils.parseTintMode(attributes.getInt(R.styleable.MaterialButton_iconTintMode, -1), PorterDuff.Mode.SRC_IN);
        this.iconTint = MaterialResources.getColorStateList(this.getContext(), attributes, R.styleable.MaterialButton_iconTint);
        this.icon = MaterialResources.getDrawable(this.getContext(), attributes, R.styleable.MaterialButton_icon);
        this.iconSize = attributes.getDimensionPixelSize(R.styleable.MaterialButton_iconSize, 0);
        this.materialButtonHelper = new MaterialButtonHelper(this);
        this.materialButtonHelper.loadFromAttributes(attributes);
        attributes.recycle();
        this.setCompoundDrawablePadding(this.iconPadding);
        this.updateIcon();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (Build.VERSION.SDK_INT < 21 && this.isUsingOriginalBackground()) {
            this.materialButtonHelper.drawStroke(canvas);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setSupportBackgroundTintList(@Nullable ColorStateList tint) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setSupportBackgroundTintList(tint);
        } else if (this.materialButtonHelper != null) {
            super.setSupportBackgroundTintList(tint);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public ColorStateList getSupportBackgroundTintList() {
        if (this.isUsingOriginalBackground()) {
            return this.materialButtonHelper.getSupportBackgroundTintList();
        }
        return super.getSupportBackgroundTintList();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setSupportBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setSupportBackgroundTintMode(tintMode);
        } else if (this.materialButtonHelper != null) {
            super.setSupportBackgroundTintMode(tintMode);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public PorterDuff.Mode getSupportBackgroundTintMode() {
        if (this.isUsingOriginalBackground()) {
            return this.materialButtonHelper.getSupportBackgroundTintMode();
        }
        return super.getSupportBackgroundTintMode();
    }

    public void setBackgroundTintList(@Nullable ColorStateList tintList) {
        this.setSupportBackgroundTintList(tintList);
    }

    @Nullable
    public ColorStateList getBackgroundTintList() {
        return this.getSupportBackgroundTintList();
    }

    public void setBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.setSupportBackgroundTintMode(tintMode);
    }

    @Nullable
    public PorterDuff.Mode getBackgroundTintMode() {
        return this.getSupportBackgroundTintMode();
    }

    public void setBackgroundColor(@ColorInt int color2) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setBackgroundColor(color2);
        } else {
            super.setBackgroundColor(color2);
        }
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    public void setBackgroundResource(@DrawableRes int backgroundResourceId) {
        Drawable background = null;
        if (backgroundResourceId != 0) {
            background = AppCompatResources.getDrawable((Context)this.getContext(), (int)backgroundResourceId);
        }
        this.setBackgroundDrawable(background);
    }

    public void setBackgroundDrawable(Drawable background) {
        if (this.isUsingOriginalBackground()) {
            if (background != this.getBackground()) {
                Log.i((String)LOG_TAG, (String)"Setting a custom background is not supported.");
                this.materialButtonHelper.setBackgroundOverwritten();
                super.setBackgroundDrawable(background);
            } else {
                this.getBackground().setState(background.getState());
            }
        } else {
            super.setBackgroundDrawable(background);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (Build.VERSION.SDK_INT == 21 && this.materialButtonHelper != null) {
            this.materialButtonHelper.updateMaskBounds(bottom - top, right - left);
        }
    }

    void setInternalBackground(Drawable background) {
        super.setBackgroundDrawable(background);
    }

    public void setButtonPadding(@Px int start, @Px int top, @Px int end, @Px int bottom) {
        this.paddingStart = start;
        this.paddingTop = top;
        this.paddingEnd = end;
        this.paddingBottom = bottom;
        this.updatePadding();
    }

    @Px
    public int getButtonPaddingStart() {
        return this.paddingStart;
    }

    @Px
    public int getButtonPaddingTop() {
        return this.paddingTop;
    }

    @Px
    public int getButtonPaddingEnd() {
        return this.paddingEnd;
    }

    @Px
    public int getButtonPaddingBottom() {
        return this.paddingBottom;
    }

    public void setAdditionalPaddingStartForIcon(@Px int additionalPaddingStartForIcon) {
        if (this.additionalPaddingStartForIcon != additionalPaddingStartForIcon) {
            this.additionalPaddingStartForIcon = additionalPaddingStartForIcon;
            this.updatePadding();
        }
    }

    @Px
    public int getAdditionalPaddingStartForIcon() {
        return this.additionalPaddingStartForIcon;
    }

    public void setAdditionalPaddingEndForIcon(@Px int additionalPaddingEndForIcon) {
        if (this.additionalPaddingEndForIcon != additionalPaddingEndForIcon) {
            this.additionalPaddingEndForIcon = additionalPaddingEndForIcon;
            this.updatePadding();
        }
    }

    @Px
    public int getAdditionalPaddingEndForIcon() {
        return this.additionalPaddingEndForIcon;
    }

    private void updatePadding() {
        ViewCompat.setPaddingRelative((View)this, (int)(this.paddingStart + (this.icon != null ? this.additionalPaddingStartForIcon : 0) + this.insetLeft), (int)(this.paddingTop + this.insetTop), (int)(this.paddingEnd + (this.icon != null ? this.additionalPaddingEndForIcon : 0) + this.insetRight), (int)(this.paddingBottom + this.insetBottom));
    }

    public void setIconPadding(@Px int iconPadding) {
        if (this.iconPadding != iconPadding) {
            this.iconPadding = iconPadding;
            this.setCompoundDrawablePadding(iconPadding);
        }
    }

    @Px
    public int getIconPadding() {
        return this.iconPadding;
    }

    public void setIconSize(@Px int iconSize) {
        if (iconSize < 0) {
            throw new IllegalArgumentException("iconSize cannot be less than 0");
        }
        if (this.iconSize != iconSize) {
            this.iconSize = iconSize;
            this.updateIcon();
        }
    }

    @Px
    public int getIconSize() {
        return this.iconSize;
    }

    public void setIcon(Drawable icon) {
        if (this.icon != icon) {
            this.icon = icon;
            this.updateIcon();
        }
    }

    public void setIconResource(@DrawableRes int iconResourceId) {
        Drawable icon = null;
        if (iconResourceId != 0) {
            icon = AppCompatResources.getDrawable((Context)this.getContext(), (int)iconResourceId);
        }
        this.setIcon(icon);
    }

    public Drawable getIcon() {
        return this.icon;
    }

    public void setIconTint(@Nullable ColorStateList iconTint) {
        if (this.iconTint != iconTint) {
            this.iconTint = iconTint;
            this.updateIcon();
        }
    }

    public void setIconTintResource(@ColorRes int iconTintResourceId) {
        this.setIconTint(AppCompatResources.getColorStateList((Context)this.getContext(), (int)iconTintResourceId));
    }

    public ColorStateList getIconTint() {
        return this.iconTint;
    }

    public void setIconTintMode(PorterDuff.Mode iconTintMode) {
        if (this.iconTintMode != iconTintMode) {
            this.iconTintMode = iconTintMode;
            this.updateIcon();
        }
    }

    public PorterDuff.Mode getIconTintMode() {
        return this.iconTintMode;
    }

    private void updateIcon() {
        if (this.icon != null) {
            this.icon = this.icon.mutate();
            DrawableCompat.setTintList((Drawable)this.icon, (ColorStateList)this.iconTint);
            if (this.iconTintMode != null) {
                DrawableCompat.setTintMode((Drawable)this.icon, (PorterDuff.Mode)this.iconTintMode);
            }
            int width = this.iconSize != 0 ? this.iconSize : this.icon.getIntrinsicWidth();
            int height = this.iconSize != 0 ? this.iconSize : this.icon.getIntrinsicHeight();
            this.icon.setBounds(0, 0, width, height);
        }
        TextViewCompat.setCompoundDrawablesRelative((TextView)this, (Drawable)this.icon, null, null, null);
        this.updatePadding();
    }

    public void setRippleColor(@Nullable ColorStateList rippleColor) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setRippleColor(rippleColor);
        }
    }

    public void setRippleColorResource(@ColorRes int rippleColorResourceId) {
        if (this.isUsingOriginalBackground()) {
            this.setRippleColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)rippleColorResourceId));
        }
    }

    public ColorStateList getRippleColor() {
        return this.isUsingOriginalBackground() ? this.materialButtonHelper.getRippleColor() : null;
    }

    public void setStrokeColor(@Nullable ColorStateList strokeColor) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setStrokeColor(strokeColor);
        }
    }

    public void setStrokeColorResource(@ColorRes int strokeColorResourceId) {
        if (this.isUsingOriginalBackground()) {
            this.setStrokeColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)strokeColorResourceId));
        }
    }

    public ColorStateList getStrokeColor() {
        return this.isUsingOriginalBackground() ? this.materialButtonHelper.getStrokeColor() : null;
    }

    public void setStrokeWidth(@Px int strokeWidth) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setStrokeWidth(strokeWidth);
        }
    }

    public void setStrokeWidthResource(@DimenRes int strokeWidthResourceId) {
        if (this.isUsingOriginalBackground()) {
            this.setStrokeWidth(this.getResources().getDimensionPixelSize(strokeWidthResourceId));
        }
    }

    @Px
    public int getStrokeWidth() {
        return this.isUsingOriginalBackground() ? this.materialButtonHelper.getStrokeWidth() : 0;
    }

    public void setCornerRadius(@Px int cornerRadius) {
        if (this.isUsingOriginalBackground()) {
            this.materialButtonHelper.setCornerRadius(cornerRadius);
        }
    }

    public void setCornerRadiusResource(@DimenRes int cornerRadiusResourceId) {
        if (this.isUsingOriginalBackground()) {
            this.setCornerRadius(this.getResources().getDimensionPixelSize(cornerRadiusResourceId));
        }
    }

    @Px
    public int getCornerRadius() {
        return this.isUsingOriginalBackground() ? this.materialButtonHelper.getCornerRadius() : 0;
    }

    private boolean isUsingOriginalBackground() {
        return this.materialButtonHelper != null && !this.materialButtonHelper.isBackgroundOverwritten();
    }
}

