/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.chip;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.AnimatorRes;
import android.support.annotation.AttrRes;
import android.support.annotation.BoolRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.annotation.XmlRes;
import android.support.design.R;
import android.support.design.animation.MotionSpec;
import android.support.design.canvas.CanvasCompat;
import android.support.design.drawable.DrawableUtils;
import android.support.design.internal.ThemeEnforcement;
import android.support.design.resources.MaterialResources;
import android.support.design.resources.TextAppearance;
import android.support.design.ripple.RippleUtils;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.graphics.drawable.TintAwareDrawable;
import android.support.v4.text.BidiFormatter;
import android.support.v7.content.res.AppCompatResources;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Xml;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ChipDrawable
extends Drawable
implements TintAwareDrawable,
Drawable.Callback {
    private static final boolean DEBUG = false;
    private static final int[] DEFAULT_STATE = new int[]{16842910};
    @Nullable
    private ColorStateList chipBackgroundColor;
    private float chipMinHeight;
    private float chipCornerRadius;
    @Nullable
    private ColorStateList chipStrokeColor;
    private float chipStrokeWidth;
    @Nullable
    private ColorStateList rippleColor;
    @Nullable
    private CharSequence rawText;
    @Nullable
    private CharSequence unicodeWrappedText;
    @Nullable
    private TextAppearance textAppearance;
    private boolean chipIconEnabled;
    @Nullable
    private Drawable chipIcon;
    private float chipIconSize;
    private boolean closeIconEnabled;
    @Nullable
    private Drawable closeIcon;
    @Nullable
    private ColorStateList closeIconTint;
    private float closeIconSize;
    @Nullable
    private CharSequence closeIconContentDescription;
    private boolean checkable;
    private boolean checkedIconEnabled;
    @Nullable
    private Drawable checkedIcon;
    @Nullable
    private MotionSpec showMotionSpec;
    @Nullable
    private MotionSpec hideMotionSpec;
    private float chipStartPadding;
    private float iconStartPadding;
    private float iconEndPadding;
    private float textStartPadding;
    private float textEndPadding;
    private float closeIconStartPadding;
    private float closeIconEndPadding;
    private float chipEndPadding;
    private final Context context;
    private final TextPaint textPaint = new TextPaint(1);
    private final Paint chipPaint = new Paint(1);
    @Nullable
    private final Paint debugPaint;
    private final Paint.FontMetrics fontMetrics = new Paint.FontMetrics();
    private final RectF rectF = new RectF();
    private final PointF pointF = new PointF();
    @ColorInt
    private int currentChipBackgroundColor;
    @ColorInt
    private int currentChipStrokeColor;
    @ColorInt
    private int currentCompatRippleColor;
    @ColorInt
    private int currentTextColor;
    private boolean currentChecked;
    @ColorInt
    private int currentTint;
    private int alpha = 255;
    @Nullable
    private ColorFilter colorFilter;
    @Nullable
    private PorterDuffColorFilter tintFilter;
    @Nullable
    private ColorStateList tint;
    @Nullable
    private PorterDuff.Mode tintMode = PorterDuff.Mode.SRC_IN;
    private int[] closeIconStateSet;
    private boolean useCompatRipple;
    @Nullable
    private ColorStateList compatRippleColor;
    private WeakReference<Delegate> delegate = new WeakReference<Object>(null);
    private boolean textWidthDirty = true;
    private float textWidth;
    private TextUtils.TruncateAt truncateAt;

    public static ChipDrawable createFromAttributes(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        ChipDrawable chip = new ChipDrawable(context);
        chip.loadFromAttributes(attrs, defStyleAttr, defStyleRes);
        return chip;
    }

    public static ChipDrawable createFromResource(Context context, @XmlRes int id2) {
        try {
            int type;
            XmlResourceParser parser = context.getResources().getXml(id2);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            if (!TextUtils.equals((CharSequence)parser.getName(), (CharSequence)"chip")) {
                throw new XmlPullParserException("Must have a <chip> start tag");
            }
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            int style2 = attrs.getStyleAttribute();
            if (style2 == 0) {
                style2 = R.style.Widget_MaterialComponents_Chip_Entry;
            }
            return ChipDrawable.createFromAttributes(context, attrs, R.attr.chipStandaloneStyle, style2);
        }
        catch (IOException | XmlPullParserException e) {
            Resources.NotFoundException exception = new Resources.NotFoundException("Can't load chip resource ID #0x" + Integer.toHexString(id2));
            exception.initCause(e);
            throw exception;
        }
    }

    private ChipDrawable(Context context) {
        this.context = context;
        this.textPaint.density = context.getResources().getDisplayMetrics().density;
        this.debugPaint = null;
        if (this.debugPaint != null) {
            this.debugPaint.setStyle(Paint.Style.STROKE);
        }
        this.setState(DEFAULT_STATE);
        this.setCloseIconState(DEFAULT_STATE);
    }

    private void loadFromAttributes(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(this.context, attrs, R.styleable.ChipDrawable, defStyleAttr, defStyleRes);
        this.setChipBackgroundColor(MaterialResources.getColorStateList(this.context, a, R.styleable.ChipDrawable_chipBackgroundColor));
        this.setChipMinHeight(a.getDimension(R.styleable.ChipDrawable_chipMinHeight, 0.0f));
        this.setChipCornerRadius(a.getDimension(R.styleable.ChipDrawable_chipCornerRadius, 0.0f));
        this.setChipStrokeColor(MaterialResources.getColorStateList(this.context, a, R.styleable.ChipDrawable_chipStrokeColor));
        this.setChipStrokeWidth(a.getDimension(R.styleable.ChipDrawable_chipStrokeWidth, 0.0f));
        this.setRippleColor(MaterialResources.getColorStateList(this.context, a, R.styleable.ChipDrawable_rippleColor));
        this.setText(a.getText(R.styleable.ChipDrawable_android_text));
        this.setTextAppearance(MaterialResources.getTextAppearance(this.context, a, R.styleable.ChipDrawable_android_textAppearance));
        int ellipsize = a.getInt(R.styleable.ChipDrawable_android_ellipsize, 0);
        switch (ellipsize) {
            case 1: {
                this.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
        }
        this.setChipIconEnabled(a.getBoolean(R.styleable.ChipDrawable_chipIconEnabled, false));
        this.setChipIcon(MaterialResources.getDrawable(this.context, a, R.styleable.ChipDrawable_chipIcon));
        this.setChipIconSize(a.getDimension(R.styleable.ChipDrawable_chipIconSize, 0.0f));
        this.setCloseIconEnabled(a.getBoolean(R.styleable.ChipDrawable_closeIconEnabled, false));
        this.setCloseIcon(MaterialResources.getDrawable(this.context, a, R.styleable.ChipDrawable_closeIcon));
        this.setCloseIconTint(MaterialResources.getColorStateList(this.context, a, R.styleable.ChipDrawable_closeIconTint));
        this.setCloseIconSize(a.getDimension(R.styleable.ChipDrawable_closeIconSize, 0.0f));
        this.setCheckable(a.getBoolean(R.styleable.ChipDrawable_android_checkable, false));
        this.setCheckedIconEnabled(a.getBoolean(R.styleable.ChipDrawable_checkedIconEnabled, false));
        this.setCheckedIcon(MaterialResources.getDrawable(this.context, a, R.styleable.ChipDrawable_checkedIcon));
        this.setShowMotionSpec(MotionSpec.createFromAttribute(this.context, a, R.styleable.ChipDrawable_showMotionSpec));
        this.setHideMotionSpec(MotionSpec.createFromAttribute(this.context, a, R.styleable.ChipDrawable_hideMotionSpec));
        this.setChipStartPadding(a.getDimension(R.styleable.ChipDrawable_chipStartPadding, 0.0f));
        this.setIconStartPadding(a.getDimension(R.styleable.ChipDrawable_iconStartPadding, 0.0f));
        this.setIconEndPadding(a.getDimension(R.styleable.ChipDrawable_iconEndPadding, 0.0f));
        this.setTextStartPadding(a.getDimension(R.styleable.ChipDrawable_textStartPadding, 0.0f));
        this.setTextEndPadding(a.getDimension(R.styleable.ChipDrawable_textEndPadding, 0.0f));
        this.setCloseIconStartPadding(a.getDimension(R.styleable.ChipDrawable_closeIconStartPadding, 0.0f));
        this.setCloseIconEndPadding(a.getDimension(R.styleable.ChipDrawable_closeIconEndPadding, 0.0f));
        this.setChipEndPadding(a.getDimension(R.styleable.ChipDrawable_chipEndPadding, 0.0f));
        a.recycle();
    }

    public void setUseCompatRipple(boolean useCompatRipple) {
        if (this.useCompatRipple != useCompatRipple) {
            this.useCompatRipple = useCompatRipple;
            this.updateCompatRippleColor();
            this.onStateChange(this.getState());
        }
    }

    public boolean getUseCompatRipple() {
        return this.useCompatRipple;
    }

    public void setDelegate(@Nullable Delegate delegate) {
        this.delegate = new WeakReference<Delegate>(delegate);
    }

    protected void onSizeChange() {
        Delegate delegate = (Delegate)this.delegate.get();
        if (delegate != null) {
            delegate.onChipDrawableSizeChange();
        }
    }

    public void getChipTouchBounds(RectF bounds) {
        this.calculateChipTouchBounds(this.getBounds(), bounds);
    }

    public void getCloseIconTouchBounds(RectF bounds) {
        this.calculateCloseIconTouchBounds(this.getBounds(), bounds);
    }

    public int getIntrinsicWidth() {
        return Math.round(this.chipStartPadding + this.calculateChipIconWidth() + this.textStartPadding + this.getTextWidth() + this.textEndPadding + this.calculateCloseIconWidth() + this.chipEndPadding);
    }

    public int getIntrinsicHeight() {
        return (int)this.chipMinHeight;
    }

    private boolean showsChipIcon() {
        return this.chipIconEnabled && this.chipIcon != null;
    }

    private boolean showsCheckedIcon() {
        return this.checkedIconEnabled && this.checkedIcon != null && this.currentChecked;
    }

    private boolean showsCloseIcon() {
        return this.closeIconEnabled && this.closeIcon != null;
    }

    private boolean canShowCheckedIcon() {
        return this.checkedIconEnabled && this.checkedIcon != null && this.checkable;
    }

    private float calculateChipIconWidth() {
        if (this.showsChipIcon() || this.showsCheckedIcon()) {
            return this.iconStartPadding + this.chipIconSize + this.iconEndPadding;
        }
        return 0.0f;
    }

    private float getTextWidth() {
        if (!this.textWidthDirty) {
            return this.textWidth;
        }
        this.textWidth = this.calculateTextWidth(this.unicodeWrappedText);
        this.textWidthDirty = false;
        return this.textWidth;
    }

    private float calculateTextWidth(@Nullable CharSequence charSequence) {
        if (charSequence == null) {
            return 0.0f;
        }
        return this.textPaint.measureText(charSequence, 0, charSequence.length());
    }

    private float calculateCloseIconWidth() {
        if (this.showsCloseIcon()) {
            return this.closeIconStartPadding + this.closeIconSize + this.closeIconEndPadding;
        }
        return 0.0f;
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        if (bounds.isEmpty() || this.getAlpha() == 0) {
            return;
        }
        int saveCount = 0;
        if (this.alpha < 255) {
            saveCount = CanvasCompat.saveLayerAlpha(canvas, bounds.left, bounds.top, bounds.right, bounds.bottom, this.alpha);
        }
        this.drawChipBackground(canvas, bounds);
        this.drawChipStroke(canvas, bounds);
        this.drawCompatRipple(canvas, bounds);
        this.drawChipIcon(canvas, bounds);
        this.drawCheckedIcon(canvas, bounds);
        this.drawText(canvas, bounds);
        this.drawCloseIcon(canvas, bounds);
        this.drawDebug(canvas, bounds);
        if (this.alpha < 255) {
            canvas.restoreToCount(saveCount);
        }
    }

    private void drawChipBackground(@NonNull Canvas canvas, Rect bounds) {
        this.chipPaint.setColor(this.currentChipBackgroundColor);
        this.chipPaint.setStyle(Paint.Style.FILL);
        this.chipPaint.setColorFilter(this.getTintColorFilter());
        this.rectF.set(bounds);
        canvas.drawRoundRect(this.rectF, this.chipCornerRadius, this.chipCornerRadius, this.chipPaint);
    }

    private void drawChipStroke(@NonNull Canvas canvas, Rect bounds) {
        if (this.chipStrokeWidth > 0.0f) {
            this.chipPaint.setColor(this.currentChipStrokeColor);
            this.chipPaint.setStyle(Paint.Style.STROKE);
            this.chipPaint.setColorFilter(this.getTintColorFilter());
            this.rectF.set((float)bounds.left + this.chipStrokeWidth / 2.0f, (float)bounds.top + this.chipStrokeWidth / 2.0f, (float)bounds.right - this.chipStrokeWidth / 2.0f, (float)bounds.bottom - this.chipStrokeWidth / 2.0f);
            float strokeCornerRadius = this.chipCornerRadius - this.chipStrokeWidth / 2.0f;
            canvas.drawRoundRect(this.rectF, strokeCornerRadius, strokeCornerRadius, this.chipPaint);
        }
    }

    private void drawCompatRipple(@NonNull Canvas canvas, Rect bounds) {
        this.chipPaint.setColor(this.currentCompatRippleColor);
        this.chipPaint.setStyle(Paint.Style.FILL);
        this.rectF.set(bounds);
        canvas.drawRoundRect(this.rectF, this.chipCornerRadius, this.chipCornerRadius, this.chipPaint);
    }

    private void drawChipIcon(@NonNull Canvas canvas, Rect bounds) {
        if (this.showsChipIcon()) {
            this.calculateChipIconBounds(bounds, this.rectF);
            float tx = this.rectF.left;
            float ty = this.rectF.top;
            canvas.translate(tx, ty);
            this.chipIcon.setBounds(0, 0, (int)this.rectF.width(), (int)this.rectF.height());
            this.chipIcon.draw(canvas);
            canvas.translate(-tx, -ty);
        }
    }

    private void drawCheckedIcon(@NonNull Canvas canvas, Rect bounds) {
        if (this.showsCheckedIcon()) {
            this.calculateChipIconBounds(bounds, this.rectF);
            float tx = this.rectF.left;
            float ty = this.rectF.top;
            canvas.translate(tx, ty);
            this.checkedIcon.setBounds(0, 0, (int)this.rectF.width(), (int)this.rectF.height());
            this.checkedIcon.draw(canvas);
            canvas.translate(-tx, -ty);
        }
    }

    private void drawText(@NonNull Canvas canvas, Rect bounds) {
        if (this.unicodeWrappedText != null) {
            Paint.Align align = this.calculateTextOrigin(bounds, this.pointF);
            this.calculateTextBounds(bounds, this.rectF);
            if (this.textAppearance != null) {
                this.textPaint.drawableState = this.getState();
                this.textAppearance.updateDrawState(this.context, this.textPaint);
            }
            this.textPaint.setTextAlign(align);
            boolean clip = Math.round(this.getTextWidth()) > Math.round(this.rectF.width());
            int saveCount = 0;
            if (clip) {
                saveCount = canvas.save();
                canvas.clipRect(this.rectF);
            }
            CharSequence finalText = this.unicodeWrappedText;
            if (clip && this.truncateAt != null) {
                finalText = TextUtils.ellipsize((CharSequence)this.unicodeWrappedText, (TextPaint)this.textPaint, (float)this.rectF.width(), (TextUtils.TruncateAt)this.truncateAt);
            }
            canvas.drawText(finalText, 0, finalText.length(), this.pointF.x, this.pointF.y, (Paint)this.textPaint);
            if (clip) {
                canvas.restoreToCount(saveCount);
            }
        }
    }

    private void drawCloseIcon(@NonNull Canvas canvas, Rect bounds) {
        if (this.showsCloseIcon()) {
            this.calculateCloseIconBounds(bounds, this.rectF);
            float tx = this.rectF.left;
            float ty = this.rectF.top;
            canvas.translate(tx, ty);
            this.closeIcon.setBounds(0, 0, (int)this.rectF.width(), (int)this.rectF.height());
            this.closeIcon.draw(canvas);
            canvas.translate(-tx, -ty);
        }
    }

    private void drawDebug(@NonNull Canvas canvas, Rect bounds) {
        if (this.debugPaint != null) {
            this.debugPaint.setColor(ColorUtils.setAlphaComponent((int)-16777216, (int)127));
            canvas.drawRect(bounds, this.debugPaint);
            if (this.showsChipIcon() || this.showsCheckedIcon()) {
                this.calculateChipIconBounds(bounds, this.rectF);
                canvas.drawRect(this.rectF, this.debugPaint);
            }
            if (this.unicodeWrappedText != null) {
                canvas.drawLine((float)bounds.left, bounds.exactCenterY(), (float)bounds.right, bounds.exactCenterY(), this.debugPaint);
            }
            if (this.showsCloseIcon()) {
                this.calculateCloseIconBounds(bounds, this.rectF);
                canvas.drawRect(this.rectF, this.debugPaint);
            }
            this.debugPaint.setColor(ColorUtils.setAlphaComponent((int)-65536, (int)127));
            this.calculateChipTouchBounds(bounds, this.rectF);
            canvas.drawRect(this.rectF, this.debugPaint);
            this.debugPaint.setColor(ColorUtils.setAlphaComponent((int)-16711936, (int)127));
            this.calculateCloseIconTouchBounds(bounds, this.rectF);
            canvas.drawRect(this.rectF, this.debugPaint);
        }
    }

    private void calculateChipIconBounds(Rect bounds, RectF outBounds) {
        outBounds.setEmpty();
        if (this.showsChipIcon() || this.showsCheckedIcon()) {
            float offsetFromStart = this.chipStartPadding + this.iconStartPadding;
            if (DrawableCompat.getLayoutDirection((Drawable)this) == 0) {
                outBounds.left = (float)bounds.left + offsetFromStart;
                outBounds.right = outBounds.left + this.chipIconSize;
            } else {
                outBounds.right = (float)bounds.right - offsetFromStart;
                outBounds.left = outBounds.right - this.chipIconSize;
            }
            outBounds.top = bounds.exactCenterY() - this.chipIconSize / 2.0f;
            outBounds.bottom = outBounds.top + this.chipIconSize;
        }
    }

    private Paint.Align calculateTextOrigin(Rect bounds, PointF pointF) {
        pointF.set(0.0f, 0.0f);
        Paint.Align align = Paint.Align.LEFT;
        if (this.unicodeWrappedText != null) {
            float offsetFromStart = this.chipStartPadding + this.calculateChipIconWidth() + this.textStartPadding;
            if (DrawableCompat.getLayoutDirection((Drawable)this) == 0) {
                pointF.x = (float)bounds.left + offsetFromStart;
                align = Paint.Align.LEFT;
            } else {
                pointF.x = (float)bounds.right - offsetFromStart;
                align = Paint.Align.RIGHT;
            }
            pointF.y = (float)bounds.centerY() - this.calculateTextCenterFromBaseline();
        }
        return align;
    }

    private float calculateTextCenterFromBaseline() {
        this.textPaint.getFontMetrics(this.fontMetrics);
        return (this.fontMetrics.descent + this.fontMetrics.ascent) / 2.0f;
    }

    private void calculateTextBounds(Rect bounds, RectF outBounds) {
        outBounds.setEmpty();
        if (this.unicodeWrappedText != null) {
            float offsetFromStart = this.chipStartPadding + this.calculateChipIconWidth() + this.textStartPadding;
            float offsetFromEnd = this.chipEndPadding + this.calculateCloseIconWidth() + this.textEndPadding;
            if (DrawableCompat.getLayoutDirection((Drawable)this) == 0) {
                outBounds.left = (float)bounds.left + offsetFromStart;
                outBounds.right = (float)bounds.right - offsetFromEnd;
            } else {
                outBounds.left = (float)bounds.left + offsetFromEnd;
                outBounds.right = (float)bounds.right - offsetFromStart;
            }
            outBounds.top = bounds.top;
            outBounds.bottom = bounds.bottom;
        }
    }

    private void calculateCloseIconBounds(Rect bounds, RectF outBounds) {
        outBounds.setEmpty();
        if (this.showsCloseIcon()) {
            float offsetFromEnd = this.chipEndPadding + this.closeIconEndPadding;
            if (DrawableCompat.getLayoutDirection((Drawable)this) == 0) {
                outBounds.right = (float)bounds.right - offsetFromEnd;
                outBounds.left = outBounds.right - this.closeIconSize;
            } else {
                outBounds.left = (float)bounds.left + offsetFromEnd;
                outBounds.right = outBounds.left + this.closeIconSize;
            }
            outBounds.top = bounds.exactCenterY() - this.closeIconSize / 2.0f;
            outBounds.bottom = outBounds.top + this.closeIconSize;
        }
    }

    private void calculateChipTouchBounds(Rect bounds, RectF outBounds) {
        outBounds.set(bounds);
        if (this.showsCloseIcon()) {
            float offsetFromEnd = this.chipEndPadding + this.closeIconEndPadding + this.closeIconSize + this.closeIconStartPadding + this.textEndPadding;
            if (DrawableCompat.getLayoutDirection((Drawable)this) == 0) {
                outBounds.right = (float)bounds.right - offsetFromEnd;
            } else {
                outBounds.left = (float)bounds.left + offsetFromEnd;
            }
        }
    }

    private void calculateCloseIconTouchBounds(Rect bounds, RectF outBounds) {
        outBounds.setEmpty();
        if (this.showsCloseIcon()) {
            float offsetFromEnd = this.chipEndPadding + this.closeIconEndPadding + this.closeIconSize + this.closeIconStartPadding + this.textEndPadding;
            if (DrawableCompat.getLayoutDirection((Drawable)this) == 0) {
                outBounds.right = bounds.right;
                outBounds.left = outBounds.right - offsetFromEnd;
            } else {
                outBounds.left = bounds.left;
                outBounds.right = (float)bounds.left + offsetFromEnd;
            }
            outBounds.top = bounds.top;
            outBounds.bottom = bounds.bottom;
        }
    }

    public boolean isStateful() {
        return ChipDrawable.isStateful(this.chipBackgroundColor) || ChipDrawable.isStateful(this.chipStrokeColor) || this.useCompatRipple && ChipDrawable.isStateful(this.compatRippleColor) || ChipDrawable.isStateful(this.textAppearance) || this.canShowCheckedIcon() || ChipDrawable.isStateful(this.chipIcon) || ChipDrawable.isStateful(this.checkedIcon) || ChipDrawable.isStateful(this.tint);
    }

    public boolean isCloseIconStateful() {
        return ChipDrawable.isStateful(this.closeIcon);
    }

    public boolean setCloseIconState(@NonNull int[] stateSet) {
        if (!Arrays.equals(this.closeIconStateSet, stateSet)) {
            this.closeIconStateSet = stateSet;
            if (this.showsCloseIcon()) {
                return this.onStateChange(this.getState(), stateSet);
            }
        }
        return false;
    }

    @NonNull
    public int[] getCloseIconState() {
        return this.closeIconStateSet;
    }

    protected boolean onStateChange(int[] state) {
        return this.onStateChange(state, this.getCloseIconState());
    }

    private boolean onStateChange(int[] chipState, int[] closeIconState) {
        int newTint;
        boolean newChecked;
        int newTextColor;
        int newCompatRippleColor;
        int newChipStrokeColor;
        int newChipBackgroundColor;
        boolean invalidate = super.onStateChange(chipState);
        boolean sizeChanged = false;
        int n = newChipBackgroundColor = this.chipBackgroundColor != null ? this.chipBackgroundColor.getColorForState(chipState, this.currentChipBackgroundColor) : 0;
        if (this.currentChipBackgroundColor != newChipBackgroundColor) {
            this.currentChipBackgroundColor = newChipBackgroundColor;
            invalidate = true;
        }
        int n2 = newChipStrokeColor = this.chipStrokeColor != null ? this.chipStrokeColor.getColorForState(chipState, this.currentChipStrokeColor) : 0;
        if (this.currentChipStrokeColor != newChipStrokeColor) {
            this.currentChipStrokeColor = newChipStrokeColor;
            invalidate = true;
        }
        int n3 = newCompatRippleColor = this.compatRippleColor != null ? this.compatRippleColor.getColorForState(chipState, this.currentCompatRippleColor) : 0;
        if (this.currentCompatRippleColor != newCompatRippleColor) {
            this.currentCompatRippleColor = newCompatRippleColor;
            if (this.useCompatRipple) {
                invalidate = true;
            }
        }
        int n4 = newTextColor = this.textAppearance != null && this.textAppearance.textColor != null ? this.textAppearance.textColor.getColorForState(chipState, this.currentTextColor) : 0;
        if (this.currentTextColor != newTextColor) {
            this.currentTextColor = newTextColor;
            invalidate = true;
        }
        boolean bl = newChecked = ChipDrawable.hasState(this.getState(), 0x10100A0) && this.checkable;
        if (this.currentChecked != newChecked && this.checkedIcon != null) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.currentChecked = newChecked;
            float newChipIconWidth = this.calculateChipIconWidth();
            invalidate = true;
            if (oldChipIconWidth != newChipIconWidth) {
                sizeChanged = true;
            }
        }
        int n5 = newTint = this.tint != null ? this.tint.getColorForState(chipState, this.currentTint) : 0;
        if (this.currentTint != newTint) {
            this.currentTint = newTint;
            this.tintFilter = DrawableUtils.updateTintFilter(this, this.tint, this.tintMode);
            invalidate = true;
        }
        if (ChipDrawable.isStateful(this.chipIcon)) {
            invalidate |= this.chipIcon.setState(chipState);
        }
        if (ChipDrawable.isStateful(this.checkedIcon)) {
            invalidate |= this.checkedIcon.setState(chipState);
        }
        if (ChipDrawable.isStateful(this.closeIcon)) {
            invalidate |= this.closeIcon.setState(closeIconState);
        }
        if (invalidate) {
            this.invalidateSelf();
        }
        if (sizeChanged) {
            this.onSizeChange();
        }
        return invalidate;
    }

    private static boolean isStateful(@Nullable ColorStateList colorStateList) {
        return colorStateList != null && colorStateList.isStateful();
    }

    private static boolean isStateful(@Nullable Drawable drawable2) {
        return drawable2 != null && drawable2.isStateful();
    }

    private static boolean isStateful(@Nullable TextAppearance textAppearance) {
        return textAppearance != null && textAppearance.textColor != null && textAppearance.textColor.isStateful();
    }

    @TargetApi(value=23)
    public boolean onLayoutDirectionChanged(int layoutDirection) {
        boolean invalidate = super.onLayoutDirectionChanged(layoutDirection);
        if (this.showsChipIcon()) {
            invalidate |= this.chipIcon.setLayoutDirection(layoutDirection);
        }
        if (this.showsCheckedIcon()) {
            invalidate |= this.checkedIcon.setLayoutDirection(layoutDirection);
        }
        if (this.showsCloseIcon()) {
            invalidate |= this.closeIcon.setLayoutDirection(layoutDirection);
        }
        if (invalidate) {
            this.invalidateSelf();
        }
        return true;
    }

    protected boolean onLevelChange(int level) {
        boolean invalidate = super.onLevelChange(level);
        if (this.showsChipIcon()) {
            invalidate |= this.chipIcon.setLevel(level);
        }
        if (this.showsCheckedIcon()) {
            invalidate |= this.checkedIcon.setLevel(level);
        }
        if (this.showsCloseIcon()) {
            invalidate |= this.closeIcon.setLevel(level);
        }
        if (invalidate) {
            this.invalidateSelf();
        }
        return invalidate;
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean invalidate = super.setVisible(visible, restart);
        if (this.showsChipIcon()) {
            invalidate |= this.chipIcon.setVisible(visible, restart);
        }
        if (this.showsCheckedIcon()) {
            invalidate |= this.checkedIcon.setVisible(visible, restart);
        }
        if (this.showsCloseIcon()) {
            invalidate |= this.closeIcon.setVisible(visible, restart);
        }
        if (invalidate) {
            this.invalidateSelf();
        }
        return invalidate;
    }

    public void setAlpha(int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        if (this.colorFilter != colorFilter) {
            this.colorFilter = colorFilter;
            this.invalidateSelf();
        }
    }

    @Nullable
    public ColorFilter getColorFilter() {
        return this.colorFilter;
    }

    public void setTintList(@Nullable ColorStateList tint) {
        if (this.tint != tint) {
            this.tint = tint;
            this.onStateChange(this.getState());
        }
    }

    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        if (this.tintMode != tintMode) {
            this.tintMode = tintMode;
            this.tintFilter = DrawableUtils.updateTintFilter(this, this.tint, tintMode);
            this.invalidateSelf();
        }
    }

    public int getOpacity() {
        return -3;
    }

    @TargetApi(value=21)
    public void getOutline(@NonNull Outline outline) {
        Rect bounds = this.getBounds();
        if (!bounds.isEmpty()) {
            outline.setRoundRect(bounds, this.chipCornerRadius);
        } else {
            outline.setRoundRect(0, 0, this.getIntrinsicWidth(), this.getIntrinsicHeight(), this.chipCornerRadius);
        }
        outline.setAlpha((float)this.getAlpha() / 255.0f);
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    private void unapplyChildDrawable(@Nullable Drawable drawable2) {
        if (drawable2 != null) {
            drawable2.setCallback(null);
        }
    }

    private void applyChildDrawable(@Nullable Drawable drawable2) {
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
            DrawableCompat.setLayoutDirection((Drawable)drawable2, (int)DrawableCompat.getLayoutDirection((Drawable)this));
            drawable2.setLevel(this.getLevel());
            drawable2.setVisible(this.isVisible(), false);
            if (drawable2 == this.closeIcon) {
                if (drawable2.isStateful()) {
                    drawable2.setState(this.getCloseIconState());
                }
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)this.closeIconTint);
            } else if (drawable2.isStateful()) {
                drawable2.setState(this.getState());
            }
        }
    }

    @Nullable
    private ColorFilter getTintColorFilter() {
        return this.colorFilter != null ? this.colorFilter : this.tintFilter;
    }

    private void updateCompatRippleColor() {
        this.compatRippleColor = this.useCompatRipple ? RippleUtils.convertToRippleDrawableColor(this.rippleColor) : null;
    }

    private static boolean hasState(@Nullable int[] stateSet, @AttrRes int state) {
        if (stateSet == null) {
            return false;
        }
        for (int s : stateSet) {
            if (s != state) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ColorStateList getChipBackgroundColor() {
        return this.chipBackgroundColor;
    }

    public void setChipBackgroundColorResource(@ColorRes int id2) {
        this.setChipBackgroundColor(AppCompatResources.getColorStateList((Context)this.context, (int)id2));
    }

    public void setChipBackgroundColor(@Nullable ColorStateList chipBackgroundColor) {
        if (this.chipBackgroundColor != chipBackgroundColor) {
            this.chipBackgroundColor = chipBackgroundColor;
            this.onStateChange(this.getState());
        }
    }

    public float getChipMinHeight() {
        return this.chipMinHeight;
    }

    public void setChipMinHeightResource(@DimenRes int id2) {
        this.setChipMinHeight(this.context.getResources().getDimension(id2));
    }

    public void setChipMinHeight(float chipMinHeight) {
        if (this.chipMinHeight != chipMinHeight) {
            this.chipMinHeight = chipMinHeight;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    public float getChipCornerRadius() {
        return this.chipCornerRadius;
    }

    public void setChipCornerRadiusResource(@DimenRes int id2) {
        this.setChipCornerRadius(this.context.getResources().getDimension(id2));
    }

    public void setChipCornerRadius(float chipCornerRadius) {
        if (this.chipCornerRadius != chipCornerRadius) {
            this.chipCornerRadius = chipCornerRadius;
            this.invalidateSelf();
        }
    }

    @Nullable
    public ColorStateList getChipStrokeColor() {
        return this.chipStrokeColor;
    }

    public void setChipStrokeColorResource(@ColorRes int id2) {
        this.setChipStrokeColor(AppCompatResources.getColorStateList((Context)this.context, (int)id2));
    }

    public void setChipStrokeColor(@Nullable ColorStateList chipStrokeColor) {
        if (this.chipStrokeColor != chipStrokeColor) {
            this.chipStrokeColor = chipStrokeColor;
            this.onStateChange(this.getState());
        }
    }

    public float getChipStrokeWidth() {
        return this.chipStrokeWidth;
    }

    public void setChipStrokeWidthResource(@DimenRes int id2) {
        this.setChipStrokeWidth(this.context.getResources().getDimension(id2));
    }

    public void setChipStrokeWidth(float chipStrokeWidth) {
        if (this.chipStrokeWidth != chipStrokeWidth) {
            this.chipStrokeWidth = chipStrokeWidth;
            this.chipPaint.setStrokeWidth(chipStrokeWidth);
            this.invalidateSelf();
        }
    }

    @Nullable
    public ColorStateList getRippleColor() {
        return this.rippleColor;
    }

    public void setRippleColorResource(@ColorRes int id2) {
        this.setRippleColor(AppCompatResources.getColorStateList((Context)this.context, (int)id2));
    }

    public void setRippleColor(@Nullable ColorStateList rippleColor) {
        if (this.rippleColor != rippleColor) {
            this.rippleColor = rippleColor;
            this.updateCompatRippleColor();
            this.onStateChange(this.getState());
        }
    }

    @Nullable
    public CharSequence getText() {
        return this.rawText;
    }

    public void setTextResource(@StringRes int id2) {
        this.setText(this.context.getResources().getString(id2));
    }

    public void setText(@Nullable CharSequence text) {
        if (this.rawText != text) {
            this.rawText = text;
            this.unicodeWrappedText = BidiFormatter.getInstance().unicodeWrap(text);
            this.textWidthDirty = true;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    @Nullable
    public TextAppearance getTextAppearance() {
        return this.textAppearance;
    }

    public void setTextAppearanceResource(@StyleRes int id2) {
        this.setTextAppearance(new TextAppearance(this.context, id2));
    }

    public void setTextAppearance(@Nullable TextAppearance textAppearance) {
        if (this.textAppearance != textAppearance) {
            this.textAppearance = textAppearance;
            if (textAppearance != null) {
                textAppearance.updateMeasureState(this.context, this.textPaint);
                this.textWidthDirty = true;
            }
            this.onStateChange(this.getState());
            this.onSizeChange();
        }
    }

    public TextUtils.TruncateAt getEllipsize() {
        return this.truncateAt;
    }

    public void setEllipsize(@Nullable TextUtils.TruncateAt truncateAt) {
        this.truncateAt = truncateAt;
    }

    public boolean isChipIconEnabled() {
        return this.chipIconEnabled;
    }

    public void setChipIconEnabledResource(@BoolRes int id2) {
        this.setChipIconEnabled(this.context.getResources().getBoolean(id2));
    }

    public void setChipIconEnabled(boolean chipIconEnabled) {
        if (this.chipIconEnabled != chipIconEnabled) {
            boolean changed;
            boolean oldShowsChipIcon = this.showsChipIcon();
            this.chipIconEnabled = chipIconEnabled;
            boolean newShowsChipIcon = this.showsChipIcon();
            boolean bl = changed = oldShowsChipIcon != newShowsChipIcon;
            if (changed) {
                if (newShowsChipIcon) {
                    this.applyChildDrawable(this.chipIcon);
                } else {
                    this.unapplyChildDrawable(this.chipIcon);
                }
                this.invalidateSelf();
                this.onSizeChange();
            }
        }
    }

    @Nullable
    public Drawable getChipIcon() {
        return this.chipIcon;
    }

    public void setChipIconResource(@DrawableRes int id2) {
        this.setChipIcon(AppCompatResources.getDrawable((Context)this.context, (int)id2));
    }

    public void setChipIcon(@Nullable Drawable chipIcon) {
        Drawable oldChipIcon = this.chipIcon;
        if (oldChipIcon != chipIcon) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.chipIcon = chipIcon;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.unapplyChildDrawable(oldChipIcon);
            if (this.showsChipIcon()) {
                this.applyChildDrawable(this.chipIcon);
            }
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    public float getChipIconSize() {
        return this.chipIconSize;
    }

    public void setChipIconSizeResource(@DimenRes int id2) {
        this.setChipIconSize(this.context.getResources().getDimension(id2));
    }

    public void setChipIconSize(float chipIconSize) {
        if (this.chipIconSize != chipIconSize) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.chipIconSize = chipIconSize;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    public boolean isCloseIconEnabled() {
        return this.closeIconEnabled;
    }

    public void setCloseIconEnabledResource(@BoolRes int id2) {
        this.setCloseIconEnabled(this.context.getResources().getBoolean(id2));
    }

    public void setCloseIconEnabled(boolean closeIconEnabled) {
        if (this.closeIconEnabled != closeIconEnabled) {
            boolean changed;
            boolean oldShowsCloseIcon = this.showsCloseIcon();
            this.closeIconEnabled = closeIconEnabled;
            boolean newShowsCloseIcon = this.showsCloseIcon();
            boolean bl = changed = oldShowsCloseIcon != newShowsCloseIcon;
            if (changed) {
                if (newShowsCloseIcon) {
                    this.applyChildDrawable(this.closeIcon);
                } else {
                    this.unapplyChildDrawable(this.closeIcon);
                }
                this.invalidateSelf();
                this.onSizeChange();
            }
        }
    }

    @Nullable
    public Drawable getCloseIcon() {
        return this.closeIcon;
    }

    public void setCloseIconResource(@DrawableRes int id2) {
        this.setCloseIcon(AppCompatResources.getDrawable((Context)this.context, (int)id2));
    }

    public void setCloseIcon(@Nullable Drawable closeIcon) {
        Drawable oldCloseIcon;
        Drawable drawable2 = oldCloseIcon = this.closeIcon != null ? DrawableCompat.unwrap((Drawable)this.closeIcon) : null;
        if (oldCloseIcon != closeIcon) {
            float oldCloseIconWidth = this.calculateCloseIconWidth();
            this.closeIcon = closeIcon != null ? DrawableCompat.wrap((Drawable)closeIcon).mutate() : null;
            float newCloseIconWidth = this.calculateCloseIconWidth();
            this.unapplyChildDrawable(oldCloseIcon);
            if (this.showsCloseIcon()) {
                this.applyChildDrawable(this.closeIcon);
            }
            this.invalidateSelf();
            if (oldCloseIconWidth != newCloseIconWidth) {
                this.onSizeChange();
            }
        }
    }

    @Nullable
    public ColorStateList getCloseIconTint() {
        return this.closeIconTint;
    }

    public void setCloseIconTintResource(@ColorRes int id2) {
        this.setCloseIconTint(AppCompatResources.getColorStateList((Context)this.context, (int)id2));
    }

    public void setCloseIconTint(@Nullable ColorStateList closeIconTint) {
        if (this.closeIconTint != closeIconTint) {
            this.closeIconTint = closeIconTint;
            if (this.showsCloseIcon()) {
                DrawableCompat.setTintList((Drawable)this.closeIcon, (ColorStateList)closeIconTint);
            }
            this.onStateChange(this.getState());
        }
    }

    public float getCloseIconSize() {
        return this.closeIconSize;
    }

    public void setCloseIconSizeResource(@DimenRes int id2) {
        this.setCloseIconSize(this.context.getResources().getDimension(id2));
    }

    public void setCloseIconSize(float closeIconSize) {
        if (this.closeIconSize != closeIconSize) {
            this.closeIconSize = closeIconSize;
            this.invalidateSelf();
            if (this.showsCloseIcon()) {
                this.onSizeChange();
            }
        }
    }

    public void setCloseIconContentDescription(@Nullable CharSequence closeIconContentDescription) {
        if (this.closeIconContentDescription != closeIconContentDescription) {
            this.closeIconContentDescription = BidiFormatter.getInstance().unicodeWrap(closeIconContentDescription);
            this.invalidateSelf();
        }
    }

    @Nullable
    public CharSequence getCloseIconContentDescription() {
        return this.closeIconContentDescription;
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public void setCheckableResource(@BoolRes int id2) {
        this.setCheckable(this.context.getResources().getBoolean(id2));
    }

    public void setCheckable(boolean checkable) {
        if (this.checkable != checkable) {
            this.checkable = checkable;
            float oldChipIconWidth = this.calculateChipIconWidth();
            if (!checkable && this.currentChecked) {
                this.currentChecked = false;
            }
            float newChipIconWidth = this.calculateChipIconWidth();
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    public boolean isCheckedIconEnabled() {
        return this.checkedIconEnabled;
    }

    public void setCheckedIconEnabledResource(@BoolRes int id2) {
        this.setCheckedIconEnabled(this.context.getResources().getBoolean(id2));
    }

    public void setCheckedIconEnabled(boolean checkedIconEnabled) {
        if (this.checkedIconEnabled != checkedIconEnabled) {
            boolean changed;
            boolean oldShowsCheckedIcon = this.showsCheckedIcon();
            this.checkedIconEnabled = checkedIconEnabled;
            boolean newShowsCheckedIcon = this.showsCheckedIcon();
            boolean bl = changed = oldShowsCheckedIcon != newShowsCheckedIcon;
            if (changed) {
                if (newShowsCheckedIcon) {
                    this.applyChildDrawable(this.checkedIcon);
                } else {
                    this.unapplyChildDrawable(this.checkedIcon);
                }
                this.invalidateSelf();
                this.onSizeChange();
            }
        }
    }

    @Nullable
    public Drawable getCheckedIcon() {
        return this.checkedIcon;
    }

    public void setCheckedIconResource(@DrawableRes int id2) {
        this.setCheckedIcon(AppCompatResources.getDrawable((Context)this.context, (int)id2));
    }

    public void setCheckedIcon(@Nullable Drawable checkedIcon) {
        Drawable oldCheckedIcon = this.checkedIcon;
        if (oldCheckedIcon != checkedIcon) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.checkedIcon = checkedIcon;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.unapplyChildDrawable(this.checkedIcon);
            this.applyChildDrawable(this.checkedIcon);
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    @Nullable
    public MotionSpec getShowMotionSpec() {
        return this.showMotionSpec;
    }

    public void setShowMotionSpecResource(@AnimatorRes int id2) {
        this.setShowMotionSpec(MotionSpec.createFromResource(this.context, id2));
    }

    public void setShowMotionSpec(@Nullable MotionSpec showMotionSpec) {
        this.showMotionSpec = showMotionSpec;
    }

    @Nullable
    public MotionSpec getHideMotionSpec() {
        return this.hideMotionSpec;
    }

    public void setHideMotionSpecResource(@AnimatorRes int id2) {
        this.setHideMotionSpec(MotionSpec.createFromResource(this.context, id2));
    }

    public void setHideMotionSpec(@Nullable MotionSpec hideMotionSpec) {
        this.hideMotionSpec = hideMotionSpec;
    }

    public float getChipStartPadding() {
        return this.chipStartPadding;
    }

    public void setChipStartPaddingResource(@DimenRes int id2) {
        this.setChipStartPadding(this.context.getResources().getDimension(id2));
    }

    public void setChipStartPadding(float chipStartPadding) {
        if (this.chipStartPadding != chipStartPadding) {
            this.chipStartPadding = chipStartPadding;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    public float getIconStartPadding() {
        return this.iconStartPadding;
    }

    public void setIconStartPaddingResource(@DimenRes int id2) {
        this.setIconStartPadding(this.context.getResources().getDimension(id2));
    }

    public void setIconStartPadding(float iconStartPadding) {
        if (this.iconStartPadding != iconStartPadding) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.iconStartPadding = iconStartPadding;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    public float getIconEndPadding() {
        return this.iconEndPadding;
    }

    public void setIconEndPaddingResource(@DimenRes int id2) {
        this.setIconEndPadding(this.context.getResources().getDimension(id2));
    }

    public void setIconEndPadding(float iconEndPadding) {
        if (this.iconEndPadding != iconEndPadding) {
            float oldChipIconWidth = this.calculateChipIconWidth();
            this.iconEndPadding = iconEndPadding;
            float newChipIconWidth = this.calculateChipIconWidth();
            this.invalidateSelf();
            if (oldChipIconWidth != newChipIconWidth) {
                this.onSizeChange();
            }
        }
    }

    public float getTextStartPadding() {
        return this.textStartPadding;
    }

    public void setTextStartPaddingResource(@DimenRes int id2) {
        this.setTextStartPadding(this.context.getResources().getDimension(id2));
    }

    public void setTextStartPadding(float textStartPadding) {
        if (this.textStartPadding != textStartPadding) {
            this.textStartPadding = textStartPadding;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    public float getTextEndPadding() {
        return this.textEndPadding;
    }

    public void setTextEndPaddingResource(@DimenRes int id2) {
        this.setTextEndPadding(this.context.getResources().getDimension(id2));
    }

    public void setTextEndPadding(float textEndPadding) {
        if (this.textEndPadding != textEndPadding) {
            this.textEndPadding = textEndPadding;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    public float getCloseIconStartPadding() {
        return this.closeIconStartPadding;
    }

    public void setCloseIconStartPaddingResource(@DimenRes int id2) {
        this.setCloseIconStartPadding(this.context.getResources().getDimension(id2));
    }

    public void setCloseIconStartPadding(float closeIconStartPadding) {
        if (this.closeIconStartPadding != closeIconStartPadding) {
            this.closeIconStartPadding = closeIconStartPadding;
            this.invalidateSelf();
            if (this.showsCloseIcon()) {
                this.onSizeChange();
            }
        }
    }

    public float getCloseIconEndPadding() {
        return this.closeIconEndPadding;
    }

    public void setCloseIconEndPaddingResource(@DimenRes int id2) {
        this.setCloseIconEndPadding(this.context.getResources().getDimension(id2));
    }

    public void setCloseIconEndPadding(float closeIconEndPadding) {
        if (this.closeIconEndPadding != closeIconEndPadding) {
            this.closeIconEndPadding = closeIconEndPadding;
            this.invalidateSelf();
            if (this.showsCloseIcon()) {
                this.onSizeChange();
            }
        }
    }

    public float getChipEndPadding() {
        return this.chipEndPadding;
    }

    public void setChipEndPaddingResource(@DimenRes int id2) {
        this.setChipEndPadding(this.context.getResources().getDimension(id2));
    }

    public void setChipEndPadding(float chipEndPadding) {
        if (this.chipEndPadding != chipEndPadding) {
            this.chipEndPadding = chipEndPadding;
            this.invalidateSelf();
            this.onSizeChange();
        }
    }

    public static interface Delegate {
        public void onChipDrawableSizeChange();
    }
}

