/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.provider;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.provider.DocumentsContract;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.provider.RawDocumentFile;
import android.support.v4.provider.SingleDocumentFile;
import android.support.v4.provider.TreeDocumentFile;
import java.io.File;

public abstract class DocumentFile {
    static final String TAG = "DocumentFile";
    @Nullable
    private final DocumentFile mParent;

    DocumentFile(@Nullable DocumentFile parent) {
        this.mParent = parent;
    }

    @NonNull
    public static DocumentFile fromFile(@NonNull File file) {
        return new RawDocumentFile(null, file);
    }

    @Nullable
    public static DocumentFile fromSingleUri(@NonNull Context context, @NonNull Uri singleUri) {
        if (Build.VERSION.SDK_INT >= 19) {
            return new SingleDocumentFile(null, context, singleUri);
        }
        return null;
    }

    @Nullable
    public static DocumentFile fromTreeUri(@NonNull Context context, @NonNull Uri treeUri) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new TreeDocumentFile(null, context, DocumentsContract.buildDocumentUriUsingTree((Uri)treeUri, (String)DocumentsContract.getTreeDocumentId((Uri)treeUri)));
        }
        return null;
    }

    public static boolean isDocumentUri(@NonNull Context context, @Nullable Uri uri) {
        if (Build.VERSION.SDK_INT >= 19) {
            return DocumentsContract.isDocumentUri((Context)context, (Uri)uri);
        }
        return false;
    }

    @Nullable
    public abstract DocumentFile createFile(@NonNull String var1, @NonNull String var2);

    @Nullable
    public abstract DocumentFile createDirectory(@NonNull String var1);

    @NonNull
    public abstract Uri getUri();

    @Nullable
    public abstract String getName();

    @Nullable
    public abstract String getType();

    @Nullable
    public DocumentFile getParentFile() {
        return this.mParent;
    }

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract boolean isVirtual();

    public abstract long lastModified();

    public abstract long length();

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public abstract boolean delete();

    public abstract boolean exists();

    @NonNull
    public abstract DocumentFile[] listFiles();

    @Nullable
    public DocumentFile findFile(@NonNull String displayName) {
        for (DocumentFile doc : this.listFiles()) {
            if (!displayName.equals(doc.getName())) continue;
            return doc;
        }
        return null;
    }

    public abstract boolean renameTo(@NonNull String var1);
}

