/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.os.Bundle;
import android.support.v7.media.MediaRouteDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class MediaRouteProviderDescriptor {
    private static final String KEY_ROUTES = "routes";
    private final Bundle mBundle;
    private List<MediaRouteDescriptor> mRoutes;

    private MediaRouteProviderDescriptor(Bundle bundle, List<MediaRouteDescriptor> routes) {
        this.mBundle = bundle;
        this.mRoutes = routes;
    }

    public List<MediaRouteDescriptor> getRoutes() {
        this.ensureRoutes();
        return this.mRoutes;
    }

    private void ensureRoutes() {
        if (this.mRoutes == null) {
            ArrayList routeBundles = this.mBundle.getParcelableArrayList(KEY_ROUTES);
            if (routeBundles == null || routeBundles.isEmpty()) {
                this.mRoutes = Collections.emptyList();
            } else {
                int count = routeBundles.size();
                this.mRoutes = new ArrayList<MediaRouteDescriptor>(count);
                for (int i = 0; i < count; ++i) {
                    this.mRoutes.add(MediaRouteDescriptor.fromBundle((Bundle)routeBundles.get(i)));
                }
            }
        }
    }

    public boolean isValid() {
        this.ensureRoutes();
        int routeCount = this.mRoutes.size();
        for (int i = 0; i < routeCount; ++i) {
            MediaRouteDescriptor route = this.mRoutes.get(i);
            if (route != null && route.isValid()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("MediaRouteProviderDescriptor{ ");
        result.append("routes=").append(Arrays.toString(this.getRoutes().toArray()));
        result.append(", isValid=").append(this.isValid());
        result.append(" }");
        return result.toString();
    }

    public Bundle asBundle() {
        return this.mBundle;
    }

    public static MediaRouteProviderDescriptor fromBundle(Bundle bundle) {
        return bundle != null ? new MediaRouteProviderDescriptor(bundle, null) : null;
    }

    public static final class Builder {
        private final Bundle mBundle;
        private ArrayList<MediaRouteDescriptor> mRoutes;

        public Builder() {
            this.mBundle = new Bundle();
        }

        public Builder(MediaRouteProviderDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException("descriptor must not be null");
            }
            this.mBundle = new Bundle(descriptor.mBundle);
            descriptor.ensureRoutes();
            if (!descriptor.mRoutes.isEmpty()) {
                this.mRoutes = new ArrayList(descriptor.mRoutes);
            }
        }

        public Builder addRoute(MediaRouteDescriptor route) {
            if (route == null) {
                throw new IllegalArgumentException("route must not be null");
            }
            if (this.mRoutes == null) {
                this.mRoutes = new ArrayList();
            } else if (this.mRoutes.contains(route)) {
                throw new IllegalArgumentException("route descriptor already added");
            }
            this.mRoutes.add(route);
            return this;
        }

        public Builder addRoutes(Collection<MediaRouteDescriptor> routes) {
            if (routes == null) {
                throw new IllegalArgumentException("routes must not be null");
            }
            if (!routes.isEmpty()) {
                for (MediaRouteDescriptor route : routes) {
                    this.addRoute(route);
                }
            }
            return this;
        }

        Builder setRoutes(Collection<MediaRouteDescriptor> routes) {
            if (routes == null || routes.isEmpty()) {
                this.mRoutes = null;
                this.mBundle.remove(MediaRouteProviderDescriptor.KEY_ROUTES);
            } else {
                this.mRoutes = new ArrayList<MediaRouteDescriptor>(routes);
            }
            return this;
        }

        public MediaRouteProviderDescriptor build() {
            if (this.mRoutes != null) {
                int count = this.mRoutes.size();
                ArrayList<Bundle> routeBundles = new ArrayList<Bundle>(count);
                for (int i = 0; i < count; ++i) {
                    routeBundles.add(this.mRoutes.get(i).asBundle());
                }
                this.mBundle.putParcelableArrayList(MediaRouteProviderDescriptor.KEY_ROUTES, routeBundles);
            }
            return new MediaRouteProviderDescriptor(this.mBundle, this.mRoutes);
        }
    }
}

