/*
 * Decompiled with CFR 0.152.
 */
package android.support.v14.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.RestrictTo;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v7.preference.PreferenceViewHolder;
import android.support.v7.preference.R;
import android.support.v7.preference.TwoStatePreference;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.Switch;

public class SwitchPreference
extends TwoStatePreference {
    private final Listener mListener = new Listener();
    private CharSequence mSwitchOn;
    private CharSequence mSwitchOff;

    public SwitchPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwitchPreference, defStyleAttr, defStyleRes);
        this.setSummaryOn(TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.SwitchPreference_summaryOn, (int)R.styleable.SwitchPreference_android_summaryOn));
        this.setSummaryOff(TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.SwitchPreference_summaryOff, (int)R.styleable.SwitchPreference_android_summaryOff));
        this.setSwitchTextOn(TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.SwitchPreference_switchTextOn, (int)R.styleable.SwitchPreference_android_switchTextOn));
        this.setSwitchTextOff(TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.SwitchPreference_switchTextOff, (int)R.styleable.SwitchPreference_android_switchTextOff));
        this.setDisableDependentsState(TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.SwitchPreference_disableDependentsState, (int)R.styleable.SwitchPreference_android_disableDependentsState, (boolean)false));
        a.recycle();
    }

    public SwitchPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public SwitchPreference(Context context, AttributeSet attrs) {
        this(context, attrs, TypedArrayUtils.getAttr((Context)context, (int)R.attr.switchPreferenceStyle, (int)16843629));
    }

    public SwitchPreference(Context context) {
        this(context, null);
    }

    @Override
    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        View switchView = holder.findViewById(16908352);
        this.syncSwitchView(switchView);
        this.syncSummaryView(holder);
    }

    public void setSwitchTextOn(CharSequence onText) {
        this.mSwitchOn = onText;
        this.notifyChanged();
    }

    public void setSwitchTextOff(CharSequence offText) {
        this.mSwitchOff = offText;
        this.notifyChanged();
    }

    public void setSwitchTextOn(int resId) {
        this.setSwitchTextOn(this.getContext().getString(resId));
    }

    public void setSwitchTextOff(int resId) {
        this.setSwitchTextOff(this.getContext().getString(resId));
    }

    public CharSequence getSwitchTextOn() {
        return this.mSwitchOn;
    }

    public CharSequence getSwitchTextOff() {
        return this.mSwitchOff;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void performClick(View view) {
        super.performClick(view);
        this.syncViewIfAccessibilityEnabled(view);
    }

    private void syncViewIfAccessibilityEnabled(View view) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        if (!accessibilityManager.isEnabled()) {
            return;
        }
        View switchView = view.findViewById(16908352);
        this.syncSwitchView(switchView);
        View summaryView = view.findViewById(0x1020010);
        this.syncSummaryView(summaryView);
    }

    private void syncSwitchView(View view) {
        Switch switchView;
        if (view instanceof Switch) {
            switchView = (Switch)view;
            switchView.setOnCheckedChangeListener(null);
        }
        if (view instanceof Checkable) {
            ((Checkable)view).setChecked(this.mChecked);
        }
        if (view instanceof Switch) {
            switchView = (Switch)view;
            switchView.setTextOn(this.mSwitchOn);
            switchView.setTextOff(this.mSwitchOff);
            switchView.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this.mListener);
        }
    }

    private class Listener
    implements CompoundButton.OnCheckedChangeListener {
        private Listener() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (!SwitchPreference.this.callChangeListener(isChecked)) {
                buttonView.setChecked(!isChecked);
                return;
            }
            SwitchPreference.this.setChecked(isChecked);
        }
    }
}

