/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.Context;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceGroup;
import android.support.v7.preference.PreferenceGroupAdapter;
import android.support.v7.preference.PreferenceViewHolder;
import android.support.v7.preference.R;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

final class CollapsiblePreferenceGroupController {
    final PreferenceGroupAdapter mPreferenceGroupAdapter;
    private final Context mContext;
    private boolean mHasExpandablePreference = false;

    CollapsiblePreferenceGroupController(PreferenceGroup preferenceGroup, PreferenceGroupAdapter preferenceGroupAdapter) {
        this.mPreferenceGroupAdapter = preferenceGroupAdapter;
        this.mContext = preferenceGroup.getContext();
    }

    public List<Preference> createVisiblePreferencesList(PreferenceGroup group) {
        return this.createInnerVisiblePreferencesList(group);
    }

    private List<Preference> createInnerVisiblePreferencesList(PreferenceGroup group) {
        this.mHasExpandablePreference = false;
        int visiblePreferenceCount = 0;
        boolean hasExpandablePreference = group.getInitialExpandedChildrenCount() != Integer.MAX_VALUE;
        ArrayList<Preference> visiblePreferences = new ArrayList<Preference>();
        ArrayList<Preference> collapsedPreferences = new ArrayList<Preference>();
        int groupSize = group.getPreferenceCount();
        for (int i = 0; i < groupSize; ++i) {
            Preference preference = group.getPreference(i);
            if (!preference.isVisible()) continue;
            if (!hasExpandablePreference || visiblePreferenceCount < group.getInitialExpandedChildrenCount()) {
                visiblePreferences.add(preference);
            } else {
                collapsedPreferences.add(preference);
            }
            if (!(preference instanceof PreferenceGroup)) {
                ++visiblePreferenceCount;
                continue;
            }
            PreferenceGroup innerGroup = (PreferenceGroup)preference;
            if (!innerGroup.isOnSameScreenAsChildren()) continue;
            List<Preference> innerList = this.createInnerVisiblePreferencesList(innerGroup);
            if (hasExpandablePreference && this.mHasExpandablePreference) {
                throw new IllegalArgumentException("Nested expand buttons are not supported!");
            }
            for (Preference inner : innerList) {
                if (!hasExpandablePreference || visiblePreferenceCount < group.getInitialExpandedChildrenCount()) {
                    visiblePreferences.add(inner);
                } else {
                    collapsedPreferences.add(inner);
                }
                ++visiblePreferenceCount;
            }
        }
        if (hasExpandablePreference && visiblePreferenceCount > group.getInitialExpandedChildrenCount()) {
            ExpandButton expandButton = this.createExpandButton(group, collapsedPreferences);
            visiblePreferences.add(expandButton);
        }
        this.mHasExpandablePreference |= hasExpandablePreference;
        return visiblePreferences;
    }

    public boolean onPreferenceVisibilityChange(Preference preference) {
        if (preference instanceof PreferenceGroup || this.mHasExpandablePreference) {
            this.mPreferenceGroupAdapter.onPreferenceHierarchyChange(preference);
            return true;
        }
        return false;
    }

    private ExpandButton createExpandButton(final PreferenceGroup group, List<Preference> collapsedPreferences) {
        ExpandButton preference = new ExpandButton(this.mContext, collapsedPreferences, group.getId());
        preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            @Override
            public boolean onPreferenceClick(Preference preference) {
                group.setInitialExpandedChildrenCount(Integer.MAX_VALUE);
                CollapsiblePreferenceGroupController.this.mPreferenceGroupAdapter.onPreferenceHierarchyChange(preference);
                PreferenceGroup.OnExpandButtonClickListener listener = group.getOnExpandButtonClickListener();
                if (listener != null) {
                    listener.onExpandButtonClick();
                }
                return true;
            }
        });
        return preference;
    }

    static class ExpandButton
    extends Preference {
        private long mId;

        ExpandButton(Context context, List<Preference> collapsedPreferences, long parentId) {
            super(context);
            this.initLayout();
            this.setSummary(collapsedPreferences);
            this.mId = parentId + 1000000L;
        }

        private void initLayout() {
            this.setLayoutResource(R.layout.expand_button);
            this.setIcon(R.drawable.ic_arrow_down_24dp);
            this.setTitle(R.string.expand_button_title);
            this.setOrder(999);
        }

        private void setSummary(List<Preference> collapsedPreferences) {
            CharSequence summary = null;
            ArrayList<PreferenceGroup> parents = new ArrayList<PreferenceGroup>();
            for (Preference preference : collapsedPreferences) {
                CharSequence title = preference.getTitle();
                if (preference instanceof PreferenceGroup && !TextUtils.isEmpty((CharSequence)title)) {
                    parents.add((PreferenceGroup)preference);
                }
                if (parents.contains(preference.getParent())) {
                    if (!(preference instanceof PreferenceGroup)) continue;
                    parents.add((PreferenceGroup)preference);
                    continue;
                }
                if (TextUtils.isEmpty((CharSequence)title)) continue;
                if (summary == null) {
                    summary = title;
                    continue;
                }
                summary = this.getContext().getString(R.string.summary_collapsed_preference_list, new Object[]{summary, title});
            }
            this.setSummary(summary);
        }

        @Override
        public void onBindViewHolder(PreferenceViewHolder holder) {
            super.onBindViewHolder(holder);
            holder.setDividerAllowedAbove(false);
        }

        @Override
        public long getId() {
            return this.mId;
        }
    }
}

