/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.Rect;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.Arrays;

public class GridLayoutManager
extends LinearLayoutManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "GridLayoutManager";
    public static final int DEFAULT_SPAN_COUNT = -1;
    boolean mPendingSpanCountChange = false;
    int mSpanCount = -1;
    int[] mCachedBorders;
    View[] mSet;
    final SparseIntArray mPreLayoutSpanSizeCache = new SparseIntArray();
    final SparseIntArray mPreLayoutSpanIndexCache = new SparseIntArray();
    SpanSizeLookup mSpanSizeLookup = new DefaultSpanSizeLookup();
    final Rect mDecorInsets = new Rect();

    public GridLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        RecyclerView.LayoutManager.Properties properties = GridLayoutManager.getProperties(context, attrs, defStyleAttr, defStyleRes);
        this.setSpanCount(properties.spanCount);
    }

    public GridLayoutManager(Context context, int spanCount) {
        super(context);
        this.setSpanCount(spanCount);
    }

    public GridLayoutManager(Context context, int spanCount, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.setSpanCount(spanCount);
    }

    @Override
    public void setStackFromEnd(boolean stackFromEnd) {
        if (stackFromEnd) {
            throw new UnsupportedOperationException("GridLayoutManager does not support stack from end. Consider using reverse layout");
        }
        super.setStackFromEnd(false);
    }

    @Override
    public int getRowCountForAccessibility(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 0) {
            return this.mSpanCount;
        }
        if (state.getItemCount() < 1) {
            return 0;
        }
        return this.getSpanGroupIndex(recycler, state, state.getItemCount() - 1) + 1;
    }

    @Override
    public int getColumnCountForAccessibility(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            return this.mSpanCount;
        }
        if (state.getItemCount() < 1) {
            return 0;
        }
        return this.getSpanGroupIndex(recycler, state, state.getItemCount() - 1) + 1;
    }

    @Override
    public void onInitializeAccessibilityNodeInfoForItem(RecyclerView.Recycler recycler, RecyclerView.State state, View host, AccessibilityNodeInfoCompat info) {
        ViewGroup.LayoutParams lp = host.getLayoutParams();
        if (!(lp instanceof LayoutParams)) {
            super.onInitializeAccessibilityNodeInfoForItem(host, info);
            return;
        }
        LayoutParams glp = (LayoutParams)lp;
        int spanGroupIndex = this.getSpanGroupIndex(recycler, state, glp.getViewLayoutPosition());
        if (this.mOrientation == 0) {
            info.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)glp.getSpanIndex(), (int)glp.getSpanSize(), (int)spanGroupIndex, (int)1, (this.mSpanCount > 1 && glp.getSpanSize() == this.mSpanCount ? 1 : 0) != 0, (boolean)false));
        } else {
            info.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)spanGroupIndex, (int)1, (int)glp.getSpanIndex(), (int)glp.getSpanSize(), (this.mSpanCount > 1 && glp.getSpanSize() == this.mSpanCount ? 1 : 0) != 0, (boolean)false));
        }
    }

    @Override
    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (state.isPreLayout()) {
            this.cachePreLayoutSpanMapping();
        }
        super.onLayoutChildren(recycler, state);
        this.clearPreLayoutSpanMappingCache();
        if (!state.isPreLayout()) {
            this.mPendingSpanCountChange = false;
        }
    }

    private void clearPreLayoutSpanMappingCache() {
        this.mPreLayoutSpanSizeCache.clear();
        this.mPreLayoutSpanIndexCache.clear();
    }

    private void cachePreLayoutSpanMapping() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            int viewPosition = lp.getViewLayoutPosition();
            this.mPreLayoutSpanSizeCache.put(viewPosition, lp.getSpanSize());
            this.mPreLayoutSpanIndexCache.put(viewPosition, lp.getSpanIndex());
        }
    }

    @Override
    public void onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsChanged(RecyclerView recyclerView) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount, Object payload) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsMoved(RecyclerView recyclerView, int from, int to, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-2, -1);
        }
        return new LayoutParams(-1, -2);
    }

    @Override
    public RecyclerView.LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
        return new LayoutParams(c, attrs);
    }

    @Override
    public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    @Override
    public boolean checkLayoutParams(RecyclerView.LayoutParams lp) {
        return lp instanceof LayoutParams;
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    public SpanSizeLookup getSpanSizeLookup() {
        return this.mSpanSizeLookup;
    }

    private void updateMeasurements() {
        int totalSpace = this.getOrientation() == 1 ? this.getWidth() - this.getPaddingRight() - this.getPaddingLeft() : this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        this.calculateItemBorders(totalSpace);
    }

    @Override
    public void setMeasuredDimension(Rect childrenBounds, int wSpec, int hSpec) {
        int width;
        int height;
        if (this.mCachedBorders == null) {
            super.setMeasuredDimension(childrenBounds, wSpec, hSpec);
        }
        int horizontalPadding = this.getPaddingLeft() + this.getPaddingRight();
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        if (this.mOrientation == 1) {
            int usedHeight = childrenBounds.height() + verticalPadding;
            height = GridLayoutManager.chooseSize(hSpec, usedHeight, this.getMinimumHeight());
            width = GridLayoutManager.chooseSize(wSpec, this.mCachedBorders[this.mCachedBorders.length - 1] + horizontalPadding, this.getMinimumWidth());
        } else {
            int usedWidth = childrenBounds.width() + horizontalPadding;
            width = GridLayoutManager.chooseSize(wSpec, usedWidth, this.getMinimumWidth());
            height = GridLayoutManager.chooseSize(hSpec, this.mCachedBorders[this.mCachedBorders.length - 1] + verticalPadding, this.getMinimumHeight());
        }
        this.setMeasuredDimension(width, height);
    }

    private void calculateItemBorders(int totalSpace) {
        this.mCachedBorders = GridLayoutManager.calculateItemBorders(this.mCachedBorders, this.mSpanCount, totalSpace);
    }

    static int[] calculateItemBorders(int[] cachedBorders, int spanCount, int totalSpace) {
        if (cachedBorders == null || cachedBorders.length != spanCount + 1 || cachedBorders[cachedBorders.length - 1] != totalSpace) {
            cachedBorders = new int[spanCount + 1];
        }
        cachedBorders[0] = 0;
        int sizePerSpan = totalSpace / spanCount;
        int sizePerSpanRemainder = totalSpace % spanCount;
        int consumedPixels = 0;
        int additionalSize = 0;
        for (int i = 1; i <= spanCount; ++i) {
            int itemSize = sizePerSpan;
            if ((additionalSize += sizePerSpanRemainder) > 0 && spanCount - additionalSize < sizePerSpanRemainder) {
                ++itemSize;
                additionalSize -= spanCount;
            }
            cachedBorders[i] = consumedPixels += itemSize;
        }
        return cachedBorders;
    }

    @Override
    void onAnchorReady(RecyclerView.Recycler recycler, RecyclerView.State state, LinearLayoutManager.AnchorInfo anchorInfo, int itemDirection) {
        super.onAnchorReady(recycler, state, anchorInfo, itemDirection);
        this.updateMeasurements();
        if (state.getItemCount() > 0 && !state.isPreLayout()) {
            this.ensureAnchorIsInCorrectSpan(recycler, state, anchorInfo, itemDirection);
        }
        this.ensureViewSet();
    }

    private void ensureViewSet() {
        if (this.mSet == null || this.mSet.length != this.mSpanCount) {
            this.mSet = new View[this.mSpanCount];
        }
    }

    @Override
    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.updateMeasurements();
        this.ensureViewSet();
        return super.scrollHorizontallyBy(dx, recycler, state);
    }

    @Override
    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.updateMeasurements();
        this.ensureViewSet();
        return super.scrollVerticallyBy(dy, recycler, state);
    }

    private void ensureAnchorIsInCorrectSpan(RecyclerView.Recycler recycler, RecyclerView.State state, LinearLayoutManager.AnchorInfo anchorInfo, int itemDirection) {
        boolean layingOutInPrimaryDirection = itemDirection == 1;
        int span = this.getSpanIndex(recycler, state, anchorInfo.mPosition);
        if (layingOutInPrimaryDirection) {
            while (span > 0 && anchorInfo.mPosition > 0) {
                --anchorInfo.mPosition;
                span = this.getSpanIndex(recycler, state, anchorInfo.mPosition);
            }
        } else {
            int next;
            int pos;
            int indexLimit = state.getItemCount() - 1;
            int bestSpan = span;
            for (pos = anchorInfo.mPosition; pos < indexLimit && (next = this.getSpanIndex(recycler, state, pos + 1)) > bestSpan; ++pos) {
                bestSpan = next;
            }
            anchorInfo.mPosition = pos;
        }
    }

    @Override
    View findReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state, int start, int end, int itemCount) {
        this.ensureLayoutState();
        View invalidMatch = null;
        View outOfBoundsMatch = null;
        int boundsStart = this.mOrientationHelper.getStartAfterPadding();
        int boundsEnd = this.mOrientationHelper.getEndAfterPadding();
        int diff = end > start ? 1 : -1;
        for (int i = start; i != end; i += diff) {
            int span;
            View view = this.getChildAt(i);
            int position = this.getPosition(view);
            if (position < 0 || position >= itemCount || (span = this.getSpanIndex(recycler, state, position)) != 0) continue;
            if (((RecyclerView.LayoutParams)view.getLayoutParams()).isItemRemoved()) {
                if (invalidMatch != null) continue;
                invalidMatch = view;
                continue;
            }
            if (this.mOrientationHelper.getDecoratedStart(view) >= boundsEnd || this.mOrientationHelper.getDecoratedEnd(view) < boundsStart) {
                if (outOfBoundsMatch != null) continue;
                outOfBoundsMatch = view;
                continue;
            }
            return view;
        }
        return outOfBoundsMatch != null ? outOfBoundsMatch : invalidMatch;
    }

    private int getSpanGroupIndex(RecyclerView.Recycler recycler, RecyclerView.State state, int viewPosition) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getSpanGroupIndex(viewPosition, this.mSpanCount);
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(viewPosition);
        if (adapterPosition == -1) {
            Log.w((String)TAG, (String)("Cannot find span size for pre layout position. " + viewPosition));
            return 0;
        }
        return this.mSpanSizeLookup.getSpanGroupIndex(adapterPosition, this.mSpanCount);
    }

    private int getSpanIndex(RecyclerView.Recycler recycler, RecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getCachedSpanIndex(pos, this.mSpanCount);
        }
        int cached = this.mPreLayoutSpanIndexCache.get(pos, -1);
        if (cached != -1) {
            return cached;
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            Log.w((String)TAG, (String)("Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + pos));
            return 0;
        }
        return this.mSpanSizeLookup.getCachedSpanIndex(adapterPosition, this.mSpanCount);
    }

    private int getSpanSize(RecyclerView.Recycler recycler, RecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getSpanSize(pos);
        }
        int cached = this.mPreLayoutSpanSizeCache.get(pos, -1);
        if (cached != -1) {
            return cached;
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            Log.w((String)TAG, (String)("Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + pos));
            return 1;
        }
        return this.mSpanSizeLookup.getSpanSize(adapterPosition);
    }

    @Override
    void layoutChunk(RecyclerView.Recycler recycler, RecyclerView.State state, LinearLayoutManager.LayoutState layoutState, LinearLayoutManager.LayoutChunkResult result) {
        int size;
        int mainSpec;
        int spec;
        LayoutParams lp;
        View view;
        int i;
        int currentOtherDirSize;
        int otherDirSpecMode = this.mOrientationHelper.getModeInOther();
        boolean flexibleInOtherDir = otherDirSpecMode != 0x40000000;
        int n = currentOtherDirSize = this.getChildCount() > 0 ? this.mCachedBorders[this.mSpanCount] : 0;
        if (flexibleInOtherDir) {
            this.updateMeasurements();
        }
        boolean layingOutInPrimaryDirection = layoutState.mItemDirection == 1;
        int count = 0;
        int consumedSpanCount = 0;
        int remainingSpan = this.mSpanCount;
        if (!layingOutInPrimaryDirection) {
            int itemSpanIndex = this.getSpanIndex(recycler, state, layoutState.mCurrentPosition);
            int itemSpanSize = this.getSpanSize(recycler, state, layoutState.mCurrentPosition);
            remainingSpan = itemSpanIndex + itemSpanSize;
        }
        while (count < this.mSpanCount && layoutState.hasMore(state) && remainingSpan > 0) {
            View view2;
            int pos = layoutState.mCurrentPosition;
            int spanSize = this.getSpanSize(recycler, state, pos);
            if (spanSize > this.mSpanCount) {
                throw new IllegalArgumentException("Item at position " + pos + " requires " + spanSize + " spans but GridLayoutManager has only " + this.mSpanCount + " spans.");
            }
            if ((remainingSpan -= spanSize) < 0 || (view2 = layoutState.next(recycler)) == null) break;
            consumedSpanCount += spanSize;
            this.mSet[count] = view2;
            ++count;
        }
        if (count == 0) {
            result.mFinished = true;
            return;
        }
        int maxSize = 0;
        float maxSizeInOther = 0.0f;
        this.assignSpans(recycler, state, count, consumedSpanCount, layingOutInPrimaryDirection);
        for (i = 0; i < count; ++i) {
            float otherSize;
            boolean applyInsets;
            view = this.mSet[i];
            if (layoutState.mScrapList == null) {
                if (layingOutInPrimaryDirection) {
                    this.addView(view);
                } else {
                    this.addView(view, 0);
                }
            } else if (layingOutInPrimaryDirection) {
                this.addDisappearingView(view);
            } else {
                this.addDisappearingView(view, 0);
            }
            lp = (LayoutParams)view.getLayoutParams();
            spec = GridLayoutManager.getChildMeasureSpec(this.mCachedBorders[lp.mSpanIndex + lp.mSpanSize] - this.mCachedBorders[lp.mSpanIndex], otherDirSpecMode, 0, this.mOrientation == 0 ? lp.height : lp.width, false);
            mainSpec = GridLayoutManager.getChildMeasureSpec(this.mOrientationHelper.getTotalSpace(), this.mOrientationHelper.getMode(), 0, this.mOrientation == 1 ? lp.height : lp.width, true);
            if (this.mOrientation == 1) {
                applyInsets = lp.height == -1;
                this.measureChildWithDecorationsAndMargin(view, spec, mainSpec, applyInsets, false);
            } else {
                applyInsets = lp.width == -1;
                this.measureChildWithDecorationsAndMargin(view, mainSpec, spec, applyInsets, false);
            }
            size = this.mOrientationHelper.getDecoratedMeasurement(view);
            if (size > maxSize) {
                maxSize = size;
            }
            if (!((otherSize = 1.0f * (float)this.mOrientationHelper.getDecoratedMeasurementInOther(view) / (float)lp.mSpanSize) > maxSizeInOther)) continue;
            maxSizeInOther = otherSize;
        }
        if (flexibleInOtherDir) {
            this.guessMeasurement(maxSizeInOther, currentOtherDirSize);
            maxSize = 0;
            for (i = 0; i < count; ++i) {
                view = this.mSet[i];
                lp = (LayoutParams)view.getLayoutParams();
                spec = GridLayoutManager.getChildMeasureSpec(this.mCachedBorders[lp.mSpanIndex + lp.mSpanSize] - this.mCachedBorders[lp.mSpanIndex], 0x40000000, 0, this.mOrientation == 0 ? lp.height : lp.width, false);
                mainSpec = GridLayoutManager.getChildMeasureSpec(this.mOrientationHelper.getTotalSpace(), this.mOrientationHelper.getMode(), 0, this.mOrientation == 1 ? lp.height : lp.width, true);
                if (this.mOrientation == 1) {
                    this.measureChildWithDecorationsAndMargin(view, spec, mainSpec, false, true);
                } else {
                    this.measureChildWithDecorationsAndMargin(view, mainSpec, spec, false, true);
                }
                size = this.mOrientationHelper.getDecoratedMeasurement(view);
                if (size <= maxSize) continue;
                maxSize = size;
            }
        }
        int maxMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)maxSize, (int)0x40000000);
        for (int i2 = 0; i2 < count; ++i2) {
            View view3 = this.mSet[i2];
            if (this.mOrientationHelper.getDecoratedMeasurement(view3) == maxSize) continue;
            LayoutParams lp2 = (LayoutParams)view3.getLayoutParams();
            int spec2 = GridLayoutManager.getChildMeasureSpec(this.mCachedBorders[lp2.mSpanIndex + lp2.mSpanSize] - this.mCachedBorders[lp2.mSpanIndex], 0x40000000, 0, this.mOrientation == 0 ? lp2.height : lp2.width, false);
            if (this.mOrientation == 1) {
                this.measureChildWithDecorationsAndMargin(view3, spec2, maxMeasureSpec, true, true);
                continue;
            }
            this.measureChildWithDecorationsAndMargin(view3, maxMeasureSpec, spec2, true, true);
        }
        result.mConsumed = maxSize;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (this.mOrientation == 1) {
            if (layoutState.mLayoutDirection == -1) {
                bottom = layoutState.mOffset;
                top = bottom - maxSize;
            } else {
                top = layoutState.mOffset;
                bottom = top + maxSize;
            }
        } else if (layoutState.mLayoutDirection == -1) {
            right = layoutState.mOffset;
            left = right - maxSize;
        } else {
            left = layoutState.mOffset;
            right = left + maxSize;
        }
        for (int i3 = 0; i3 < count; ++i3) {
            View view4 = this.mSet[i3];
            LayoutParams params = (LayoutParams)view4.getLayoutParams();
            if (this.mOrientation == 1) {
                if (this.isLayoutRTL()) {
                    right = this.getPaddingLeft() + this.mCachedBorders[params.mSpanIndex + params.mSpanSize];
                    left = right - this.mOrientationHelper.getDecoratedMeasurementInOther(view4);
                } else {
                    left = this.getPaddingLeft() + this.mCachedBorders[params.mSpanIndex];
                    right = left + this.mOrientationHelper.getDecoratedMeasurementInOther(view4);
                }
            } else {
                top = this.getPaddingTop() + this.mCachedBorders[params.mSpanIndex];
                bottom = top + this.mOrientationHelper.getDecoratedMeasurementInOther(view4);
            }
            this.layoutDecoratedWithMargins(view4, left, top, right, bottom);
            if (params.isItemRemoved() || params.isItemChanged()) {
                result.mIgnoreConsumed = true;
            }
            result.mFocusable |= view4.isFocusable();
        }
        Arrays.fill(this.mSet, null);
    }

    private void guessMeasurement(float maxSizeInOther, int currentOtherDirSize) {
        int contentSize = Math.round(maxSizeInOther * (float)this.mSpanCount);
        this.calculateItemBorders(Math.max(contentSize, currentOtherDirSize));
    }

    private void measureChildWithDecorationsAndMargin(View child, int widthSpec, int heightSpec, boolean capBothSpecs, boolean alreadyMeasured) {
        boolean measure;
        this.calculateItemDecorationsForChild(child, this.mDecorInsets);
        RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
        if (capBothSpecs || this.mOrientation == 1) {
            widthSpec = this.updateSpecWithExtra(widthSpec, lp.leftMargin + this.mDecorInsets.left, lp.rightMargin + this.mDecorInsets.right);
        }
        if (capBothSpecs || this.mOrientation == 0) {
            heightSpec = this.updateSpecWithExtra(heightSpec, lp.topMargin + this.mDecorInsets.top, lp.bottomMargin + this.mDecorInsets.bottom);
        }
        if (measure = alreadyMeasured ? this.shouldReMeasureChild(child, widthSpec, heightSpec, lp) : this.shouldMeasureChild(child, widthSpec, heightSpec, lp)) {
            child.measure(widthSpec, heightSpec);
        }
    }

    private int updateSpecWithExtra(int spec, int startInset, int endInset) {
        if (startInset == 0 && endInset == 0) {
            return spec;
        }
        int mode = View.MeasureSpec.getMode((int)spec);
        if (mode == Integer.MIN_VALUE || mode == 0x40000000) {
            return View.MeasureSpec.makeMeasureSpec((int)Math.max(0, View.MeasureSpec.getSize((int)spec) - startInset - endInset), (int)mode);
        }
        return spec;
    }

    private void assignSpans(RecyclerView.Recycler recycler, RecyclerView.State state, int count, int consumedSpanCount, boolean layingOutInPrimaryDirection) {
        int spanDiff;
        int span;
        int diff;
        int end;
        int start;
        if (layingOutInPrimaryDirection) {
            start = 0;
            end = count;
            diff = 1;
        } else {
            start = count - 1;
            end = -1;
            diff = -1;
        }
        if (this.mOrientation == 1 && this.isLayoutRTL()) {
            span = this.mSpanCount - 1;
            spanDiff = -1;
        } else {
            span = 0;
            spanDiff = 1;
        }
        for (int i = start; i != end; i += diff) {
            View view = this.mSet[i];
            LayoutParams params = (LayoutParams)view.getLayoutParams();
            params.mSpanSize = this.getSpanSize(recycler, state, this.getPosition(view));
            if (spanDiff == -1 && params.mSpanSize > 1) {
                params.mSpanIndex = span - (params.mSpanSize - 1);
            } else {
                params.mSpanIndex = span;
            }
            span += spanDiff * params.mSpanSize;
        }
    }

    public int getSpanCount() {
        return this.mSpanCount;
    }

    public void setSpanCount(int spanCount) {
        if (spanCount == this.mSpanCount) {
            return;
        }
        this.mPendingSpanCountChange = true;
        if (spanCount < 1) {
            throw new IllegalArgumentException("Span count should be at least 1. Provided " + spanCount);
        }
        this.mSpanCount = spanCount;
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public View onFocusSearchFailed(View focused, int focusDirection, RecyclerView.Recycler recycler, RecyclerView.State state) {
        View candidate;
        int limit;
        int inc;
        int start;
        boolean ascend;
        View prevFocusedChild = this.findContainingItemView(focused);
        if (prevFocusedChild == null) {
            return null;
        }
        LayoutParams lp = (LayoutParams)prevFocusedChild.getLayoutParams();
        int prevSpanStart = lp.mSpanIndex;
        int prevSpanEnd = lp.mSpanIndex + lp.mSpanSize;
        View view = super.onFocusSearchFailed(focused, focusDirection, recycler, state);
        if (view == null) {
            return null;
        }
        int layoutDir = this.convertFocusDirectionToLayoutDirection(focusDirection);
        boolean bl = ascend = layoutDir == 1 != this.mShouldReverseLayout;
        if (ascend) {
            start = this.getChildCount() - 1;
            inc = -1;
            limit = -1;
        } else {
            start = 0;
            inc = 1;
            limit = this.getChildCount();
        }
        boolean preferLastSpan = this.mOrientation == 1 && this.isLayoutRTL();
        View weakCandidate = null;
        int weakCandidateSpanIndex = -1;
        int weakCandidateOverlap = 0;
        for (int i = start; i != limit && (candidate = this.getChildAt(i)) != prevFocusedChild; i += inc) {
            if (!candidate.isFocusable()) continue;
            LayoutParams candidateLp = (LayoutParams)candidate.getLayoutParams();
            int candidateStart = candidateLp.mSpanIndex;
            int candidateEnd = candidateLp.mSpanIndex + candidateLp.mSpanSize;
            if (candidateStart == prevSpanStart && candidateEnd == prevSpanEnd) {
                return candidate;
            }
            boolean assignAsWeek = false;
            if (weakCandidate == null) {
                assignAsWeek = true;
            } else {
                int maxStart = Math.max(candidateStart, prevSpanStart);
                int minEnd = Math.min(candidateEnd, prevSpanEnd);
                int overlap = minEnd - maxStart;
                if (overlap > weakCandidateOverlap) {
                    assignAsWeek = true;
                } else if (overlap == weakCandidateOverlap && preferLastSpan == candidateStart > weakCandidateSpanIndex) {
                    assignAsWeek = true;
                }
            }
            if (!assignAsWeek) continue;
            weakCandidate = candidate;
            weakCandidateSpanIndex = candidateLp.mSpanIndex;
            weakCandidateOverlap = Math.min(candidateEnd, prevSpanEnd) - Math.max(candidateStart, prevSpanStart);
        }
        return weakCandidate;
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        return this.mPendingSavedState == null && !this.mPendingSpanCountChange;
    }

    public static class LayoutParams
    extends RecyclerView.LayoutParams {
        public static final int INVALID_SPAN_ID = -1;
        private int mSpanIndex = -1;
        private int mSpanSize = 0;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(RecyclerView.LayoutParams source) {
            super(source);
        }

        public int getSpanIndex() {
            return this.mSpanIndex;
        }

        public int getSpanSize() {
            return this.mSpanSize;
        }
    }

    public static final class DefaultSpanSizeLookup
    extends SpanSizeLookup {
        @Override
        public int getSpanSize(int position) {
            return 1;
        }

        @Override
        public int getSpanIndex(int position, int spanCount) {
            return position % spanCount;
        }
    }

    public static abstract class SpanSizeLookup {
        final SparseIntArray mSpanIndexCache = new SparseIntArray();
        private boolean mCacheSpanIndices = false;

        public abstract int getSpanSize(int var1);

        public void setSpanIndexCacheEnabled(boolean cacheSpanIndices) {
            this.mCacheSpanIndices = cacheSpanIndices;
        }

        public void invalidateSpanIndexCache() {
            this.mSpanIndexCache.clear();
        }

        public boolean isSpanIndexCacheEnabled() {
            return this.mCacheSpanIndices;
        }

        int getCachedSpanIndex(int position, int spanCount) {
            if (!this.mCacheSpanIndices) {
                return this.getSpanIndex(position, spanCount);
            }
            int existing = this.mSpanIndexCache.get(position, -1);
            if (existing != -1) {
                return existing;
            }
            int value = this.getSpanIndex(position, spanCount);
            this.mSpanIndexCache.put(position, value);
            return value;
        }

        public int getSpanIndex(int position, int spanCount) {
            int prevKey;
            int positionSpanSize = this.getSpanSize(position);
            if (positionSpanSize == spanCount) {
                return 0;
            }
            int span = 0;
            int startPos = 0;
            if (this.mCacheSpanIndices && this.mSpanIndexCache.size() > 0 && (prevKey = this.findReferenceIndexFromCache(position)) >= 0) {
                span = this.mSpanIndexCache.get(prevKey) + this.getSpanSize(prevKey);
                startPos = prevKey + 1;
            }
            for (int i = startPos; i < position; ++i) {
                int size = this.getSpanSize(i);
                if ((span += size) == spanCount) {
                    span = 0;
                    continue;
                }
                if (span <= spanCount) continue;
                span = size;
            }
            if (span + positionSpanSize <= spanCount) {
                return span;
            }
            return 0;
        }

        int findReferenceIndexFromCache(int position) {
            int lo = 0;
            int hi = this.mSpanIndexCache.size() - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midVal = this.mSpanIndexCache.keyAt(mid);
                if (midVal < position) {
                    lo = mid + 1;
                    continue;
                }
                hi = mid - 1;
            }
            int index = lo - 1;
            if (index >= 0 && index < this.mSpanIndexCache.size()) {
                return this.mSpanIndexCache.keyAt(index);
            }
            return -1;
        }

        public int getSpanGroupIndex(int adapterPosition, int spanCount) {
            int span = 0;
            int group = 0;
            int positionSpanSize = this.getSpanSize(adapterPosition);
            for (int i = 0; i < adapterPosition; ++i) {
                int size = this.getSpanSize(i);
                if ((span += size) == spanCount) {
                    span = 0;
                    ++group;
                    continue;
                }
                if (span <= spanCount) continue;
                span = size;
                ++group;
            }
            if (span + positionSpanSize > spanCount) {
                ++group;
            }
            return group;
        }
    }
}

