/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.util.Pair;

@RequiresApi(value=9)
class PaintCompatGingerbread {
    private static final String TOFU_STRING = "\udb3f\udffd";
    private static final ThreadLocal<Pair<Rect, Rect>> sRectThreadLocal = new ThreadLocal();

    PaintCompatGingerbread() {
    }

    static boolean hasGlyph(@NonNull Paint paint, @NonNull String string) {
        int length = string.length();
        if (length == 1 && Character.isWhitespace(string.charAt(0))) {
            return true;
        }
        float missingGlyphWidth = paint.measureText(TOFU_STRING);
        float width = paint.measureText(string);
        if (width == 0.0f) {
            return false;
        }
        if (string.codePointCount(0, string.length()) > 1) {
            int charCount;
            if (width > 2.0f * missingGlyphWidth) {
                return false;
            }
            float sumWidth = 0.0f;
            for (int i = 0; i < length; i += charCount) {
                charCount = Character.charCount(string.codePointAt(i));
                sumWidth += paint.measureText(string, i, i + charCount);
            }
            if (width >= sumWidth) {
                return false;
            }
        }
        if (width != missingGlyphWidth) {
            return true;
        }
        Pair<Rect, Rect> rects = PaintCompatGingerbread.obtainEmptyRects();
        paint.getTextBounds(TOFU_STRING, 0, TOFU_STRING.length(), (Rect)rects.first);
        paint.getTextBounds(string, 0, length, (Rect)rects.second);
        return !((Rect)rects.first).equals(rects.second);
    }

    private static Pair<Rect, Rect> obtainEmptyRects() {
        Pair<Rect, Rect> rects = sRectThreadLocal.get();
        if (rects == null) {
            rects = new Pair<Rect, Rect>(new Rect(), new Rect());
            sRectThreadLocal.set(rects);
        } else {
            ((Rect)rects.first).setEmpty();
            ((Rect)rects.second).setEmpty();
        }
        return rects;
    }
}

