/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.view.NestedScrollingParent;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;

public final class ViewParentCompat {
    private static final String TAG = "ViewParentCompat";
    static final ViewParentCompatBaseImpl IMPL;

    private ViewParentCompat() {
    }

    @Deprecated
    public static boolean requestSendAccessibilityEvent(ViewParent parent, View child, AccessibilityEvent event) {
        return parent.requestSendAccessibilityEvent(child, event);
    }

    public static boolean onStartNestedScroll(ViewParent parent, View child, View target, int nestedScrollAxes) {
        return IMPL.onStartNestedScroll(parent, child, target, nestedScrollAxes);
    }

    public static void onNestedScrollAccepted(ViewParent parent, View child, View target, int nestedScrollAxes) {
        IMPL.onNestedScrollAccepted(parent, child, target, nestedScrollAxes);
    }

    public static void onStopNestedScroll(ViewParent parent, View target) {
        IMPL.onStopNestedScroll(parent, target);
    }

    public static void onNestedScroll(ViewParent parent, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        IMPL.onNestedScroll(parent, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
    }

    public static void onNestedPreScroll(ViewParent parent, View target, int dx, int dy, int[] consumed) {
        IMPL.onNestedPreScroll(parent, target, dx, dy, consumed);
    }

    public static boolean onNestedFling(ViewParent parent, View target, float velocityX, float velocityY, boolean consumed) {
        return IMPL.onNestedFling(parent, target, velocityX, velocityY, consumed);
    }

    public static boolean onNestedPreFling(ViewParent parent, View target, float velocityX, float velocityY) {
        return IMPL.onNestedPreFling(parent, target, velocityX, velocityY);
    }

    public static void notifySubtreeAccessibilityStateChanged(ViewParent parent, View child, View source, int changeType) {
        IMPL.notifySubtreeAccessibilityStateChanged(parent, child, source, changeType);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 21 ? new ViewParentCompatApi21Impl() : (version >= 19 ? new ViewParentCompatApi19Impl() : new ViewParentCompatBaseImpl());
    }

    @RequiresApi(value=21)
    static class ViewParentCompatApi21Impl
    extends ViewParentCompatApi19Impl {
        ViewParentCompatApi21Impl() {
        }

        @Override
        public boolean onStartNestedScroll(ViewParent parent, View child, View target, int nestedScrollAxes) {
            try {
                return parent.onStartNestedScroll(child, target, nestedScrollAxes);
            }
            catch (AbstractMethodError e) {
                Log.e((String)ViewParentCompat.TAG, (String)("ViewParent " + parent + " does not implement interface " + "method onStartNestedScroll"), (Throwable)e);
                return false;
            }
        }

        @Override
        public void onNestedScrollAccepted(ViewParent parent, View child, View target, int nestedScrollAxes) {
            try {
                parent.onNestedScrollAccepted(child, target, nestedScrollAxes);
            }
            catch (AbstractMethodError e) {
                Log.e((String)ViewParentCompat.TAG, (String)("ViewParent " + parent + " does not implement interface " + "method onNestedScrollAccepted"), (Throwable)e);
            }
        }

        @Override
        public void onStopNestedScroll(ViewParent parent, View target) {
            try {
                parent.onStopNestedScroll(target);
            }
            catch (AbstractMethodError e) {
                Log.e((String)ViewParentCompat.TAG, (String)("ViewParent " + parent + " does not implement interface " + "method onStopNestedScroll"), (Throwable)e);
            }
        }

        @Override
        public void onNestedScroll(ViewParent parent, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
            try {
                parent.onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
            }
            catch (AbstractMethodError e) {
                Log.e((String)ViewParentCompat.TAG, (String)("ViewParent " + parent + " does not implement interface " + "method onNestedScroll"), (Throwable)e);
            }
        }

        @Override
        public void onNestedPreScroll(ViewParent parent, View target, int dx, int dy, int[] consumed) {
            try {
                parent.onNestedPreScroll(target, dx, dy, consumed);
            }
            catch (AbstractMethodError e) {
                Log.e((String)ViewParentCompat.TAG, (String)("ViewParent " + parent + " does not implement interface " + "method onNestedPreScroll"), (Throwable)e);
            }
        }

        @Override
        public boolean onNestedFling(ViewParent parent, View target, float velocityX, float velocityY, boolean consumed) {
            try {
                return parent.onNestedFling(target, velocityX, velocityY, consumed);
            }
            catch (AbstractMethodError e) {
                Log.e((String)ViewParentCompat.TAG, (String)("ViewParent " + parent + " does not implement interface " + "method onNestedFling"), (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean onNestedPreFling(ViewParent parent, View target, float velocityX, float velocityY) {
            try {
                return parent.onNestedPreFling(target, velocityX, velocityY);
            }
            catch (AbstractMethodError e) {
                Log.e((String)ViewParentCompat.TAG, (String)("ViewParent " + parent + " does not implement interface " + "method onNestedPreFling"), (Throwable)e);
                return false;
            }
        }
    }

    @RequiresApi(value=19)
    static class ViewParentCompatApi19Impl
    extends ViewParentCompatBaseImpl {
        ViewParentCompatApi19Impl() {
        }

        @Override
        public void notifySubtreeAccessibilityStateChanged(ViewParent parent, View child, View source, int changeType) {
            parent.notifySubtreeAccessibilityStateChanged(child, source, changeType);
        }
    }

    static class ViewParentCompatBaseImpl {
        ViewParentCompatBaseImpl() {
        }

        public boolean onStartNestedScroll(ViewParent parent, View child, View target, int nestedScrollAxes) {
            if (parent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)parent).onStartNestedScroll(child, target, nestedScrollAxes);
            }
            return false;
        }

        public void onNestedScrollAccepted(ViewParent parent, View child, View target, int nestedScrollAxes) {
            if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onNestedScrollAccepted(child, target, nestedScrollAxes);
            }
        }

        public void onStopNestedScroll(ViewParent parent, View target) {
            if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onStopNestedScroll(target);
            }
        }

        public void onNestedScroll(ViewParent parent, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
            if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
            }
        }

        public void onNestedPreScroll(ViewParent parent, View target, int dx, int dy, int[] consumed) {
            if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onNestedPreScroll(target, dx, dy, consumed);
            }
        }

        public boolean onNestedFling(ViewParent parent, View target, float velocityX, float velocityY, boolean consumed) {
            if (parent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)parent).onNestedFling(target, velocityX, velocityY, consumed);
            }
            return false;
        }

        public boolean onNestedPreFling(ViewParent parent, View target, float velocityX, float velocityY) {
            if (parent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)parent).onNestedPreFling(target, velocityX, velocityY);
            }
            return false;
        }

        public void notifySubtreeAccessibilityStateChanged(ViewParent parent, View child, View source, int changeType) {
        }
    }
}

