/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics.fonts;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.Preconditions;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class FontResult
implements Parcelable {
    private final ParcelFileDescriptor mFileDescriptor;
    private final int mTtcIndex;
    private final String mFontVariationSettings;
    private final int mWeight;
    private final boolean mItalic;
    public static final Parcelable.Creator<FontResult> CREATOR = new Parcelable.Creator<FontResult>(){

        public FontResult createFromParcel(Parcel in) {
            return new FontResult(in);
        }

        public FontResult[] newArray(int size) {
            return new FontResult[size];
        }
    };

    public FontResult(@NonNull ParcelFileDescriptor fileDescriptor, int ttcIndex, @Nullable String fontVariationSettings, int weight, boolean italic) {
        this.mFileDescriptor = Preconditions.checkNotNull(fileDescriptor);
        this.mTtcIndex = ttcIndex;
        this.mFontVariationSettings = fontVariationSettings;
        this.mWeight = weight;
        this.mItalic = italic;
    }

    public ParcelFileDescriptor getFileDescriptor() {
        return this.mFileDescriptor;
    }

    public int getTtcIndex() {
        return this.mTtcIndex;
    }

    public String getFontVariationSettings() {
        return this.mFontVariationSettings;
    }

    public int getWeight() {
        return this.mWeight;
    }

    public boolean getItalic() {
        return this.mItalic;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mFileDescriptor, flags);
        dest.writeInt(this.mTtcIndex);
        dest.writeInt(this.mFontVariationSettings != null ? 1 : 0);
        if (this.mFontVariationSettings != null) {
            dest.writeString(this.mFontVariationSettings);
        }
        dest.writeInt(this.mWeight);
        dest.writeInt(this.mItalic ? 1 : 0);
    }

    private FontResult(Parcel in) {
        this.mFileDescriptor = (ParcelFileDescriptor)in.readParcelable(null);
        this.mTtcIndex = in.readInt();
        this.mFontVariationSettings = in.readInt() == 1 ? in.readString() : null;
        this.mWeight = in.readInt();
        this.mItalic = in.readInt() == 1;
    }
}

