/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.v4.content.res.FontResourcesParserCompat;
import android.support.v4.graphics.TypefaceCompat;
import android.support.v4.provider.FontsContractCompat;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=14)
class TypefaceCompatBaseImpl
implements TypefaceCompat.TypefaceCompatImpl {
    private static final String TAG = "TypefaceCompatBaseImpl";
    private static final String CACHE_FILE_PREFIX = "cached_font_";

    TypefaceCompatBaseImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Typeface createTypeface(Context context, @NonNull FontsContractCompat.FontInfo[] fonts, Map<Uri, ByteBuffer> uriBuffer) {
        if (fonts.length < 1) {
            return null;
        }
        Typeface typeface = null;
        FontsContractCompat.FontInfo font = fonts[0];
        ByteBuffer buffer = uriBuffer.get(font.getUri());
        File tmpFile = TypefaceCompatBaseImpl.copyToCacheFile(context, buffer);
        if (tmpFile != null) {
            try {
                typeface = Typeface.createFromFile((String)tmpFile.getPath());
            }
            catch (RuntimeException e) {
                Typeface typeface2 = null;
                return typeface2;
            }
            finally {
                tmpFile.delete();
            }
        }
        return typeface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyToCacheFile(Context context, InputStream is) {
        File cacheFile;
        FileOutputStream fos = null;
        try {
            int readLen;
            cacheFile = new File(context.getCacheDir(), CACHE_FILE_PREFIX + Thread.currentThread().getId());
            fos = new FileOutputStream(cacheFile, false);
            byte[] buffer = new byte[1024];
            while ((readLen = is.read(buffer)) != -1) {
                fos.write(buffer, 0, readLen);
            }
            TypefaceCompatBaseImpl.closeQuietly(is);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error copying font file descriptor to temp local file.", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            TypefaceCompatBaseImpl.closeQuietly(is);
            TypefaceCompatBaseImpl.closeQuietly(fos);
        }
        TypefaceCompatBaseImpl.closeQuietly(fos);
        return cacheFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyToCacheFile(Context context, ByteBuffer is) {
        File cacheFile;
        FileOutputStream fos = null;
        try {
            cacheFile = new File(context.getCacheDir(), CACHE_FILE_PREFIX + Thread.currentThread().getId());
            fos = new FileOutputStream(cacheFile, false);
            byte[] buffer = new byte[1024];
            while (is.hasRemaining()) {
                int len = Math.min(1024, is.remaining());
                is.get(buffer, 0, len);
                fos.write(buffer, 0, len);
            }
            TypefaceCompatBaseImpl.closeQuietly(fos);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error copying font file descriptor to temp local file.", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            TypefaceCompatBaseImpl.closeQuietly(fos);
        }
        return cacheFile;
    }

    private static void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException io) {
                Log.e((String)TAG, (String)"Error closing input stream", (Throwable)io);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Typeface createFromResourcesFontFile(Context context, Resources resources, int id, int style) {
        InputStream is = null;
        try {
            is = resources.openRawResource(id);
            Typeface typeface = this.createTypeface(context, resources, is);
            return typeface;
        }
        catch (IOException e) {
            Typeface typeface = null;
            return typeface;
        }
        finally {
            TypefaceCompatBaseImpl.closeQuietly(is);
        }
    }

    private FontResourcesParserCompat.FontFileResourceEntry findBestEntry(FontResourcesParserCompat.FontFamilyFilesResourceEntry entry, int targetWeight, boolean isTargetItalic) {
        FontResourcesParserCompat.FontFileResourceEntry bestEntry = null;
        int bestScore = Integer.MAX_VALUE;
        for (FontResourcesParserCompat.FontFileResourceEntry e : entry.getEntries()) {
            int score = Math.abs(e.getWeight() - targetWeight) * 2 + (isTargetItalic == e.isItalic() ? 0 : 1);
            if (bestEntry != null && bestScore <= score) continue;
            bestEntry = e;
            bestScore = score;
        }
        return bestEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Override
    @Nullable
    public Typeface createFromFontFamilyFilesResourceEntry(Context context, FontResourcesParserCompat.FontFamilyFilesResourceEntry entry, Resources resources, int id, int style) {
        Typeface typeface;
        FontResourcesParserCompat.FontFileResourceEntry best = this.findBestEntry(entry, (style & 1) == 0 ? 400 : 700, (style & 2) != 0);
        if (best == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = resources.openRawResource(best.getResourceId());
            typeface = this.createTypeface(context, resources, is);
        }
        catch (IOException iOException) {
            TypefaceCompatBaseImpl.closeQuietly(is);
            catch (Throwable throwable) {
                TypefaceCompatBaseImpl.closeQuietly(is);
                throw throwable;
            }
        }
        TypefaceCompatBaseImpl.closeQuietly(is);
        return typeface;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Typeface createTypeface(Context context, Resources resources, InputStream is) throws IOException {
        File tmpFile = TypefaceCompatBaseImpl.copyToCacheFile(context, is);
        if (tmpFile != null) {
            try {
                Typeface typeface = Typeface.createFromFile((String)tmpFile.getPath());
                return typeface;
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Failed to create font", (Throwable)e);
                Typeface typeface = null;
                return typeface;
            }
            finally {
                tmpFile.delete();
            }
        }
        return null;
    }

    static void closeQuietly(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException io) {
                Log.e((String)TAG, (String)"Error closing stream", (Throwable)io);
            }
        }
    }
}

