/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.PatternsCompat;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.webkit.WebView;
import android.widget.TextView;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LinkifyCompat {
    private static final String[] EMPTY_STRING = new String[0];
    private static final Comparator<LinkSpec> COMPARATOR = new Comparator<LinkSpec>(){

        @Override
        public final int compare(LinkSpec a, LinkSpec b) {
            if (a.start < b.start) {
                return -1;
            }
            if (a.start > b.start) {
                return 1;
            }
            if (a.end < b.end) {
                return 1;
            }
            if (a.end > b.end) {
                return -1;
            }
            return 0;
        }
    };

    public static final boolean addLinks(@NonNull Spannable text, int mask) {
        if (mask == 0) {
            return false;
        }
        URLSpan[] old = (URLSpan[])text.getSpans(0, text.length(), URLSpan.class);
        for (int i = old.length - 1; i >= 0; --i) {
            text.removeSpan((Object)old[i]);
        }
        boolean frameworkReturn = false;
        if ((mask & 4) != 0) {
            frameworkReturn = Linkify.addLinks((Spannable)text, (int)4);
        }
        ArrayList<LinkSpec> links = new ArrayList<LinkSpec>();
        if ((mask & 1) != 0) {
            LinkifyCompat.gatherLinks(links, text, PatternsCompat.AUTOLINK_WEB_URL, new String[]{"http://", "https://", "rtsp://"}, Linkify.sUrlMatchFilter, null);
        }
        if ((mask & 2) != 0) {
            LinkifyCompat.gatherLinks(links, text, PatternsCompat.AUTOLINK_EMAIL_ADDRESS, new String[]{"mailto:"}, null, null);
        }
        if ((mask & 8) != 0) {
            LinkifyCompat.gatherMapLinks(links, text);
        }
        LinkifyCompat.pruneOverlaps(links, text);
        if (links.size() == 0) {
            return false;
        }
        for (LinkSpec link : links) {
            if (link.frameworkAddedSpan != null) continue;
            LinkifyCompat.applyLink(link.url, link.start, link.end, text);
        }
        return true;
    }

    public static final boolean addLinks(@NonNull TextView text, int mask) {
        if (mask == 0) {
            return false;
        }
        CharSequence t = text.getText();
        if (t instanceof Spannable) {
            if (LinkifyCompat.addLinks((Spannable)t, mask)) {
                LinkifyCompat.addLinkMovementMethod(text);
                return true;
            }
            return false;
        }
        SpannableString s = SpannableString.valueOf((CharSequence)t);
        if (LinkifyCompat.addLinks((Spannable)s, mask)) {
            LinkifyCompat.addLinkMovementMethod(text);
            text.setText((CharSequence)s);
            return true;
        }
        return false;
    }

    public static final void addLinks(@NonNull TextView text, @NonNull Pattern pattern, @Nullable String scheme) {
        LinkifyCompat.addLinks(text, pattern, scheme, null, null, null);
    }

    public static final void addLinks(@NonNull TextView text, @NonNull Pattern pattern, @Nullable String scheme, @Nullable Linkify.MatchFilter matchFilter, @Nullable Linkify.TransformFilter transformFilter) {
        LinkifyCompat.addLinks(text, pattern, scheme, null, matchFilter, transformFilter);
    }

    public static final void addLinks(@NonNull TextView text, @NonNull Pattern pattern, @Nullable String defaultScheme, @Nullable String[] schemes, @Nullable Linkify.MatchFilter matchFilter, @Nullable Linkify.TransformFilter transformFilter) {
        SpannableString spannable = SpannableString.valueOf((CharSequence)text.getText());
        boolean linksAdded = LinkifyCompat.addLinks((Spannable)spannable, pattern, defaultScheme, schemes, matchFilter, transformFilter);
        if (linksAdded) {
            text.setText((CharSequence)spannable);
            LinkifyCompat.addLinkMovementMethod(text);
        }
    }

    public static final boolean addLinks(@NonNull Spannable text, @NonNull Pattern pattern, @Nullable String scheme) {
        return LinkifyCompat.addLinks(text, pattern, scheme, null, null, null);
    }

    public static final boolean addLinks(@NonNull Spannable spannable, @NonNull Pattern pattern, @Nullable String scheme, @Nullable Linkify.MatchFilter matchFilter, @Nullable Linkify.TransformFilter transformFilter) {
        return LinkifyCompat.addLinks(spannable, pattern, scheme, null, matchFilter, transformFilter);
    }

    public static final boolean addLinks(@NonNull Spannable spannable, @NonNull Pattern pattern, @Nullable String defaultScheme, @Nullable String[] schemes, @Nullable Linkify.MatchFilter matchFilter, @Nullable Linkify.TransformFilter transformFilter) {
        if (defaultScheme == null) {
            defaultScheme = "";
        }
        if (schemes == null || schemes.length < 1) {
            schemes = EMPTY_STRING;
        }
        String[] schemesCopy = new String[schemes.length + 1];
        schemesCopy[0] = defaultScheme.toLowerCase(Locale.ROOT);
        for (int index = 0; index < schemes.length; ++index) {
            String scheme = schemes[index];
            schemesCopy[index + 1] = scheme == null ? "" : scheme.toLowerCase(Locale.ROOT);
        }
        boolean hasMatches = false;
        Matcher m = pattern.matcher((CharSequence)spannable);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            boolean allowed = true;
            if (matchFilter != null) {
                allowed = matchFilter.acceptMatch((CharSequence)spannable, start, end);
            }
            if (!allowed) continue;
            String url = LinkifyCompat.makeUrl(m.group(0), schemesCopy, m, transformFilter);
            LinkifyCompat.applyLink(url, start, end, spannable);
            hasMatches = true;
        }
        return hasMatches;
    }

    private static void addLinkMovementMethod(@NonNull TextView t) {
        MovementMethod m = t.getMovementMethod();
        if ((m == null || !(m instanceof LinkMovementMethod)) && t.getLinksClickable()) {
            t.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    private static String makeUrl(@NonNull String url, @NonNull String[] prefixes, Matcher matcher, @Nullable Linkify.TransformFilter filter) {
        if (filter != null) {
            url = filter.transformUrl(matcher, url);
        }
        boolean hasPrefix = false;
        for (int i = 0; i < prefixes.length; ++i) {
            if (!url.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
            hasPrefix = true;
            if (url.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
            url = prefixes[i] + url.substring(prefixes[i].length());
            break;
        }
        if (!hasPrefix && prefixes.length > 0) {
            url = prefixes[0] + url;
        }
        return url;
    }

    private static void gatherLinks(ArrayList<LinkSpec> links, Spannable s, Pattern pattern, String[] schemes, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        Matcher m = pattern.matcher((CharSequence)s);
        while (m.find()) {
            String url;
            int start = m.start();
            int end = m.end();
            if (matchFilter != null && !matchFilter.acceptMatch((CharSequence)s, start, end)) continue;
            LinkSpec spec = new LinkSpec();
            spec.url = url = LinkifyCompat.makeUrl(m.group(0), schemes, m, transformFilter);
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    private static void applyLink(String url, int start, int end, Spannable text) {
        URLSpan span = new URLSpan(url);
        text.setSpan((Object)span, start, end, 33);
    }

    private static final void gatherMapLinks(ArrayList<LinkSpec> links, Spannable s) {
        String string = s.toString();
        int base = 0;
        try {
            int start;
            String address;
            while ((address = WebView.findAddress((String)string)) != null && (start = string.indexOf(address)) >= 0) {
                LinkSpec spec = new LinkSpec();
                int length = address.length();
                int end = start + length;
                spec.start = base + start;
                spec.end = base + end;
                string = string.substring(end);
                base += end;
                String encodedAddress = null;
                try {
                    encodedAddress = URLEncoder.encode(address, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    continue;
                }
                spec.url = "geo:0,0?q=" + encodedAddress;
                links.add(spec);
            }
        }
        catch (UnsupportedOperationException e) {
            return;
        }
    }

    private static final void pruneOverlaps(ArrayList<LinkSpec> links, Spannable text) {
        URLSpan[] urlSpans = (URLSpan[])text.getSpans(0, text.length(), URLSpan.class);
        for (int i = 0; i < urlSpans.length; ++i) {
            LinkSpec spec = new LinkSpec();
            spec.frameworkAddedSpan = urlSpans[i];
            spec.start = text.getSpanStart((Object)urlSpans[i]);
            spec.end = text.getSpanEnd((Object)urlSpans[i]);
            links.add(spec);
        }
        Collections.sort(links, COMPARATOR);
        int len = links.size();
        int i = 0;
        while (i < len - 1) {
            LinkSpec a = links.get(i);
            LinkSpec b = links.get(i + 1);
            int remove = -1;
            if (a.start <= b.start && a.end > b.start) {
                if (b.end <= a.end) {
                    remove = i + 1;
                } else if (a.end - a.start > b.end - b.start) {
                    remove = i + 1;
                } else if (a.end - a.start < b.end - b.start) {
                    remove = i;
                }
                if (remove != -1) {
                    URLSpan span = links.get((int)remove).frameworkAddedSpan;
                    if (span != null) {
                        text.removeSpan((Object)span);
                    }
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
    }

    private LinkifyCompat() {
    }

    private static class LinkSpec {
        URLSpan frameworkAddedSpan;
        String url;
        int start;
        int end;

        LinkSpec() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LinkifyMask {
    }
}

