/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.v4.util.Preconditions;

public final class PathSegment {
    private final PointF mStart;
    private final float mStartFraction;
    private final PointF mEnd;
    private final float mEndFraction;

    public PathSegment(@NonNull PointF start, float startFraction, @NonNull PointF end, float endFraction) {
        this.mStart = Preconditions.checkNotNull(start, "start == null");
        this.mStartFraction = startFraction;
        this.mEnd = Preconditions.checkNotNull(end, "end == null");
        this.mEndFraction = endFraction;
    }

    @NonNull
    public PointF getStart() {
        return this.mStart;
    }

    public float getStartFraction() {
        return this.mStartFraction;
    }

    @NonNull
    public PointF getEnd() {
        return this.mEnd;
    }

    public float getEndFraction() {
        return this.mEndFraction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathSegment)) {
            return false;
        }
        PathSegment that = (PathSegment)o;
        return Float.compare(this.mStartFraction, that.mStartFraction) == 0 && Float.compare(this.mEndFraction, that.mEndFraction) == 0 && this.mStart.equals((Object)that.mStart) && this.mEnd.equals((Object)that.mEnd);
    }

    public int hashCode() {
        int result = this.mStart.hashCode();
        result = 31 * result + (this.mStartFraction != 0.0f ? Float.floatToIntBits(this.mStartFraction) : 0);
        result = 31 * result + this.mEnd.hashCode();
        result = 31 * result + (this.mEndFraction != 0.0f ? Float.floatToIntBits(this.mEndFraction) : 0);
        return result;
    }

    public String toString() {
        return "PathSegment{start=" + this.mStart + ", startFraction=" + this.mStartFraction + ", end=" + this.mEnd + ", endFraction=" + this.mEndFraction + '}';
    }
}

