/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.v4.app.BundleCompat;
import android.support.v4.app.SupportActivity;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.IMediaControllerCallback;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaControllerCompatApi21;
import android.support.v4.media.session.MediaControllerCompatApi23;
import android.support.v4.media.session.MediaControllerCompatApi24;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.ParcelableVolumeInfo;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class MediaControllerCompat {
    static final String TAG = "MediaControllerCompat";
    static final String COMMAND_GET_EXTRA_BINDER = "android.support.v4.media.session.command.GET_EXTRA_BINDER";
    static final String COMMAND_ADD_QUEUE_ITEM = "android.support.v4.media.session.command.ADD_QUEUE_ITEM";
    static final String COMMAND_ADD_QUEUE_ITEM_AT = "android.support.v4.media.session.command.ADD_QUEUE_ITEM_AT";
    static final String COMMAND_REMOVE_QUEUE_ITEM = "android.support.v4.media.session.command.REMOVE_QUEUE_ITEM";
    static final String COMMAND_REMOVE_QUEUE_ITEM_AT = "android.support.v4.media.session.command.REMOVE_QUEUE_ITEM_AT";
    static final String COMMAND_ARGUMENT_MEDIA_DESCRIPTION = "android.support.v4.media.session.command.ARGUMENT_MEDIA_DESCRIPTION";
    static final String COMMAND_ARGUMENT_INDEX = "android.support.v4.media.session.command.ARGUMENT_INDEX";
    private final MediaControllerImpl mImpl;
    private final MediaSessionCompat.Token mToken;

    public static void setMediaController(Activity activity, MediaControllerCompat mediaController) {
        if (activity instanceof SupportActivity) {
            ((SupportActivity)activity).putExtraData((SupportActivity.ExtraData)new MediaControllerExtraData(mediaController));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Object controllerObj = null;
            if (mediaController != null) {
                Object sessionTokenObj = mediaController.getSessionToken().getToken();
                controllerObj = MediaControllerCompatApi21.fromToken((Context)activity, sessionTokenObj);
            }
            MediaControllerCompatApi21.setMediaController(activity, controllerObj);
        }
    }

    public static MediaControllerCompat getMediaController(Activity activity) {
        if (activity instanceof SupportActivity) {
            MediaControllerExtraData extraData = (MediaControllerExtraData)((SupportActivity)activity).getExtraData(MediaControllerExtraData.class);
            return extraData != null ? extraData.getMediaController() : null;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Object controllerObj = MediaControllerCompatApi21.getMediaController(activity);
            if (controllerObj == null) {
                return null;
            }
            Object sessionTokenObj = MediaControllerCompatApi21.getSessionToken(controllerObj);
            try {
                return new MediaControllerCompat((Context)activity, MediaSessionCompat.Token.fromToken(sessionTokenObj));
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Dead object in getMediaController.", (Throwable)e);
            }
        }
        return null;
    }

    public MediaControllerCompat(Context context, MediaSessionCompat session) {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        this.mToken = session.getSessionToken();
        this.mImpl = Build.VERSION.SDK_INT >= 24 ? new MediaControllerImplApi24(context, session) : (Build.VERSION.SDK_INT >= 23 ? new MediaControllerImplApi23(context, session) : (Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, session) : new MediaControllerImplBase(this.mToken)));
    }

    public MediaControllerCompat(Context context, MediaSessionCompat.Token sessionToken) throws RemoteException {
        if (sessionToken == null) {
            throw new IllegalArgumentException("sessionToken must not be null");
        }
        this.mToken = sessionToken;
        this.mImpl = Build.VERSION.SDK_INT >= 24 ? new MediaControllerImplApi24(context, sessionToken) : (Build.VERSION.SDK_INT >= 23 ? new MediaControllerImplApi23(context, sessionToken) : (Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, sessionToken) : new MediaControllerImplBase(this.mToken)));
    }

    public TransportControls getTransportControls() {
        return this.mImpl.getTransportControls();
    }

    public boolean dispatchMediaButtonEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            throw new IllegalArgumentException("KeyEvent may not be null");
        }
        return this.mImpl.dispatchMediaButtonEvent(keyEvent);
    }

    public PlaybackStateCompat getPlaybackState() {
        return this.mImpl.getPlaybackState();
    }

    public MediaMetadataCompat getMetadata() {
        return this.mImpl.getMetadata();
    }

    public List<MediaSessionCompat.QueueItem> getQueue() {
        return this.mImpl.getQueue();
    }

    public void addQueueItem(MediaDescriptionCompat description) {
        this.mImpl.addQueueItem(description);
    }

    public void addQueueItem(MediaDescriptionCompat description, int index) {
        this.mImpl.addQueueItem(description, index);
    }

    public void removeQueueItem(MediaDescriptionCompat description) {
        this.mImpl.removeQueueItem(description);
    }

    public void removeQueueItemAt(int index) {
        this.mImpl.removeQueueItemAt(index);
    }

    public CharSequence getQueueTitle() {
        return this.mImpl.getQueueTitle();
    }

    public Bundle getExtras() {
        return this.mImpl.getExtras();
    }

    public int getRatingType() {
        return this.mImpl.getRatingType();
    }

    public boolean isCaptioningEnabled() {
        return this.mImpl.isCaptioningEnabled();
    }

    public int getRepeatMode() {
        return this.mImpl.getRepeatMode();
    }

    public boolean isShuffleModeEnabled() {
        return this.mImpl.isShuffleModeEnabled();
    }

    public long getFlags() {
        return this.mImpl.getFlags();
    }

    public PlaybackInfo getPlaybackInfo() {
        return this.mImpl.getPlaybackInfo();
    }

    public PendingIntent getSessionActivity() {
        return this.mImpl.getSessionActivity();
    }

    public MediaSessionCompat.Token getSessionToken() {
        return this.mToken;
    }

    public void setVolumeTo(int value, int flags) {
        this.mImpl.setVolumeTo(value, flags);
    }

    public void adjustVolume(int direction, int flags) {
        this.mImpl.adjustVolume(direction, flags);
    }

    public void registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    public void registerCallback(Callback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        this.mImpl.registerCallback(callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.mImpl.unregisterCallback(callback);
    }

    public void sendCommand(String command, Bundle params, ResultReceiver cb) {
        if (TextUtils.isEmpty((CharSequence)command)) {
            throw new IllegalArgumentException("command cannot be null or empty");
        }
        this.mImpl.sendCommand(command, params, cb);
    }

    public String getPackageName() {
        return this.mImpl.getPackageName();
    }

    public Object getMediaController() {
        return this.mImpl.getMediaController();
    }

    static class TransportControlsApi24
    extends TransportControlsApi23 {
        public TransportControlsApi24(Object controlsObj) {
            super(controlsObj);
        }

        @Override
        public void prepare() {
            MediaControllerCompatApi24.TransportControls.prepare(this.mControlsObj);
        }

        @Override
        public void prepareFromMediaId(String mediaId, Bundle extras) {
            MediaControllerCompatApi24.TransportControls.prepareFromMediaId(this.mControlsObj, mediaId, extras);
        }

        @Override
        public void prepareFromSearch(String query, Bundle extras) {
            MediaControllerCompatApi24.TransportControls.prepareFromSearch(this.mControlsObj, query, extras);
        }

        @Override
        public void prepareFromUri(Uri uri, Bundle extras) {
            MediaControllerCompatApi24.TransportControls.prepareFromUri(this.mControlsObj, uri, extras);
        }
    }

    static class MediaControllerImplApi24
    extends MediaControllerImplApi23 {
        public MediaControllerImplApi24(Context context, MediaSessionCompat session) {
            super(context, session);
        }

        public MediaControllerImplApi24(Context context, MediaSessionCompat.Token sessionToken) throws RemoteException {
            super(context, sessionToken);
        }

        @Override
        public TransportControls getTransportControls() {
            Object controlsObj = MediaControllerCompatApi21.getTransportControls(this.mControllerObj);
            return controlsObj != null ? new TransportControlsApi24(controlsObj) : null;
        }
    }

    static class TransportControlsApi23
    extends TransportControlsApi21 {
        public TransportControlsApi23(Object controlsObj) {
            super(controlsObj);
        }

        @Override
        public void playFromUri(Uri uri, Bundle extras) {
            MediaControllerCompatApi23.TransportControls.playFromUri(this.mControlsObj, uri, extras);
        }
    }

    static class MediaControllerImplApi23
    extends MediaControllerImplApi21 {
        public MediaControllerImplApi23(Context context, MediaSessionCompat session) {
            super(context, session);
        }

        public MediaControllerImplApi23(Context context, MediaSessionCompat.Token sessionToken) throws RemoteException {
            super(context, sessionToken);
        }

        @Override
        public TransportControls getTransportControls() {
            Object controlsObj = MediaControllerCompatApi21.getTransportControls(this.mControllerObj);
            return controlsObj != null ? new TransportControlsApi23(controlsObj) : null;
        }
    }

    static class TransportControlsApi21
    extends TransportControls {
        protected final Object mControlsObj;

        public TransportControlsApi21(Object controlsObj) {
            this.mControlsObj = controlsObj;
        }

        @Override
        public void prepare() {
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE", null);
        }

        @Override
        public void prepareFromMediaId(String mediaId, Bundle extras) {
            Bundle bundle = new Bundle();
            bundle.putString("android.support.v4.media.session.action.ARGUMENT_MEDIA_ID", mediaId);
            bundle.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", extras);
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE_FROM_MEDIA_ID", bundle);
        }

        @Override
        public void prepareFromSearch(String query, Bundle extras) {
            Bundle bundle = new Bundle();
            bundle.putString("android.support.v4.media.session.action.ARGUMENT_QUERY", query);
            bundle.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", extras);
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE_FROM_SEARCH", bundle);
        }

        @Override
        public void prepareFromUri(Uri uri, Bundle extras) {
            Bundle bundle = new Bundle();
            bundle.putParcelable("android.support.v4.media.session.action.ARGUMENT_URI", (Parcelable)uri);
            bundle.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", extras);
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE_FROM_URI", bundle);
        }

        @Override
        public void play() {
            MediaControllerCompatApi21.TransportControls.play(this.mControlsObj);
        }

        @Override
        public void pause() {
            MediaControllerCompatApi21.TransportControls.pause(this.mControlsObj);
        }

        @Override
        public void stop() {
            MediaControllerCompatApi21.TransportControls.stop(this.mControlsObj);
        }

        @Override
        public void seekTo(long pos) {
            MediaControllerCompatApi21.TransportControls.seekTo(this.mControlsObj, pos);
        }

        @Override
        public void fastForward() {
            MediaControllerCompatApi21.TransportControls.fastForward(this.mControlsObj);
        }

        @Override
        public void rewind() {
            MediaControllerCompatApi21.TransportControls.rewind(this.mControlsObj);
        }

        @Override
        public void skipToNext() {
            MediaControllerCompatApi21.TransportControls.skipToNext(this.mControlsObj);
        }

        @Override
        public void skipToPrevious() {
            MediaControllerCompatApi21.TransportControls.skipToPrevious(this.mControlsObj);
        }

        @Override
        public void setRating(RatingCompat rating) {
            MediaControllerCompatApi21.TransportControls.setRating(this.mControlsObj, rating != null ? rating.getRating() : null);
        }

        @Override
        public void setCaptioningEnabled(boolean enabled) {
            Bundle bundle = new Bundle();
            bundle.putBoolean("android.support.v4.media.session.action.ARGUMENT_CAPTIONING_ENABLED", enabled);
            this.sendCustomAction("android.support.v4.media.session.action.SET_CAPTIONING_ENABLED", bundle);
        }

        @Override
        public void setRepeatMode(int repeatMode) {
            Bundle bundle = new Bundle();
            bundle.putInt("android.support.v4.media.session.action.ARGUMENT_REPEAT_MODE", repeatMode);
            this.sendCustomAction("android.support.v4.media.session.action.SET_REPEAT_MODE", bundle);
        }

        @Override
        public void setShuffleModeEnabled(boolean enabled) {
            Bundle bundle = new Bundle();
            bundle.putBoolean("android.support.v4.media.session.action.ARGUMENT_SHUFFLE_MODE_ENABLED", enabled);
            this.sendCustomAction("android.support.v4.media.session.action.SET_SHUFFLE_MODE_ENABLED", bundle);
        }

        @Override
        public void playFromMediaId(String mediaId, Bundle extras) {
            MediaControllerCompatApi21.TransportControls.playFromMediaId(this.mControlsObj, mediaId, extras);
        }

        @Override
        public void playFromSearch(String query, Bundle extras) {
            MediaControllerCompatApi21.TransportControls.playFromSearch(this.mControlsObj, query, extras);
        }

        @Override
        public void playFromUri(Uri uri, Bundle extras) {
            if (uri == null || Uri.EMPTY.equals((Object)uri)) {
                throw new IllegalArgumentException("You must specify a non-empty Uri for playFromUri.");
            }
            Bundle bundle = new Bundle();
            bundle.putParcelable("android.support.v4.media.session.action.ARGUMENT_URI", (Parcelable)uri);
            bundle.putParcelable("android.support.v4.media.session.action.ARGUMENT_EXTRAS", (Parcelable)extras);
            this.sendCustomAction("android.support.v4.media.session.action.PLAY_FROM_URI", bundle);
        }

        @Override
        public void skipToQueueItem(long id) {
            MediaControllerCompatApi21.TransportControls.skipToQueueItem(this.mControlsObj, id);
        }

        @Override
        public void sendCustomAction(PlaybackStateCompat.CustomAction customAction, Bundle args) {
            MediaControllerCompatApi21.TransportControls.sendCustomAction(this.mControlsObj, customAction.getAction(), args);
        }

        @Override
        public void sendCustomAction(String action, Bundle args) {
            MediaControllerCompatApi21.TransportControls.sendCustomAction(this.mControlsObj, action, args);
        }
    }

    static class MediaControllerImplApi21
    implements MediaControllerImpl {
        protected final Object mControllerObj;
        private IMediaSession mExtraBinder;
        private HashMap<Callback, ExtraCallback> mCallbackMap = new HashMap();
        private List<Callback> mPendingCallbacks = new ArrayList<Callback>();

        public MediaControllerImplApi21(Context context, MediaSessionCompat session) {
            this.mControllerObj = MediaControllerCompatApi21.fromToken(context, session.getSessionToken().getToken());
            this.mExtraBinder = session.getSessionToken().getExtraBinder();
            if (this.mExtraBinder == null) {
                this.requestExtraBinder();
            }
        }

        public MediaControllerImplApi21(Context context, MediaSessionCompat.Token sessionToken) throws RemoteException {
            this.mControllerObj = MediaControllerCompatApi21.fromToken(context, sessionToken.getToken());
            if (this.mControllerObj == null) {
                throw new RemoteException();
            }
            this.mExtraBinder = sessionToken.getExtraBinder();
            if (this.mExtraBinder == null) {
                this.requestExtraBinder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void registerCallback(Callback callback, Handler handler) {
            MediaControllerCompatApi21.registerCallback(this.mControllerObj, callback.mCallbackObj, handler);
            if (this.mExtraBinder != null) {
                callback.setHandler(handler);
                ExtraCallback extraCallback = new ExtraCallback(callback);
                this.mCallbackMap.put(callback, extraCallback);
                callback.mHasExtraCallback = true;
                try {
                    this.mExtraBinder.registerCallbackListener(extraCallback);
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in registerCallback.", (Throwable)e);
                }
            } else {
                callback.setHandler(handler);
                List<Callback> list = this.mPendingCallbacks;
                synchronized (list) {
                    this.mPendingCallbacks.add(callback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void unregisterCallback(Callback callback) {
            MediaControllerCompatApi21.unregisterCallback(this.mControllerObj, callback.mCallbackObj);
            if (this.mExtraBinder != null) {
                try {
                    ExtraCallback extraCallback = this.mCallbackMap.remove(callback);
                    if (extraCallback != null) {
                        this.mExtraBinder.unregisterCallbackListener(extraCallback);
                    }
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in unregisterCallback.", (Throwable)e);
                }
            } else {
                List<Callback> list = this.mPendingCallbacks;
                synchronized (list) {
                    this.mPendingCallbacks.remove(callback);
                }
            }
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent event) {
            return MediaControllerCompatApi21.dispatchMediaButtonEvent(this.mControllerObj, event);
        }

        @Override
        public TransportControls getTransportControls() {
            Object controlsObj = MediaControllerCompatApi21.getTransportControls(this.mControllerObj);
            return controlsObj != null ? new TransportControlsApi21(controlsObj) : null;
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            Object stateObj;
            if (this.mExtraBinder != null) {
                try {
                    return this.mExtraBinder.getPlaybackState();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPlaybackState.", (Throwable)e);
                }
            }
            return (stateObj = MediaControllerCompatApi21.getPlaybackState(this.mControllerObj)) != null ? PlaybackStateCompat.fromPlaybackState(stateObj) : null;
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            Object metadataObj = MediaControllerCompatApi21.getMetadata(this.mControllerObj);
            return metadataObj != null ? MediaMetadataCompat.fromMediaMetadata(metadataObj) : null;
        }

        @Override
        public List<MediaSessionCompat.QueueItem> getQueue() {
            List<Object> queueObjs = MediaControllerCompatApi21.getQueue(this.mControllerObj);
            return queueObjs != null ? MediaSessionCompat.QueueItem.fromQueueItemList(queueObjs) : null;
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat description) {
            long flags = this.getFlags();
            if ((flags & 4L) == 0L) {
                throw new UnsupportedOperationException("This session doesn't support queue management operations");
            }
            Bundle params = new Bundle();
            params.putParcelable(MediaControllerCompat.COMMAND_ARGUMENT_MEDIA_DESCRIPTION, (Parcelable)description);
            this.sendCommand(MediaControllerCompat.COMMAND_ADD_QUEUE_ITEM, params, null);
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat description, int index) {
            long flags = this.getFlags();
            if ((flags & 4L) == 0L) {
                throw new UnsupportedOperationException("This session doesn't support queue management operations");
            }
            Bundle params = new Bundle();
            params.putParcelable(MediaControllerCompat.COMMAND_ARGUMENT_MEDIA_DESCRIPTION, (Parcelable)description);
            params.putInt(MediaControllerCompat.COMMAND_ARGUMENT_INDEX, index);
            this.sendCommand(MediaControllerCompat.COMMAND_ADD_QUEUE_ITEM_AT, params, null);
        }

        @Override
        public void removeQueueItem(MediaDescriptionCompat description) {
            long flags = this.getFlags();
            if ((flags & 4L) == 0L) {
                throw new UnsupportedOperationException("This session doesn't support queue management operations");
            }
            Bundle params = new Bundle();
            params.putParcelable(MediaControllerCompat.COMMAND_ARGUMENT_MEDIA_DESCRIPTION, (Parcelable)description);
            this.sendCommand(MediaControllerCompat.COMMAND_REMOVE_QUEUE_ITEM, params, null);
        }

        @Override
        public void removeQueueItemAt(int index) {
            long flags = this.getFlags();
            if ((flags & 4L) == 0L) {
                throw new UnsupportedOperationException("This session doesn't support queue management operations");
            }
            Bundle params = new Bundle();
            params.putInt(MediaControllerCompat.COMMAND_ARGUMENT_INDEX, index);
            this.sendCommand(MediaControllerCompat.COMMAND_REMOVE_QUEUE_ITEM_AT, params, null);
        }

        @Override
        public CharSequence getQueueTitle() {
            return MediaControllerCompatApi21.getQueueTitle(this.mControllerObj);
        }

        @Override
        public Bundle getExtras() {
            return MediaControllerCompatApi21.getExtras(this.mControllerObj);
        }

        @Override
        public int getRatingType() {
            if (Build.VERSION.SDK_INT < 22 && this.mExtraBinder != null) {
                try {
                    return this.mExtraBinder.getRatingType();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRatingType.", (Throwable)e);
                }
            }
            return MediaControllerCompatApi21.getRatingType(this.mControllerObj);
        }

        @Override
        public boolean isCaptioningEnabled() {
            if (this.mExtraBinder != null) {
                try {
                    return this.mExtraBinder.isCaptioningEnabled();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in isCaptioningEnabled.", (Throwable)e);
                }
            }
            return false;
        }

        @Override
        public int getRepeatMode() {
            if (this.mExtraBinder != null) {
                try {
                    return this.mExtraBinder.getRepeatMode();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRepeatMode.", (Throwable)e);
                }
            }
            return 0;
        }

        @Override
        public boolean isShuffleModeEnabled() {
            if (this.mExtraBinder != null) {
                try {
                    return this.mExtraBinder.isShuffleModeEnabled();
                }
                catch (RemoteException e) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in isShuffleModeEnabled.", (Throwable)e);
                }
            }
            return false;
        }

        @Override
        public long getFlags() {
            return MediaControllerCompatApi21.getFlags(this.mControllerObj);
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            Object volumeInfoObj = MediaControllerCompatApi21.getPlaybackInfo(this.mControllerObj);
            return volumeInfoObj != null ? new PlaybackInfo(MediaControllerCompatApi21.PlaybackInfo.getPlaybackType(volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getLegacyAudioStream(volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getVolumeControl(volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getMaxVolume(volumeInfoObj), MediaControllerCompatApi21.PlaybackInfo.getCurrentVolume(volumeInfoObj)) : null;
        }

        @Override
        public PendingIntent getSessionActivity() {
            return MediaControllerCompatApi21.getSessionActivity(this.mControllerObj);
        }

        @Override
        public void setVolumeTo(int value, int flags) {
            MediaControllerCompatApi21.setVolumeTo(this.mControllerObj, value, flags);
        }

        @Override
        public void adjustVolume(int direction, int flags) {
            MediaControllerCompatApi21.adjustVolume(this.mControllerObj, direction, flags);
        }

        @Override
        public void sendCommand(String command, Bundle params, ResultReceiver cb) {
            MediaControllerCompatApi21.sendCommand(this.mControllerObj, command, params, cb);
        }

        @Override
        public String getPackageName() {
            return MediaControllerCompatApi21.getPackageName(this.mControllerObj);
        }

        @Override
        public Object getMediaController() {
            return this.mControllerObj;
        }

        private void requestExtraBinder() {
            this.sendCommand(MediaControllerCompat.COMMAND_GET_EXTRA_BINDER, null, new ExtraBinderRequestResultReceiver(this, new Handler()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPendingCallbacks() {
            if (this.mExtraBinder == null) {
                return;
            }
            List<Callback> list = this.mPendingCallbacks;
            synchronized (list) {
                for (Callback callback : this.mPendingCallbacks) {
                    ExtraCallback extraCallback = new ExtraCallback(callback);
                    this.mCallbackMap.put(callback, extraCallback);
                    callback.mHasExtraCallback = true;
                    try {
                        this.mExtraBinder.registerCallbackListener(extraCallback);
                    }
                    catch (RemoteException e) {
                        Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in registerCallback.", (Throwable)e);
                        break;
                    }
                }
                this.mPendingCallbacks.clear();
            }
        }

        private class ExtraCallback
        extends IMediaControllerCallback.Stub {
            private Callback mCallback;

            ExtraCallback(Callback callback) {
                this.mCallback = callback;
            }

            @Override
            public void onEvent(final String event, final Bundle extras) throws RemoteException {
                this.mCallback.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ExtraCallback.this.mCallback.onSessionEvent(event, extras);
                    }
                });
            }

            @Override
            public void onSessionDestroyed() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onPlaybackStateChanged(final PlaybackStateCompat state) throws RemoteException {
                this.mCallback.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ExtraCallback.this.mCallback.onPlaybackStateChanged(state);
                    }
                });
            }

            @Override
            public void onMetadataChanged(MediaMetadataCompat metadata) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onQueueChanged(List<MediaSessionCompat.QueueItem> queue) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onQueueTitleChanged(CharSequence title) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onCaptioningEnabledChanged(final boolean enabled) throws RemoteException {
                this.mCallback.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ExtraCallback.this.mCallback.onCaptioningEnabledChanged(enabled);
                    }
                });
            }

            @Override
            public void onRepeatModeChanged(final int repeatMode) throws RemoteException {
                this.mCallback.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ExtraCallback.this.mCallback.onRepeatModeChanged(repeatMode);
                    }
                });
            }

            @Override
            public void onShuffleModeChanged(final boolean enabled) throws RemoteException {
                this.mCallback.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ExtraCallback.this.mCallback.onShuffleModeChanged(enabled);
                    }
                });
            }

            @Override
            public void onExtrasChanged(Bundle extras) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onVolumeInfoChanged(ParcelableVolumeInfo info) throws RemoteException {
                throw new AssertionError();
            }
        }

        private static class ExtraBinderRequestResultReceiver
        extends ResultReceiver {
            private WeakReference<MediaControllerImplApi21> mMediaControllerImpl;

            public ExtraBinderRequestResultReceiver(MediaControllerImplApi21 mediaControllerImpl, Handler handler) {
                super(handler);
                this.mMediaControllerImpl = new WeakReference<MediaControllerImplApi21>(mediaControllerImpl);
            }

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                MediaControllerImplApi21 mediaControllerImpl = (MediaControllerImplApi21)this.mMediaControllerImpl.get();
                if (mediaControllerImpl == null || resultData == null) {
                    return;
                }
                mediaControllerImpl.mExtraBinder = IMediaSession.Stub.asInterface(BundleCompat.getBinder((Bundle)resultData, (String)"android.support.v4.media.session.EXTRA_BINDER"));
                mediaControllerImpl.processPendingCallbacks();
            }
        }
    }

    static class TransportControlsBase
    extends TransportControls {
        private IMediaSession mBinder;

        public TransportControlsBase(IMediaSession binder) {
            this.mBinder = binder;
        }

        @Override
        public void prepare() {
            try {
                this.mBinder.prepare();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepare.", (Throwable)e);
            }
        }

        @Override
        public void prepareFromMediaId(String mediaId, Bundle extras) {
            try {
                this.mBinder.prepareFromMediaId(mediaId, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepareFromMediaId.", (Throwable)e);
            }
        }

        @Override
        public void prepareFromSearch(String query, Bundle extras) {
            try {
                this.mBinder.prepareFromSearch(query, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepareFromSearch.", (Throwable)e);
            }
        }

        @Override
        public void prepareFromUri(Uri uri, Bundle extras) {
            try {
                this.mBinder.prepareFromUri(uri, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepareFromUri.", (Throwable)e);
            }
        }

        @Override
        public void play() {
            try {
                this.mBinder.play();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in play.", (Throwable)e);
            }
        }

        @Override
        public void playFromMediaId(String mediaId, Bundle extras) {
            try {
                this.mBinder.playFromMediaId(mediaId, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in playFromMediaId.", (Throwable)e);
            }
        }

        @Override
        public void playFromSearch(String query, Bundle extras) {
            try {
                this.mBinder.playFromSearch(query, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in playFromSearch.", (Throwable)e);
            }
        }

        @Override
        public void playFromUri(Uri uri, Bundle extras) {
            try {
                this.mBinder.playFromUri(uri, extras);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in playFromUri.", (Throwable)e);
            }
        }

        @Override
        public void skipToQueueItem(long id) {
            try {
                this.mBinder.skipToQueueItem(id);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in skipToQueueItem.", (Throwable)e);
            }
        }

        @Override
        public void pause() {
            try {
                this.mBinder.pause();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in pause.", (Throwable)e);
            }
        }

        @Override
        public void stop() {
            try {
                this.mBinder.stop();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in stop.", (Throwable)e);
            }
        }

        @Override
        public void seekTo(long pos) {
            try {
                this.mBinder.seekTo(pos);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in seekTo.", (Throwable)e);
            }
        }

        @Override
        public void fastForward() {
            try {
                this.mBinder.fastForward();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in fastForward.", (Throwable)e);
            }
        }

        @Override
        public void skipToNext() {
            try {
                this.mBinder.next();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in skipToNext.", (Throwable)e);
            }
        }

        @Override
        public void rewind() {
            try {
                this.mBinder.rewind();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in rewind.", (Throwable)e);
            }
        }

        @Override
        public void skipToPrevious() {
            try {
                this.mBinder.previous();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in skipToPrevious.", (Throwable)e);
            }
        }

        @Override
        public void setRating(RatingCompat rating) {
            try {
                this.mBinder.rate(rating);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setRating.", (Throwable)e);
            }
        }

        @Override
        public void setCaptioningEnabled(boolean enabled) {
            try {
                this.mBinder.setCaptioningEnabled(enabled);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setCaptioningEnabled.", (Throwable)e);
            }
        }

        @Override
        public void setRepeatMode(int repeatMode) {
            try {
                this.mBinder.setRepeatMode(repeatMode);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setRepeatMode.", (Throwable)e);
            }
        }

        @Override
        public void setShuffleModeEnabled(boolean enabled) {
            try {
                this.mBinder.setShuffleModeEnabled(enabled);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setShuffleModeEnabled.", (Throwable)e);
            }
        }

        @Override
        public void sendCustomAction(PlaybackStateCompat.CustomAction customAction, Bundle args) {
            this.sendCustomAction(customAction.getAction(), args);
        }

        @Override
        public void sendCustomAction(String action, Bundle args) {
            try {
                this.mBinder.sendCustomAction(action, args);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in sendCustomAction.", (Throwable)e);
            }
        }
    }

    static class MediaControllerImplBase
    implements MediaControllerImpl {
        private IMediaSession mBinder;
        private TransportControls mTransportControls;

        public MediaControllerImplBase(MediaSessionCompat.Token token) {
            this.mBinder = IMediaSession.Stub.asInterface((IBinder)token.getToken());
        }

        @Override
        public void registerCallback(Callback callback, Handler handler) {
            if (callback == null) {
                throw new IllegalArgumentException("callback may not be null.");
            }
            try {
                this.mBinder.asBinder().linkToDeath((IBinder.DeathRecipient)callback, 0);
                this.mBinder.registerCallbackListener((IMediaControllerCallback)callback.mCallbackObj);
                callback.setHandler(handler);
                callback.mRegistered = true;
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in registerCallback.", (Throwable)e);
                callback.onSessionDestroyed();
            }
        }

        @Override
        public void unregisterCallback(Callback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback may not be null.");
            }
            try {
                this.mBinder.unregisterCallbackListener((IMediaControllerCallback)callback.mCallbackObj);
                this.mBinder.asBinder().unlinkToDeath((IBinder.DeathRecipient)callback, 0);
                callback.mRegistered = false;
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in unregisterCallback.", (Throwable)e);
            }
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException("event may not be null.");
            }
            try {
                this.mBinder.sendMediaButton(event);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in dispatchMediaButtonEvent.", (Throwable)e);
            }
            return false;
        }

        @Override
        public TransportControls getTransportControls() {
            if (this.mTransportControls == null) {
                this.mTransportControls = new TransportControlsBase(this.mBinder);
            }
            return this.mTransportControls;
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            try {
                return this.mBinder.getPlaybackState();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPlaybackState.", (Throwable)e);
                return null;
            }
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            try {
                return this.mBinder.getMetadata();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getMetadata.", (Throwable)e);
                return null;
            }
        }

        @Override
        public List<MediaSessionCompat.QueueItem> getQueue() {
            try {
                return this.mBinder.getQueue();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getQueue.", (Throwable)e);
                return null;
            }
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat description) {
            try {
                long flags = this.mBinder.getFlags();
                if ((flags & 4L) == 0L) {
                    throw new UnsupportedOperationException("This session doesn't support queue management operations");
                }
                this.mBinder.addQueueItem(description);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in addQueueItem.", (Throwable)e);
            }
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat description, int index) {
            try {
                long flags = this.mBinder.getFlags();
                if ((flags & 4L) == 0L) {
                    throw new UnsupportedOperationException("This session doesn't support queue management operations");
                }
                this.mBinder.addQueueItemAt(description, index);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in addQueueItemAt.", (Throwable)e);
            }
        }

        @Override
        public void removeQueueItem(MediaDescriptionCompat description) {
            try {
                long flags = this.mBinder.getFlags();
                if ((flags & 4L) == 0L) {
                    throw new UnsupportedOperationException("This session doesn't support queue management operations");
                }
                this.mBinder.removeQueueItem(description);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in removeQueueItem.", (Throwable)e);
            }
        }

        @Override
        public void removeQueueItemAt(int index) {
            try {
                long flags = this.mBinder.getFlags();
                if ((flags & 4L) == 0L) {
                    throw new UnsupportedOperationException("This session doesn't support queue management operations");
                }
                this.mBinder.removeQueueItemAt(index);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in removeQueueItemAt.", (Throwable)e);
            }
        }

        @Override
        public CharSequence getQueueTitle() {
            try {
                return this.mBinder.getQueueTitle();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getQueueTitle.", (Throwable)e);
                return null;
            }
        }

        @Override
        public Bundle getExtras() {
            try {
                return this.mBinder.getExtras();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getExtras.", (Throwable)e);
                return null;
            }
        }

        @Override
        public int getRatingType() {
            try {
                return this.mBinder.getRatingType();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRatingType.", (Throwable)e);
                return 0;
            }
        }

        @Override
        public boolean isCaptioningEnabled() {
            try {
                return this.mBinder.isCaptioningEnabled();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in isCaptioningEnabled.", (Throwable)e);
                return false;
            }
        }

        @Override
        public int getRepeatMode() {
            try {
                return this.mBinder.getRepeatMode();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRepeatMode.", (Throwable)e);
                return 0;
            }
        }

        @Override
        public boolean isShuffleModeEnabled() {
            try {
                return this.mBinder.isShuffleModeEnabled();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in isShuffleModeEnabled.", (Throwable)e);
                return false;
            }
        }

        @Override
        public long getFlags() {
            try {
                return this.mBinder.getFlags();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getFlags.", (Throwable)e);
                return 0L;
            }
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            try {
                ParcelableVolumeInfo info = this.mBinder.getVolumeAttributes();
                PlaybackInfo pi = new PlaybackInfo(info.volumeType, info.audioStream, info.controlType, info.maxVolume, info.currentVolume);
                return pi;
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPlaybackInfo.", (Throwable)e);
                return null;
            }
        }

        @Override
        public PendingIntent getSessionActivity() {
            try {
                return this.mBinder.getLaunchPendingIntent();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getSessionActivity.", (Throwable)e);
                return null;
            }
        }

        @Override
        public void setVolumeTo(int value, int flags) {
            try {
                this.mBinder.setVolumeTo(value, flags, null);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setVolumeTo.", (Throwable)e);
            }
        }

        @Override
        public void adjustVolume(int direction, int flags) {
            try {
                this.mBinder.adjustVolume(direction, flags, null);
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in adjustVolume.", (Throwable)e);
            }
        }

        @Override
        public void sendCommand(String command, Bundle params, ResultReceiver cb) {
            try {
                this.mBinder.sendCommand(command, params, new MediaSessionCompat.ResultReceiverWrapper(cb));
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in sendCommand.", (Throwable)e);
            }
        }

        @Override
        public String getPackageName() {
            try {
                return this.mBinder.getPackageName();
            }
            catch (RemoteException e) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPackageName.", (Throwable)e);
                return null;
            }
        }

        @Override
        public Object getMediaController() {
            return null;
        }
    }

    static interface MediaControllerImpl {
        public void registerCallback(Callback var1, Handler var2);

        public void unregisterCallback(Callback var1);

        public boolean dispatchMediaButtonEvent(KeyEvent var1);

        public TransportControls getTransportControls();

        public PlaybackStateCompat getPlaybackState();

        public MediaMetadataCompat getMetadata();

        public List<MediaSessionCompat.QueueItem> getQueue();

        public void addQueueItem(MediaDescriptionCompat var1);

        public void addQueueItem(MediaDescriptionCompat var1, int var2);

        public void removeQueueItem(MediaDescriptionCompat var1);

        public void removeQueueItemAt(int var1);

        public CharSequence getQueueTitle();

        public Bundle getExtras();

        public int getRatingType();

        public boolean isCaptioningEnabled();

        public int getRepeatMode();

        public boolean isShuffleModeEnabled();

        public long getFlags();

        public PlaybackInfo getPlaybackInfo();

        public PendingIntent getSessionActivity();

        public void setVolumeTo(int var1, int var2);

        public void adjustVolume(int var1, int var2);

        public void sendCommand(String var1, Bundle var2, ResultReceiver var3);

        public String getPackageName();

        public Object getMediaController();
    }

    public static final class PlaybackInfo {
        public static final int PLAYBACK_TYPE_LOCAL = 1;
        public static final int PLAYBACK_TYPE_REMOTE = 2;
        private final int mPlaybackType;
        private final int mAudioStream;
        private final int mVolumeControl;
        private final int mMaxVolume;
        private final int mCurrentVolume;

        PlaybackInfo(int type, int stream, int control, int max, int current) {
            this.mPlaybackType = type;
            this.mAudioStream = stream;
            this.mVolumeControl = control;
            this.mMaxVolume = max;
            this.mCurrentVolume = current;
        }

        public int getPlaybackType() {
            return this.mPlaybackType;
        }

        public int getAudioStream() {
            return this.mAudioStream;
        }

        public int getVolumeControl() {
            return this.mVolumeControl;
        }

        public int getMaxVolume() {
            return this.mMaxVolume;
        }

        public int getCurrentVolume() {
            return this.mCurrentVolume;
        }
    }

    public static abstract class TransportControls {
        TransportControls() {
        }

        public abstract void prepare();

        public abstract void prepareFromMediaId(String var1, Bundle var2);

        public abstract void prepareFromSearch(String var1, Bundle var2);

        public abstract void prepareFromUri(Uri var1, Bundle var2);

        public abstract void play();

        public abstract void playFromMediaId(String var1, Bundle var2);

        public abstract void playFromSearch(String var1, Bundle var2);

        public abstract void playFromUri(Uri var1, Bundle var2);

        public abstract void skipToQueueItem(long var1);

        public abstract void pause();

        public abstract void stop();

        public abstract void seekTo(long var1);

        public abstract void fastForward();

        public abstract void skipToNext();

        public abstract void rewind();

        public abstract void skipToPrevious();

        public abstract void setRating(RatingCompat var1);

        public abstract void setCaptioningEnabled(boolean var1);

        public abstract void setRepeatMode(int var1);

        public abstract void setShuffleModeEnabled(boolean var1);

        public abstract void sendCustomAction(PlaybackStateCompat.CustomAction var1, Bundle var2);

        public abstract void sendCustomAction(String var1, Bundle var2);
    }

    public static abstract class Callback
    implements IBinder.DeathRecipient {
        private final Object mCallbackObj = Build.VERSION.SDK_INT >= 21 ? MediaControllerCompatApi21.createCallback(new StubApi21()) : new StubCompat();
        MessageHandler mHandler;
        boolean mHasExtraCallback;
        boolean mRegistered = false;

        public void onSessionDestroyed() {
        }

        public void onSessionEvent(String event, Bundle extras) {
        }

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
        }

        public void onMetadataChanged(MediaMetadataCompat metadata) {
        }

        public void onQueueChanged(List<MediaSessionCompat.QueueItem> queue) {
        }

        public void onQueueTitleChanged(CharSequence title) {
        }

        public void onExtrasChanged(Bundle extras) {
        }

        public void onAudioInfoChanged(PlaybackInfo info) {
        }

        public void onCaptioningEnabledChanged(boolean enabled) {
        }

        public void onRepeatModeChanged(int repeatMode) {
        }

        public void onShuffleModeChanged(boolean enabled) {
        }

        public void binderDied() {
            this.onSessionDestroyed();
        }

        private void setHandler(Handler handler) {
            this.mHandler = new MessageHandler(handler.getLooper());
        }

        private class MessageHandler
        extends Handler {
            private static final int MSG_EVENT = 1;
            private static final int MSG_UPDATE_PLAYBACK_STATE = 2;
            private static final int MSG_UPDATE_METADATA = 3;
            private static final int MSG_UPDATE_VOLUME = 4;
            private static final int MSG_UPDATE_QUEUE = 5;
            private static final int MSG_UPDATE_QUEUE_TITLE = 6;
            private static final int MSG_UPDATE_EXTRAS = 7;
            private static final int MSG_DESTROYED = 8;
            private static final int MSG_UPDATE_REPEAT_MODE = 9;
            private static final int MSG_UPDATE_SHUFFLE_MODE = 10;
            private static final int MSG_UPDATE_CAPTIONING_ENABLED = 11;

            public MessageHandler(Looper looper) {
                super(looper);
            }

            public void handleMessage(Message msg) {
                if (!Callback.this.mRegistered) {
                    return;
                }
                switch (msg.what) {
                    case 1: {
                        Callback.this.onSessionEvent((String)msg.obj, msg.getData());
                        break;
                    }
                    case 2: {
                        Callback.this.onPlaybackStateChanged((PlaybackStateCompat)msg.obj);
                        break;
                    }
                    case 3: {
                        Callback.this.onMetadataChanged((MediaMetadataCompat)msg.obj);
                        break;
                    }
                    case 5: {
                        Callback.this.onQueueChanged((List)msg.obj);
                        break;
                    }
                    case 6: {
                        Callback.this.onQueueTitleChanged((CharSequence)msg.obj);
                        break;
                    }
                    case 11: {
                        Callback.this.onCaptioningEnabledChanged((Boolean)msg.obj);
                        break;
                    }
                    case 9: {
                        Callback.this.onRepeatModeChanged((Integer)msg.obj);
                        break;
                    }
                    case 10: {
                        Callback.this.onShuffleModeChanged((Boolean)msg.obj);
                        break;
                    }
                    case 7: {
                        Callback.this.onExtrasChanged((Bundle)msg.obj);
                        break;
                    }
                    case 4: {
                        Callback.this.onAudioInfoChanged((PlaybackInfo)msg.obj);
                        break;
                    }
                    case 8: {
                        Callback.this.onSessionDestroyed();
                    }
                }
            }

            public void post(int what, Object obj, Bundle data) {
                Message msg = this.obtainMessage(what, obj);
                msg.setData(data);
                msg.sendToTarget();
            }
        }

        private class StubCompat
        extends IMediaControllerCallback.Stub {
            StubCompat() {
            }

            @Override
            public void onEvent(String event, Bundle extras) throws RemoteException {
                Callback.this.mHandler.post(1, event, extras);
            }

            @Override
            public void onSessionDestroyed() throws RemoteException {
                Callback.this.mHandler.post(8, null, null);
            }

            @Override
            public void onPlaybackStateChanged(PlaybackStateCompat state) throws RemoteException {
                Callback.this.mHandler.post(2, state, null);
            }

            @Override
            public void onMetadataChanged(MediaMetadataCompat metadata) throws RemoteException {
                Callback.this.mHandler.post(3, metadata, null);
            }

            @Override
            public void onQueueChanged(List<MediaSessionCompat.QueueItem> queue) throws RemoteException {
                Callback.this.mHandler.post(5, queue, null);
            }

            @Override
            public void onQueueTitleChanged(CharSequence title) throws RemoteException {
                Callback.this.mHandler.post(6, title, null);
            }

            @Override
            public void onCaptioningEnabledChanged(boolean enabled) throws RemoteException {
                Callback.this.mHandler.post(11, enabled, null);
            }

            @Override
            public void onRepeatModeChanged(int repeatMode) throws RemoteException {
                Callback.this.mHandler.post(9, repeatMode, null);
            }

            @Override
            public void onShuffleModeChanged(boolean enabled) throws RemoteException {
                Callback.this.mHandler.post(10, enabled, null);
            }

            @Override
            public void onExtrasChanged(Bundle extras) throws RemoteException {
                Callback.this.mHandler.post(7, extras, null);
            }

            @Override
            public void onVolumeInfoChanged(ParcelableVolumeInfo info) throws RemoteException {
                PlaybackInfo pi = null;
                if (info != null) {
                    pi = new PlaybackInfo(info.volumeType, info.audioStream, info.controlType, info.maxVolume, info.currentVolume);
                }
                Callback.this.mHandler.post(4, pi, null);
            }
        }

        private class StubApi21
        implements MediaControllerCompatApi21.Callback {
            StubApi21() {
            }

            @Override
            public void onSessionDestroyed() {
                Callback.this.onSessionDestroyed();
            }

            @Override
            public void onSessionEvent(String event, Bundle extras) {
                if (!Callback.this.mHasExtraCallback || Build.VERSION.SDK_INT >= 23) {
                    Callback.this.onSessionEvent(event, extras);
                }
            }

            @Override
            public void onPlaybackStateChanged(Object stateObj) {
                if (!Callback.this.mHasExtraCallback) {
                    Callback.this.onPlaybackStateChanged(PlaybackStateCompat.fromPlaybackState(stateObj));
                }
            }

            @Override
            public void onMetadataChanged(Object metadataObj) {
                Callback.this.onMetadataChanged(MediaMetadataCompat.fromMediaMetadata(metadataObj));
            }

            @Override
            public void onQueueChanged(List<?> queue) {
                Callback.this.onQueueChanged(MediaSessionCompat.QueueItem.fromQueueItemList(queue));
            }

            @Override
            public void onQueueTitleChanged(CharSequence title) {
                Callback.this.onQueueTitleChanged(title);
            }

            @Override
            public void onExtrasChanged(Bundle extras) {
                Callback.this.onExtrasChanged(extras);
            }

            @Override
            public void onAudioInfoChanged(int type, int stream, int control, int max, int current) {
                Callback.this.onAudioInfoChanged(new PlaybackInfo(type, stream, control, max, current));
            }
        }
    }

    private static class MediaControllerExtraData
    extends SupportActivity.ExtraData {
        private final MediaControllerCompat mMediaController;

        MediaControllerExtraData(MediaControllerCompat mediaController) {
            this.mMediaController = mediaController;
        }

        MediaControllerCompat getMediaController() {
            return this.mMediaController;
        }
    }
}

