/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.TargetApi;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.media.AudioAttributesCompat;
import android.support.v4.media.DataSourceDesc;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;

@TargetApi(value=19)
public abstract class BaseMediaPlayer
implements AutoCloseable {
    public static final int PLAYER_STATE_IDLE = 0;
    public static final int PLAYER_STATE_PAUSED = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_ERROR = 3;
    public static final int BUFFERING_STATE_UNKNOWN = 0;
    public static final int BUFFERING_STATE_BUFFERING_AND_PLAYABLE = 1;
    public static final int BUFFERING_STATE_BUFFERING_AND_STARVED = 2;
    public static final int BUFFERING_STATE_BUFFERING_COMPLETE = 3;
    public static final long UNKNOWN_TIME = -1L;

    public abstract void play();

    public abstract void prepare();

    public abstract void pause();

    public abstract void reset();

    public abstract void skipToNext();

    public abstract void seekTo(long var1);

    public long getCurrentPosition() {
        return -1L;
    }

    public long getDuration() {
        return -1L;
    }

    public long getBufferedPosition() {
        return -1L;
    }

    public abstract int getPlayerState();

    public abstract int getBufferingState();

    public abstract void setAudioAttributes(@NonNull AudioAttributesCompat var1);

    @Nullable
    public abstract AudioAttributesCompat getAudioAttributes();

    public abstract void setDataSource(@NonNull DataSourceDesc var1);

    public abstract void setNextDataSource(@NonNull DataSourceDesc var1);

    public abstract void setNextDataSources(@NonNull List<DataSourceDesc> var1);

    @Nullable
    public abstract DataSourceDesc getCurrentDataSource();

    public abstract void loopCurrent(boolean var1);

    public abstract void setPlaybackSpeed(float var1);

    public float getPlaybackSpeed() {
        return 1.0f;
    }

    public boolean isReversePlaybackSupported() {
        return false;
    }

    public abstract void setPlayerVolume(float var1);

    public abstract float getPlayerVolume();

    public float getMaxPlayerVolume() {
        return 1.0f;
    }

    public abstract void registerPlayerEventCallback(@NonNull Executor var1, @NonNull PlayerEventCallback var2);

    public abstract void unregisterPlayerEventCallback(@NonNull PlayerEventCallback var1);

    public static abstract class PlayerEventCallback {
        public void onCurrentDataSourceChanged(@NonNull BaseMediaPlayer mpb, @Nullable DataSourceDesc dsd) {
        }

        public void onMediaPrepared(@NonNull BaseMediaPlayer mpb, @NonNull DataSourceDesc dsd) {
        }

        public void onPlayerStateChanged(@NonNull BaseMediaPlayer mpb, int state) {
        }

        public void onBufferingStateChanged(@NonNull BaseMediaPlayer mpb, @NonNull DataSourceDesc dsd, int state) {
        }

        public void onPlaybackSpeedChanged(@NonNull BaseMediaPlayer mpb, float speed) {
        }

        public void onSeekCompleted(@NonNull BaseMediaPlayer mpb, long position) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface BuffState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface PlayerState {
    }
}

