/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.view;

import android.annotation.TargetApi;
import android.graphics.Point;
import android.support.annotation.RequiresApi;
import android.support.v4.view.MotionEventCompat;
import android.view.MotionEvent;
import android.view.View;

@RequiresApi(value=13)
@TargetApi(value=13)
public class DragStartHelper {
    private final View mView;
    private final OnDragStartListener mListener;
    private int mLastTouchX;
    private int mLastTouchY;
    private boolean mDragging;
    private final View.OnLongClickListener mLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            return DragStartHelper.this.onLongClick(v);
        }
    };
    private final View.OnTouchListener mTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            return DragStartHelper.this.onTouch(v, event);
        }
    };

    public DragStartHelper(View view, OnDragStartListener listener) {
        this.mView = view;
        this.mListener = listener;
    }

    public void attach() {
        this.mView.setOnLongClickListener(this.mLongClickListener);
        this.mView.setOnTouchListener(this.mTouchListener);
    }

    public void detach() {
        this.mView.setOnLongClickListener(null);
        this.mView.setOnTouchListener(null);
    }

    public boolean onTouch(View v, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                break;
            }
            case 2: {
                if (!MotionEventCompat.isFromSource((MotionEvent)event, (int)8194) || (MotionEventCompat.getButtonState((MotionEvent)event) & 1) == 0 || this.mDragging || this.mLastTouchX == x && this.mLastTouchY == y) break;
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                this.mDragging = this.mListener.onDragStart(v, this);
                return this.mDragging;
            }
            case 1: 
            case 3: {
                this.mDragging = false;
            }
        }
        return false;
    }

    public boolean onLongClick(View v) {
        return this.mListener.onDragStart(v, this);
    }

    public void getTouchPosition(Point point) {
        point.set(this.mLastTouchX, this.mLastTouchY);
    }

    public static interface OnDragStartListener {
        public boolean onDragStart(View var1, DragStartHelper var2);
    }
}

