/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.media.browse.MediaBrowser;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.service.media.MediaBrowserService;
import android.support.v4.media.MediaBrowserServiceCompatApi23;
import android.support.v4.media.ServiceBinderAdapterApi21;
import android.util.Log;

class ServiceBinderAdapterApi23
extends ServiceBinderAdapterApi21 {
    private static final String TAG = "IMediaBrowserServiceAdapterApi23";
    private static final int TRANSACTION_getMediaItem = 5;
    final MediaBrowserServiceCompatApi23.ServiceImplApi23 mServiceImpl;

    public ServiceBinderAdapterApi23(MediaBrowserServiceCompatApi23.ServiceImplApi23 serviceImpl) {
        super(serviceImpl);
        this.mServiceImpl = serviceImpl;
    }

    @Override
    public IBinder asBinder() {
        return this;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        switch (code) {
            case 5: {
                data.enforceInterface("android.service.media.IMediaBrowserService");
                String arg0 = data.readString();
                ResultReceiver arg1 = data.readInt() != 0 ? (ResultReceiver)ResultReceiver.CREATOR.createFromParcel(data) : null;
                this.getMediaItem(arg0, arg1);
                return true;
            }
        }
        return super.onTransact(code, data, reply, flags);
    }

    void getMediaItem(String mediaId, final ResultReceiver receiver) {
        String KEY_MEDIA_ITEM;
        try {
            KEY_MEDIA_ITEM = (String)MediaBrowserService.class.getDeclaredField("KEY_MEDIA_ITEM").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Log.i((String)TAG, (String)"Failed to get KEY_MEDIA_ITEM via reflection", (Throwable)e);
            return;
        }
        this.mServiceImpl.getMediaItem(mediaId, new MediaBrowserServiceCompatApi23.ItemCallback(){

            @Override
            public void onItemLoaded(int resultCode, Bundle resultData, Parcel itemParcel) {
                if (itemParcel != null) {
                    itemParcel.setDataPosition(0);
                    MediaBrowser.MediaItem item = (MediaBrowser.MediaItem)MediaBrowser.MediaItem.CREATOR.createFromParcel(itemParcel);
                    resultData.putParcelable(KEY_MEDIA_ITEM, (Parcelable)item);
                    itemParcel.recycle();
                }
                receiver.send(resultCode, resultData);
            }
        });
    }
}

