/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.contrib;

import android.support.annotation.Nullable;
import android.support.test.espresso.Espresso;
import android.support.test.espresso.IdlingResource;
import android.support.test.espresso.PerformException;
import android.support.test.espresso.UiController;
import android.support.test.espresso.ViewAction;
import android.support.test.espresso.contrib.DrawerMatchers;
import android.support.test.espresso.matcher.ViewMatchers;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import java.lang.reflect.Field;
import org.hamcrest.Matcher;

public final class DrawerActions {
    private static Field listenerField;

    private DrawerActions() {
    }

    @Deprecated
    public static void openDrawer(int drawerLayoutId) {
        DrawerActions.openDrawer(drawerLayoutId, 0x800003);
    }

    @Deprecated
    public static void openDrawer(int drawerLayoutId, int gravity) {
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.open(gravity)});
    }

    public static ViewAction open() {
        return DrawerActions.open(0x800003);
    }

    public static ViewAction open(final int gravity) {
        return new DrawerAction(){

            public String getDescription() {
                int n = gravity;
                return new StringBuilder(36).append("open drawer with gravity ").append(n).toString();
            }

            @Override
            protected Matcher<View> checkAction() {
                return DrawerMatchers.isClosed(gravity);
            }

            @Override
            protected void performAction(UiController uiController, DrawerLayout view) {
                view.openDrawer(gravity);
            }
        };
    }

    @Deprecated
    public static void closeDrawer(int drawerLayoutId) {
        DrawerActions.closeDrawer(drawerLayoutId, 0x800003);
    }

    @Deprecated
    public static void closeDrawer(int drawerLayoutId, int gravity) {
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.close(gravity)});
    }

    public static ViewAction close() {
        return DrawerActions.close(0x800003);
    }

    public static ViewAction close(final int gravity) {
        return new DrawerAction(){

            public String getDescription() {
                int n = gravity;
                return new StringBuilder(37).append("close drawer with gravity ").append(n).toString();
            }

            @Override
            protected Matcher<View> checkAction() {
                return DrawerMatchers.isOpen(gravity);
            }

            @Override
            protected void performAction(UiController uiController, DrawerLayout view) {
                view.closeDrawer(gravity);
                uiController.loopMainThreadUntilIdle();
                if (view.isDrawerVisible(gravity)) {
                    uiController.loopMainThreadForAtLeast(300L);
                }
            }
        };
    }

    @Nullable
    private static DrawerLayout.DrawerListener getDrawerListener(DrawerLayout drawer) {
        try {
            if (listenerField == null) {
                listenerField = DrawerLayout.class.getDeclaredField("mListener");
                listenerField.setAccessible(true);
            }
            return (DrawerLayout.DrawerListener)listenerField.get(drawer);
        }
        catch (IllegalArgumentException ex) {
            throw new PerformException.Builder().withCause((Throwable)ex).build();
        }
        catch (IllegalAccessException ex) {
            throw new PerformException.Builder().withCause((Throwable)ex).build();
        }
        catch (NoSuchFieldException ex) {
            throw new PerformException.Builder().withCause((Throwable)ex).build();
        }
        catch (SecurityException ex) {
            throw new PerformException.Builder().withCause((Throwable)ex).build();
        }
    }

    private static class IdlingDrawerListener
    implements DrawerLayout.DrawerListener,
    IdlingResource {
        private static IdlingDrawerListener instance;
        @Nullable
        private DrawerLayout.DrawerListener parentListener;
        private IdlingResource.ResourceCallback callback;
        private boolean idle = true;

        private IdlingDrawerListener() {
        }

        private static IdlingDrawerListener getInstance(DrawerLayout.DrawerListener parentListener) {
            if (instance == null) {
                instance = new IdlingDrawerListener();
            }
            instance.setParentListener(parentListener);
            return instance;
        }

        public void setParentListener(@Nullable DrawerLayout.DrawerListener parentListener) {
            this.parentListener = parentListener;
        }

        public void onDrawerClosed(View drawer) {
            if (this.parentListener != null) {
                this.parentListener.onDrawerClosed(drawer);
            }
        }

        public void onDrawerOpened(View drawer) {
            if (this.parentListener != null) {
                this.parentListener.onDrawerOpened(drawer);
            }
        }

        public void onDrawerSlide(View drawer, float slideOffset) {
            if (this.parentListener != null) {
                this.parentListener.onDrawerSlide(drawer, slideOffset);
            }
        }

        public void onDrawerStateChanged(int newState) {
            if (newState == 0) {
                this.idle = true;
                if (this.callback != null) {
                    this.callback.onTransitionToIdle();
                }
            } else {
                this.idle = false;
            }
            if (this.parentListener != null) {
                this.parentListener.onDrawerStateChanged(newState);
            }
        }

        public String getName() {
            return "IdlingDrawerListener";
        }

        public boolean isIdleNow() {
            return this.idle;
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback callback) {
            this.callback = callback;
        }
    }

    private static abstract class DrawerAction
    implements ViewAction {
        private DrawerAction() {
        }

        public final Matcher<View> getConstraints() {
            return ViewMatchers.isAssignableFrom(DrawerLayout.class);
        }

        public final void perform(UiController uiController, View view) {
            IdlingDrawerListener idlingListener;
            DrawerLayout drawer = (DrawerLayout)view;
            if (!this.checkAction().matches((Object)drawer)) {
                return;
            }
            DrawerLayout.DrawerListener listener = DrawerActions.getDrawerListener(drawer);
            if (listener instanceof IdlingDrawerListener) {
                idlingListener = (IdlingDrawerListener)listener;
            } else {
                idlingListener = IdlingDrawerListener.getInstance(listener);
                drawer.setDrawerListener((DrawerLayout.DrawerListener)idlingListener);
                Espresso.registerIdlingResources((IdlingResource[])new IdlingResource[]{idlingListener});
            }
            this.performAction(uiController, drawer);
            uiController.loopMainThreadUntilIdle();
            Espresso.unregisterIdlingResources((IdlingResource[])new IdlingResource[]{idlingListener});
            drawer.setDrawerListener(idlingListener.parentListener);
            idlingListener.parentListener = null;
        }

        protected abstract Matcher<View> checkAction();

        protected abstract void performAction(UiController var1, DrawerLayout var2);
    }
}

