/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.intent;

import android.app.Instrumentation;
import android.content.Intent;
import android.support.test.InstrumentationRegistry;
import android.support.test.espresso.Espresso;
import android.support.test.espresso.NoMatchingViewException;
import android.support.test.espresso.ViewAssertion;
import android.support.test.espresso.intent.Checks;
import android.support.test.espresso.intent.OngoingStubbing;
import android.support.test.espresso.intent.ResettingStubber;
import android.support.test.espresso.intent.ResettingStubberImpl;
import android.support.test.espresso.intent.VerifiableIntent;
import android.support.test.espresso.intent.VerifiableIntentImpl;
import android.support.test.espresso.intent.VerificationMode;
import android.support.test.espresso.intent.VerificationModes;
import android.support.test.espresso.intent.matcher.IntentMatchers;
import android.support.test.espresso.matcher.ViewMatchers;
import android.support.test.internal.runner.tracker.UsageTrackerRegistry;
import android.support.test.runner.intent.IntentCallback;
import android.support.test.runner.intent.IntentMonitor;
import android.support.test.runner.intent.IntentMonitorRegistry;
import android.support.test.runner.intent.IntentStubber;
import android.support.test.runner.intent.IntentStubberRegistry;
import android.support.test.runner.lifecycle.ActivityLifecycleMonitor;
import android.support.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import android.support.test.runner.lifecycle.Stage;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.hamcrest.Matcher;

public final class Intents {
    private static Intents defaultInstance;
    private static final List<VerifiableIntent> recordedIntents;
    private static boolean isInitialized;
    private final ResettingStubber resettingStubber;
    private final IntentCallback intentCallback = new IntentCallback(){

        public void onIntentSent(Intent intent) {
            recordedIntents.add(new VerifiableIntentImpl(((ResettingStubberImpl)Intents.this.resettingStubber).resolveIntent(intent)));
        }
    };
    private IntentMonitor intentMonitor;
    private static Instrumentation instrumentation;

    Intents(ResettingStubber resettingStubber) {
        this.resettingStubber = Checks.checkNotNull(resettingStubber);
    }

    public static void init() {
        if (!IntentStubberRegistry.isLoaded()) {
            ResettingStubberImpl resettingStubber = new ResettingStubberImpl();
            IntentStubberRegistry.load((IntentStubber)resettingStubber);
            defaultInstance = new Intents(resettingStubber);
        }
        defaultInstance.internalInit();
    }

    public static void release() {
        defaultInstance.internalRelease();
    }

    public static OngoingStubbing intending(Matcher<Intent> matcher) {
        return defaultInstance.internalIntending(matcher);
    }

    public static void intended(Matcher<Intent> matcher) {
        Intents.intended(matcher, Intents.times(1));
    }

    public static void intended(final Matcher<Intent> matcher, final VerificationMode verificationMode) {
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        if (Intents.resumedActivitiesExist(instrumentation)) {
            Espresso.onView((Matcher)ViewMatchers.isRoot()).check(new ViewAssertion(){

                public void check(View view, NoMatchingViewException noViewFoundException) {
                    defaultInstance.internalIntended((Matcher<Intent>)matcher, verificationMode, recordedIntents);
                }
            });
        } else {
            instrumentation.waitForIdleSync();
            instrumentation.runOnMainSync(new Runnable(){

                @Override
                public void run() {
                    defaultInstance.internalIntended((Matcher<Intent>)matcher, verificationMode, recordedIntents);
                }
            });
            instrumentation.waitForIdleSync();
        }
    }

    public static VerificationMode times(int times) {
        if (times < 0) {
            throw new IllegalArgumentException("times expects a nonnegative integer");
        }
        return VerificationModes.times(times);
    }

    public static void assertNoUnverifiedIntents() {
        Intents.intended(IntentMatchers.anyIntent(), VerificationModes.noUnverifiedIntents());
    }

    private static boolean resumedActivitiesExist(Instrumentation instrumentation) {
        FutureTask<Boolean> checkResumed = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ActivityLifecycleMonitor monitor = ActivityLifecycleMonitorRegistry.getInstance();
                return !monitor.getActivitiesInStage(Stage.RESUMED).isEmpty();
            }
        });
        instrumentation.runOnMainSync(checkResumed);
        try {
            return checkResumed.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    void internalInit() {
        Checks.checkState(!isInitialized, "#init was called twice in a row. Make sure to call #release after every #init", new Object[0]);
        instrumentation = InstrumentationRegistry.getInstrumentation();
        this.intentMonitor = IntentMonitorRegistry.getInstance();
        this.intentMonitor.addIntentCallback(this.intentCallback);
        this.resettingStubber.initialize();
        isInitialized = true;
    }

    OngoingStubbing internalIntending(Matcher<Intent> matcher) {
        return new OngoingStubbing(matcher, this.resettingStubber, instrumentation);
    }

    void internalRelease() {
        Checks.checkState(isInitialized, "init() must be called prior to using this method.", new Object[0]);
        this.intentMonitor.removeIntentCallback(this.intentCallback);
        IntentStubberRegistry.reset();
        instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                recordedIntents.clear();
                Intents.this.resettingStubber.reset();
            }
        });
        isInitialized = false;
    }

    void internalIntended(Matcher<Intent> matcher, VerificationMode verificationMode, List<VerifiableIntent> intents) {
        Checks.checkState(isInitialized, "init() must be called prior to using this method.", new Object[0]);
        verificationMode.verify(matcher, intents);
    }

    static {
        UsageTrackerRegistry.getInstance().trackUsage("Intents");
        recordedIntents = new ArrayList<VerifiableIntent>();
        isInitialized = false;
    }
}

