/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.intent;

import android.app.Instrumentation;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Looper;
import android.support.test.InstrumentationRegistry;
import android.support.test.espresso.intent.Checks;
import android.support.test.espresso.intent.ResettingStubber;
import android.support.test.espresso.intent.ResolvedIntent;
import android.support.test.espresso.intent.ResolvedIntentImpl;
import android.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.Matcher;

public final class ResettingStubberImpl
implements ResettingStubber {
    private List<Pair<Matcher<Intent>, Instrumentation.ActivityResult>> intentResponsePairs = new ArrayList<Pair<Matcher<Intent>, Instrumentation.ActivityResult>>();
    private PackageManager packageManager;
    private boolean isInitialized;

    @Override
    public void initialize() {
        this.packageManager = InstrumentationRegistry.getTargetContext().getPackageManager();
        this.isInitialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void reset() {
        ResettingStubberImpl.checkMain();
        this.intentResponsePairs.clear();
        this.isInitialized = false;
    }

    @Override
    public void setActivityResultForIntent(Matcher<Intent> matcher, Instrumentation.ActivityResult result) {
        Checks.checkState(this.isInitialized, "ResettingStubber must be initialized before calling this method", new Object[0]);
        Checks.checkNotNull(matcher);
        ResettingStubberImpl.checkMain();
        this.intentResponsePairs.add((Pair<Matcher<Intent>, Instrumentation.ActivityResult>)new Pair(matcher, (Object)result));
    }

    public Instrumentation.ActivityResult getActivityResultForIntent(Intent intent) {
        Checks.checkState(this.isInitialized, "ResettingStubber must be initialized before calling this method", new Object[0]);
        Checks.checkNotNull(intent);
        ResettingStubberImpl.checkMain();
        ListIterator<Pair<Matcher<Intent>, Instrumentation.ActivityResult>> reverseIterator = this.intentResponsePairs.listIterator(this.intentResponsePairs.size());
        while (reverseIterator.hasPrevious()) {
            Pair<Matcher<Intent>, Instrumentation.ActivityResult> pair = reverseIterator.previous();
            if (!((Matcher)pair.first).matches((Object)this.resolveIntent(intent))) continue;
            return (Instrumentation.ActivityResult)pair.second;
        }
        return null;
    }

    ResolvedIntent resolveIntent(Intent intent) {
        ArrayList<ResolveInfo> resolveInfos = this.packageManager.queryIntentActivities(intent, 0);
        if (null == resolveInfos) {
            resolveInfos = new ArrayList<ResolveInfo>();
        }
        return new ResolvedIntentImpl(intent, resolveInfos);
    }

    private static void checkMain() {
        Checks.checkState(Looper.myLooper() == Looper.getMainLooper(), "Must be called on main thread.", new Object[0]);
    }
}

