/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.support.test.espresso.intent;

import android.content.Intent;
import java.util.List;
import org.hamcrest.Matcher;

/** An interface for different modes of verifying intents. */
public interface VerificationMode {
  /**
   * Verifies the recorded intents that match the provided {@link Matcher}. No intents should be
   * marked as verified unless the verification passes.
   */
  void verify(Matcher<Intent> matcher, List<VerifiableIntent> recordedIntents);
}
