/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.intent;

import android.app.Instrumentation;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Looper;
import android.support.test.InstrumentationRegistry;
import android.support.test.espresso.intent.ActivityResultFunction;
import android.support.test.espresso.intent.Checks;
import android.support.test.espresso.intent.ResettingStubber;
import android.support.test.espresso.intent.ResettingStubberImpl$$Lambda$0;
import android.support.test.espresso.intent.ResolvedIntent;
import android.support.test.espresso.intent.ResolvedIntentImpl;
import android.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.Matcher;

public final class ResettingStubberImpl
implements ResettingStubber {
    private List<Pair<Matcher<Intent>, ActivityResultFunction>> intentResponsePairs = new ArrayList<Pair<Matcher<Intent>, ActivityResultFunction>>();
    private PackageManager packageManager;
    private boolean isInitialized;

    @Override
    public void initialize() {
        this.packageManager = InstrumentationRegistry.getInstrumentation().getTargetContext().getPackageManager();
        this.isInitialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void reset() {
        ResettingStubberImpl.checkMain();
        this.intentResponsePairs.clear();
        this.isInitialized = false;
    }

    @Override
    public void setActivityResultForIntent(Matcher<Intent> matcher, Instrumentation.ActivityResult result) {
        this.setActivityResultFunctionForIntent(matcher, new ResettingStubberImpl$$Lambda$0(result));
    }

    @Override
    public void setActivityResultFunctionForIntent(Matcher<Intent> matcher, ActivityResultFunction result) {
        Checks.checkState(this.isInitialized, "ResettingStubber must be initialized before calling this method");
        Checks.checkNotNull(matcher);
        ResettingStubberImpl.checkMain();
        this.intentResponsePairs.add((Pair<Matcher<Intent>, ActivityResultFunction>)new Pair(matcher, (Object)result));
    }

    public Instrumentation.ActivityResult getActivityResultForIntent(Intent intent) {
        Checks.checkState(this.isInitialized, "ResettingStubber must be initialized before calling this method");
        Checks.checkNotNull(intent);
        ResettingStubberImpl.checkMain();
        ListIterator<Pair<Matcher<Intent>, ActivityResultFunction>> reverseIterator = this.intentResponsePairs.listIterator(this.intentResponsePairs.size());
        while (reverseIterator.hasPrevious()) {
            Pair<Matcher<Intent>, ActivityResultFunction> pair = reverseIterator.previous();
            if (!((Matcher)pair.first).matches((Object)this.resolveIntent(intent))) continue;
            return ((ActivityResultFunction)pair.second).apply(intent);
        }
        return null;
    }

    ResolvedIntent resolveIntent(Intent intent) {
        ArrayList<ResolveInfo> resolveInfos = this.packageManager.queryIntentActivities(intent, 0);
        if (null == resolveInfos) {
            resolveInfos = new ArrayList<ResolveInfo>();
        }
        return new ResolvedIntentImpl(intent, resolveInfos);
    }

    private static void checkMain() {
        Checks.checkState(Looper.myLooper() == Looper.getMainLooper(), "Must be called on main thread.");
    }

    static final /* synthetic */ Instrumentation.ActivityResult lambda$setActivityResultForIntent$0$ResettingStubberImpl(Instrumentation.ActivityResult result, Intent intent) {
        return result;
    }
}

