/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.util;

import android.support.test.internal.util.Checks;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtil {
    private static final String TAG = "ReflectionUtil";

    public static void reflectivelyInvokeRemoteMethod(String className, String methodName) {
        Checks.checkNotNull(className);
        Checks.checkNotNull(methodName);
        String string = String.valueOf(methodName);
        Log.i((String)TAG, (String)(string.length() != 0 ? "Attempting to reflectively call: ".concat(string) : new String("Attempting to reflectively call: ")));
        try {
            Class<?> c = Class.forName(className);
            Method m = c.getDeclaredMethod(methodName, new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Log.e((String)TAG, (String)"Reflective call failed: ", (Throwable)e);
        }
    }
}

