/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner;

import android.app.Instrumentation;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.support.annotation.VisibleForTesting;
import android.support.test.internal.runner.RunnerArgs;
import android.support.test.internal.runner.TestExecutor;
import android.support.test.internal.runner.TestRequestBuilder;
import android.support.test.internal.runner.listener.ActivityFinisherRunListener;
import android.support.test.internal.runner.listener.CoverageListener;
import android.support.test.internal.runner.listener.DelayInjector;
import android.support.test.internal.runner.listener.InstrumentationResultPrinter;
import android.support.test.internal.runner.listener.LogRunListener;
import android.support.test.internal.runner.listener.SuiteAssignmentPrinter;
import android.support.test.internal.runner.tracker.AnalyticsBasedUsageTracker;
import android.support.test.orchestrator.instrumentationlistener.OrchestratedInstrumentationListener;
import android.support.test.runner.MonitoringInstrumentation;
import android.support.test.runner.UsageTrackerFacilitator;
import android.support.test.runner.lifecycle.ApplicationLifecycleCallback;
import android.support.test.runner.lifecycle.ApplicationLifecycleMonitorRegistry;
import android.support.test.runner.screenshot.ScreenCaptureProcessor;
import android.support.test.runner.screenshot.Screenshot;
import android.util.Log;
import java.util.HashSet;
import org.junit.runner.Request;
import org.junit.runner.notification.RunListener;

public class AndroidJUnitRunner
extends MonitoringInstrumentation
implements OrchestratedInstrumentationListener.OnConnectListener {
    private static final String LOG_TAG = "AndroidJUnitRunner";
    private Bundle mArguments;
    private InstrumentationResultPrinter mInstrumentationResultPrinter = new InstrumentationResultPrinter();
    private RunnerArgs mRunnerArgs;
    private UsageTrackerFacilitator mUsageTrackerFacilitator;
    private OrchestratedInstrumentationListener mOrchestratorListener;

    @Override
    public void onCreate(Bundle arguments) {
        this.mArguments = arguments;
        this.parseRunnerArgs(this.mArguments);
        if (this.mRunnerArgs.debug) {
            Log.i((String)LOG_TAG, (String)"Waiting for debugger to connect...");
            Debug.waitForDebugger();
            Log.i((String)LOG_TAG, (String)"Debugger connected.");
        }
        this.mUsageTrackerFacilitator = this.isPrimaryInstrProcess(this.mRunnerArgs.targetProcess) ? new UsageTrackerFacilitator(this.mRunnerArgs) : new UsageTrackerFacilitator(false);
        super.onCreate(arguments);
        for (ApplicationLifecycleCallback listener : this.mRunnerArgs.appListeners) {
            ApplicationLifecycleMonitorRegistry.getInstance().addLifecycleCallback(listener);
        }
        this.addScreenCaptureProcessors(this.mRunnerArgs);
        if (this.mRunnerArgs.orchestratorService != null && this.isPrimaryInstrProcess(this.mRunnerArgs.targetProcess)) {
            this.mOrchestratorListener = new OrchestratedInstrumentationListener(this);
            this.mOrchestratorListener.connect(this.getContext());
        } else {
            this.start();
        }
    }

    @Override
    public void onOrchestratorConnect() {
        this.start();
    }

    private void parseRunnerArgs(Bundle arguments) {
        this.mRunnerArgs = new RunnerArgs.Builder().fromManifest(this).fromBundle(arguments).build();
    }

    private Bundle getArguments() {
        return this.mArguments;
    }

    @VisibleForTesting
    InstrumentationResultPrinter getInstrumentationResultPrinter() {
        return this.mInstrumentationResultPrinter;
    }

    @Override
    public void onStart() {
        this.setJsBridgeClassName("android.support.test.espresso.web.bridge.JavaScriptBridge");
        super.onStart();
        if (this.mRunnerArgs.listTestsForOrchestrator && this.isPrimaryInstrProcess(this.mRunnerArgs.targetProcess)) {
            Request testRequest = this.buildRequest(this.mRunnerArgs, this.getArguments());
            this.mOrchestratorListener.addTests(testRequest.getRunner().getDescription());
            this.finish(-1, new Bundle());
            return;
        }
        if (this.mRunnerArgs.remoteMethod != null) {
            AndroidJUnitRunner.reflectivelyInvokeRemoteMethod(this.mRunnerArgs.remoteMethod);
        }
        if (!this.isPrimaryInstrProcess(this.mRunnerArgs.targetProcess)) {
            Log.i((String)LOG_TAG, (String)"Runner is idle...");
            return;
        }
        Bundle results = new Bundle();
        try {
            TestExecutor.Builder executorBuilder = new TestExecutor.Builder(this);
            this.addListeners(this.mRunnerArgs, executorBuilder);
            Request testRequest = this.buildRequest(this.mRunnerArgs, this.getArguments());
            results = executorBuilder.build().execute(testRequest);
        }
        catch (RuntimeException e) {
            String msg = "Fatal exception when running tests";
            Log.e((String)LOG_TAG, (String)"Fatal exception when running tests", (Throwable)e);
            String string = String.valueOf("Fatal exception when running tests\n");
            String string2 = String.valueOf(Log.getStackTraceString((Throwable)e));
            results.putString("stream", string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        this.finish(-1, results);
    }

    @Override
    public void finish(int resultCode, Bundle results) {
        try {
            this.mUsageTrackerFacilitator.trackUsage(LOG_TAG, "1.0.0");
            this.mUsageTrackerFacilitator.sendUsages();
        }
        catch (RuntimeException re) {
            Log.w((String)LOG_TAG, (String)"Failed to send analytics.", (Throwable)re);
        }
        super.finish(resultCode, results);
    }

    private void addListeners(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.logOnly) {
            builder.addRunListener(this.getInstrumentationResultPrinter());
        } else if (args.suiteAssignment) {
            builder.addRunListener(new SuiteAssignmentPrinter());
        } else {
            builder.addRunListener(new LogRunListener());
            if (this.mOrchestratorListener != null) {
                builder.addRunListener(this.mOrchestratorListener);
            } else {
                builder.addRunListener(this.getInstrumentationResultPrinter());
            }
            builder.addRunListener(new ActivityFinisherRunListener(this, new MonitoringInstrumentation.ActivityFinisher(), new Runnable(){

                @Override
                public void run() {
                    AndroidJUnitRunner.this.waitForActivitiesToComplete();
                }
            }));
            this.addDelayListener(args, builder);
            this.addCoverageListener(args, builder);
        }
        this.addListenersFromArg(args, builder);
    }

    private void addScreenCaptureProcessors(RunnerArgs args) {
        Screenshot.addScreenCaptureProcessors(new HashSet<ScreenCaptureProcessor>(args.screenCaptureProcessors));
    }

    private void addCoverageListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.codeCoverage) {
            builder.addRunListener(new CoverageListener(args.codeCoveragePath));
        }
    }

    private void addDelayListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.delayInMillis > 0) {
            builder.addRunListener(new DelayInjector(args.delayInMillis));
        } else if (args.logOnly && Build.VERSION.SDK_INT < 16) {
            builder.addRunListener(new DelayInjector(15));
        }
    }

    private void addListenersFromArg(RunnerArgs args, TestExecutor.Builder builder) {
        for (RunListener listener : args.listeners) {
            builder.addRunListener(listener);
        }
    }

    @Override
    public boolean onException(Object obj, Throwable e) {
        InstrumentationResultPrinter instResultPrinter = this.getInstrumentationResultPrinter();
        if (instResultPrinter != null) {
            instResultPrinter.reportProcessCrash(e);
        }
        return super.onException(obj, e);
    }

    @VisibleForTesting
    Request buildRequest(RunnerArgs runnerArgs, Bundle bundleArgs) {
        TestRequestBuilder builder = this.createTestRequestBuilder(this, bundleArgs);
        builder.addApkToScan(this.getContext().getPackageCodePath());
        builder.addFromRunnerArgs(runnerArgs);
        this.registerUserTracker();
        return builder.build();
    }

    private void registerUserTracker() {
        Context targetContext = this.getTargetContext();
        if (targetContext != null) {
            this.mUsageTrackerFacilitator.registerUsageTracker(new AnalyticsBasedUsageTracker.Builder(targetContext).buildIfPossible());
        }
    }

    @VisibleForTesting
    TestRequestBuilder createTestRequestBuilder(Instrumentation instr, Bundle arguments) {
        return new TestRequestBuilder(instr, arguments);
    }
}

