/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.permission;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.test.InstrumentationRegistry;
import android.support.test.annotation.Beta;
import android.support.test.internal.util.Checks;
import android.support.test.runner.permission.GrantPermissionCallable;
import android.support.test.runner.permission.RequestPermissionCallable;
import android.support.test.runner.permission.UiAutomationShellCommand;
import android.text.TextUtils;
import android.util.Log;
import java.util.HashSet;
import junit.framework.Assert;

@Beta
@TargetApi(value=23)
public class PermissionRequester {
    private static final String TAG = "PermissionRequester";
    private int mAndroidRuntimeVersion = Build.VERSION.SDK_INT;
    @NonNull
    private final Context mTargetContext;
    @VisibleForTesting
    final HashSet<RequestPermissionCallable> mRequestedPermissions = new HashSet();

    public PermissionRequester() {
        this(InstrumentationRegistry.getTargetContext());
    }

    @VisibleForTesting
    PermissionRequester(@NonNull Context targetContext) {
        this.mTargetContext = Checks.checkNotNull(targetContext, "targetContext cannot be null!");
    }

    public void addPermissions(String ... permissions) {
        Checks.checkNotNull(permissions, "permissions cannot be null!");
        if (this.deviceSupportsRuntimePermissions()) {
            for (String permission : permissions) {
                Assert.assertFalse((String)"Permission String is empty or null!", (boolean)TextUtils.isEmpty((CharSequence)permission));
                GrantPermissionCallable requestPermissionCallable = new GrantPermissionCallable(new UiAutomationShellCommand(this.mTargetContext.getPackageName(), permission, UiAutomationShellCommand.PmCommand.GRANT_PERMISSION), this.mTargetContext, permission);
                Checks.checkState(this.mRequestedPermissions.add(requestPermissionCallable));
            }
        }
    }

    public void requestPermissions() {
        if (this.deviceSupportsRuntimePermissions()) {
            for (RequestPermissionCallable requestPermissionCallable : this.mRequestedPermissions) {
                try {
                    if (RequestPermissionCallable.Result.FAILURE != requestPermissionCallable.call()) continue;
                    Assert.fail((String)"Failed to grant permissions, see logcat for details");
                    return;
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"An Exception was thrown while granting permission", (Throwable)exception);
                    Assert.fail((String)"Failed to grant permissions, see logcat for details");
                    return;
                }
            }
        }
    }

    @VisibleForTesting
    protected void setAndroidRuntimeVersion(int sdkInt) {
        this.mAndroidRuntimeVersion = sdkInt;
    }

    private boolean deviceSupportsRuntimePermissions() {
        boolean supportsRuntimePermissions;
        boolean bl = supportsRuntimePermissions = this.getAndroidRuntimeVersion() >= 23;
        if (!supportsRuntimePermissions) {
            Log.w((String)TAG, (String)"Permissions can only be granted on devices running Android M (API 23) orhigher. This rule is ignored.");
        }
        return supportsRuntimePermissions;
    }

    private int getAndroidRuntimeVersion() {
        return this.mAndroidRuntimeVersion;
    }
}

