/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.screenshot;

import android.os.Build;
import android.os.Environment;
import android.support.annotation.VisibleForTesting;
import android.support.test.annotation.Beta;
import android.support.test.runner.screenshot.ScreenCapture;
import android.support.test.runner.screenshot.ScreenCaptureProcessor;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

@Beta
public class BasicScreenCaptureProcessor
implements ScreenCaptureProcessor {
    private static int sAndroidRuntimeVersion = Build.VERSION.SDK_INT;
    private static String sAndroidDeviceName = Build.DEVICE;
    protected String mTag = "BasicScreenCaptureProcessor";
    protected String mFileNameDelimiter = "-";
    protected String mDefaultFilenamePrefix = "screenshot";
    protected File mDefaultScreenshotPath;

    public BasicScreenCaptureProcessor() {
        this(new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), "screenshots"));
    }

    BasicScreenCaptureProcessor(File defaultScreenshotPath) {
        this.mDefaultScreenshotPath = defaultScreenshotPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(ScreenCapture capture) throws IOException {
        String filename = capture.getName() == null ? this.getDefaultFilename() : this.getFilename(capture.getName());
        String string = String.valueOf(filename);
        String string2 = capture.getFormat().toString().toLowerCase();
        filename = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
        File imageFolder = this.mDefaultScreenshotPath;
        imageFolder.mkdirs();
        if (!imageFolder.isDirectory() && !imageFolder.canWrite()) {
            throw new IOException(String.format("The directory %s does not exist and could not be created or is not writable.", imageFolder));
        }
        File imageFile = new File(imageFolder, filename);
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(imageFile));
            capture.getBitmap().compress(capture.getFormat(), 100, (OutputStream)out);
            ((BufferedOutputStream)out).flush();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                Log.e((String)this.mTag, (String)"Could not close output steam.", (Throwable)e);
            }
        }
        return filename;
    }

    protected String getDefaultFilename() {
        String string = this.mDefaultFilenamePrefix;
        String string2 = this.mFileNameDelimiter;
        String string3 = sAndroidDeviceName;
        String string4 = this.mFileNameDelimiter;
        int n = sAndroidRuntimeVersion;
        return this.getFilename(new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append(string2).append(string3).append(string4).append(n).toString());
    }

    protected String getFilename(String prefix) {
        String string = this.mFileNameDelimiter;
        String string2 = String.valueOf(UUID.randomUUID());
        return new StringBuilder(String.valueOf(prefix).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(prefix).append(string).append(string2).toString();
    }

    @VisibleForTesting
    static void setAndroidDeviceName(String deviceName) {
        sAndroidDeviceName = deviceName;
    }

    @VisibleForTesting
    static void setAndroidRuntimeVersion(int sdkInt) {
        sAndroidRuntimeVersion = sdkInt;
    }
}

