/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner;

import android.util.Log;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;

public class TestLoader {
    private static final String LOG_TAG = "TestLoader";
    private Map<String, Class<?>> mLoadedClassesMap = new LinkedHashMap();
    private Map<String, Failure> mLoadFailuresMap = new LinkedHashMap<String, Failure>();
    private PrintStream mWriter;

    public TestLoader(PrintStream writer) {
        this.mWriter = writer;
    }

    public Class<?> loadClass(String className) {
        Class<?> loadedClass = this.doLoadClass(className);
        if (loadedClass != null) {
            this.mLoadedClassesMap.put(className, loadedClass);
        }
        return loadedClass;
    }

    private Class<?> doLoadClass(String className) {
        if (this.mLoadFailuresMap.containsKey(className)) {
            return null;
        }
        if (this.mLoadedClassesMap.containsKey(className)) {
            return this.mLoadedClassesMap.get(className);
        }
        try {
            ClassLoader myClassLoader = this.getClass().getClassLoader();
            return Class.forName(className, false, myClassLoader);
        }
        catch (ClassNotFoundException e) {
            String errMsg = String.format("Could not find class: %s", className);
            Log.e((String)LOG_TAG, (String)errMsg);
            this.mWriter.println(errMsg);
            Description description = Description.createSuiteDescription((String)className, (Annotation[])new Annotation[0]);
            Failure failure = new Failure(description, (Throwable)e);
            this.mLoadFailuresMap.put(className, failure);
            return null;
        }
    }

    public Class<?> loadIfTest(String className) {
        Class<?> loadedClass = this.doLoadClass(className);
        if (loadedClass != null && this.isTestClass(loadedClass)) {
            this.mLoadedClassesMap.put(className, loadedClass);
            return loadedClass;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.mLoadedClassesMap.isEmpty() && this.mLoadFailuresMap.isEmpty();
    }

    public Collection<Class<?>> getLoadedClasses() {
        return this.mLoadedClassesMap.values();
    }

    public Collection<Failure> getLoadFailures() {
        return this.mLoadFailuresMap.values();
    }

    private boolean isTestClass(Class<?> loadedClass) {
        try {
            if (Modifier.isAbstract(loadedClass.getModifiers())) {
                this.logDebug(String.format("Skipping abstract class %s: not a test", loadedClass.getName()));
                return false;
            }
            if (Test.class.isAssignableFrom(loadedClass)) {
                if (TestCase.class.isAssignableFrom(loadedClass)) {
                    return this.hasJUnit3TestMethod(loadedClass);
                }
                return true;
            }
            if (loadedClass.isAnnotationPresent(RunWith.class)) {
                return true;
            }
            for (Method testMethod : loadedClass.getMethods()) {
                if (!testMethod.isAnnotationPresent(org.junit.Test.class)) continue;
                return true;
            }
            this.logDebug(String.format("Skipping class %s: not a test", loadedClass.getName()));
            return false;
        }
        catch (Exception e) {
            Log.w((String)LOG_TAG, (String)String.format("%s in isTestClass for %s", e.toString(), loadedClass.getName()));
            return false;
        }
        catch (Error e) {
            Log.w((String)LOG_TAG, (String)String.format("%s in isTestClass for %s", e.toString(), loadedClass.getName()));
            return false;
        }
    }

    private boolean hasJUnit3TestMethod(Class<?> loadedClass) {
        for (Method testMethod : loadedClass.getMethods()) {
            if (!this.isPublicTestMethod(testMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean isPublicTestMethod(Method m) {
        return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private boolean isTestMethod(Method m) {
        return m.getParameterTypes().length == 0 && m.getName().startsWith("test") && m.getReturnType().equals(Void.TYPE);
    }

    private void logDebug(String msg) {
        if (Log.isLoggable((String)LOG_TAG, (int)3)) {
            Log.d((String)LOG_TAG, (String)msg);
        }
    }
}

