/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner;

import android.app.Instrumentation;
import android.os.Build;
import android.os.Bundle;
import android.support.test.filters.RequiresDevice;
import android.support.test.filters.SdkSuppress;
import android.support.test.internal.runner.AndroidRunnerBuilder;
import android.support.test.internal.runner.ClassPathScanner;
import android.support.test.internal.runner.TestLoader;
import android.support.test.internal.runner.TestRequest;
import android.support.test.internal.util.AndroidRunnerParams;
import android.test.suitebuilder.annotation.LargeTest;
import android.test.suitebuilder.annotation.MediumTest;
import android.test.suitebuilder.annotation.SmallTest;
import android.test.suitebuilder.annotation.Suppress;
import android.util.Log;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class TestRequestBuilder {
    private static final String LOG_TAG = "TestRequestBuilder";
    public static final String LARGE_SIZE = "large";
    public static final String MEDIUM_SIZE = "medium";
    public static final String SMALL_SIZE = "small";
    static final String EMULATOR_HARDWARE = "goldfish";
    private String[] mApkPaths;
    private TestLoader mTestLoader;
    private ClassAndMethodFilter mClassMethodFilter = new ClassAndMethodFilter();
    private Filter mFilter = new AnnotationExclusionFilter(Suppress.class).intersect(new SdkSuppressFilter()).intersect((Filter)new RequiresDeviceFilter()).intersect((Filter)this.mClassMethodFilter);
    private boolean mSkipExecution = false;
    private String mTestPackageName = null;
    private final DeviceBuild mDeviceBuild;
    private long mPerTestTimeout = 0L;

    public TestRequestBuilder(PrintStream writer, String ... apkPaths) {
        this(new DeviceBuildImpl(), writer, apkPaths);
    }

    TestRequestBuilder(DeviceBuild deviceBuildAccessor, PrintStream writer, String ... apkPaths) {
        this.mDeviceBuild = deviceBuildAccessor;
        this.mApkPaths = apkPaths;
        this.mTestLoader = new TestLoader(writer);
    }

    public void addTestClass(String className) {
        this.mTestLoader.loadClass(className);
    }

    public void addTestMethod(String testClassName, String testMethodName) {
        Class<?> clazz = this.mTestLoader.loadClass(testClassName);
        if (clazz != null) {
            this.mClassMethodFilter.add(testClassName, testMethodName);
        }
    }

    public void addTestPackageFilter(String testPackage) {
        this.mTestPackageName = testPackage;
    }

    public void addTestSizeFilter(String testSize) {
        if (SMALL_SIZE.equals(testSize)) {
            this.mFilter = this.mFilter.intersect((Filter)new SizeFilter(SmallTest.class));
        } else if (MEDIUM_SIZE.equals(testSize)) {
            this.mFilter = this.mFilter.intersect((Filter)new SizeFilter(MediumTest.class));
        } else if (LARGE_SIZE.equals(testSize)) {
            this.mFilter = this.mFilter.intersect((Filter)new SizeFilter(LargeTest.class));
        } else {
            Log.e((String)LOG_TAG, (String)String.format("Unrecognized test size '%s'", testSize));
        }
    }

    public void addAnnotationInclusionFilter(String annotation) {
        Class<? extends Annotation> annotationClass = this.loadAnnotationClass(annotation);
        if (annotationClass != null) {
            this.mFilter = this.mFilter.intersect((Filter)new AnnotationInclusionFilter(annotationClass));
        }
    }

    public void addAnnotationExclusionFilter(String notAnnotation) {
        Class<? extends Annotation> annotationClass = this.loadAnnotationClass(notAnnotation);
        if (annotationClass != null) {
            this.mFilter = this.mFilter.intersect((Filter)new AnnotationExclusionFilter(annotationClass));
        }
    }

    public void addShardingFilter(int numShards, int shardIndex) {
        this.mFilter = this.mFilter.intersect((Filter)new ShardingFilter(numShards, shardIndex));
    }

    public void setSkipExecution(boolean b) {
        this.mSkipExecution = b;
    }

    public void setPerTestTimeout(long millis) {
        this.mPerTestTimeout = millis;
    }

    public TestRequest build(Instrumentation instr, Bundle bundle) {
        if (this.mTestLoader.isEmpty()) {
            this.loadClassesFromClassPath();
        }
        Request request = TestRequestBuilder.classes(new AndroidRunnerParams(instr, bundle, this.mSkipExecution, this.mPerTestTimeout), new Computer(), this.mTestLoader.getLoadedClasses().toArray(new Class[0]));
        return new TestRequest(this.mTestLoader.getLoadFailures(), new LenientFilterRequest(request, this.mFilter));
    }

    private static Request classes(AndroidRunnerParams runnerParams, Computer computer, Class<?> ... classes) {
        try {
            Runner suite = computer.getSuite((RunnerBuilder)new AndroidRunnerBuilder(runnerParams), (Class[])classes);
            return Request.runner((Runner)suite);
        }
        catch (InitializationError e) {
            throw new RuntimeException("Suite constructor, called as above, should always complete");
        }
    }

    private void loadClassesFromClassPath() {
        Collection<String> classNames = this.getClassNamesFromClassPath();
        for (String className : classNames) {
            this.mTestLoader.loadIfTest(className);
        }
    }

    private Collection<String> getClassNamesFromClassPath() {
        Log.i((String)LOG_TAG, (String)String.format("Scanning classpath to find tests in apks %s", Arrays.toString(this.mApkPaths)));
        ClassPathScanner scanner = new ClassPathScanner(this.mApkPaths);
        ClassPathScanner.ChainedClassNameFilter filter = new ClassPathScanner.ChainedClassNameFilter();
        filter.add(new ClassPathScanner.ExternalClassNameFilter());
        if (this.mTestPackageName != null) {
            filter.add(new ClassPathScanner.InclusivePackageNameFilter(this.mTestPackageName));
        } else {
            filter.addAll(new ClassPathScanner.ExcludePackageNameFilter("junit"), new ClassPathScanner.ExcludePackageNameFilter("org.junit"), new ClassPathScanner.ExcludePackageNameFilter("org.hamcrest"), new ClassPathScanner.ExcludePackageNameFilter("android.support.test.internal.runner.junit3"));
        }
        try {
            return scanner.getClassPathEntries(filter);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Failed to scan classes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    ClassPathScanner createClassPathScanner(String ... apkPaths) {
        return new ClassPathScanner(apkPaths);
    }

    private Class<? extends Annotation> loadAnnotationClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)LOG_TAG, (String)String.format("Could not find annotation class: %s", className));
        }
        catch (ClassCastException e) {
            Log.e((String)LOG_TAG, (String)String.format("Class %s is not an annotation", className));
        }
        return null;
    }

    private int getDeviceSdkInt() {
        return this.mDeviceBuild.getSdkVersionInt();
    }

    private String getDeviceHardware() {
        return this.mDeviceBuild.getHardware();
    }

    private static class MethodFilter
    extends Filter {
        private final String mClassName;
        private Set<String> mMethodNames = new HashSet<String>();

        public MethodFilter(String className) {
            this.mClassName = className;
        }

        public String describe() {
            return "Method filter for " + this.mClassName + " class";
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                String methodName = description.getMethodName();
                methodName = this.stripParameterizedSuffix(methodName);
                return this.mMethodNames.contains(methodName);
            }
            return true;
        }

        private String stripParameterizedSuffix(String name) {
            Pattern suffixPattern = Pattern.compile(".+(\\[[0-9]+\\])$");
            if (suffixPattern.matcher(name).matches()) {
                name = name.substring(0, name.lastIndexOf(91));
            }
            return name;
        }

        public void add(String methodName) {
            this.mMethodNames.add(methodName);
        }
    }

    private static class ClassAndMethodFilter
    extends Filter {
        private Map<String, MethodFilter> mClassMethodFilterMap = new HashMap<String, MethodFilter>();

        private ClassAndMethodFilter() {
        }

        public boolean shouldRun(Description description) {
            if (this.mClassMethodFilterMap.isEmpty()) {
                return true;
            }
            if (description.isTest()) {
                MethodFilter mf = this.mClassMethodFilterMap.get(description.getClassName());
                if (mf != null) {
                    return mf.shouldRun(description);
                }
            } else {
                for (Description child : description.getChildren()) {
                    if (!this.shouldRun(child)) continue;
                    return true;
                }
            }
            return false;
        }

        public String describe() {
            return "Class and method filter";
        }

        public void add(String className, String methodName) {
            MethodFilter mf = this.mClassMethodFilterMap.get(className);
            if (mf == null) {
                mf = new MethodFilter(className);
                this.mClassMethodFilterMap.put(className, mf);
            }
            mf.add(methodName);
        }
    }

    private static class BlankRunner
    extends Runner {
        private BlankRunner() {
        }

        public Description getDescription() {
            return Description.createSuiteDescription((String)"no tests found", (Annotation[])new Annotation[0]);
        }

        public void run(RunNotifier notifier) {
        }
    }

    private static class LenientFilterRequest
    extends Request {
        private final Request mRequest;
        private final Filter mFilter;

        public LenientFilterRequest(Request classRequest, Filter filter) {
            this.mRequest = classRequest;
            this.mFilter = filter;
        }

        public Runner getRunner() {
            try {
                Runner runner = this.mRequest.getRunner();
                this.mFilter.apply((Object)runner);
                return runner;
            }
            catch (NoTestsRemainException e) {
                return new BlankRunner();
            }
        }
    }

    private static class ShardingFilter
    extends Filter {
        private final int mNumShards;
        private final int mShardIndex;

        ShardingFilter(int numShards, int shardIndex) {
            this.mNumShards = numShards;
            this.mShardIndex = shardIndex;
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                return Math.abs(description.hashCode()) % this.mNumShards == this.mShardIndex;
            }
            for (Description each : description.getChildren()) {
                if (!this.shouldRun(each)) continue;
                return true;
            }
            return false;
        }

        public String describe() {
            return String.format("Shard %s of %s shards", this.mShardIndex, this.mNumShards);
        }
    }

    private class RequiresDeviceFilter
    extends AnnotationExclusionFilter {
        RequiresDeviceFilter() {
            super(RequiresDevice.class);
        }

        @Override
        protected boolean evaluateTest(Description description) {
            if (!super.evaluateTest(description)) {
                return !TestRequestBuilder.EMULATOR_HARDWARE.equals(TestRequestBuilder.this.getDeviceHardware());
            }
            return true;
        }

        @Override
        public String describe() {
            return String.format("skip tests annotated with RequiresDevice if necessary", new Object[0]);
        }
    }

    private class SdkSuppressFilter
    extends ParentFilter {
        private SdkSuppressFilter() {
        }

        @Override
        protected boolean evaluateTest(Description description) {
            SdkSuppress s = this.getAnnotationForTest(description);
            return s == null || TestRequestBuilder.this.getDeviceSdkInt() >= s.minSdkVersion();
        }

        private SdkSuppress getAnnotationForTest(Description description) {
            SdkSuppress s = (SdkSuppress)description.getAnnotation(SdkSuppress.class);
            if (s != null) {
                return s;
            }
            Class testClass = description.getTestClass();
            if (testClass != null) {
                return testClass.getAnnotation(SdkSuppress.class);
            }
            return null;
        }

        public String describe() {
            return String.format("skip tests annotated with SdkSuppress if necessary", new Object[0]);
        }
    }

    private static class AnnotationExclusionFilter
    extends ParentFilter {
        private final Class<? extends Annotation> mAnnotationClass;

        AnnotationExclusionFilter(Class<? extends Annotation> annotation) {
            this.mAnnotationClass = annotation;
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            return (testClass == null || !testClass.isAnnotationPresent(this.mAnnotationClass)) && description.getAnnotation(this.mAnnotationClass) == null;
        }

        public String describe() {
            return String.format("not annotation %s", this.mAnnotationClass.getName());
        }
    }

    private static class SizeFilter
    extends AnnotationInclusionFilter {
        private static final Set<Class<?>> ALL_SIZES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(SmallTest.class, MediumTest.class, LargeTest.class)));

        SizeFilter(Class<? extends Annotation> annotation) {
            super(annotation);
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            if (description.getAnnotation(this.getAnnotationClass()) != null) {
                return true;
            }
            if (testClass != null && testClass.isAnnotationPresent(this.getAnnotationClass())) {
                for (Annotation a : description.getAnnotations()) {
                    if (!ALL_SIZES.contains(a.annotationType())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static class AnnotationInclusionFilter
    extends ParentFilter {
        private final Class<? extends Annotation> mAnnotationClass;

        AnnotationInclusionFilter(Class<? extends Annotation> annotation) {
            this.mAnnotationClass = annotation;
        }

        @Override
        protected boolean evaluateTest(Description description) {
            Class testClass = description.getTestClass();
            return description.getAnnotation(this.mAnnotationClass) != null || testClass != null && testClass.isAnnotationPresent(this.mAnnotationClass);
        }

        protected Class<? extends Annotation> getAnnotationClass() {
            return this.mAnnotationClass;
        }

        public String describe() {
            return String.format("annotation %s", this.mAnnotationClass.getName());
        }
    }

    private static abstract class ParentFilter
    extends Filter {
        private ParentFilter() {
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                return this.evaluateTest(description);
            }
            for (Description each : description.getChildren()) {
                if (!this.shouldRun(each)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean evaluateTest(Description var1);
    }

    private static class DeviceBuildImpl
    implements DeviceBuild {
        private DeviceBuildImpl() {
        }

        @Override
        public int getSdkVersionInt() {
            return Build.VERSION.SDK_INT;
        }

        @Override
        public String getHardware() {
            return Build.HARDWARE;
        }
    }

    static interface DeviceBuild {
        public int getSdkVersionInt();

        public String getHardware();
    }
}

