/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.junit3;

import android.support.test.internal.runner.junit3.AndroidTestResult;
import android.support.test.internal.runner.junit3.DelegatingFilterableTestSuite;
import android.support.test.internal.runner.junit3.NonLeakyTestSuite;
import android.support.test.internal.util.AndroidRunnerParams;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.Ignore;

@Ignore
class AndroidTestSuite
extends DelegatingFilterableTestSuite {
    private final AndroidRunnerParams mAndroidRunnerParams;

    public AndroidTestSuite(Class<?> testClass, AndroidRunnerParams runnerParams) {
        this(new NonLeakyTestSuite(testClass), runnerParams);
    }

    public AndroidTestSuite(TestSuite s, AndroidRunnerParams runnerParams) {
        super(s);
        this.mAndroidRunnerParams = runnerParams;
    }

    @Override
    public void run(TestResult result) {
        AndroidTestResult androidTestResult = new AndroidTestResult(this.mAndroidRunnerParams.getBundle(), this.mAndroidRunnerParams.getInstrumentation(), result);
        long timeout = this.mAndroidRunnerParams.getPerTestTimeout();
        if (timeout > 0L) {
            this.runTestsWithTimeout(timeout, androidTestResult);
        } else {
            super.run(androidTestResult);
        }
    }

    private void runTestsWithTimeout(long timeout, AndroidTestResult result) {
        int suiteSize = this.testCount();
        for (int i = 0; i < suiteSize; ++i) {
            Test test = this.testAt(i);
            try {
                this.runTestWithTimeout(test, result, timeout);
                continue;
            }
            catch (Throwable throwable) {
                result.notifyFailureAndFinish(test, throwable);
            }
        }
    }

    private void runTestWithTimeout(final Test test, final AndroidTestResult androidTestResult, long timeout) throws Throwable {
        ExecutorService threadExecutor = Executors.newSingleThreadExecutor();
        Runnable execRunnable = new Runnable(){

            @Override
            public void run() {
                test.run((TestResult)androidTestResult);
            }
        };
        try {
            threadExecutor.submit(execRunnable).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new TimeoutException(String.format("Test timed out after %d milliseconds", timeout));
        }
        finally {
            threadExecutor.shutdownNow();
        }
    }
}

