/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.support.test.internal.runner.TestRequest;
import android.support.test.internal.runner.TestRequestBuilder;
import android.support.test.internal.runner.listener.ActivityFinisherRunListener;
import android.support.test.internal.runner.listener.CoverageListener;
import android.support.test.internal.runner.listener.DelayInjector;
import android.support.test.internal.runner.listener.InstrumentationResultPrinter;
import android.support.test.internal.runner.listener.InstrumentationRunListener;
import android.support.test.internal.runner.listener.LogRunListener;
import android.support.test.internal.runner.listener.SuiteAssignmentPrinter;
import android.support.test.internal.runner.tracker.AnalyticsBasedUsageTracker;
import android.support.test.internal.runner.tracker.UsageTracker;
import android.support.test.internal.runner.tracker.UsageTrackerRegistry;
import android.support.test.runner.MonitoringInstrumentation;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class AndroidJUnitRunner
extends MonitoringInstrumentation {
    public static final String ARGUMENT_TEST_CLASS = "class";
    private static final String ARGUMENT_TEST_SIZE = "size";
    private static final String ARGUMENT_LOG_ONLY = "log";
    private static final String ARGUMENT_ANNOTATION = "annotation";
    private static final String ARGUMENT_NOT_ANNOTATION = "notAnnotation";
    private static final String ARGUMENT_NUM_SHARDS = "numShards";
    private static final String ARGUMENT_SHARD_INDEX = "shardIndex";
    private static final String ARGUMENT_DELAY_MSEC = "delay_msec";
    private static final String ARGUMENT_COVERAGE = "coverage";
    private static final String ARGUMENT_COVERAGE_PATH = "coverageFile";
    private static final String ARGUMENT_SUITE_ASSIGNMENT = "suiteAssignment";
    private static final String ARGUMENT_DEBUG = "debug";
    private static final String ARGUMENT_LISTENER = "listener";
    private static final String ARGUMENT_TEST_PACKAGE = "package";
    static final String ARGUMENT_TIMEOUT = "timeout_msec";
    static final String ARGUMENT_TEST_FILE = "testFile";
    private static final String ARGUMENT_DISABLE_ANALYTICS = "disableAnalytics";
    private static final String LOG_TAG = "AndroidJUnitRunner";
    private static final char CLASS_SEPARATOR = ',';
    private static final char METHOD_SEPARATOR = '#';
    private Bundle mArguments;
    private InstrumentationResultPrinter mInstrumentationResultPrinter = null;

    @Override
    public void onCreate(Bundle arguments) {
        super.onCreate(arguments);
        this.setArguments(arguments);
        this.specifyDexMakerCacheProperty();
        this.start();
    }

    public Bundle getArguments() {
        return this.mArguments;
    }

    void setArguments(Bundle args) {
        this.mArguments = args;
    }

    private boolean getBooleanArgument(String tag) {
        String tagString = this.getArguments().getString(tag);
        return tagString != null && Boolean.parseBoolean(tagString);
    }

    InstrumentationResultPrinter getInstrumentationResultPrinter() {
        return this.mInstrumentationResultPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        super.onStart();
        if (this.getBooleanArgument(ARGUMENT_DEBUG)) {
            Debug.waitForDebugger();
        }
        this.setupDexmakerClassloader();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(byteArrayOutputStream);
        ArrayList<RunListener> listeners = new ArrayList<RunListener>();
        try {
            JUnitCore testRunner = new JUnitCore();
            this.addListeners(listeners, testRunner, writer);
            TestRequest testRequest = this.buildRequest(this.getArguments(), writer);
            Result result = testRunner.run(testRequest.getRequest());
            result.getFailures().addAll(testRequest.getFailures());
        }
        catch (Throwable t) {
            try {
                writer.println(String.format("Test run aborted due to unexpected exception: %s", t.getMessage()));
                t.printStackTrace(writer);
            }
            catch (Throwable throwable) {
                Bundle results = new Bundle();
                this.reportRunEnded(listeners, writer, results);
                writer.close();
                results.putString("stream", String.format("\n%s", byteArrayOutputStream.toString()));
                this.finish(-1, results);
                throw throwable;
            }
            Bundle results = new Bundle();
            this.reportRunEnded(listeners, writer, results);
            writer.close();
            results.putString("stream", String.format("\n%s", byteArrayOutputStream.toString()));
            this.finish(-1, results);
        }
        Bundle results = new Bundle();
        this.reportRunEnded(listeners, writer, results);
        writer.close();
        results.putString("stream", String.format("\n%s", byteArrayOutputStream.toString()));
        this.finish(-1, results);
    }

    @Override
    public void finish(int resultCode, Bundle results) {
        try {
            UsageTrackerRegistry.getInstance().trackUsage(LOG_TAG);
            UsageTrackerRegistry.getInstance().sendUsages();
        }
        catch (RuntimeException re) {
            Log.w((String)LOG_TAG, (String)"Failed to send analytics.", (Throwable)re);
        }
        super.finish(resultCode, results);
    }

    private void addListeners(List<RunListener> listeners, JUnitCore testRunner, PrintStream writer) {
        if (this.getBooleanArgument(ARGUMENT_SUITE_ASSIGNMENT)) {
            listeners.add(new SuiteAssignmentPrinter());
        } else {
            listeners.add((RunListener)new TextListener(writer));
            listeners.add(new LogRunListener());
            this.mInstrumentationResultPrinter = new InstrumentationResultPrinter();
            listeners.add(this.mInstrumentationResultPrinter);
            listeners.add(new ActivityFinisherRunListener(this, new MonitoringInstrumentation.ActivityFinisher()));
            this.addDelayListener(listeners);
            this.addCoverageListener(listeners);
        }
        this.addListenersFromArg(listeners, writer);
        this.addListenersFromManifest(listeners, writer);
        for (RunListener listener : listeners) {
            testRunner.addListener(listener);
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).setInstrumentation(this);
        }
    }

    private void addCoverageListener(List<RunListener> list) {
        if (this.getBooleanArgument(ARGUMENT_COVERAGE)) {
            String coverageFilePath = this.getArguments().getString(ARGUMENT_COVERAGE_PATH);
            list.add(new CoverageListener(coverageFilePath));
        }
    }

    private void addDelayListener(List<RunListener> list) {
        try {
            Object delay = this.getArguments().get(ARGUMENT_DELAY_MSEC);
            if (delay != null) {
                int delayMsec = Integer.parseInt(delay.toString());
                list.add(new DelayInjector(delayMsec));
            } else if (this.getBooleanArgument(ARGUMENT_LOG_ONLY) && Build.VERSION.SDK_INT < 16) {
                list.add(new DelayInjector(15));
            }
        }
        catch (NumberFormatException e) {
            Log.e((String)LOG_TAG, (String)"Invalid delay_msec parameter", (Throwable)e);
        }
    }

    private void addListenersFromArg(List<RunListener> listeners, PrintStream writer) {
        this.addListenersFromClassString(this.getArguments().getString(ARGUMENT_LISTENER), listeners, writer);
    }

    private void addListenersFromManifest(List<RunListener> listeners, PrintStream writer) {
        PackageManager pm = this.getContext().getPackageManager();
        try {
            InstrumentationInfo instrInfo = pm.getInstrumentationInfo(this.getComponentName(), 128);
            Bundle b = instrInfo.metaData;
            if (b == null) {
                return;
            }
            String extraListenerList = b.getString(ARGUMENT_LISTENER);
            this.addListenersFromClassString(extraListenerList, listeners, writer);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.wtf((String)LOG_TAG, (String)String.format("Could not find component %s", this.getComponentName()));
        }
    }

    private void addListenersFromClassString(String extraListenerList, List<RunListener> listeners, PrintStream writer) {
        if (extraListenerList == null) {
            return;
        }
        for (String listenerName : extraListenerList.split(",")) {
            this.addListenerByClassName(listeners, writer, listenerName);
        }
    }

    private void addListenerByClassName(List<RunListener> listeners, PrintStream writer, String extraListener) {
        RunListener l;
        Class<?> klass;
        if (extraListener == null || extraListener.length() == 0) {
            return;
        }
        try {
            klass = Class.forName(extraListener);
        }
        catch (ClassNotFoundException e) {
            writer.println("Could not find extra RunListener class " + extraListener);
            return;
        }
        if (!RunListener.class.isAssignableFrom(klass)) {
            writer.println("Extra listeners must extend RunListener class " + extraListener);
            return;
        }
        try {
            klass.getConstructor(new Class[0]).setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            writer.println("Must have no argument constructor for class " + extraListener);
            return;
        }
        try {
            l = (RunListener)klass.newInstance();
        }
        catch (Throwable t) {
            writer.println("Could not instantiate extra RunListener class " + extraListener);
            t.printStackTrace(writer);
            return;
        }
        listeners.add(l);
    }

    @Override
    public boolean onException(Object obj, Throwable e) {
        InstrumentationResultPrinter instResultPrinter = this.getInstrumentationResultPrinter();
        if (instResultPrinter != null) {
            instResultPrinter.reportProcessCrash(e);
        }
        return super.onException(obj, e);
    }

    private void reportRunEnded(List<RunListener> listeners, PrintStream writer, Bundle results) {
        for (RunListener listener : listeners) {
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).instrumentationRunFinished(writer, results);
        }
    }

    TestRequest buildRequest(Bundle arguments, PrintStream writer) {
        UsageTracker tracker;
        String timeout;
        String notAnnotations;
        String annotation;
        String testSize;
        String testPackage;
        String testFilePath;
        TestRequestBuilder builder = this.createTestRequestBuilder(writer, this.getContext().getPackageCodePath());
        String testClassName = arguments.getString(ARGUMENT_TEST_CLASS);
        if (testClassName != null) {
            for (String className : testClassName.split(String.valueOf(','))) {
                this.parseTestClass(className, builder);
            }
        }
        if ((testFilePath = arguments.getString(ARGUMENT_TEST_FILE)) != null) {
            this.parseTestClassesFromFile(testFilePath, builder);
        }
        if ((testPackage = arguments.getString(ARGUMENT_TEST_PACKAGE)) != null) {
            builder.addTestPackageFilter(testPackage);
        }
        if ((testSize = arguments.getString(ARGUMENT_TEST_SIZE)) != null) {
            builder.addTestSizeFilter(testSize);
        }
        if ((annotation = arguments.getString(ARGUMENT_ANNOTATION)) != null) {
            builder.addAnnotationInclusionFilter(annotation);
        }
        if ((notAnnotations = arguments.getString(ARGUMENT_NOT_ANNOTATION)) != null) {
            for (String notAnnotation : notAnnotations.split(",")) {
                builder.addAnnotationExclusionFilter(notAnnotation);
            }
        }
        if ((timeout = arguments.getString(ARGUMENT_TIMEOUT)) != null) {
            this.addTimeout(timeout, builder);
        }
        Object numShardsObj = arguments.get(ARGUMENT_NUM_SHARDS);
        Object shardIndexObj = arguments.get(ARGUMENT_SHARD_INDEX);
        if (numShardsObj != null && shardIndexObj != null) {
            int numShards = -1;
            int shardIndex = -1;
            try {
                numShards = Integer.parseInt(numShardsObj.toString());
                shardIndex = Integer.parseInt(shardIndexObj.toString());
            }
            catch (NumberFormatException e) {
                Log.e((String)LOG_TAG, (String)"Invalid sharding parameter", (Throwable)e);
            }
            if (numShards > 0 && shardIndex >= 0 && shardIndex < numShards) {
                builder.addShardingFilter(numShards, shardIndex);
            }
        }
        if (this.getBooleanArgument(ARGUMENT_LOG_ONLY)) {
            builder.setSkipExecution(true);
        }
        if (!this.getBooleanArgument(ARGUMENT_DISABLE_ANALYTICS) && null != this.getTargetContext() && null != (tracker = new AnalyticsBasedUsageTracker.Builder(this.getTargetContext()).buildIfPossible())) {
            UsageTrackerRegistry.registerInstance(tracker);
        }
        return builder.build(this, arguments);
    }

    TestRequestBuilder createTestRequestBuilder(PrintStream writer, String ... packageCodePaths) {
        return new TestRequestBuilder(writer, packageCodePaths);
    }

    private void parseTestClass(String testClassName, TestRequestBuilder testRequestBuilder) {
        int methodSeparatorIndex = testClassName.indexOf(35);
        if (methodSeparatorIndex > 0) {
            String testMethodName = testClassName.substring(methodSeparatorIndex + 1);
            testClassName = testClassName.substring(0, methodSeparatorIndex);
            testRequestBuilder.addTestMethod(testClassName, testMethodName);
        } else {
            testRequestBuilder.addTestClass(testClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTestClassesFromFile(String filePath, TestRequestBuilder testRequestBuilder) {
        ArrayList<String> classes = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(new File(filePath)));
            while ((line = br.readLine()) != null) {
                classes.add(line);
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)LOG_TAG, (String)String.format("File not found: %s", filePath), (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)String.format("Something went wrong reading %s, ignoring file", filePath), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        for (String className : classes) {
            this.parseTestClass(className, testRequestBuilder);
        }
    }

    void addTimeout(String timeout, TestRequestBuilder testRequestBuilder) {
        long t = Long.parseLong(timeout);
        if (t < 0L) {
            throw new NumberFormatException("Timeout can not be negative");
        }
        testRequestBuilder.setPerTestTimeout(t);
    }

    private void setupDexmakerClassloader() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Log.i((String)LOG_TAG, (String)String.format("Setting context classloader to '%s', Original: '%s'", newClassLoader.toString(), originalClassLoader.toString()));
        Thread.currentThread().setContextClassLoader(newClassLoader);
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder token, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id, Object lastNonConfigurationInstance) throws InstantiationException, IllegalAccessException {
        ComponentName intentComponentName;
        String activityClassPackageName = clazz.getPackage().getName();
        String contextPackageName = context.getPackageName();
        if (!contextPackageName.equals((intentComponentName = intent.getComponent()).getPackageName()) && activityClassPackageName.equals(intentComponentName.getPackageName())) {
            intent.setComponent(new ComponentName(contextPackageName, intentComponentName.getClassName()));
        }
        return super.newActivity(clazz, context, token, application, intent, info, title, parent, id, lastNonConfigurationInstance);
    }
}

